// Paq32.dll
// $Id: Classes.cpp,v 1.2 2006/03/19 12:36:14 sirakaba Exp $

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "StdAfx.h"
#include "Classes.h"
#include "function.h"

//******************************************************************************
//    o֐ (BufferStream)
//******************************************************************************

// RXgN^B
BufferStream::BufferStream(void)
{
	this->BufferSize = 0;
	this->lpBuffer = NULL;
}

// fXgN^B
BufferStream::~BufferStream(void)
{
	if (this->lpBuffer != NULL)
	{
		free(this->lpBuffer);
	}
}

// w肳ꂽTCŸmہB
BOOL BufferStream::Allocate(size_t _stSize)
{
	if (this->lpBuffer != NULL)
	{
		return FALSE;
	}

	this->BufferSize = _stSize;
	this->lpBuffer = (char *) malloc(_stSize);
	return this->lpBuffer != NULL;
}

// mۂ̈JB
BOOL BufferStream::Free(void)
{
	if (this->lpBuffer == NULL)
	{
		return FALSE;
	}
	free(this->lpBuffer);
	this->lpBuffer = NULL;
	return TRUE;
}

//******************************************************************************
//    o֐ (ArrayStream)
//******************************************************************************

ArrayStream::ArrayStream(void)
{
	this->BufferSize = 0;
	this->ItemCount = 0;
	this->lpBuffer = NULL;
}

ArrayStream::~ArrayStream(void)
{
	if (this->lpBuffer != NULL)
	{
		free(this->lpBuffer);
	}
}

BOOL ArrayStream::Allocate(size_t _stCount, size_t _stSize)
{
	if (this->lpBuffer != NULL)
	{
		return FALSE;
	}

	this->BufferSize = _stSize;
	this->ItemCount = _stCount;
	this->lpBuffer = (void *) calloc(_stCount, _stSize);
	return this->lpBuffer != NULL;
}

BOOL ArrayStream::ChangeSize(size_t _stCount)
{
	if (this->lpBuffer == NULL)
	{
		return FALSE;
	}

	this->ItemCount = _stCount;
	this->lpBuffer = (void *) realloc(this->lpBuffer, _stCount * this->BufferSize);
	return this->lpBuffer != NULL;
}

BOOL ArrayStream::Free(void)
{
	if (this->lpBuffer == NULL)
	{
		return FALSE;
	}
	free(this->lpBuffer);
	this->lpBuffer = NULL;
	return TRUE;
}

//******************************************************************************
//    o֐ (FileStream)
//******************************************************************************

// RXgN^B
FileStream::FileStream(void)
{
	// lݒ
	this->bRemove = FALSE;
	this->fpFile = NULL;
}

// fXgN^B
FileStream::~FileStream(void)
{
	// t@CB
	if (this->fpFile)
	{
		fclose(this->fpFile);
	}
	if (this->bRemove)
	{
		remove(this->szFileName);
	}
}

// w肳ꂽt@CJB
BOOL FileStream::Open(const char * _szFile, const char * _szMode)
{
	// t@CJB
	if (_szFile != NULL)
	{
		strncpy(this->szFileName, _szFile, sizeof(this->szFileName) - 1);
	}
	this->fpFile = fopen(this->szFileName, _szMode);
	return this->fpFile != NULL;
}

//******************************************************************************
//    o֐ (Callback)
//******************************************************************************

// RXgN^B
Callback::Callback(void)
{
	// B
	memset(& this->sArchiveInfo, 0, sizeof(Callback::ArchiveInfo));
	memset(& this->sFileInfo,    0, sizeof(Callback::FileInfo));
	memset(& this->sMemberInfo,  0, sizeof(Callback::MemberInfo));
	memset(& this->sProgress,    0, sizeof(Callback::Progress));

	// EChEbZ[Wo^B
	this->sProgress.uID_Progress = RegisterWindowMessage(WM_ARCEXTRACT);

}

// EnumMembersProc MB
BOOL Callback::SendFileInfo(void)
{
	BOOL bReturnCode = FALSE;
	DoEvents();

	if (this->sFileInfo.epCallbackProc == NULL)
	{
		return TRUE;
	}

	switch (this->sFileInfo.dwStructureSize)
	{
		case sizeof(PAQ_ENUM_MEMBER_INFO):
		{
			PAQ_ENUM_MEMBER_INFO pi;

			pi.dwStructSize             = this->sFileInfo.dwStructureSize;
			pi.uCommand                 = this->sMemberInfo.uCommand;
			pi.dwOriginalSize           = (DWORD) this->sMemberInfo.llOriginalSize;
			pi.dwCompressedSize         = (DWORD) this->sMemberInfo.llCompressedSize;
			pi.dwAttributes             = this->sMemberInfo.dwAttributes;
			pi.dwCRC                    = this->sMemberInfo.dwCRC;
			pi.uOSType                  = 0;
			pi.wRatio                   = this->sMemberInfo.wRatio;
			pi.ftCreateTime             = this->sMemberInfo.ftCreateTime;
			pi.ftAccessTime             = this->sMemberInfo.ftAccessTime;
			pi.ftWriteTime              = this->sMemberInfo.ftWriteTime;
			strcpy(pi.szFileName,       this->sMemberInfo.szFileName);
			strcpy(pi.dummy1,           "");
			strcpy(pi.szAddFileName,    this->sMemberInfo.szAddFileName);
			strcpy(pi.dummy2,           "");

			bReturnCode = this->sFileInfo.epCallbackProc(& pi);

			this->sMemberInfo.ftCreateTime          = pi.ftCreateTime;
			this->sMemberInfo.ftAccessTime          = pi.ftAccessTime;
			this->sMemberInfo.ftWriteTime           = pi.ftWriteTime;
			strcpy(this->sMemberInfo.szFileName,   pi.szFileName);
			strcpy(this->sMemberInfo.szAddFileName,pi.szAddFileName);

			break;
		}
		case sizeof(PAQ_ENUM_MEMBER_INFO64):
		{
			PAQ_ENUM_MEMBER_INFO64 pi;

			pi.dwStructSize             = this->sFileInfo.dwStructureSize;
			pi.uCommand                 = this->sMemberInfo.uCommand;
			pi.llOriginalSize           = this->sMemberInfo.llOriginalSize;
			pi.llCompressedSize         = this->sMemberInfo.llCompressedSize;
			pi.dwAttributes             = this->sMemberInfo.dwAttributes;
			pi.dwCRC                    = this->sMemberInfo.dwCRC;
			pi.uOSType                  = 0;
			pi.wRatio                   = this->sMemberInfo.wRatio;
			pi.ftCreateTime             = this->sMemberInfo.ftCreateTime;
			pi.ftAccessTime             = this->sMemberInfo.ftAccessTime;
			pi.ftWriteTime              = this->sMemberInfo.ftWriteTime;
			strcpy(pi.szFileName,       this->sMemberInfo.szFileName);
			strcpy(pi.dummy1,           "");
			strcpy(pi.szAddFileName,    this->sMemberInfo.szAddFileName);
			strcpy(pi.dummy2,           "");

			bReturnCode = this->sFileInfo.epCallbackProc(& pi);

			this->sMemberInfo.ftCreateTime          = pi.ftCreateTime;
			this->sMemberInfo.ftAccessTime          = pi.ftAccessTime;
			this->sMemberInfo.ftWriteTime           = pi.ftWriteTime;
			strcpy(this->sMemberInfo.szFileName,   pi.szFileName);
			strcpy(this->sMemberInfo.szAddFileName,pi.szAddFileName);

			break;
		}
	}
	return bReturnCode;
}

// OwnerWindow MB
BOOL Callback::SendProgress(UINT _uProgressID)
{
	DoEvents();
	switch (this->sProgress.dwStructureSize)
	{
		case sizeof(EXTRACTINGINFO):
		{
			EXTRACTINGINFO ei;
			ei.dwFileSize                = (DWORD) this->sArchiveInfo.llFileSize;
			ei.dwWriteSize               = (DWORD) this->sArchiveInfo.llWriteSize;
			strcpy(ei.szSourceFileName,  this->sArchiveInfo.szSourceFileName);
			strcpy(ei.szDestFileName,    this->sArchiveInfo.szDestFileName);

			return this->sProgress.apCallbackProc == NULL
				? ! SendMessage(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, (LPARAM) & ei)
				: this->sProgress.apCallbackProc(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, & ei);
		}
		case sizeof(EXTRACTINGINFOEX):
		{
			EXTRACTINGINFOEX ei;
			ei.exinfo.dwFileSize         = (DWORD) this->sArchiveInfo.llFileSize;
			ei.exinfo.dwWriteSize        = (DWORD) this->sArchiveInfo.llWriteSize;
			strcpy(ei.exinfo.szSourceFileName, this->sArchiveInfo.szSourceFileName);
			strcpy(ei.exinfo.szDestFileName,   this->sArchiveInfo.szDestFileName);
			ei.dwCompressedSize          = (DWORD) this->sArchiveInfo.llCompressedSize;
			ei.dwCRC                     = this->sArchiveInfo.dwCRC;
			ei.wRatio                    = this->sArchiveInfo.wRatio;
			ei.wDate                     = this->sArchiveInfo.wDate;
			ei.wTime                     = this->sArchiveInfo.wTime;
			strcpy(ei.szMode,			 this->sArchiveInfo.szMode);

			return this->sProgress.apCallbackProc == NULL
				? ! SendMessage(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, (LPARAM) & ei)
				: this->sProgress.apCallbackProc(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, & ei);
		}
		case sizeof(EXTRACTINGINFOEX32):
		{
			EXTRACTINGINFOEX32 ei;
			ei.dwStructSize              = this->sProgress.dwStructureSize;
			ei.exinfo.dwFileSize         = (DWORD) this->sArchiveInfo.llFileSize;
			ei.exinfo.dwWriteSize        = (DWORD) this->sArchiveInfo.llWriteSize;
			strcpy(ei.exinfo.szSourceFileName, this->sArchiveInfo.szSourceFileName);
			strcpy(ei.exinfo.szDestFileName,   this->sArchiveInfo.szDestFileName);
			ei.dwFileSize                = (DWORD) this->sArchiveInfo.llFileSize;
			ei.dwCompressedSize          = (DWORD) this->sArchiveInfo.llCompressedSize;
			ei.dwWriteSize               = (DWORD) this->sArchiveInfo.llWriteSize;
			ei.dwAttributes              = (DWORD) this->sArchiveInfo.dwAttributes;
			ei.dwCRC                     = this->sArchiveInfo.dwCRC;
			ei.wRatio                    = this->sArchiveInfo.wRatio;
			ei.ftCreateTime              = this->sArchiveInfo.ftCreateTime;
			ei.ftAccessTime              = this->sArchiveInfo.ftAccessTime;
			ei.ftWriteTime               = this->sArchiveInfo.ftWriteTime;
			strcpy(ei.szSourceFileName,  this->sArchiveInfo.szSourceFileName);
			strcpy(ei.szDestFileName,    this->sArchiveInfo.szDestFileName);

			return this->sProgress.apCallbackProc(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, & ei);
		}
		case sizeof(EXTRACTINGINFOEX64):
		{
			EXTRACTINGINFOEX64 ei;
			ei.dwStructSize              = this->sProgress.dwStructureSize;
			ei.exinfo.dwFileSize         = (DWORD) this->sArchiveInfo.llFileSize;
			ei.exinfo.dwWriteSize        = (DWORD) this->sArchiveInfo.llWriteSize;
			strcpy(ei.exinfo.szSourceFileName, this->sArchiveInfo.szSourceFileName);
			strcpy(ei.exinfo.szDestFileName,   this->sArchiveInfo.szDestFileName);
			ei.llFileSize                = this->sArchiveInfo.llFileSize;
			ei.llCompressedSize          = this->sArchiveInfo.llCompressedSize;
			ei.llWriteSize               = this->sArchiveInfo.llWriteSize;
			ei.dwAttributes              = (DWORD) this->sArchiveInfo.dwAttributes;
			ei.dwCRC                     = this->sArchiveInfo.dwCRC;
			ei.wRatio                    = this->sArchiveInfo.wRatio;
			ei.ftCreateTime              = this->sArchiveInfo.ftCreateTime;
			ei.ftAccessTime              = this->sArchiveInfo.ftAccessTime;
			ei.ftWriteTime               = this->sArchiveInfo.ftWriteTime;
			strcpy(ei.szSourceFileName,  this->sArchiveInfo.szSourceFileName);
			strcpy(ei.szDestFileName,    this->sArchiveInfo.szDestFileName);
			strcpy(ei.dummy1,            this->sArchiveInfo.dummy1);

			return this->sProgress.apCallbackProc(this->sProgress.hwDialog, this->sProgress.uID_Progress, _uProgressID, & ei);
		}
	}

	return TRUE;
}

//******************************************************************************
//    o֐ (RegistryConfig)
//******************************************************************************

// RXgN^B
RegistryConfig::RegistryConfig(void)
{
	// WXgnhJBL[݂Ȃ΍쐬B
	//
	//	[HKCU\Software\ArchiverDll\]
	//		[Common\]
	//		[Paq32\]
	//			[Config\]
	//				"CompressLevel"	:	kx̊lB
	//				"x86Compress"	:	x86œKk̊lB
	//			[String\]
	//				[(LANGID)\]
	//					"(String)"	:	ẽ\[XB
	//
	//	[HKLM\Software\ArchiverDll\]
	//		[Paq32\]
	//			[String\]
	//				[(LANGID)\]
	//					"(String)"	:	ẽ\[XB
	//
	::RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\ArchiverDll", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, & this->hKey, NULL);
}

// fXgN^B
RegistryConfig::~RegistryConfig()
{
	// WXgnhB
	::RegCloseKey(this->hKey);
}

// WXg擾B
BOOL RegistryConfig::GetConfig(API_NAME(ArchiveInfo) * pai)
{
	HKEY hConfig;
	DWORD dwType, dwData, dwSize;

	// Ǝ̐ݒB
	::RegCreateKeyEx(this->hKey, "Paq32\\Config", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_READ, NULL, & hConfig, NULL);
	dwSize = sizeof(pai->nCompressionLevel);
	pai->nCompressionLevel	= (::RegQueryValueEx(hConfig, "CompressLevel", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : 2;
	dwSize = sizeof(pai->bEnableX86Optimize);
	pai->bEnableX86Optimize	= (::RegQueryValueEx(hConfig, "x86Compress",   NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : FALSE;
	::RegCloseKey(hConfig);

	return TRUE;
}

// WXg擾B
BOOL RegistryConfig::GetConfig(API_NAME(ArchiveInfo) * pai, RegistryConfig::CommonConfig * cc)
{
	HKEY hConfig;
	DWORD dwType, dwData, dwSize;

	// Ǝ̐ݒB
	this->GetConfig(pai);

	// ʐݒB
	::RegCreateKeyEx(this->hKey, "Common", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_READ, NULL, & hConfig, NULL);
	dwSize = sizeof(cc->bExtractAttribute);
	cc->bExtractAttribute = (::RegQueryValueEx(hConfig, "ExtractAttribute", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : FALSE;
	dwSize = sizeof(cc->bJunkDirectory);
	cc->bJunkDirectory = (::RegQueryValueEx(hConfig, "JunkDirectory", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : FALSE;
	dwSize = sizeof(cc->dwBadPathLevel);
	cc->dwBadPathLevel = (::RegQueryValueEx(hConfig, "BadPathLevel", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : 1;
	dwSize = sizeof(cc->dwDirectoryMode);
	cc->dwDirectoryMode = (::RegQueryValueEx(hConfig, "DirectoryMode", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : 1;
	dwSize = sizeof(cc->dwOverWriteMode);
	cc->dwOverWriteMode = (::RegQueryValueEx(hConfig, "OverWriteMode", NULL, & dwType, (LPBYTE) & dwData, & dwSize) == ERROR_SUCCESS && dwType == REG_DWORD) ? dwData : 1;
	dwSize = sizeof(cc->szDefaultDir);
	::RegQueryValueEx(hConfig, "DefaultDir", NULL, & dwType, (LPBYTE) cc->szDefaultDir, & dwSize);
	::RegCloseKey(hConfig);

	return TRUE;
}

// WXgɐݒB
BOOL RegistryConfig::SetConfig(API_NAME(ArchiveInfo) * pai)
{
	HKEY hConfig;

	// Ǝ̐ݒB
	::RegCreateKeyEx(this->hKey, "Paq32\\Config", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, & hConfig, NULL);
	::RegSetValueEx(hConfig, "CompressLevel", 0, REG_DWORD, (const BYTE *) & pai->nCompressionLevel, sizeof(pai->nCompressionLevel));
	::RegSetValueEx(hConfig, "x86Compress",   0, REG_DWORD, (const BYTE *) & pai->bEnableX86Optimize, sizeof(pai->bEnableX86Optimize));
	::RegCloseKey(hConfig);

	return TRUE;
}
