// Paq32.dll
// $Id: Paq32.cpp,v 1.3 2006/03/20 09:57:58 sirakaba Exp $

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "StdAfx.h"
#include "Paq32.h"
#include "Classes.h"
#include "CArchiver.h"
#include "inuse.h"
#include "function.h"
#include "resource.h"

//******************************************************************************
//    O[oϐQ
//******************************************************************************

BOOL g_Running;					// GetRunningŎgpB
BOOL g_Cancel;					// R[obNŎgpB
LANGID g_LanguageID;			// LangueSpecifiednŎgpB
HINSTANCE hDLL;					// g̃nhB_CAOŎgpB
PAQ_ENUM_MEMBER_INFO64 * pEnum;	// EnumMembersProc|C^ێpB
API_NAME(Switch) * pps;			// Switchւ̃|C^B
Callback cbProc;				// R[obNtOB

//******************************************************************************
//    }N`
//******************************************************************************

#define Process_Sta(ret) if(API_NAME(GetRunning)()) return (ret); g_Running = true;
#define Process_End(ret){ g_Running = false; return (ret); }
#define Process(reta, retb){ Process_Sta(reta); Process_End(retb); }

//******************************************************************************
//    DLLMain 錾
//******************************************************************************

extern "C"
{

BOOL APIENTRY DllMain(HINSTANCE hModule, DWORD fdwReason, LPVOID)
{
	if (fdwReason == DLL_PROCESS_ATTACH)
	{
		g_Running = FALSE;
		API_NAME(KillOwnerWindowEx64)(NULL);
		API_NAME(ClearEnumMembersProc64)();
		g_LanguageID = ::GetUserDefaultLangID();

		hDLL = hModule; //Rs[B

		// vOXo[gp̂ŎsB
		// Ƃ͎v̂IE3̂߂Ɂ`Ex()ł͂ȂB
		::InitCommonControls();
	}
	return TRUE;
}

//******************************************************************************
//    LHA.DLL ݊ API
//******************************************************************************

// Command : vȃR}hCs܂B
int WINAPI API_PREFIX(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize)
{
	Process_Sta(ERROR_ALREADY_RUNNING);

	// ϐ`
	int argc, nReturnCode;
	char * argv[1024];

	// R}hC
	argv[0] = "";
	argc = cmdline2array(argv + 1, _szCmdLine) + 1;

	// R}hݒ
	if(strcmp(argv[1], "") == 0)
	{
		for(int i = 1; i < argc; i++) free(argv[i]);
		Process_End(ERROR_COMMAND_NAME);
	}

	// B
	API_NAME(Archive) pa;
	API_NAME(ArchiveInfo) pai;
	API_NAME(Switch) ps;

	// XCb`ݒB
	int i = 2;
	ConvertSwitchToStruct(argv, i, argc, 0, pai, ps);

	// ɐݒ
	if (strcmp(argv[i], "") == 0)
	{
		for(i = 1; i < argc; i++) free(argv[i]);
		Process_End(ERROR_NOT_ARC_FILE);
	}
	strncpy(pai.szArchiveName, argv[i++], sizeof(pai.szArchiveName) - 1);

	// t@CXg𐮗B
	char * szFiles[1024];
	MakeSeparatedList(argc - i, (const char * *) argv + i, szFiles);

	// O
	HWND hDialog = CreateDialog(hDLL, (LPCTSTR) ID_DLG_PROCESS, _hwnd, ProcessDialogProc);

	// EnumMembersProc o^mF
	if (cbProc.sFileInfo.epCallbackProc != NULL)
	{
		pa.cbProc.sFileInfo.dwStructureSize = cbProc.sFileInfo.dwStructureSize;
		pa.cbProc.sFileInfo.epCallbackProc = cbProc.sFileInfo.epCallbackProc;
	}
	else
	{
		pa.cbProc.sFileInfo.dwStructureSize = sizeof(PAQ_ENUM_MEMBER_INFO64);
		pa.cbProc.sFileInfo.epCallbackProc = ProcessEnumMembersProc;
	}
	if (cbProc.sProgress.apCallbackProc != NULL)
	{
		pa.cbProc.sProgress.apCallbackProc = cbProc.sProgress.apCallbackProc;
		pa.cbProc.sProgress.dwStructureSize = cbProc.sProgress.dwStructureSize;
		pa.cbProc.sProgress.hwDialog = cbProc.sProgress.hwDialog;
	}
	else
	{
		pa.cbProc.sProgress.apCallbackProc = (ARCHIVERPROC) ProcessDialogProc;
		pa.cbProc.sProgress.dwStructureSize = sizeof(EXTRACTINGINFOEX64);
		pa.cbProc.sProgress.hwDialog = hDialog;
		cbProc.sProgress.hwDialog = hDialog;
	}
	DoEvents();

	// 
	i = tolower(argv[1][0]);
	if (ps.sQuietInfo.bShowStatusDialog && (i == 'a' || i == 'e' || i == 'n' || i == 'x'))
	{
		CenteringWindow(hDialog, _hwnd);
		SendDlgItemMessage(hDialog, ID_DLG_PROCESS_EDIT, EM_LIMITTEXT, 0, 0);
	}
	// R}hɂ镪B
	switch (i)
	{
		case 'a':
			// kB
			nReturnCode = pa.Open(pai);
			if (nReturnCode != 0)
			{
				break;
			}
			nReturnCode = pa.Add(szFiles, & ps);
			if (! pa.Close() && nReturnCode == 0)
			{
				nReturnCode = ERROR_CLOSE_FILE;
				break;
			}
			if (nReturnCode != 0)
			{
				// G[Iɒԏɂ폜B
				remove(pai.szArchiveName);
			}
			break;
		case 'l':
			// ꗗB
			if (! pa.Open(pai.szArchiveName))
			{
				nReturnCode = ERROR_ARC_FILE_OPEN;
				break;
			}
			API_NAME(FileInfo) pfi;
			pa.szWildName = szFiles;
			nReturnCode = pa.FindFile(TRUE, & pfi);
			if (nReturnCode == 0)
			{
				char szMember[801], szBuffer[30];
				int nFiles = 0;
				ULONGLONG llArchiveSize = 0;

				GetArchiveString(pa.paiInfo.dwArchiveType, szBuffer, sizeof(szBuffer) - 1);
				snprintf(szMember, sizeof(szMember) - 1,
					"===============================================================================\r\n"
					"                Paq32.dll v.%1.2f Build %d\r\n"
					"===============================================================================\r\n\r\n"
					"        Listing of archive:        %s\r\n"
					"        Archive info:\r\n"
					"               Compression Type:   %s\r\n"
					"               Compression Level:  %d\r\n"
					"               x86Compress:        %s\r\n\r\n"
					"  Name                                    Original\r\n"
					"------------------------------------  ------------\r\n"
					, (double) API_NAME(GetVersion)() / 100, (int) API_NAME(GetSubVersion)(), pa.paiInfo.szArchiveName, szBuffer, pa.paiInfo.nCompressionLevel - '0', pa.paiInfo.bEnableX86Optimize ? "TRUE" : "FALSE");
				AddStatusText(hDialog, szMember);
				do
				{
					// 𑗐M (EnumMembersProc)B
					strncpy(pa.cbProc.sMemberInfo.szFileName, pfi.szFileName, sizeof(pa.cbProc.sMemberInfo.szFileName) - 1);
					pa.cbProc.sMemberInfo.llOriginalSize = pfi.llFileSize;
					pa.cbProc.sMemberInfo.uCommand = PAQ_LIST_COMMAND;

					if (! pa.cbProc.SendFileInfo())
					{
						continue;
					}

					snprintf(szMember, sizeof(szMember) - 1, "%-36s  %12I64u\r\n", pfi.szFileName, pfi.llFileSize);
					AddStatusText(hDialog, szMember);
					nFiles++;
					llArchiveSize += pfi.llFileSize;
				}
				while ((nReturnCode = pa.FindFile(FALSE, & pfi)) == 0);
				snprintf(szMember, sizeof(szMember) - 1,
					"------------------------------------  ------------\r\n"
					"%30d files  %12I64u\r\n"
					"===============================================================================\r\n"
					, nFiles, llArchiveSize);
				AddStatusText(hDialog, szMember);
			}
			if (nReturnCode == -1)
			{
				nReturnCode = 0;
			}
			if (! pa.Close() && nReturnCode == 0)
			{
				nReturnCode = ERROR_CLOSE_FILE;
				break;
			}
			break;
		case 'n':
			// l[B
			if (! pa.Open(pai.szArchiveName))
			{
				nReturnCode = ERROR_ARC_FILE_OPEN;
				break;
			}
			nReturnCode = pa.Rename(szFiles, & ps);
			if (! pa.Close() && nReturnCode == 0)
			{
				nReturnCode = ERROR_CLOSE_FILE;
				break;
			}
			break;
		case 't':
			// B
			if (! pa.Open(pai.szArchiveName))
			{
				nReturnCode = ERROR_ARC_FILE_OPEN;
				break;
			}
			nReturnCode = pa.FindFile(true, NULL);
			if (nReturnCode == 0)
			{
				while ((nReturnCode = pa.FindFile(false, NULL)) == 0);
			}
			if (nReturnCode == -1)
			{
				nReturnCode = 0;
			}
			if (! pa.Close() && nReturnCode == 0)
			{
				nReturnCode = ERROR_CLOSE_FILE;
				break;
			}
			break;
		case 'e':
			// WJBApXjB
			ps.bDestoryPath = TRUE;
		case 'x':
			// WJB
			if (! pa.Open(pai.szArchiveName))
			{
				nReturnCode = ERROR_ARC_FILE_OPEN;
				break;
			}
			nReturnCode = pa.Extract(szFiles, & ps);
			if (! pa.Close() && nReturnCode == 0)
			{
				nReturnCode = ERROR_CLOSE_FILE;
				break;
			}
			break;
		default:
			nReturnCode = ERROR_COMMAND_NAME;
	}

	// I
	if (ps.sQuietInfo.bOutputLog && _szOutput != NULL)
	{
		SendDlgItemMessage(hDialog, ID_DLG_PROCESS_EDIT, WM_GETTEXT, _dwSize - 1, (LPARAM) _szOutput);
	}
	DestroyWindow(hDialog);
	for(i = 1; i < argc; i++)           free(argv[i]);
	for(i = 0; szFiles[i] != NULL; i++) free(szFiles[i]);

	// G[(xG[Ƃ݂Ȃꍇ͌x)_CAO\B
	// xmFꍇ͌ʂɕ\̂ŁAł̓_CAO\ȂB
	nReturnCode = g_Cancel ? ERROR_USER_CANCEL : nReturnCode;
	if (ps.sQuietInfo.bShowErrorDialog && nReturnCode != 0 && (nReturnCode >= ERROR_MAKEDIRECTORY || ps.sQuietInfo.eWarningAsError == '2'))
	{
		ErrorConfirmDialog(_hwnd, nReturnCode, TRUE);
	}
	Process_End(nReturnCode);
}

// GetVersion : W[o[W擾B
WORD WINAPI API_NAME(GetVersion)(void)
{
	VS_FIXEDFILEINFO * vfInfo = (VS_FIXEDFILEINFO *) ((char *) LockResource(LoadResource(hDLL, FindResource(hDLL, MAKEINTRESOURCE(VS_VERSION_INFO), RT_VERSION))) + 40);
	return (WORD) ((vfInfo->dwFileVersionMS >> 16) * 100 + (vfInfo->dwFileVersionMS & 0xffff));
}

// GetSubVersion : }Ci[o[W擾B
WORD WINAPI API_NAME(GetSubVersion)(void)
{
	VS_FIXEDFILEINFO * vfInfo = (VS_FIXEDFILEINFO *) ((char *) LockResource(LoadResource(hDLL, FindResource(hDLL, MAKEINTRESOURCE(VS_VERSION_INFO), RT_VERSION))) + 40);
	return (WORD) ((vfInfo->dwFileVersionLS >> 16) * 100 + (vfInfo->dwFileVersionLS & 0xffff));
}

// GetBuild : rhԍ擾B
WORD WINAPI API_NAME(GetBuild)(void)
{
	return API_NAME(GetSubVersion)();
}

// G API Q : ܂܂ȏ̎擾ƐݒB
BOOL WINAPI API_NAME(GetRunning)(void){             return g_Running;}
BOOL WINAPI API_NAME(GetBackGroundMode)(void){      return FALSE; }
BOOL WINAPI API_NAME(SetBackGroundMode)(const BOOL){return FALSE; }
BOOL WINAPI API_NAME(GetCursorMode)(void){          return TRUE;  }
BOOL WINAPI API_NAME(SetCursorMode)(const BOOL){    return FALSE; }
WORD WINAPI API_NAME(GetCursorInterval)(void){      return 80;    }
BOOL WINAPI API_NAME(SetCursorInterval)(const WORD){return FALSE; }

//******************************************************************************
//    LHA.DLL ݊ API
//******************************************************************************

// CheckArchive : ɂ̐B
BOOL WINAPI API_NAME(CheckArchive)(LPCSTR _szFileName, const int _iMode)
{
	// Process_Stâ͓rAPIĂԂ߁B
	HARC pa = API_NAME(OpenArchive)(NULL, _szFileName, 0);
	if (pa == NULL)
	{
		Process_End(FALSE);
	}

	// ȂłJOKƂ̂͑ʖڂȁHw
	// ꉞFindFirst񂵂ĂB
	int value = API_NAME(FindFirst)(pa, "*", NULL), nReturnCode = FALSE;
	if (value == 0)
	{
		// ̌_iModeɂB
		if (_iMode & CHECKARCHIVE_BASIC || (_iMode & CHECKARCHIVE_RAPID && _iMode & CHECKARCHIVE_ALL))
		{
			// ʏ탂[hBwb_݂̂ASẴt@CɂČB
			// ȈՃ[hłׂẴt@CꍇB
			while ((value = API_NAME(FindNext)(pa, NULL)) == 0);
		}
		else if (_iMode & CHECKARCHIVE_RAPID)
		{
			// ȈՃ[hBwb_݂̂A擪3t@CB
			for (int i = 2; i <= 3; i++)
			{
				value = API_NAME(FindNext)(pa, NULL);
				if (value == 0)
				{
					// BɑB
					continue;
				}
				else
				{
					// IG[BeB
					break;
				}
			}
		}

		nReturnCode = (value == 0 || value == -1);

		if (_iMode & CHECKARCHIVE_SFX && nReturnCode)
		{
			// SFX ̎ނB
			int nSFXCode = API_NAME(IsSFXFile)(pa);
			if (nSFXCode != 0 && nSFXCode != -1)
			{
				nReturnCode = nSFXCode + 0x8000;
			}
		}
	}
	else if (value == -1)
	{
		// t@Ci[ĂȂƎv鏑ɂ̏B
		// Ƃ肠TRUEԂB
		nReturnCode = TRUE;
	}

	// IŃ[v𔲂ꍇ͐B
	API_NAME(CloseArchive)(pa);
	Process_End(nReturnCode);
}

// GetFileCount : ɂ̊i[t@C\B
int WINAPI API_NAME(GetFileCount)(LPCSTR _szArcFile)
{
	// Process_Stâ͓rAPIĂԂ߁B
	HARC pa = API_NAME(OpenArchive)(NULL, _szArcFile, 0);
	if (pa == NULL)
	{
		Process_End(-1);
	}
	int count = 0, value = API_NAME(FindFirst)(pa, "*", NULL);
	if (value == 0)
	{
		do
		{
			count++;
		}
		while ((value = API_NAME(FindNext)(pa, NULL)) == 0);
		API_NAME(CloseArchive)(pa);

		// G[m
		if (value != 0 && value != -1)
		{
			Process_End(-1);
		}
	}
	else
	{
		API_NAME(CloseArchive)(pa);
		// t@Ci[ĂȂ(oFłȂ)ɂƔ肳ꂽꍇɂ0ԂB
		Process_End(value == -1 ? 0 : -1);
	}

	Process_End(count);
}

// QueryFunctionList : API Ή̎擾B
BOOL WINAPI API_NAME(QueryFunctionList)(const int _iFunction)
{
	switch (_iFunction)
	{
		case ISARC:
		case ISARC_GET_VERSION:
		case ISARC_GET_CURSOR_INTERVAL:
		case ISARC_SET_CURSOR_INTERVAL:
		case ISARC_GET_BACK_GROUND_MODE:
		case ISARC_SET_BACK_GROUND_MODE:
		case ISARC_GET_CURSOR_MODE:
		case ISARC_SET_CURSOR_MODE:
		case ISARC_GET_RUNNING:

		case ISARC_CHECK_ARCHIVE:
		case ISARC_CONFIG_DIALOG:
		case ISARC_GET_FILE_COUNT:
		case ISARC_QUERY_FUNCTION_LIST:

/*		case ISARC_HOUT:
		case ISARC_STRUCTOUT:
		case ISARC_GET_ARC_FILE_INFO: */
		case ISARC_OPEN_ARCHIVE:
		case ISARC_CLOSE_ARCHIVE:
		case ISARC_FIND_FIRST:
		case ISARC_FIND_NEXT:
/*		case ISARC_EXTRACT:
		case ISARC_ADD:
		case ISARC_MOVE:
		case ISARC_DELETE: */

		case ISARC_SETOWNERWINDOW:
		case ISARC_CLEAROWNERWINDOW:
		case ISARC_SETOWNERWINDOWEX:
		case ISARC_KILLOWNERWINDOWEX:

		case ISARC_GET_ARC_FILE_NAME:
		case ISARC_GET_ARC_FILE_SIZE:
		case ISARC_GET_ARC_ORIGINAL_SIZE:
		case ISARC_GET_ARC_COMPRESSED_SIZE:
		case ISARC_GET_ARC_RATIO:
		case ISARC_GET_ARC_DATE:
		case ISARC_GET_ARC_TIME:
		case ISARC_GET_ARC_OS_TYPE:
		case ISARC_GET_ARC_IS_SFX_FILE:
		case ISARC_GET_ARC_WRITE_TIME_EX:
		case ISARC_GET_ARC_CREATE_TIME_EX:
		case ISARC_GET_ARC_ACCESS_TIME_EX:
/*		case ISARC_GET_ARC_CREATE_TIME_EX2:
		case ISARC_GET_ARC_ACCESS_TIME_EX2: */

		case ISARC_GET_FILE_NAME:
		case ISARC_GET_ORIGINAL_SIZE:
		case ISARC_GET_COMPRESSED_SIZE:
		case ISARC_GET_RATIO:
		case ISARC_GET_DATE:
		case ISARC_GET_TIME:
		case ISARC_GET_CRC:
		case ISARC_GET_ATTRIBUTE:
		case ISARC_GET_OS_TYPE:
		case ISARC_GET_METHOD:
		case ISARC_GET_WRITE_TIME:
		case ISARC_GET_CREATE_TIME:
		case ISARC_GET_ACCESS_TIME:
		case ISARC_GET_WRITE_TIME_EX:
		case ISARC_GET_CREATE_TIME_EX:
		case ISARC_GET_ACCESS_TIME_EX:

		case ISARC_SET_ENUM_MEMBERS_PROC:
		case ISARC_CLEAR_ENUM_MEMBERS_PROC:

		case ISARC_GET_ARC_FILE_SIZE_EX:
		case ISARC_GET_ARC_ORIGINAL_SIZE_EX:
		case ISARC_GET_ARC_COMPRESSED_SIZE_EX:

		case ISARC_GET_ORIGINAL_SIZE_EX:
		case ISARC_GET_COMPRESSED_SIZE_EX:

		case ISARC_SETOWNERWINDOWEX64:
		case ISARC_KILLOWNERWINDOWEX64:
		case ISARC_SET_ENUM_MEMBERS_PROC64:
		case ISARC_CLEAR_ENUM_MEMBERS_PROC64:

		case ISARC_OPEN_ARCHIVE2:

		case ISARC_GET_ARC_READ_SIZE:
		case ISARC_GET_ARC_READ_SIZE_EX:

		case SET_LANGUE_JAPANESE:
		case SET_LANGUE_ENGLISH:
		case SET_LANGUE_SPECIFIED:
		case ISARC_SET_LANGUE_SPECIFIED:
		case ISARC_SET_LANGUE_JAPANESE:
		case ISARC_SET_LANGUE_ENGLISH:

		case ISARC_SET_PRIORITY:
			return true;
	}
	return false;
}

// ConfigDialog : ȈՐݒ_CAO̕\B
BOOL WINAPI API_NAME(ConfigDialog)(const HWND _hwnd, LPSTR _szOptionBuffer, const int)
{
	Process(FALSE, (BOOL) DialogBoxParam(hDLL, MAKEINTRESOURCE(ID_DLG_CONFIG), _hwnd, ConfigDialogProc, (LPARAM) _szOptionBuffer));
}

//******************************************************************************
//    OpenArchive n API (1) -  API Q
//******************************************************************************

// OpenArchive : Ƀnh擾B
HARC WINAPI API_NAME(OpenArchive)(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode)
{
	return API_NAME(OpenArchive2)(_hwnd, _szFileName, _dwMode, NULL);
}

// OpenArchive2 : Ƀnh擾B
HARC WINAPI API_NAME(OpenArchive2)(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode, LPCSTR _szOption)
{
	Process_Sta(NULL);
	API_NAME(Archive) * pa = new API_NAME(Archive);

	// ϐ`
	char * argv[1024];

	// R}hC
	int argc = cmdline2array(argv, _szOption == NULL ? "" : _szOption);
	// B
	API_NAME(ArchiveInfo) pai;
	API_NAME(Switch) ps;

	// XCb`ݒB
	int i = 0;
	ConvertSwitchToStruct(argv, i, argc, _dwMode, pai, ps);

	memset(pa, 0, sizeof(API_NAME(Archive)));
	if (! pa->Open(_szFileName))
	{
		if (pps->sQuietInfo.bShowErrorDialog)
		{
			ErrorConfirmDialog(_hwnd, ERROR_ARC_FILE_OPEN, TRUE);
		}
		delete pa;
		Process_End(NULL);
	}
	Process_End((HARC) pa);
}

// CloseArchive : ɃnhB
int WINAPI API_NAME(CloseArchive)(HARC _harc)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}
	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;
	int nReturn = pa->Close() ? 0 : ERROR_CLOSE_FILE;
	for(int i = 0; pa->szWildName[i] != NULL; i++) free(pa->szWildName[i]);
	delete pa;
	Process_End(nReturn);
}

// FindFirst : ŏ̃t@C擾B
int WINAPI API_NAME(FindFirst)(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO * _lpSubInfo)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}

	API_NAME(FileInfo) pfi;
	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;

	// t@CXg𕪊B
	char * argv[1024];
	int argc = cmdline2array(argv, _szWildName);

	// t@CXg𐮗B
	char * szFiles[512];
	{
		int nReturn = MakeSeparatedList(argc, (const char * *) argv, szFiles);
		pa->szWildName = szFiles;
		if (nReturn != 0)
		{
			Process_End(nReturn);
		}
	}

	int i = pa->FindFile(TRUE, & pfi);
	if (i == 0 && _lpSubInfo != NULL)
	{
		memset(_lpSubInfo, 0, sizeof(INDIVIDUALINFO));
		strcpy(_lpSubInfo->szFileName, pfi.szFileName);
		GetArchiveString(pa->paiInfo.dwArchiveType, _lpSubInfo->szMode, sizeof(_lpSubInfo->szMode) - 1);
		_lpSubInfo->dwOriginalSize	=	(DWORD) pfi.llFileSize;
	}

	Process_End(i);
}

// FindNext : 2 Ԗڈȍ~̃t@C擾B
int WINAPI API_NAME(FindNext)(HARC _harc, INDIVIDUALINFO * _lpSubInfo)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}

	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;
	if (! pa->bReaded)
	{
		Process_End(ERROR_NOT_SEARCH_MODE);
	}

	API_NAME(FileInfo) pfi;

	int i = pa->FindFile(FALSE, & pfi);
	if (i == 0 && _lpSubInfo != NULL)
	{
		memset(_lpSubInfo, 0, sizeof(INDIVIDUALINFO));
		strcpy(_lpSubInfo->szFileName, pfi.szFileName);
		GetArchiveString(pa->paiInfo.dwArchiveType, _lpSubInfo->szMode, sizeof(_lpSubInfo->szMode) - 1);
		_lpSubInfo->dwOriginalSize	=	(DWORD) pfi.llFileSize;
	}
	Process_End(i);
}

//******************************************************************************
//    OpenArchive n API (2) - ɏ擾 API Q
//******************************************************************************

// GetArcFileName : bZ[W̑MEChEݒB
int WINAPI API_NAME(GetArcFileName)(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}
	strncpy(_lpBuffer, ((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, _nSize - 1);

	Process_End(0);
}

// GetArcFileSize : ɃTCY擾B
DWORD WINAPI API_NAME(GetArcFileSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetArcFileSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetArcFileSizeEx : ɃTCY擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcFileSizeEx)(HARC _harc, LONGLONG * _lpllSize)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

	struct _stati64 stInfo;
	if (_stati64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
	{
		Process_End(FALSE);
	}
	* _lpllSize = stInfo.st_size;

	Process_End(TRUE);
}

// GetArcOriginalSize : Kt@C̍v擾B
DWORD WINAPI API_NAME(GetArcOriginalSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetArcOriginalSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetArcOriginalSizeEx : Kt@C̍v擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcOriginalSizeEx)(HARC _harc, LONGLONG * _lpllSize)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}
	* _lpllSize = ((API_NAME(Archive) *) _harc)->llTotalOriginalSize;
	Process_End(FALSE);
}

// GetArcCompressedSize : Kt@C̈kTCY̍v擾B
DWORD WINAPI API_NAME(GetArcCompressedSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetArcCompressedSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetArcCompressedSizeEx : Kt@C̈kTCY̍v擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcCompressedSizeEx)(HARC, LONGLONG *)
{
	// `̎dl擾sB
	return FALSE;
}

// GetArcRatio : Kt@C̑Ŝ̈k擾B
WORD WINAPI API_NAME(GetArcRatio)(HARC)
{
	// `̎dl擾sB
	return 0xFFFF;
}

// GetArcDate : ɂ̓t擾B
WORD WINAPI API_NAME(GetArcDate)(HARC _harc)
{
	FILETIME ftDate;
	WORD wDate, wTime;
	return (API_NAME(GetArcWriteTimeEx)(_harc, & ftDate) && FileTimeToDosDateTime(& ftDate, & wDate, & wTime) != 0) ? wDate : -1;
}

// GetArcTime : ɂ̎擾B
WORD WINAPI API_NAME(GetArcTime)(HARC _harc)
{
	FILETIME ftDate;
	WORD wDate, wTime;
	return (API_NAME(GetArcWriteTimeEx)(_harc, & ftDate) && FileTimeToDosDateTime(& ftDate, & wDate, & wTime) != 0) ? wTime : -1;
}

// GetArcCreateTimeEx : ɂ̍쐬擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcCreateTimeEx)(HARC _harc, FILETIME * _lpftCreationTime)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

#ifdef __GNUC__
	struct __stat64 stInfo;
	if (_stat64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#else
	struct _stati64 stInfo;
	if (_stati64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#endif
	{
		Process_End(FALSE);
	}
	* _lpftCreationTime = TimetToFileTime(stInfo.st_ctime);

	Process_End(TRUE);
}

// GetArcAccessTimeEx : ɂ̎QƎ擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcAccessTimeEx)(HARC _harc, FILETIME * _lpftLastAccessTime)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

#ifdef __GNUC__
	struct __stat64 stInfo;
	if (_stat64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#else
	struct _stati64 stInfo;
	if (_stati64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#endif
	{
		Process_End(FALSE);
	}
	* _lpftLastAccessTime = TimetToFileTime(stInfo.st_atime);

	Process_End(TRUE);
}

// GetArcWriteTimeEx : ɂ̍XV擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcWriteTimeEx)(HARC _harc, FILETIME * _lpftLastWriteTime)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

#ifdef __GNUC__
	struct __stat64 stInfo;
	if (_stat64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#else
	struct _stati64 stInfo;
	if (_stati64(((API_NAME(Archive) *) _harc)->paiInfo.szArchiveName, & stInfo) != 0)
#endif
	{
		Process_End(FALSE);
	}
	* _lpftLastWriteTime = TimetToFileTime(stInfo.st_mtime);

	Process_End(TRUE);
}

// GetArcOSType : ɂ̍쐬OS擾B
UINT WINAPI API_NAME(GetArcOSType)(HARC)
{
	// `̎dl擾sB
	return 0xFFFFFFFF;
}

// GetIsSFXFile : ɂ̍쐬OS擾B
int WINAPI API_NAME(IsSFXFile)(HARC _harc)
{
	Process_Sta(-1);
	if (_harc == NULL)
	{
		Process_End(-1);
	}

	Process_End(((API_NAME(Archive) *) _harc)->paiInfo.nSFXModuleType);
}

// GetArcReadSize : ɂ̓ǂݍݍς݃TCY̍v擾B
DWORD WINAPI API_NAME(GetArcReadSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetArcReadSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetArcReadSizeEx : ɂ̓ǂݍݍς݃TCY̍v擾 (64Bit)B
BOOL WINAPI API_NAME(GetArcReadSizeEx)(HARC _harc, LONGLONG * _lpllSize)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

	fpos_t poSize;
	if (fgetpos(((API_NAME(Archive) *) _harc)->fp, & poSize) != 0)
	{
		Process_End(FALSE);
	}
	* _lpllSize = poSize;

	Process_End(TRUE);
}

//******************************************************************************
//    OpenArchive n API (3) - i[t@C擾 API Q
//******************************************************************************

// GetFileName : i[t@C擾B
int WINAPI API_NAME(GetFileName)(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}

	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;
	if (! pa->bReaded)
	{
		Process_End(ERROR_NOT_SEARCH_MODE);
	}
	strncpy(_lpBuffer, pa->pfiCurrent.szFileName, _nSize - 1);

	Process_End(0);
}

// GetMethod : i[t@C̊i[@擾B
int WINAPI API_NAME(GetMethod)(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	Process_Sta(ERROR_ALREADY_RUNNING);
	if (_harc == NULL)
	{
		Process_End(ERROR_HARC_ISNOT_OPENED);
	}

	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;
	if (! pa->bReaded)
	{
		Process_End(ERROR_NOT_SEARCH_MODE);
	}

	// `Rs[B
	GetArchiveString(pa->paiInfo.dwArchiveType, _lpBuffer, _nSize - 1);

	Process_End(0);
}

// GetOriginalSize : i[t@C̃t@CTCY擾B
DWORD WINAPI API_NAME(GetOriginalSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetOriginalSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetOriginalSizeEx : i[t@C̃t@CTCY擾 (64Bit)B
BOOL WINAPI API_NAME(GetOriginalSizeEx)(HARC _harc, LONGLONG * _lpllSize)
{
	Process_Sta(FALSE);
	if (_harc == NULL)
	{
		Process_End(FALSE);
	}

	API_NAME(Archive) * pa = (API_NAME(Archive) *) _harc;
	if (! pa->bReaded)
	{
		Process_End(FALSE);
	}
	* _lpllSize = pa->pfiCurrent.llFileSize;

	Process_End(TRUE);
}

// GetCompressedSize : i[t@C̃t@CTCY擾B
DWORD WINAPI API_NAME(GetCompressedSize)(HARC _harc)
{
	LONGLONG llSize;
	return API_NAME(GetCompressedSizeEx)(_harc, & llSize) ? (DWORD) llSize : -1;
}

// GetCompressedSizeEx : i[t@C̃t@CTCY擾 (64Bit)B
BOOL WINAPI API_NAME(GetCompressedSizeEx)(HARC, LONGLONG *)
{
	// `̎dl擾sB
	return FALSE;
}

// GetRatio : i[t@C̈k擾B
WORD WINAPI API_NAME(GetRatio)(HARC)
{
	// `̎dl擾sB
	return 0xFFFF;
}

// GetDate : i[t@C̓t擾B
WORD WINAPI API_NAME(GetDate)(HARC _harc)
{
	FILETIME ftDate;
	WORD wDate, wTime;
	return (API_NAME(GetArcWriteTimeEx)(_harc, & ftDate) && FileTimeToDosDateTime(& ftDate, & wDate, & wTime) != 0) ? wDate : -1;
}

// GetTime : i[t@C̎擾B
WORD WINAPI API_NAME(GetTime)(HARC _harc)
{
	FILETIME ftDate;
	WORD wDate, wTime;
	return (API_NAME(GetArcWriteTimeEx)(_harc, & ftDate) && FileTimeToDosDateTime(& ftDate, & wDate, & wTime) != 0) ? wTime : -1;
}

// GetCreateTime : i[t@C̍쐬擾B
DWORD WINAPI API_NAME(GetCreateTime)(HARC _harc)
{
	FILETIME ftDate;

	// FILETIME  DWORD ɕϊB     
	return API_NAME(GetCreateTimeEx)(_harc, & ftDate) ? FileTimeToTimet(& ftDate) : -1;
}

// GetCreateTimeEx : i[t@C̍쐬擾 (64Bit)B
BOOL WINAPI API_NAME(GetCreateTimeEx)(HARC, FILETIME *)
{
	// `̎dl擾sB
	return FALSE;
}

// GetWriteTime : i[t@C̍XV擾B
DWORD WINAPI API_NAME(GetWriteTime)(HARC _harc)
{
	FILETIME ftDate;

	// FILETIME  DWORD ɕϊB     
	return API_NAME(GetWriteTimeEx)(_harc, & ftDate) ? FileTimeToTimet(& ftDate) : -1;
}

// GetWriteTimeEx : i[t@C̍XV擾 (64Bit)B
BOOL WINAPI API_NAME(GetWriteTimeEx)(HARC, FILETIME *)
{
	// `̎dl擾sB
	return FALSE;
}

// GetAccessTime : i[t@C̎QƓ擾B
DWORD WINAPI API_NAME(GetAccessTime)(HARC _harc)
{
	FILETIME ftDate;

	// FILETIME  DWORD ɕϊB     
	return API_NAME(GetAccessTimeEx)(_harc, & ftDate) ? FileTimeToTimet(& ftDate) : -1;
}

// GetAccessTimeEx : i[t@C̎QƓ擾 (64Bit)B
BOOL WINAPI API_NAME(GetAccessTimeEx)(HARC, FILETIME *)
{
	// `̎dl擾sB
	return FALSE;
}

// GetCRC : i[t@C̃`FbNT擾B
DWORD WINAPI API_NAME(GetCRC)(HARC)
{
	// `̎dl擾sB
	return 0xFFFFFFFF;
}

// GetAttribute : i[t@C̑擾B
int WINAPI API_NAME(GetAttribute)(HARC _harc)
{
	// GetAttributes()ĂяoB
	return API_NAME(GetAttributes)(_harc);
}

// GetAttributes : i[t@C̑擾B
int WINAPI API_NAME(GetAttributes)(HARC)
{
	// `̎dl擾sB
	return -1;
}

// GetOSType : i[t@C̍쐬OS擾B
UINT WINAPI API_NAME(GetOSType)(HARC)
{
	// `̎dl擾sB
	return 0xFFFFFFFF;
}

//******************************************************************************
//    SetOwnerWindow n API
//******************************************************************************

// SetOwnerWindow : bZ[W̑MEChEݒB
BOOL WINAPI API_NAME(SetOwnerWindow)(HWND _hwnd)
{
	return API_NAME(SetOwnerWindowEx64)(_hwnd, NULL, sizeof(EXTRACTINGINFO));
}

// ClearOwnerWindow : bZ[W̑MEChEݒB
BOOL WINAPI API_NAME(ClearOwnerWindow)(void)
{
	return API_NAME(KillOwnerWindowEx64)(NULL);
}

// SetOwnerWindowEx : bZ[W̑MR[obN֐ݒ (32Bit)B
BOOL WINAPI API_NAME(SetOwnerWindowEx)(HWND _hwnd, LPARCHIVERPROC _lpArcProc)
{
	return API_NAME(SetOwnerWindowEx64)(_hwnd, _lpArcProc, sizeof(EXTRACTINGINFO));
}

// KillOwnerWindowEx : bZ[W̑MR[obN֐ (32Bit)B
BOOL WINAPI API_NAME(KillOwnerWindowEx)(HWND _hwnd)
{
	return API_NAME(KillOwnerWindowEx64)(_hwnd);
}

// SetOwnerWindowEx64 : bZ[W̑MR[obN֐ݒ (64Bit)B
BOOL WINAPI API_NAME(SetOwnerWindowEx64)(HWND _hwnd, LPARCHIVERPROC _lpArcProc, DWORD _dwStructSize)
{
	Process_Sta(FALSE);
	if ((_lpArcProc == NULL && _hwnd == NULL) || (
		_dwStructSize != sizeof(EXTRACTINGINFO) &&
		_dwStructSize != sizeof(EXTRACTINGINFOEX) &&
		_dwStructSize != sizeof(EXTRACTINGINFOEX32) &&
		_dwStructSize != sizeof(EXTRACTINGINFOEX64)
		))
	{
		Process_End(FALSE);
	}

	cbProc.sProgress.apCallbackProc = (ARCHIVERPROC) _lpArcProc;
	cbProc.sProgress.hwDialog = _hwnd;
	cbProc.sProgress.dwStructureSize = _dwStructSize;

	Process_End(TRUE);
}

// KillOwnerWindowEx64 : bZ[W̑MR[obN֐ (64Bit)B
BOOL WINAPI API_NAME(KillOwnerWindowEx64)(HWND _hwnd)
{
	Process_Sta(FALSE);
	if (_hwnd != NULL && _hwnd != cbProc.sProgress.hwDialog)
	{
		Process_End(FALSE);
	}

	cbProc.sProgress.apCallbackProc = NULL;
	cbProc.sProgress.hwDialog = NULL;
	cbProc.sProgress.dwStructureSize = 0;

	Process_End(TRUE);
}

//******************************************************************************
//    SetEnumMembersProc n API
//******************************************************************************

// SetEnumMembersProc : R[obN֐ݒB
BOOL WINAPI API_NAME(SetEnumMembersProc)(PAQ_WND_ENUMMEMBPROC _lpEnumProc)
{
	return API_NAME(SetEnumMembersProc64)(_lpEnumProc, sizeof(PAQ_ENUM_MEMBER_INFO));
}

// ClearEnumMembersProc : R[obN֐B
BOOL WINAPI API_NAME(ClearEnumMembersProc)(void)
{
	return API_NAME(ClearEnumMembersProc64)();
}

// SetEnumMembersProc64 : R[obN֐ݒ (64Bit)B
BOOL WINAPI API_NAME(SetEnumMembersProc64)(PAQ_WND_ENUMMEMBPROC _lpEnumProc, DWORD _dwStructSize)
{
	Process_Sta(FALSE);
	if (_lpEnumProc == NULL || (_dwStructSize != sizeof(PAQ_ENUM_MEMBER_INFO) && _dwStructSize != sizeof(PAQ_ENUM_MEMBER_INFO64)))
	{
		Process_End(FALSE);
	}

	cbProc.sFileInfo.dwStructureSize = _dwStructSize;
	cbProc.sFileInfo.epCallbackProc = * _lpEnumProc;

	Process_End(TRUE);
}

// ClearEnumMembersProc64 : R[obN֐ (64Bit)B
BOOL WINAPI API_NAME(ClearEnumMembersProc64)(void)
{
	Process_Sta(FALSE);

	cbProc.sFileInfo.dwStructureSize = 0;
	cbProc.sFileInfo.epCallbackProc = NULL;

	Process_End(TRUE);
}

//******************************************************************************
//    SetLangueSpecified n API
//******************************************************************************

// SetLangueSpecified : \[X̌ݒB
void WINAPI SetLangueSpecified(LANGID _wLanguage)
{
	// ŗp邽߂ɒlmہB
	g_LanguageID = _wLanguage;
}

// SetLangueJapanese : \[X̌{ɐݒB
void WINAPI SetLangueJapanese(void)
{
	SetLangueSpecified(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT));
}

// SetLangueEnglish : \[X̌pɐݒB
void WINAPI SetLangueEnglish(void)
{
	SetLangueSpecified(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US));
}

// SetLangueSpecified : \[X̌ݒB
void WINAPI API_NAME(SetLangueSpecified)(LANGID _wLanguage)
{
	SetLangueSpecified(_wLanguage);
}

// SetLangueJapanese : \[X̌{ɐݒB
void WINAPI API_NAME(SetLangueJapanese)(void)
{
	SetLangueJapanese();
}

// SetLangueEnglish : \[X̌pɐݒB
void WINAPI API_NAME(SetLangueEnglish)(void)
{
	SetLangueEnglish();
}

//******************************************************************************
//    ̑API
//******************************************************************************

// SetPriority : Xbh̗D揇ʂݒB
BOOL WINAPI API_NAME(SetPriority)(int _nPriority)
{
	// GetCurrentThread() Ŏ擾nh͋[nhł̂ŁA
	// CloseHandle() Kv͖B
	return SetThreadPriority(GetCurrentThread(), _nPriority);
}

} // extern "C"
