// Independent class
// $Id: TPIHandle.cpp,v 1.5 2006/07/28 10:40:12 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "stdafx.h"
#include "..\header\plugin.h"
#include "TPIHandle.h"

//******************************************************************************
//    Class (TPIHandle)
//******************************************************************************

TPIHandle::~TPIHandle(void)
{
	this->FreeLibrary();
}

BOOL TPIHandle::InitLibrary(const char * _szLibName, const char * _szArcName, ULONGLONG _llSubOption)
{
	this->hPlugin = ::LoadLibrary(_szLibName);
	if (this->hPlugin == NULL)
	{
		return FALSE;
	}

	// InitPlugin
	if (_szArcName != NULL)
	{
		try
		{
			FARPROC fp = ::GetProcAddress(this->hPlugin, "LoadPlugin");
			if (fp == NULL) return FALSE;
			return ((int (WINAPI *)(const char *, ULONGLONG)) fp)(_szArcName, _llSubOption);
		}
		catch (...)
		{
			return FALSE;
		}
	}

	return TRUE;
}

BOOL TPIHandle::FreeLibrary(void)
{
	// FreePlugin
	if (this->hPlugin == NULL)
	{
		return FALSE;
	}

	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "FreePlugin");
		if (fp == NULL) return FALSE;
		((int (WINAPI *)(void *)) fp)(NULL);
	}
	catch (...)
	{
		return FALSE;
	}

	return ::FreeLibrary(this->hPlugin);
}

int TPIHandle::GetPluginInformation(unsigned int _uInfoId, ULONGLONG _llSubOption, void * _pPtr)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "GetPluginInformation");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(unsigned int, ULONGLONG, void *)) fp)(_uInfoId, _llSubOption, _pPtr);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::CheckArchive(const char * _szArcName, int * _nFileCount)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "CheckArchive");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(const char *, int *)) fp)(_szArcName, _nFileCount);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::OpenArchive(const char * _szArcName, void * * _hArchive)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "OpenArchive");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(const char *, void * *)) fp)(_szArcName, _hArchive);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::CloseArchive(void * _hArchive)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "CloseArchive");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(void *)) fp)(_hArchive);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::GetFileInformation(void * _hArchive, TPI_FILEINFO * _fiInfo, BOOL _bFirst)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "GetFileInformation");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(void *, TPI_FILEINFO *, BOOL)) fp)(_hArchive, _fiInfo, _bFirst);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::GetArchiveInformation(void * _hArchive, TPI_ARCHIVEINFO * _aiInfo)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "GetArchiveInformation");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(void *, TPI_ARCHIVEINFO *)) fp)(_hArchive, _aiInfo);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::Command(unsigned int _uCommand, TPI_SWITCHES * _swInfo, const char * _szArcName, const char * _szFiles)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "Command");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(unsigned int, TPI_SWITCHES *, const char *, const char *)) fp)(_uCommand, _swInfo, _szArcName, _szFiles);
	}
	catch (...)
	{
		return -1;
	}
}

int TPIHandle::SetCallbackProc(TPI_PROC _prProc)
{
	try
	{
		FARPROC fp = ::GetProcAddress(this->hPlugin, "SetCallbackProc");
		if (fp == NULL) return -1;
		return ((int (WINAPI *)(TPI_PROC)) fp)(_prProc);
	}
	catch (...)
	{
		return -1;
	}
}
