// frontend
// $Id: functions.h,v 1.4 2006/07/16 06:18:57 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    萔`
//******************************************************************************

#ifndef H_LOADED_FUNCTIONS
#define H_LOADED_FUNCTIONS

//******************************************************************************
//    \̒`
//******************************************************************************

struct CreateDialogInfo
{
	char szDestinationPath[MAX_PATH + 1];
	char szArchiveName[MAX_PATH + 1];
	BOOL bOpenDirectory;
	BOOL bIgnorePath;
	BOOL bExitAfter;
	int eArchiveType;
	char szLibName[MAX_PATH + 1];
	BOOL bMakeSFX;
};

struct ExtractDialogInfo
{
	char szDestinationPath[MAX_PATH + 1];
	int eMakeDirectory;
	BOOL bOpenDirectory;
	BOOL bIgnorePath;
	BOOL bExitAfter;
};

//******************************************************************************
//    Rg[n֐
//******************************************************************************

BOOL TreeView_CheckNewerItem(HWND, HTREEITEM, const char *);
BOOL TreeView_GetItemPath(HWND hTreeView, HTREEITEM htiItem, char * szNodePath, int nSize);
BOOL ListView_FileInfoToShow(HWND hWnd, int nListViewID, int nItemNum, TPI_FILEINFO fiInfo, HIMAGELIST hIconL, HIMAGELIST hIconS);
BOOL ListView_SortingWith(NM_LISTVIEW * _pnmListView, HWND _hListView);
BOOL MenuBar_SetListViewStyle(HWND _hWnd, int _nCheckMenuID, int _nListViewStyle);
BOOL MenuBar_SetSomeBarStyle(HWND _hWnd, int _nMenuItemID, int _nBarID);

//******************************************************************************
//    _CAOvV[W
//******************************************************************************

BOOL CALLBACK CreateDialogProc      (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ExtractDialogProc     (HWND, UINT, WPARAM, LPARAM);
int  CALLBACK BrowseFolderDialogProc(HWND, UINT, LPARAM, LPARAM);
BOOL CALLBACK ProcessDialogProc     (HWND, UINT, WPARAM, LPARAM);
int  CALLBACK ListViewCompureProc       (LPARAM, LPARAM, LPARAM);

//******************************************************************************
//    ֐
//******************************************************************************

int LoadArchive(HWND hWnd, const char * szFileName, TPIHandle & tpi, int nTreeViewID);
BOOL AttributeToString(DWORD dwAttribute, char * szBuffer);
int cmdline2array(char **argv, const char *cmdline);
void CenteringWindow(HWND _hwnd, HWND _hwParent);
BOOL BackSlashToSlash(char *);
BOOL SlashToBackSlash(char *);
BOOL WritePrivateProfileInt(const char * lpAppName, const char * lpKeyName, int nInt, const char * lpFileName);
void ErrorCodeDialog(HWND hWnd, int nErrorCode);

#endif
