// calLibrary
// $Id: calLibrary.cpp,v 1.13 2006/08/20 13:22:27 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include <windows.h>
#include "..\..\common\header\plugin.h"
#include "..\..\common\header\plugin-extra.h"
#include "calLibrary.h"

#ifdef __cplusplus
extern "C"
{
#endif

//******************************************************************************
//    Global varients
//******************************************************************************

HMODULE g_hInst;
char g_szIniFileName[MAX_PATH * 2 + 1];

struct
{
	HMODULE hLib;
	char szLibName[MAX_PATH * 2 + 1];
	char szPrefix[100];
	int nLibIndex;
}	g_LibInfo;

TPI_PROC g_prProc;
BOOL g_fCallback32bit;

//******************************************************************************
//    Entry
//******************************************************************************

BOOL APIENTRY DllMain
(
	HMODULE hModule,
	DWORD  fdwReason,
	LPVOID // lpReserved
)
{
	switch (fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		// nhۑB
		g_hInst = hModule;

		// InĩpX擾B
		::GetModuleFileName(g_hInst, (char *) & g_szIniFileName, sizeof(g_szIniFileName) - 1);
		for (int i = ::lstrlen(g_szIniFileName); i > 0; i--)
		{
			if (g_szIniFileName[i] == '\\')
			{
				g_szIniFileName[i + 1] = 0;
				break;
			}
		}
		::lstrcat(g_szIniFileName, "calLibrary.ini");
		break;
	case DLL_PROCESS_DETACH:
		::FreeLibrary(g_LibInfo.hLib);
		break;
	}
	return TRUE;
}

//******************************************************************************
//    Callback Wrapper
//******************************************************************************

BOOL CALLBACK CallbackProc(HWND, unsigned int _uMsg, unsigned int _uState, void * _lpEis)
{
	if (_uMsg != ::RegisterWindowMessage(WM_ARCEXTRACT))
	{
		// ƎdlȂǂɑ΂\R[hB
		return TRUE;
	}

	// \̂B
	TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;

	if (_lpEis != NULL)
	{
		if (g_fCallback32bit)
		{
			// B
			EXTRACTINGINFOEX * ex = (EXTRACTINGINFOEX *) _lpEis;

			// EXTRACTINGINFOEX -> TPI_FILEINFOϊB
			piInfo.fiInfo.dwAttribute       = 0;
			piInfo.fiInfo.dwCRC32           = ex->dwCRC;
			::DosDateTimeToFileTime(ex->wDate, ex->wTime, & piInfo.fiInfo.ftModifiedTime);
			piInfo.fiInfo.llPackedSize      = ex->dwCompressedSize;
			piInfo.fiInfo.llUnpackedSize    = ex->exinfo.dwFileSize;
			piInfo.fiInfo.uOSType           = ex->uOSType;
			piInfo.fiInfo.wCompressRatio    = ex->wRatio;
			::lstrcpyn(piInfo.fiInfo.szFileName, ex->exinfo.szSourceFileName, sizeof(piInfo.fiInfo.szFileName) - 1);
			::lstrcpyn(piInfo.fiInfo.szMethod,   ex->szMode, sizeof(piInfo.fiInfo.szMethod) - 1);

			// EXTRACTINGINFOEX -> TPI_PROCESSINFOϊB
			piInfo.llProcessedSize          = ex->exinfo.dwWriteSize;
			::lstrcpyn(piInfo.szDestinationFileName, ex->exinfo.szDestFileName, sizeof(piInfo.szDestinationFileName) - 1);
		}
		else
		{
			// B
			EXTRACTINGINFOEX64 * ex = (EXTRACTINGINFOEX64 *) _lpEis;

			// EXTRACTINGINFOEX64 -> TPI_FILEINFOϊB
			piInfo.fiInfo.dwAttribute       = ex->dwAttributes;
			piInfo.fiInfo.dwCRC32           = ex->dwCRC;
			piInfo.fiInfo.ftAccessTime      = ex->ftAccessTime;
			piInfo.fiInfo.ftCreateTime      = ex->ftCreateTime;
			piInfo.fiInfo.ftModifiedTime    = ex->ftWriteTime;
			piInfo.fiInfo.llPackedSize      = ex->llCompressedSize;
			piInfo.fiInfo.llUnpackedSize    = ex->llFileSize;
			piInfo.fiInfo.uOSType           = ex->uOSType;
			piInfo.fiInfo.wCompressRatio    = ex->wRatio;
			::lstrcpyn(piInfo.fiInfo.szFileName, ex->szSourceFileName, sizeof(piInfo.fiInfo.szFileName) - 1);
			::lstrcpyn(piInfo.fiInfo.szMethod,   ex->szMode, sizeof(piInfo.fiInfo.szMethod) - 1);

			// EXTRACTINGINFOEX64 -> TPI_PROCESSINFOϊB
			piInfo.llProcessedSize          = ex->llWriteSize;
			::lstrcpyn(piInfo.szDestinationFileName, ex->szDestFileName, sizeof(piInfo.szDestinationFileName) - 1);
		}
	}

	// ̏łȂ̏ŕł邱ƂɒӁB
	switch (_uState)
	{
	case ARCEXTRACT_OPEN:
		// Yɂ̏JnB
		piInfo.uStatus = TPI_STATUS_OPENARCHIVE;
		break;
	case 5:
		// Yt@ČB
		piInfo.uStatus = TPI_STATUS_SEEKFILE;
		break;
	case ARCEXTRACT_BEGIN:
		// Yt@C̏JnB
		piInfo.uStatus = TPI_STATUS_BEGINPROCESS;
		break;
	case ARCEXTRACT_INPROCESS:
		// Yt@C̏sB
		piInfo.uStatus = TPI_STATUS_INPROCESS;
		break;
	case 6:
		// Yt@C̏IB
		piInfo.uStatus = TPI_STATUS_ENDPROCESS;
		break;
	case 7:
		// Yɂ̌B
		piInfo.uStatus = TPI_STATUS_TESTARCHIVE;
		break;
	case ARCEXTRACT_COPY:
		// Yɂ̏߂B
		piInfo.uStatus = TPI_STATUS_COPYARCHIVE;
		break;
	case ARCEXTRACT_END:
		// Yɂ̏IB
		piInfo.uStatus = TPI_STATUS_CLOSEARCHIVE;
		break;
	}

	// R[obN֐ɑMB
	if (g_prProc == NULL)
	{
		return TRUE;
	}

	return g_prProc(TPI_NOTIFY_COMMON, & piInfo) != TPI_CALLBACK_CANCEL;
	// Tar32.dllł͎̃R[hԂ́H(--;
//	return g_prProc(TPI_NOTIFY_COMMON, & piInfo) == TPI_CALLBACK_CANCEL;
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

int CalErrorCodeConvert(int nCalErrorCode)
{
	switch (nCalErrorCode)
	{
	case 0:                     return TPI_ERROR_SUCCESS;
	case ERROR_DISK_SPACE:      return TPI_ERROR_IO_ARC_WRITE;
	case ERROR_READ_ONLY:       return TPI_ERROR_IO_FILE_WRITE;
	case ERROR_USER_SKIP:       return TPI_ERROR_D_SKIPPED;
	case ERROR_UNKNOWN_TYPE:    return TPI_ERROR_IO_MISC;
	case ERROR_METHOD:          return TPI_ERROR_ARC_UNSUPPORTED;
	case ERROR_PASSWORD_FILE:   return TPI_ERROR_ARC_ENCRYPTED;
	case ERROR_VERSION:         return TPI_ERROR_ARC_UNSUPPORTED;
	case ERROR_FILE_CRC:        return TPI_ERROR_ARC_BROKEN_SUM;
	case ERROR_FILE_OPEN:       return TPI_ERROR_IO_FILE_OPEN;
	case ERROR_MORE_FRESH:      return TPI_ERROR_IO_FILE_MISC;
	case ERROR_NOT_EXIST:       return TPI_ERROR_IO_FILE_ACCESS;
	case ERROR_ALREADY_EXIST:   return TPI_ERROR_IO_FILE_ACCESS;
	case ERROR_TOO_MANY_FILES:  return TPI_ERROR_IO_ARC_MISC;
	case ERROR_MAKEDIRECTORY:   return TPI_ERROR_IO_DIR_OPEN;
	case ERROR_CANNOT_WRITE:    return TPI_ERROR_IO_FILE_WRITE;
	case ERROR_HUFFMAN_CODE:    return TPI_ERROR_ARC_BROKEN_MISC;
	case ERROR_COMMENT_HEADER:  return TPI_ERROR_ARC_BROKEN_HEADER;
	case ERROR_HEADER_CRC:      return TPI_ERROR_ARC_BROKEN_SUM;
	case ERROR_HEADER_BROKEN:   return TPI_ERROR_ARC_BROKEN_HEADER;
	case ERROR_ARC_FILE_OPEN:   return TPI_ERROR_IO_ARC_OPEN;
	case ERROR_NOT_ARC_FILE:    return TPI_ERROR_D_UNSUPPORTED;
	case ERROR_CANNOT_READ:     return TPI_ERROR_IO_ARC_READ;
	case ERROR_FILE_STYLE:      return TPI_ERROR_D_UNSUPPORTED;
	case ERROR_COMMAND_NAME:    return TPI_ERROR_UNDEFINED;
	case ERROR_MORE_HEAP_MEMORY:return TPI_ERROR_D_OUTOFMEMORY;
	case ERROR_ENOUGH_MEMORY:   return TPI_ERROR_D_OUTOFMEMORY;
	case ERROR_ALREADY_RUNNING: return TPI_ERROR_UNDEFINED;
	case ERROR_USER_CANCEL:     return TPI_ERROR_D_SKIPPED;
	case ERROR_HARC_ISNOT_OPENED: return TPI_ERROR_D_PARAMETER;
	case ERROR_NOT_SEARCH_MODE: return TPI_ERROR_D_PARAMETER;
	case ERROR_NOT_SUPPORT:     return TPI_ERROR_U_USE_LIBRARY;
	case ERROR_TIME_STAMP:      return TPI_ERROR_UNDEFINED;
	case ERROR_TMP_OPEN:        return TPI_ERROR_IO_TMP_OPEN;
	case ERROR_LONG_FILE_NAME:  return TPI_ERROR_IO_FILE_ACCESS;
	case ERROR_ARC_READ_ONLY:   return TPI_ERROR_IO_ARC_ACCESS;
	case ERROR_SAME_NAME_FILE:  return TPI_ERROR_UNDEFINED;
	case ERROR_NOT_FIND_ARC_FILE: return TPI_ERROR_IO_ARC_NOTFOUND;
	case ERROR_RESPONSE_READ:   return TPI_ERROR_IO_MISC_READ;
	case ERROR_NOT_FILENAME:    return TPI_ERROR_IO_FILE_NOTFOUND;
	case ERROR_TMP_COPY:        return TPI_ERROR_IO_TMP_COPY;
	case ERROR_EOF:             return TPI_ERROR_ARC_BROKEN_SIZE;
	case ERROR_ADD_TO_LARC:     return TPI_ERROR_UNDEFINED;
	case ERROR_TMP_BACK_SPACE:  return TPI_ERROR_IO_TMP_MOVE;
	case ERROR_SHARING:         return TPI_ERROR_IO_FILE_ACCESS;
	case ERROR_NOT_FIND_FILE:   return TPI_ERROR_IO_NOTFOUND;
	case ERROR_LOG_FILE:        return TPI_ERROR_IO_MISC_WRITE;
	case ERROR_NO_DEVICE:       return TPI_ERROR_IO_FILE_ACCESS;
	case ERROR_GET_ATTRIBUTES:  return TPI_ERROR_IO_FILE_GETINFO;
	case ERROR_SET_ATTRIBUTES:  return TPI_ERROR_IO_FILE_SETINFO;
	case ERROR_GET_INFORMATION: return TPI_ERROR_IO_FILE_GETINFO;
	case ERROR_GET_POINT:       return TPI_ERROR_IO_FILE_POINT;
	case ERROR_SET_POINT:       return TPI_ERROR_IO_FILE_POINT;
	case ERROR_CONVERT_TIME:    return TPI_ERROR_UNDEFINED;
	case ERROR_GET_TIME:        return TPI_ERROR_IO_FILE_GETINFO;
	case ERROR_SET_TIME:        return TPI_ERROR_IO_FILE_SETINFO;
	case ERROR_CLOSE_FILE:      return TPI_ERROR_IO_FILE_CLOSE;
	case ERROR_HEAP_MEMORY:     return TPI_ERROR_D_USEMEMORY;
	case ERROR_HANDLE:          return TPI_ERROR_UNDEFINED;
	case ERROR_TIME_STAMP_RANGE:return TPI_ERROR_UNDEFINED;
	case ERROR_MAKE_ARCHIVE:    return TPI_ERROR_ARC_BROKEN_MISC;
	case ERROR_NOT_CONFIRM_NAME:return TPI_ERROR_ARC_BROKEN_HEADER;
	case ERROR_UNEXPECTED_EOF:  return TPI_ERROR_ARC_BROKEN_HEADER;
	case ERROR_INVALID_END_MARK:return TPI_ERROR_ARC_BROKEN_SIZE;
	case ERROR_INVOLVED_LZH:    return TPI_ERROR_ARC_BROKEN_MISC;
	case ERROR_NO_END_MARK:     return TPI_ERROR_ARC_BROKEN_SIZE;
	case ERROR_HDR_INVALID_SIZE:return TPI_ERROR_ARC_BROKEN_HEADER;
	case ERROR_UNKNOWN_LEVEL:   return TPI_ERROR_ARC_UNSUPPORTED;
	case ERROR_BROKEN_DATA:     return TPI_ERROR_ARC_BROKEN_MISC;
	case ERROR_INVALID_PATH:    return TPI_ERROR_UNDEFINED;
	case ERROR_TOO_BIG:         return TPI_ERROR_IO_FILE_WRITE;
	case ERROR_EXECUTABLE_FILE: return TPI_ERROR_UNDEFINED;
	case ERROR_INVALID_VALUE:   return TPI_ERROR_UNDEFINED;
	default:                    return TPI_ERROR_UNDEFINED;
	}
}

//******************************************************************************
//    Functions
//******************************************************************************

int WINAPI GetPluginInformation
(
	unsigned int _uInfoId,
	ULONGLONG _llSubOption,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 1;
		break;
	case TPI_INFO_SUPPORTED_TYPE:
	case TPI_INFO_SUPPORTED_SUFFIX:
		// ݒ擾B
		char szKeyName[256];
		::wsprintf(szKeyName, "Library%u", (unsigned int) _llSubOption);
		::GetPrivateProfileString(szKeyName, LOWORD(_uInfoId) == TPI_INFO_SUPPORTED_TYPE ? "TypeName" : "TypeSuffix", NULL, (char *) _pPtr, HIWORD(_uInfoId), g_szIniFileName);
		if (::lstrcmp((char *) _pPtr, "") == 0)
		{
			return TPI_ERROR_D_PARAMETER;
		}
		if (::lstrcmp((char *) _pPtr, "@") == 0)
		{
			((char *) _pPtr)[0] = 0;
		}
		break;
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int WINAPI LoadPlugin
(
	const char * _szArcName,
	ULONGLONG _llSubOption
)
{
	// ݒ擾B
	char szKeyName[256];

	// Ώۂ݂ȂΑΉ郉Cu𒲍A
	// Ώۂ݂ȂȂΎwꂽCu[hB
	HANDLE hFile = ::CreateFile(_szArcName, NULL, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		g_LibInfo.nLibIndex = (int) _llSubOption;
		::wsprintf(szKeyName, "Library%d", g_LibInfo.nLibIndex);
		::GetPrivateProfileString(szKeyName, "Name",   NULL, g_LibInfo.szLibName, sizeof(g_LibInfo.szLibName), g_szIniFileName);
		::GetPrivateProfileString(szKeyName, "Prefix", NULL, g_LibInfo.szPrefix,  sizeof(g_LibInfo.szPrefix),  g_szIniFileName);
		if (::lstrlen(g_LibInfo.szLibName) == 0)
		{
			// wꂽCu݂͑ȂH
			return TPI_ERROR_U_LOAD_LIBRARY;
		}

		// Cu[hB
		g_LibInfo.hLib = ::LoadLibrary(g_LibInfo.szLibName);
		return g_LibInfo.hLib == NULL ? TPI_ERROR_U_LOAD_LIBRARY : TRUE;
	}

	if (! ::CloseHandle(hFile))
	{
		return TPI_ERROR_IO_ARC_CLOSE;
	}

	// [vɊׂȂ悤ݒB
	for (g_LibInfo.nLibIndex = 0; g_LibInfo.nLibIndex < 300; g_LibInfo.nLibIndex++)
	{
		::wsprintf(szKeyName, "Library%d", g_LibInfo.nLibIndex);
		::GetPrivateProfileString(szKeyName, "Name",   NULL, g_LibInfo.szLibName, sizeof(g_LibInfo.szLibName), g_szIniFileName);
		::GetPrivateProfileString(szKeyName, "Prefix", NULL, g_LibInfo.szPrefix,  sizeof(g_LibInfo.szPrefix),  g_szIniFileName);
		if (::lstrlen(g_LibInfo.szLibName) == 0)
		{
			// K郉CuȂB
			break;
		}

		// Cu[hB
		g_LibInfo.hLib = ::LoadLibrary(g_LibInfo.szLibName);
		if (g_LibInfo.hLib == NULL)
		{
			continue;
		}

		// ɂɑΉĂ邩`FbNB
		if (CheckArchive(_szArcName, NULL) == TPI_ERROR_SUCCESS)
		{
			// ΉĂΏIB
			return TPI_ERROR_SUCCESS;
		}

		::FreeLibrary(g_LibInfo.hLib);
	}

	return TPI_ERROR_U_LOAD_LIBRARY;
}

int WINAPI FreePlugin
(
	void * // _pReserved
)
{
	return ::FreeLibrary(g_LibInfo.hLib) ? TPI_ERROR_SUCCESS : TPI_ERROR_U_FREE_LIBRARY;
}

int WINAPI CheckArchive
(
	const char * _szArcName,
	int * _nFileCount
)
{
	char szAPIName[100];
	::wsprintf(szAPIName, "%sCheckArchive", g_LibInfo.szPrefix);
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	if (! ((BOOL (WINAPI *)(const char *, const int)) fpProc)(_szArcName, 0))
	{
		return TPI_ERROR_D_UNSUPPORTED;
	}

	if (_nFileCount != NULL)
	{
		::wsprintf(szAPIName, "%sGetFileCount", g_LibInfo.szPrefix);
		fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}

		* _nFileCount = ((int (WINAPI *)(const char *)) fpProc)(_szArcName);
		if (* _nFileCount == -1)
		{
			return TPI_ERROR_ARC_UNSUPPORTED;
		}
	}

	return TPI_ERROR_SUCCESS;
}

int WINAPI OpenArchive
(
	const char * _szArcName,
	void * * _hArchive
)
{
	char szAPIName[100];
	::wsprintf(szAPIName, "%sOpenArchive", g_LibInfo.szPrefix);
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	* _hArchive = ((void * (WINAPI *)(const HWND, LPCSTR, const DWORD)) fpProc)(NULL, _szArcName, 0);
	return _hArchive == NULL ? TPI_ERROR_UNDEFINED : TPI_ERROR_SUCCESS;
}

int WINAPI CloseArchive
(
	void * _hArchive
)
{
	char szAPIName[100];
	::wsprintf(szAPIName, "%sCloseArchive", g_LibInfo.szPrefix);
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);

	return fpProc == NULL ? TPI_ERROR_U_USE_LIBRARY : CalErrorCodeConvert(((int (WINAPI *)(void *)) fpProc)(_hArchive));
}

int WINAPI GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	BOOL _bFirst
)
{
	static unsigned int s_uFileID;
	int nResult;
	INDIVIDUALINFO iiInfo;

	if (_bFirst)
	{
		char szAPIName[100];
		::wsprintf(szAPIName, "%sFindFirst", g_LibInfo.szPrefix);
		FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}

		s_uFileID = 0;
		nResult = ((int (WINAPI *)(void *, const char *, LPINDIVIDUALINFO)) fpProc)(_hArchive, "*", & iiInfo);
	}
	else
	{
		char szAPIName[100];
		::wsprintf(szAPIName, "%sFindNext", g_LibInfo.szPrefix);
		FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}

		nResult = ((int (WINAPI *)(void *, LPINDIVIDUALINFO)) fpProc)(_hArchive, & iiInfo);
	}

	nResult = CalErrorCodeConvert(nResult);
	if (nResult == TPI_ERROR_SUCCESS)
	{
		for (int i = 0; i < ::lstrlen(iiInfo.szFileName); i++)
		{
			if (iiInfo.szFileName[i] == '\\')
			{
				iiInfo.szFileName[i] = '/';
			}
		}

		{
			char szAPIName[100];
			::wsprintf(szAPIName, "%sGetAttribute", g_LibInfo.szPrefix);
			FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
			_fiInfo->dwAttribute = fpProc == NULL ? 0 : ((int (WINAPI *)(void *)) fpProc)(_hArchive);
			if (_fiInfo->dwAttribute == -1)
			{
				_fiInfo->dwAttribute = 0;
			}
		}
		_fiInfo->dwCRC32        = iiInfo.dwCRC;
		_fiInfo->uOSType        = iiInfo.uOSType;
		_fiInfo->llPackedSize   = iiInfo.dwCompressedSize;
		_fiInfo->llUnpackedSize = iiInfo.dwOriginalSize;
		_fiInfo->llFileID       = s_uFileID++;
/*
		_fiInfo->ftAccessTime   = 0;
		_fiInfo->ftCreateTime   = 0;
*/
		::DosDateTimeToFileTime(iiInfo.wDate, iiInfo.wTime, & _fiInfo->ftModifiedTime);
		::lstrcpyn(_fiInfo->szFileName, iiInfo.szFileName, sizeof(_fiInfo->szFileName) - 1);
		::lstrcpyn(_fiInfo->szMethod,   iiInfo.szMode,     sizeof(_fiInfo->szMethod)   - 1);
		_fiInfo->wCompressRatio = iiInfo.wRatio;
	}

	return nResult;
}

int WINAPI GetArchiveInformation
(
	void * _hArchive,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	char szAPIName[100];
	::wsprintf(szAPIName, "%sGetArcFileName", g_LibInfo.szPrefix);
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((int (WINAPI *)(void *, char *, const int)) fpProc)(_hArchive, _aiInfo->szFileName, sizeof(_aiInfo->szFileName) - 1);
	}

	::wsprintf(szAPIName, "%sGetArcFileSizeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(_hArchive, (LONGLONG *) & _aiInfo->llFileSize);
	}

	::wsprintf(szAPIName, "%sGetArcOriginalSizeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(_hArchive, (LONGLONG *) & _aiInfo->llUnpackedSize);
	}

	::wsprintf(szAPIName, "%sGetArcCompressedSizeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(_hArchive, (LONGLONG *) & _aiInfo->llPackedSize);
	}

	::wsprintf(szAPIName, "%sGetArcReadSizeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(_hArchive, (LONGLONG *) & _aiInfo->llReadSize);
	}

	::wsprintf(szAPIName, "%sGetArcRatio", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		_aiInfo->wCompressRatio = ((WORD (WINAPI *)(void *)) fpProc)(_hArchive);
	}

	::wsprintf(szAPIName, "%sGetArcAccessTimeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(_hArchive, & _aiInfo->ftAccessTime);
	}

	::wsprintf(szAPIName, "%sGetArcCreatedTimeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(_hArchive, & _aiInfo->ftCreateTime);
	}

	::wsprintf(szAPIName, "%sGetArcWriteTimeEx", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(_hArchive, & _aiInfo->ftModifiedTime);
	}

	::wsprintf(szAPIName, "%sGetArcOSType", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		_aiInfo->uOSType = ((UINT (WINAPI *)(void *)) fpProc)(_hArchive);
	}

	::wsprintf(szAPIName, "%sIsSFXFile", g_LibInfo.szPrefix);
	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	if (fpProc != NULL)
	{
		_aiInfo->nSFXType = ((int (WINAPI *)(void *)) fpProc)(_hArchive);
	}

	return TPI_ERROR_SUCCESS;
}

int WINAPI Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const char * _szArcName,
	const char * _szFiles
)
{
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, g_LibInfo.szPrefix);
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// 蔲X|Xt@CB
	HANDLE hFile = ::CreateFile("__callib__listfile", GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		return TPI_ERROR_UNDEFINED;
	}
	DWORD dwWritten;

	// t@CXgݏB
	if (_szFiles == NULL)
	{
		::WriteFile(hFile, "*", 1, & dwWritten, NULL);
//		::WriteFile(hFile, _szFiles == NULL ? "*" : _szFiles, _szFiles == NULL ? 1 : ::lstrlen(_szFiles), & dwWritten, NULL);
	}
	else
	{
		// pŊďB
		char szFName[FNAME_MAX32 + 1];
		for (int i = 0, l = 0; i <= ::lstrlen(_szFiles); i++)
		{
			if (l == 0)
			{
				// sJnB
				szFName[l++] = '"';
				szFName[l]   = 0;
			}

			if (_szFiles[i] == '\n' || _szFiles[i] == 0)
			{
				// svȍs͏B
				if (::lstrcmp(szFName, "\"") != 0)
				{
					// sƂɃt@Cɏ݁B
					szFName[l++] = '"';
					szFName[l++] = '\r';
					szFName[l++] = '\n';
					szFName[l]   = 0;
					::WriteFile(hFile, szFName, l, & dwWritten, NULL);
				}

				::lstrcpy(szFName, "");
				l = 0;
			}
			else if (_szFiles[i] == '\r')
			{
				// \r݂̂̉sĂꍇ܂ł͍lĂ܂B
				continue;
			}
			else
			{
				szFName[l++] = _szFiles[i];
			}
		}
	}
	::CloseHandle(hFile);

	// IniR}hC擾B
	char szKeyName[256], szCommandLine[2048];
	::wsprintf(szKeyName, "Library%d", g_LibInfo.nLibIndex);
	::GetPrivateProfileString(szKeyName,
		_uCommand == TPI_COMMAND_ADD ? "Add" :
		_uCommand == TPI_COMMAND_EXTRACT ? "Extract" : NULL
		, NULL, szCommandLine, sizeof(szCommandLine) - 1, g_szIniFileName);

	// R}hCϐւB
	char szCommandLineSend[2048];
	for (int i = 0, j = 0; i <= ::lstrlen(szCommandLine); i++)
	{
		if (szCommandLine[i] == '%')
		{
			// ϐ͊JnB
			switch (szCommandLine[++i])
			{
			case '-':
				// ꕶB
				szCommandLineSend[j++] = szCommandLine[++i];
				break;
			case '9':
				switch (szCommandLine[++i])
				{
				case '0':
					// ɖB
					::lstrcpyn(szCommandLineSend + j, _szArcName, sizeof(szCommandLineSend) - j);
					j = ::lstrlen(szCommandLineSend);
					break;
				case '1':
					// o͐B
					::lstrcpyn(szCommandLineSend + j, _swInfo->szDestinationDirectory, sizeof(szCommandLineSend) - j);
					j = ::lstrlen(szCommandLineSend);
					break;
				case '2':
					{
						// X|Xt@CB
						char szTemp[FNAME_MAX32 + 1];
						::GetFullPathName("__callib__listfile", sizeof(szTemp) - 1, szTemp, NULL);
						::lstrcpyn(szCommandLineSend + j, szTemp, sizeof(szCommandLineSend) - j);
//						::lstrcpyn(szCommandLineSend + j, "__callib__listfile", sizeof(szCommandLineSend) - j);
						j = ::lstrlen(szCommandLineSend);
					}
					break;
				case '3':
					// t@CXgB
					::lstrcpyn(szCommandLineSend + j, _szFiles, sizeof(szCommandLineSend) - j);
					j = ::lstrlen(szCommandLineSend);
					break;
				}
				break;
			case 'a':
				switch (szCommandLine[++i])
				{
				case '0':
					// pXLɂ邩B
					if (szCommandLine[++i] == '{')
					{
						// ʁB
						for (i++; szCommandLine[i] != '|' && i < ::lstrlen(szCommandLine); i++)
						{
							if (_swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend[j++] = szCommandLine[i];
							}
						}
						for (i++; szCommandLine[i] != '}' && i < ::lstrlen(szCommandLine); i++)
						{
							if (! _swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend[j++] = szCommandLine[i];
							}
						}
					}
					else
					{
						// BOOLlԋpB
						szCommandLineSend[j++] = _swInfo->fStoreDirectoryPathes ? '1' : '0';
						i--;
					}
					break;
				}
				break;
			}
		}
		else
		{
			szCommandLineSend[j++] = szCommandLine[i];
		}
	}

	// R}hCsB
//	int nResult = CalErrorCodeConvert(((int (WINAPI *)(const HWND, const char *, char *, DWORD)) fpProc)(NULL, szCommandLineSend, NULL, 0));
	int nCalErrorCode =((int (WINAPI *)(const HWND, const char *, char *, DWORD)) fpProc)(NULL, szCommandLineSend, NULL, 0);
	if (nCalErrorCode != 0)
	{
		::wsprintf(szKeyName, "calLib;Error : %x", nCalErrorCode);
		::MessageBox(NULL, szCommandLineSend, szKeyName, MB_OK);
	}

	// X|Xt@C폜B
	::DeleteFile("__callib__listfile");

	return CalErrorCodeConvert(nCalErrorCode);
}

int WINAPI SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// |C^ۑB
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;
	g_fCallback32bit = FALSE;

	// APĨAhX擾B
	char szAPIName[100];
	::wsprintf(szAPIName, "%sSetOwnerWindowEx64", g_LibInfo.szPrefix);
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);

	BOOL fResult = FALSE;
	if (fpProc == NULL)
	{
		// SetOwnerWindowEx64ĂȂꍇASetOwnerWindowEx𗘗pB
		::wsprintf(szAPIName, "%sSetOwnerWindowEx", g_LibInfo.szPrefix);
		fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}
		g_fCallback32bit = TRUE;
		fResult = ((BOOL (WINAPI *)(HWND, ARCHIVERPROC *)) fpProc)(::GetDesktopWindow(), (ARCHIVERPROC *) CallbackProc);
	}
	else
	{
		fResult = ((BOOL (WINAPI *)(HWND, ARCHIVERPROC *, DWORD)) fpProc)(::GetDesktopWindow(), (ARCHIVERPROC *) CallbackProc, sizeof(EXTRACTINGINFOEX64));
	}
	return fResult ? TPI_ERROR_SUCCESS : TPI_ERROR_UNDEFINED;
}

#ifdef __cplusplus
}
#endif
