// spiLibrary
// $Id: spiLibrary.cpp,v 1.17 2006/11/20 14:01:15 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include <windows.h>
#include <imagehlp.h>
#include "..\..\common\header\plugin.h"
#include "..\..\common\header\plugin-extra.h"
#include "spiLibrary.h"

#ifdef __cplusplus
extern "C"
{
#endif

//******************************************************************************
//    Global varients
//******************************************************************************

HMODULE g_hInst;

struct
{
	HMODULE hLib;
	char szLibName[MAX_PATH * 2 + 1];
	int nLibIndex;
}	g_LibInfo;

TPI_PROC g_prProc;
unsigned int g_uFileCount;
unsigned int g_uFilePointer;

//******************************************************************************
//    Entry
//******************************************************************************

BOOL APIENTRY DllMain
(
	HMODULE hModule,
	DWORD  fdwReason,
	LPVOID // lpReserved
)
{
	switch (fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		// nhۑB
		g_hInst = hModule;
		break;
	case DLL_PROCESS_DETACH:
		::FreeLibrary(g_LibInfo.hLib);
		break;
	}
	return TRUE;
}

//******************************************************************************
//    Callback Wrapper
//******************************************************************************

int PASCAL CallbackProc(int _nNow, int _nMax, long _lData)
{
	// \̂B
	TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;
	piInfo.uStatus  = _nNow == 0     ? TPI_STATUS_BEGINPROCESS
					: _nNow == _nMax ? TPI_STATUS_ENDPROCESS
					: _nNow <  0     ? TPI_STATUS_OPENARCHIVE : TPI_STATUS_INPROCESS;
	piInfo.llProcessedSize       = _nNow;
	piInfo.fiInfo.llUnpackedSize = _nMax;
	::lstrcpyn(piInfo.fiInfo.szFileName, (char *) _lData, sizeof(piInfo.fiInfo.szFileName) - 1);

	// R[obN֐ɑMB
	if (g_prProc == NULL)
	{
		return TRUE;
	}

	return g_prProc(TPI_NOTIFY_COMMON, & piInfo) == TPI_CALLBACK_CANCEL;
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

int SpiErrorCodeConvert(int nSpiErrorCode)
{
	switch (nSpiErrorCode)
	{
	case -1: return TPI_ERROR_U_USE_LIBRARY;
	case 0:  return TPI_ERROR_SUCCESS;
	case 1:  return TPI_ERROR_D_SKIPPED;
	case 2:  return TPI_ERROR_ARC_UNSUPPORTED;
	case 3:  return TPI_ERROR_ARC_BROKEN_MISC;
	case 4:  return TPI_ERROR_D_OUTOFMEMORY;
	case 5:  return TPI_ERROR_D_USEMEMORY;
	case 6:  return TPI_ERROR_IO_ARC_READ;
	default: return TPI_ERROR_UNDEFINED;
	}
}

void TimetToFileTime(time_t tTime, FILETIME * pftTime)
{
	// Note that LONGLONG is a 64-bit value
	LONGLONG ll = Int32x32To64(tTime, 10000000) + 116444736000000000;
	pftTime->dwLowDateTime  = (DWORD) ll;
	pftTime->dwHighDateTime = (DWORD) (ll >> 32);
}

//******************************************************************************
//    Functions
//******************************************************************************

int WINAPI GetPluginInformation
(
	unsigned int _uInfoId,
	ULONGLONG,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 1;
		break;
	default:
		return TPI_ERROR_D_PARAMETER;
	}
	return TPI_ERROR_SUCCESS;
}

int WINAPI LoadPlugin
(
	const char * _szArcName,
	ULONGLONG //_llSubOption
)
{
	// JgfBNg擾B
	char szCurrentDir[MAX_PATH * 2 + 1];
	::GetModuleFileName(g_hInst, (char *) & szCurrentDir, sizeof(szCurrentDir) - 1);
	for (int i = ::lstrlen(szCurrentDir); i >= 0; i--)
	{
		if (szCurrentDir[i] == '\\')
		{
			szCurrentDir[++i] = 0;
			break;
		}
	}

	char szWildCard[sizeof(szCurrentDir)];
	::lstrcpyn(szWildCard, szCurrentDir, sizeof(szWildCard) - 1);
	::lstrcat(szWildCard, "*.spi");

	WIN32_FIND_DATA fiInfo;
	HANDLE hFinder = ::FindFirstFile(szWildCard, & fiInfo);
	if (hFinder != INVALID_HANDLE_VALUE)
	{
		do
		{
			// Cu[hB
			char szLibraryName[MAX_PATH * 2 + 1];
			::lstrcpyn(szLibraryName, szCurrentDir, sizeof(szWildCard) - 1);
			::lstrcat(szLibraryName, fiInfo.cFileName);
			g_LibInfo.hLib = ::LoadLibrary(szLibraryName);
			if (g_LibInfo.hLib == NULL)
			{
				continue;
			}

			// GetPluginInfosB
			FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, "GetPluginInfo");
			char szPluginType[5]; // 4bytes + NULL
			if (fpProc == NULL
				|| ((int (PASCAL *)(int, char *, int)) fpProc)(0, szPluginType, sizeof(szPluginType)) < 0
				|| szPluginType[2] != 'A' || szPluginType[3] != 'M')
			{
				continue;
			}

			// ɂɑΉĂ邩`FbNB
			if (CheckArchive(_szArcName, NULL) == TPI_ERROR_SUCCESS)
			{
				// ΉĂΏIB
				return TPI_ERROR_SUCCESS;
			}
		}
		while (::FindNextFile(hFinder, & fiInfo));
		::FindClose(hFinder);
	}
	::FreeLibrary(g_LibInfo.hLib);

	return TPI_ERROR_U_LOAD_LIBRARY;
}

int WINAPI FreePlugin
(
	void * // _pReserved
)
{
	return ::FreeLibrary(g_LibInfo.hLib) ? TPI_ERROR_SUCCESS : TPI_ERROR_U_FREE_LIBRARY;
}

int WINAPI CheckArchive
(
	const char * _szArcName,
	int * _nFileCount
)
{
	FARPROC	fpProc = ::GetProcAddress(g_LibInfo.hLib, "IsSupported");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	char szBuffer[2000];
	unsigned long dwReadBytes;
	HANDLE hFile = ::CreateFile(_szArcName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		return TPI_ERROR_IO_ARC_OPEN;
	}

	if (! ::ReadFile(hFile, szBuffer, sizeof(szBuffer), & dwReadBytes, NULL)
		|| ! ((BOOL (PASCAL *)(const char *, unsigned long)) fpProc)(_szArcName, (unsigned long) szBuffer))
	{
		::CloseHandle(hFile);
		return TPI_ERROR_IO_ARC_READ;
	}

	if (! ::CloseHandle(hFile))
	{
		return TPI_ERROR_IO_ARC_CLOSE;
	}

	fpProc = ::GetProcAddress(g_LibInfo.hLib, "GetArchiveInfo");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	HLOCAL hMemory;
	int nReturnCode = SpiErrorCodeConvert(((int (PASCAL *)(const char *, long, unsigned int, HLOCAL *)) fpProc)(_szArcName, 0, 0, & hMemory));
	if (nReturnCode == TPI_ERROR_SUCCESS)
	{
		if (_nFileCount != NULL)
		{
			* _nFileCount = int(::LocalSize(hMemory) / sizeof(fileInfo));
		}
		::LocalFree(hMemory);
	}
	return nReturnCode;
}

int WINAPI OpenArchive
(
	const char * _szArcName,
	void * * _hArchive
)
{
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, "GetArchiveInfo");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	int nReturnCode = SpiErrorCodeConvert(((int (PASCAL *)(const char *, long, unsigned int, HLOCAL *)) fpProc)(_szArcName, 0, 0, _hArchive));
	if (nReturnCode != TPI_ERROR_SUCCESS)
	{
		return nReturnCode;
	}

	g_uFilePointer = 0;
	g_uFileCount = (unsigned int) (::LocalSize(* _hArchive) / sizeof(fileInfo));

	return * _hArchive == NULL ? TPI_ERROR_IO_ARC_OPEN : nReturnCode;
}

int WINAPI CloseArchive
(
	void * _hArchive
)
{
	return ::LocalFree(_hArchive) == NULL ? TPI_ERROR_SUCCESS : TPI_ERROR_IO_ARC_CLOSE;
}

int WINAPI GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	BOOL _bFirst
)
{
	if (_bFirst)
	{
		g_uFilePointer = 0;
	}

	if (g_uFilePointer > g_uFileCount)
	{
		return TPI_ERROR_UNDEFINED;
	}

	fileInfo pfiInfo = ((fileInfo *) ::LocalLock(_hArchive))[g_uFilePointer++];
	if (pfiInfo.method[0] == 0)
	{
		// JȃvOĈ߂̐킹 (^^;
		g_uFileCount = g_uFilePointer - 1;
		return TPI_ERROR_UNDEFINED;
	}

	_fiInfo->dwCRC32        = pfiInfo.crc;
	_fiInfo->llPackedSize   = pfiInfo.compsize;
	_fiInfo->llUnpackedSize = pfiInfo.filesize;
	_fiInfo->wCompressRatio = pfiInfo.compsize >= pfiInfo.filesize ? 1000 : (WORD) (1000 * pfiInfo.compsize / pfiInfo.filesize);
	_fiInfo->llFileID       = pfiInfo.position;
//	_fiInfo->pCustomInfo    = pfiInfo.position;
	TimetToFileTime(pfiInfo.timestamp, & _fiInfo->ftModifiedTime);
	::wsprintf(_fiInfo->szFileName, "%s%s", pfiInfo.path, pfiInfo.filename);
	::lstrcpyn(_fiInfo->szMethod, (const char *) pfiInfo.method, sizeof(_fiInfo->szMethod) - 1);
	::LocalUnlock(_hArchive);

	return TPI_ERROR_SUCCESS;
}

int WINAPI GetArchiveInformation
(
	void *, // _hArchive,
	TPI_ARCHIVEINFO * // _aiInfo
)
{
	return TPI_ERROR_SUCCESS;
}

int WINAPI Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const char * _szArcName,
	const char * // _szFiles
)
{
	if (_uCommand != TPI_COMMAND_EXTRACT)
	{
		return TPI_ERROR_D_UNSUPPORTED;
	}

	// WĴ݂sB
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, "GetFile");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// Ƀnh擾B
	void * hArchive;
	int nResult = OpenArchive(_szArcName, & hArchive);
	if (nResult != TPI_ERROR_SUCCESS)
	{
		return nResult;
	}

	// R[obN𑗐MB֋X-1𑗐MB
	if (CallbackProc(-1, 0, (long) _szArcName))
	{
		return TPI_ERROR_D_SKIPPED;
	}

	// sB
	TPI_FILEINFO fiInfo;
	nResult = GetFileInformation(hArchive, & fiInfo, TRUE);
	if (nResult == TPI_ERROR_SUCCESS)
	{
		do
		{
			// R[obN𑗐MB
			if (CallbackProc(0, (int) fiInfo.llUnpackedSize, (long) fiInfo.szFileName))
			{
				nResult = TPI_ERROR_D_SKIPPED;
				break;
			}

			// tH_؂ϊB
			for (int i = 0; i < ::lstrlen(fiInfo.szFileName); i++)
			{
				if (fiInfo.szFileName[i] == '/')
				{
					fiInfo.szFileName[i] = '\\';
				}
			}

			// o͖쐬B
			char szTargetPath[MAX_PATH * 2 + 1];
			::wsprintf(szTargetPath, "%s%s", _swInfo->szDestinationDirectory, fiInfo.szFileName);

			// WJfBNg쐬B
			::MakeSureDirectoryPathExists(szTargetPath);
			if (szTargetPath[::lstrlen(szTargetPath) - 1] == '\\')
			{
				continue;
			}

			// t@Co͂ɂ͑ΉĂȂ̂Ńo͂ősB
			HLOCAL hMemory = NULL;
			nResult = SpiErrorCodeConvert(((int (PASCAL *)(char *, long, char *, unsigned int, FARPROC, long)) fpProc)((char *) _szArcName, (long) fiInfo.llFileID, (char *) & hMemory, 0x0100, (FARPROC) CallbackProc, (long) fiInfo.szFileName));
			if (nResult == TPI_ERROR_SUCCESS && hMemory == NULL)
			{
				nResult = TPI_ERROR_UNDEFINED;
			}
			if (nResult != TPI_ERROR_SUCCESS)
			{
				break;
			}

			// WJɏóB
			HANDLE hFile = ::CreateFile(szTargetPath, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile == INVALID_HANDLE_VALUE)
			{
				nResult = TPI_ERROR_IO_FILE_OPEN;
				break;
			}

			void * pData = ::LocalLock(hMemory);
			DWORD dwWritten, dwWrite = (DWORD) fiInfo.llUnpackedSize;
			::WriteFile(hFile, pData, dwWrite, & dwWritten, NULL);
			::LocalUnlock(hMemory);
			::LocalFree(hMemory);
			::CloseHandle(hFile);
			if (dwWrite != dwWritten)
			{
				nResult = TPI_ERROR_IO_FILE_WRITE;
				break;
			}

			nResult = TPI_ERROR_SUCCESS;

			// R[obN𑗐MB
			if (CallbackProc((int) fiInfo.llUnpackedSize, (int) fiInfo.llUnpackedSize, (long) fiInfo.szFileName))
			{
				nResult = TPI_ERROR_D_SKIPPED;
				break;
			}
		}
		while ((nResult = GetFileInformation(hArchive, & fiInfo, FALSE)) != TPI_ERROR_UNDEFINED);
		// bIɋTRUEB
		nResult = TPI_ERROR_SUCCESS;
	}
	CloseArchive(hArchive);

	return nResult;
}

int WINAPI SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// |C^ۑB
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;

	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
