/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frm_main.h,v 1.8 2009/08/15 07:47:41 sirakaba Exp $
*******************************************************************************/

#include <wx/cmdline.h>
#include <wx/splitter.h>

#ifndef H_LOADED_FRM_MAIN
#define H_LOADED_FRM_MAIN

class MainFrame: public wxFrame {
public:
    wxStatusBar* statusbar;
    wxTreeCtrl* tree_ctrl;
    myListCtrl* list_ctrl;
	ArrayTPI_FILEINFO fileinfo;
	TPIHandle tpi;
	wxString szCurrentPath;
	wxFileName fnLastOpenPath;
	wxCmdLineParser cmdLine;
	unsigned int nProgressShowFileNumLimit;

    // Event handler.
    void OnInit(    wxInitDialogEvent&);
    void OnExit(       wxCommandEvent&);
    void OnArcCreate(  wxCommandEvent&);
    void OnArcOpen(    wxCommandEvent&);
    void OnArcClose(   wxCommandEvent&);
    void OnArcAdd(     wxCommandEvent&);
    void OnArcSFX(     wxCommandEvent&);
    void OnArcUnSFX(   wxCommandEvent&);
    void OnArcExtract( wxCommandEvent&);
    void OnArcDelete(  wxCommandEvent&);
    void OnArcTest(    wxCommandEvent&);
    void OnArcRepair(  wxCommandEvent&);
    void OnViewMode(   wxCommandEvent&);
    void OnSelectAll(  wxCommandEvent&);
    void OnTreeChanged(   wxTreeEvent&);
    void OnListItemDClick(wxListEvent&);
    void OnListBeginDrag( wxListEvent&);

	void LoadArc(wxString);
	int ErrorCheck(int);

	MainFrame();
	~MainFrame();

protected:
    wxMenuBar* menubar;
    wxToolBar* toolbar;
    wxSplitterWindow* window_splitter;
    DECLARE_EVENT_TABLE()
};

#endif
