/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.cpp,v 1.10 2009/09/27 13:42:33 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "library.h"

//******************************************************************************
//    Functions
//******************************************************************************

wxString ProcessBoolLoop(bool b, wxString szCommandLine, size_t * nPos, wxString szVal, bool fIf)
{
	wxString szCommandLineSend;
	size_t i = * nPos;
	for (i++; i < szCommandLine.Len() && szCommandLine[i] != (fIf ? wxT('|') : wxT('}')); i++)
	{
		if (fIf ? b : ! b)
		{
			szCommandLineSend += szCommandLine[i] == wxT('#') ? szVal : szCommandLine[i];
		}
	}
	* nPos = i;
	return szCommandLineSend;
}

wxString ProcessBool(bool b, wxString szCommandLine, size_t * nPos, wxString szVal = wxEmptyString)
{
	wxString szCommandLineSend;
	size_t i = * nPos;
	if (szCommandLine[++i] == wxT('{'))
	{
		// ʁB
		szCommandLineSend += ProcessBoolLoop(b, szCommandLine, & i, szVal, true);
		szCommandLineSend += ProcessBoolLoop(b, szCommandLine, & i, szVal, false);
	}
	else
	{
		// boollԋpB
		szCommandLineSend += b ? wxT('1') : wxT('0');
		i--;
	}
	* nPos = i;
	return szCommandLineSend;
}

wxString MakeCommandLineSend(wxString szCommandLine, wxString szArcName, TPI_SWITCHES * swInfo, wxArrayString asFiles, wxString szResponceFileName)
{
	// R}hCϐւB
	wxString szCommandLineSend;
	for (size_t i = 0; i < szCommandLine.Len(); i++)
	{
		if (szCommandLine[i] == wxT('%'))
		{
			// ϐ͊JnB
			switch (szCommandLine[++i])
			{
			case wxT('%'):
				// ꕶB
				szCommandLineSend += szCommandLine[i];
				break;
			case wxT('9'):
				switch (szCommandLine[++i])
				{
				// 0: ɖ
				// 1: o͐
				// 2: X|Xt@C
				// 3: t@CXg
				// 4: kx
				// 5: Jo[R[h
				// 6: Rg
				case wxT('0'): szCommandLineSend += szArcName; break;
				case wxT('1'): szCommandLineSend += swInfo->fnDestinationDirectory.GetPathWithSep(); break;
				case wxT('2'): szCommandLineSend += szResponceFileName; break;
				case wxT('3'):
					for (size_t j = 0; j < asFiles.GetCount(); j++)
					{
						szCommandLineSend += wxT("\"") + asFiles[j] + wxT("\" ");
					}
					break;
				case wxT('4'): szCommandLineSend += wxString::Format(wxT("%d"), swInfo->sCompressLevel); break;
				case wxT('5'): szCommandLineSend += wxString::Format(wxT("%d"), swInfo->sRecoveryRecord); break;
				case wxT('6'): szCommandLineSend += swInfo->szComment; break;
				}
				break;
			case wxT('a'):
				switch (szCommandLine[++i])
				{
				// 0: pXLɂ邩
				// 1: SFX쐬邩
				// 2: Solidk
				// 3: MMœK
				// 4: wb_Í
				// 5: pX[h
				// 6: L[t@C
				// 7: TCY
				case wxT('0'): szCommandLineSend += ProcessBool(swInfo->fStoreDirectoryPathes,      szCommandLine, & i); break;
				case wxT('1'): szCommandLineSend += ProcessBool(swInfo->fMakeSFX,                   szCommandLine, & i); break;
				case wxT('2'): szCommandLineSend += ProcessBool(swInfo->fSolid,                     szCommandLine, & i); break;
				case wxT('3'): szCommandLineSend += ProcessBool(swInfo->fMMOptimize,                szCommandLine, & i); break;
				case wxT('4'): szCommandLineSend += ProcessBool(swInfo->fEncryptHeader,             szCommandLine, & i); break;
				case wxT('5'): szCommandLineSend += ProcessBool(swInfo->szPassword != wxEmptyString,szCommandLine, & i, swInfo->szPassword); break;
				case wxT('6'): szCommandLineSend += ProcessBool(swInfo->szKeyFile  != wxEmptyString,szCommandLine, & i, swInfo->szKeyFile); break;
				case wxT('7'): szCommandLineSend += ProcessBool(swInfo->llSplitSize != 0,           szCommandLine, & i, swInfo->llSplitSize.ToString()); break;
				}
				break;
			}
		}
		else
		{
			szCommandLineSend += szCommandLine[i];
		}
	}

	return szCommandLineSend;
}

wxString MakeResponceFile(wxArrayString asFiles, bool bQuote)
{
	wxFile fListFile;
	wxString szFileName = wxFileName::CreateTempFileName(wxT("__listfile"), & fListFile);
	if (szFileName.IsEmpty())
	{
		return wxEmptyString;
	}

	// t@CXgݏB
	if (asFiles.GetCount() == 0)
	{
		fListFile.Write(wxT("*"));
	}
	else
	{
		// pŊďB
		for (size_t i = 0; i < asFiles.GetCount(); i++)
		{
			// ŌɉsƓ삪Ȃꍇ͗lB
			if (i != 0)
			{
#ifdef __WINDOWS__
				fListFile.Write(wxT("\r\n"));
#else
				fListFile.Write(wxT("\n"));
#endif
			}
			fListFile.Write((bQuote ? wxT("\"") : wxEmptyString) + asFiles[i] + (bQuote ? wxT("\"") : wxEmptyString));
		}
	}
	fListFile.Close();

	return szFileName;
}

wxString MB2String(const char * sz)
{
//	wxString szTemp(sz, wxConvLibc);
	wxString szTemp(sz, wxConvUTF8);
	return szTemp;
}

wxString WC2String(const wchar_t * sz)
{
	wxString szTemp((wchar_t *) sz, wxConvUTF8);
	return szTemp;
}
