/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_process.cpp,v 1.6 2009/09/01 12:20:49 sirakaba Exp $
*******************************************************************************/

#include "frontend.h"
#include "dlg_process.h"

ProcessDialog * g_procDlg = NULL;

//******************************************************************************
// ProcessDialog
//******************************************************************************

ProcessDialog::ProcessDialog(): wxDialog()
{
}

ProcessDialog::~ProcessDialog()
{
	g_procDlg = NULL;
}

//******************************************************************************
// Event table.
//******************************************************************************

BEGIN_EVENT_TABLE(ProcessDialog, wxDialog)
	EVT_INIT_DIALOG(ProcessDialog::OnInit)
	EVT_CLOSE(      ProcessDialog::OnClose)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void ProcessDialog::OnInit(wxInitDialogEvent &)
{
	// XRCƌтB
	this->ebSource          = XRCCTRL(* this, "ebSource",     wxTextCtrl);
	this->ebTarget          = XRCCTRL(* this, "ebTarget",     wxTextCtrl);
	this->gauge             = XRCCTRL(* this, "gauge",        wxGauge);
	this->fCancel           = false;
	g_procDlg = this;

	::wxXmlResource::Get()->Unload(FE_DIR_S_XRC wxT("dlg_process.xrc"));
}

void ProcessDialog::OnClose(wxCloseEvent & e)
{
	if (e.CanVeto() && ::AskDlg(wxT("Really do you want to cancel this operation?"), this) == wxYES)
	{
		this->fCancel = true;
	}
	e.Veto();
}

//******************************************************************************
//    _CAOvV[W
//******************************************************************************

int __stdcall TPICallbackProc(unsigned int _uMsg, void * _pStructure)
{
	if (_uMsg != TPI_NOTIFY_COMMON)
	{
		return TPI_CALLBACK_UNSUPPORTED;
	}

	TPI_PROCESSINFO * piInfo = (TPI_PROCESSINFO *) _pStructure;
	if (g_procDlg == NULL || piInfo == NULL || piInfo->uMessage != TPI_MESSAGE_STATUS || ! g_procDlg->IsShown())
	{
		return TPI_CALLBACK_CONTINUE;
	}

	static int s_nGaugeCounter = 0;
	switch (piInfo->uStatus)
	{
	case TPI_STATUS_OPENARCHIVE:
		g_procDlg->ebSource->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
		break;
	case TPI_STATUS_BEGINPROCESS:
		g_procDlg->ebTarget->ChangeValue((piInfo->fnDestination.IsOk() ? piInfo->fnDestination : piInfo->fiInfo.fnFileName).GetFullPath());
		if (piInfo->fiInfo.llUnpackedSize > 10000)
		{
			g_procDlg->gauge->SetRange(piInfo->fiInfo.llUnpackedSize.ToULong());
			g_procDlg->gauge->SetValue(0);
		}
		::wxSafeYield(g_procDlg, true);
		break;
	case TPI_STATUS_INPROCESS:
		if (s_nGaugeCounter++ > 100)
		{
			if (piInfo->fiInfo.llUnpackedSize > 10000)
			{
				g_procDlg->gauge->SetValue(piInfo->llProcessedSize.ToULong());
			}
			::wxSafeYield(g_procDlg, true);
			s_nGaugeCounter = 0;
		}
		break;
	case TPI_STATUS_ENDPROCESS:
//		g_procDlg->gauge->SetValue(piInfo->fiInfo.llUnpackedSize.ToULong());
		break;
	// Ƀ[hp̓ƎdlB
	case 0x1000:
		g_procDlg->ebSource->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
		g_procDlg->gauge->SetRange(piInfo->fiInfo.llUnpackedSize.ToULong());
		g_procDlg->gauge->SetValue(0);
		break;
	case 0x1001:
		// XVƒᑬȂ̂100t@CɍXVB
		if (piInfo->llProcessedSize > g_procDlg->gauge->GetValue() + 100)
		{
			g_procDlg->ebTarget->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
			g_procDlg->gauge->SetValue(piInfo->llProcessedSize.ToULong());
			::wxSafeYield(g_procDlg, true);
		}
		break;
	}

	return g_procDlg->fCancel ? TPI_CALLBACK_CANCEL : TPI_CALLBACK_CONTINUE;
}
