/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: lychee.cpp 456 2010-12-04 11:00:00Z sirakaba $
*******************************************************************************/

#include "lychee.h"
#include "frm_main.h"
#include <wx/cmdline.h>

//******************************************************************************
// Lychee
//******************************************************************************

IMPLEMENT_APP(Lychee)

bool Lychee::OnInit()
{
	wxInitAllImageHandlers();
	::wxXmlResource::Get()->InitAllHandlers();

	// 作業パスを設定。
	wxString szCwd;
	{
		wxChar cSep = wxFileName::GetPathSeparator();
		szCwd = ::wxGetCwd() + cSep;
		wxStandardPaths p;
		::wxSetWorkingDirectory(::wxPathOnly(p.GetExecutablePath()) + cSep);
	}

	// 言語ファイルのパスを指定。
	this->lc.AddCatalogLookupPathPrefix(L_DIR_S_LOC);
	this->lc.AddCatalog(wxT("lychee"));

	MainFrame * frm_main = new MainFrame();
	if (! ::wxXmlResource::Get()->Load(L_DIR_S_XRC wxT("frm_main.xrc")))
	{
		wxLogError(_("Unable to find XRC!"));
		return false;
	}

	::wxXmlResource::Get()->LoadFrame(frm_main, NULL, wxT("frame_main"));
	::wxXmlResource::Get()->Unload(L_DIR_S_XRC wxT("frm_main.xrc"));
	frm_main->InitDialog();

	// コマンドライン読み込み。
	wxCmdLineParser cmdLine(this->argc, this->argv);
	cmdLine.SetSwitchChars(wxT("-"));
	cmdLine.AddSwitch(wxT("a"), wxEmptyString, _("(command) Add to archive."));
	cmdLine.AddSwitch(wxT("x"), wxEmptyString, _("(command) Extract archive."));
	cmdLine.AddSwitch(wxT("t"), wxEmptyString, _("(command) Test archive."));
	cmdLine.AddSwitch(wxT("l"), wxEmptyString, _("(command) List archive(default)."));
	cmdLine.AddParam(_("archive"),   wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL);
	cmdLine.AddParam(_("filenames"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE);
	if (cmdLine.Parse() != 0)
	{
		frm_main->Close(true);
		return true;
	}

	if (cmdLine.GetParamCount() == 0)
	{
		// コマンドラインがなければウインドウを表示。
		frm_main->Show();
		return true;
	}

	// 書庫を開く。
	wxCommandEvent e;
	frm_main->fnArchive = wxFileName(cmdLine.GetParam(0));
	frm_main->fnArchive.Normalize(wxPATH_NORM_DOTS | wxPATH_NORM_ABSOLUTE | wxPATH_NORM_LONG, szCwd);
	frm_main->OnArcOpen(e);
	if (cmdLine.Found(wxT("a")))
	{
		// 書庫に追加。
		frm_main->OnArcAdd(e);
	}
	else if (cmdLine.Found(wxT("t")))
	{
		// 書庫を検査。
		frm_main->OnArcTest(e);
	}
	else if (cmdLine.Found(wxT("x")))
	{
		// 書庫を展開。
		frm_main->OnArcExtract(e);
	}
	else
	{
		// 閲覧モード。
		frm_main->Show();
		// スプリッター設定(OnInitでは効かないことがあるため)。
		frm_main->window_splitter->SetSashPosition(frm_main->conf.ReadId(CONF_WINDOW_SPLITTER_POS, 200l));
		return true;
	}

	// 何かコマンドを実行していればこのまま終了。
	frm_main->Close(true);
	return true;
}
