/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.cpp 371 2010-10-02 03:17:45Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "xmldoc.h"

//******************************************************************************
//    XML処理関数
//******************************************************************************

bool myIsLib(wxXmlNode * n)
{
	return (
		n->GetName() == wxT("library")
		&& ! myGetAttributeBool(n, wxT("disable"))
#ifdef __WINDOWS__
		&& ! myGetAttributeBool(n, wxT("disable-win"))
#else
		&& ! myGetAttributeBool(n, wxT("disable-lin"))
#endif
		);
}

wxXmlNode * myGetFirstLib(wxXmlDocument * xmlDoc, int nLibIndex)
{
	if (! xmlDoc->IsOk())
	{
		return NULL;
	}
	wxXmlNode * n = xmlDoc->GetRoot()->GetChildren();
	return (n == NULL || myIsLib(n)) ? (nLibIndex <= 0 ? n : myGetNextLib(n, nLibIndex - 1)) : myGetNextLib(n, nLibIndex);
}

wxXmlNode * myGetNextLib(wxXmlNode * n, int nLibIndex)
{
	n = n->GetNext();
	return (n == NULL || myIsLib(n)) ? (nLibIndex <= 0 ? n : myGetNextLib(n, nLibIndex - 1)) : myGetNextLib(n, nLibIndex);
}

wxULongLong_t myGetAttributeInt(wxXmlNode * n, const wxString & szValue, wxULongLong_t nDefaultValue, int nBase)
{
	wxULongLong_t l;
	n->GetAttribute(szValue, wxString::Format(wxString("%" wxLongLongFmtSpec "u"), nDefaultValue)).ToULongLong(& l, nBase);
	return l;
}

bool myGetAttributeBool(wxXmlNode * n, const wxString & szValue, bool bDefaultValue)
{
	return myGetAttributeInt(n, szValue, bDefaultValue ? 1 : 0) != 0;
}

#define CheckSupportedCommand(attr, value) if (n->HasAttribute(wxT(attr)) || n->HasAttribute(wxT(attr) wxT("-alt"))) _fiInfo->eSupportedCommand |= value
#define CheckSupportedSwitch(var,   value) value = szCmdLine.Find(wxT(var)) != wxNOT_FOUND

void MakeFormatInfo(wxXmlNode * n, const wxString & szTPIName, TPI_FORMATINFO * _fiInfo, wxULongLong_t nId)
{
	_fiInfo->fArchive       = myGetAttributeBool(n, wxT("archive"), true);
	_fiInfo->szTypeName     = n->GetAttribute(wxT("typename"), wxEmptyString);
	_fiInfo->szSuffix       = n->GetAttribute(wxT("suffix"),   wxEmptyString);
	_fiInfo->szEngineName   = n->GetAttribute(wxT("name"),     wxEmptyString);
	_fiInfo->szTPIName      = szTPIName;
	_fiInfo->nTypeId        = nId;

	// 対応コマンドを調査。
	CheckSupportedCommand("create", TPI_COMMAND_CREATE);
	CheckSupportedCommand("add",    TPI_COMMAND_ADD);
	CheckSupportedCommand("extract",TPI_COMMAND_EXTRACT);
	CheckSupportedCommand("delete", TPI_COMMAND_DELETE);
	CheckSupportedCommand("update", TPI_COMMAND_UPDATE);
	CheckSupportedCommand("test",   TPI_COMMAND_TEST);
	CheckSupportedCommand("repair", TPI_COMMAND_REPAIR);
	CheckSupportedCommand("move",   TPI_COMMAND_MOVE);
	CheckSupportedCommand("sfx",    TPI_COMMAND_SFX);
	CheckSupportedCommand("unsfx",  TPI_COMMAND_UNSFX);

	// 対応スイッチを調査。
	wxString szCmdLine =
		n->HasAttribute(wxT("create"))      ? n->GetAttribute(wxT("create"),      wxEmptyString) :
		n->HasAttribute(wxT("create-alt"))  ? n->GetAttribute(wxT("create-alt"),  wxEmptyString) :
		n->HasAttribute(wxT("extract"))     ? n->GetAttribute(wxT("extract"),     wxEmptyString) :
		n->HasAttribute(wxT("extract-alt")) ? n->GetAttribute(wxT("extract-alt"), wxEmptyString) :
		(wxString) wxEmptyString;
	CheckSupportedSwitch("96", _fiInfo->fComment);
	CheckSupportedSwitch("a1", _fiInfo->fSFX);
	CheckSupportedSwitch("a2", _fiInfo->fSolid);
	CheckSupportedSwitch("a3", _fiInfo->fMMOptimize);
	CheckSupportedSwitch("a4", _fiInfo->fEncryptHeader);
	CheckSupportedSwitch("a5", _fiInfo->fEncryptPassword);
	CheckSupportedSwitch("a6", _fiInfo->fEncryptKeyFile);
	CheckSupportedSwitch("a7", _fiInfo->fMultiVolume);
	CheckSupportedSwitch("a8", _fiInfo->fCompressHeader);

	_fiInfo->nCompressLevelMin  = myGetAttributeInt(n, wxT("level-min"));
	_fiInfo->nCompressLevelMax  = myGetAttributeInt(n, wxT("level-max"));
	_fiInfo->nRecoveryRecordMin = myGetAttributeInt(n, wxT("rr-min"));
	_fiInfo->nRecoveryRecordMax = myGetAttributeInt(n, wxT("rr-max"));
}
