/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frm_main.h 572 2011-10-03 13:20:53Z sirakaba $
*******************************************************************************/

#include <wx/splitter.h>
#include <wx/clipbrd.h>

#ifndef H_LOADED_FRM_MAIN
#define H_LOADED_FRM_MAIN

#include <wx/arrimpl.cpp>

WX_DECLARE_OBJARRAY(TPI_FILEINFO, ArrayTPI_FILEINFO);

class MainFrame: public wxFrame {
public:
    wxMenuBar * menubar;
    wxToolBar * toolbar;

	wxTreeCtrl * tree_ctrl;
    myListCtrl * list_ctrl;
    wxSplitterWindow * window_splitter;
	wxGauge* gFrame;
	myConfig conf;

	TPIHandle tpi;
	wxFileName fnArchive;
	TPI_ARCHIVEINFO aiArchive;
	wxString szPassword;
	ArrayTPI_FILEINFO fileinfo;

    // Event handler.
    void OnInit(    wxInitDialogEvent&);
    void OnClose(        wxCloseEvent&);
    void OnSize(          wxSizeEvent&);

	void OnExit(       wxCommandEvent&);
    void OnArcCreate(  wxCommandEvent&);
    void OnArcOpen(    wxCommandEvent&);
    void OnArcClose(   wxCommandEvent&);
    void OnArcClone(   wxCommandEvent&);
    void OnArcAdd(     wxCommandEvent&);
    void OnArcConvert( wxCommandEvent&);

	void OnArcExtract( wxCommandEvent&);
    void OnArcDelete(  wxCommandEvent&);
    void OnArcTest(    wxCommandEvent&);
    void OnArcRepair(  wxCommandEvent&);

	void OnExeCopy(    wxCommandEvent&);

	void OnViewMode(   wxCommandEvent&);

	void OnShowToolBar(  wxCommandEvent&);
	void OnShowStatusBar(wxCommandEvent&);

	void OnSelectAll(wxCommandEvent&);

	void OnTreeChanged(wxTreeEvent&);
	void OnTreeBeginDrag(wxTreeEvent&);
	void OnContextMenu(wxContextMenuEvent&);

	void OnListItemSelect(wxListEvent&);
	void OnListItemDClick(wxListEvent&);
    void OnListBeginDrag( wxListEvent&);

	void OnFilter(wxCommandEvent&);

	bool LoadTPI(const wxString &, wxULongLong_t *);
	int ErrorCheck(int, const wxString & szAPIName = wxT("Command"));

	MainFrame();
	~MainFrame();

protected:
    wxStatusBar * statusbar;
    wxTextCtrl * tcFilter;

	DECLARE_EVENT_TABLE()
};

#endif
