# -*- coding: utf-8 -*-

#
# Copyright (C) 2009 ソフトウエア興業株式会社 All rights reserved.
# author 青山陽一
# mail : aoyama-y@users.sourceforge.jp
#
# 本プログラムはフリーソフトウェアです。GPLv2のもとに配布されています。
#

import datetime

from trac.core import *
from trac.web.chrome import INavigationContributor, ITemplateProvider, \
        add_stylesheet
from trac.web.main import IRequestHandler
from trac.web import auth
from trac.util import escape, Markup
from trac.db import *

from nico import *

class NicoDataManage(Component):
    implements(IRequestHandler, ITemplateProvider)

    # IRequestHandler methods
    def match_request(self, req):
        return req.path_info == '/nico_insert'
    def process_request(self, req):
        # 認証名を確認
        authname = None
        if req.remote_user:
            authname = req.remote_user
        else:
            authname = req.authname

        if authname != 'anonymous': # 認証済みの場合
            req.hdf['result'] = self.insertState(authname,req.args.get('state'),req.args.get('comment'))

        req.hdf['insertdebug'] = req.args.get('state') + ':' + req.args.get('comment')
        req.redirect(self.env.href.nico()) # TOPへ戻る
        return 'nico.cs', None

    # ITemplateProvider methods
    def get_templates_dirs(self):
        from pkg_resources import resource_filename
        return [resource_filename(__name__, 'templates')]

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('hw', resource_filename(__name__, 'htdocs'))]

    def insertState(self,authname,state,comment):
        if self.checkStateData(authname) == True:
            self.insertStateData(authname,state,comment)
        else:
            self.updateStateData(authname,state,comment)
        return authname + ':complete'

    # 状態を登録
    def insertStateData(self,authname,state,comment):
        now = datetime.now()
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute('INSERT INTO nicostate ' \
                       '(date, id, comment, state) ' \
                       'VALUES (%s, %s, %s ,%s)',
                       (now.strftime("%Y-%m-%d"), authname, comment, state, ))
        db.commit()

    # 状態を更新
    def updateStateData(self,authname,state,comment):
        now = datetime.now()
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute('UPDATE nicostate SET comment=%s,state=%s ' \
                       'WHERE id=%s AND date=%s ',
                       (comment, state, authname, now.strftime("%Y-%m-%d"), ))
        db.commit()

    # データが登録されているか確認
    def checkStateData(self,authname):
        now = datetime.now()
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        cursor.execute('SELECT count(*) FROM nicostate ' \
                       'WHERE id=%s AND date=%s ',
                       (authname, now.strftime("%Y-%m-%d"), ))
        row = cursor.fetchone()
        if not row or row[0] > 0:
            return False
        return True
