# -*- coding: utf-8 -*-

#
# Copyright (C) 2009 ソフトウエア興業株式会社 All rights reserved.
# author 青山陽一
# mail : aoyama-y@users.sourceforge.jp
#
# 本プログラムはフリーソフトウェアです。GPLv2のもとに配布されています。
#

from datetime import datetime, timedelta

from trac.core import *
from trac.web.chrome import ITemplateProvider, add_stylesheet
from trac.web.main import IRequestHandler
from trac.web import auth
from trac.web.href import Href

class NicoCommentModule(Component):
    implements(IRequestHandler, ITemplateProvider)

    # IRequestHandler methods
    def match_request(self, req):
        return req.path_info == '/nico_comment'

    def process_request(self, req):
        authname = None
        if req.remote_user:
            authname = req.remote_user
        else:
            authname = req.authname

        data={}

        add_stylesheet(req, 'nicohw/css/nico.css')
        data['nico_top_href'] = req.href.nico()
        data['nico_comment_href'] = req.href.nico_comment()

        if req.args.get('type') == 'personal':
            dispdays = req.args.get('dispdays')
            if dispdays==None or dispdays.isdigit() == False:
                dispdays = self.env.config.getint('nico', 'dispdays')
            data['allcommentdata'] = self.getPersonalCommentData(req.args.get('id'),dispdays)
            data['colTitle1'] = 'date'
            data['pageTitle'] = 'id: ' + req.args.get('id')
            data['type'] = 'personal'
            data['id'] = req.args.get('id')
            data['dispdays'] = dispdays
        else:
            # コメント一覧
            data['allcommentdata'] = self.getAllCommentData(req.args.get('date'))
            data['colTitle1'] = 'id'
            data['pageTitle'] = 'date: ' + req.args.get('date')

        return 'comment.html',data, None

    # ITemplateProvider methods
    def get_templates_dirs(self):
        from pkg_resources import resource_filename
        return [resource_filename('nico', 'templates')]

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('nicohw', resource_filename('nico', 'htdocs'))]

    # 特定期間のデータを取得
    def getAllCommentData(self,date):
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # コメント一覧取得
        cursor.execute('SELECT id,state,comment FROM nicostate where date=%s ORDER BY id ',(date,))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            resultData.append(row)
        return resultData

    def getPersonalCommentData(self,id,dispdays):
        start = datetime.now()-timedelta(int(dispdays))
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # コメント一覧取得
        cursor.execute('SELECT date,state,comment FROM nicostate where id=%s and date>=%s ORDER BY date ',(id,start.strftime("%Y-%m-%d"),))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            resultData.append(row)
        return resultData
