#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   


char* infile;
char* outfile;

int  nPoint,nTri,i,v0,v1,v2;
double x,y,z;
char buf[1024];


int  main(int argc,char** argv){

  if(argc != 3){
    fprintf (stderr, "Usage : \n"
	             "tos2mqo tosFileName(in) mqoFileName(out) \n");
    exit (-1);
  }
   

  infile  = argv[1];
  outfile = argv[2];


  FILE* fin = fopen(infile,"r");
  if(fin == NULL)
    exit (-1);

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL)
    exit (-1);


  /*  tos read & wrl write */


  /**************/
  /* write      */
  /**************/

  /* mqo header */
  fprintf(fout, "%s\n", "Metasequoia Document");
  fprintf(fout, "%s\n", "Format Text Ver 1.0");

  /* mqo entity */
  fprintf(fout, "%s\n", "Object \"obj1\" {");

  while(fscanf(fin,"%s",buf) != EOF ){

    /* Coordinate3 */
    if(!strcmp("$vertex",buf)){
      fscanf (fin, "%d \n", &nPoint);

      fprintf(fout, "%s %d %s\n", "  vertex ",nPoint," {");

      for(i = 0; i < nPoint  ;i++){
        fscanf (fin,    "%lf %lf %lf \n", &x,&y,&z);
        fprintf(fout,   "    %f %f %f\n",x,y,z);
      }
      fprintf(fout,"  }\n");
    }

    /* face */
    if(!strcmp("$triangle",buf)){

      fscanf (fin, "%d", &nTri);
      fprintf(fout, "%s %d %s\n", "  face ",nTri," {");
      for(i = 0; i < nTri ;i++){
        fscanf (fin, "%d %d %d", &v0,&v1,&v2);
        fprintf(fout, "    3 V(%d %d %d)\n",v0,v1,v2);
      }
      fprintf(fout, "%s\n", "  }");
    }
  }

  fprintf(fout, "%s\n", "}");
  fprintf(fout, "%s\n", "Eof");



  fclose(fin);
  fclose(fout);

  return 0;

}









