#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   

/* file name info */
char* infile;
char* outfile;

/* point info */
int  nPos;
double (*pos)[3];


/* tri info */
int  nTri,i,v0,v1,v2;
double x,y,z;

/* bound boxt info */
double  min,max;
double  minimum[3],maximum[3];


/* povray parameter */
double backRGB[3];
double angle;
double location[3];

char buf[1024];




double  max3(double a,double b,double c)
{
  return (a > b) ? ( (a > c) ? a : c ) : ( (b > c) ? b : c );
}
double  min3(double a,double b,double c)
{
  return (a < b) ? ( (a < c) ? a : c ) : ( (b < c) ? b : c );
}

void  normalizePosition(double a[3],double min,double max)
{
  a[0] = (a[0] - min) / (max -min);
  a[1] = (a[1] - min) / (max -min);
  a[2] = (a[2] - min) / (max -min);
}


int  main(int argc,char** argv)
{
  int i;

  if(argc < 3 ){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) povFileName(out) [option]  \n",argv[0]);
    fprintf (stderr, "The option is as follows.\n"); 
    fprintf (stderr, " -b: backgrand rgb color. rgb color defined from 0.0 to 1.0.\n");
    fprintf (stderr, "     default is white (1.0 1.0 1.0).\n");
    fprintf (stderr, "     ex) -b 0.0 0.0 0.0 (black)\n");
    fprintf (stderr, " -z: zoom option.default is 60.\n");
    fprintf (stderr, "     It zooms when set to value that is smaller than 60. \n");
    fprintf (stderr, "     ex) -z 40 \n");
    fprintf (stderr, " -l: location of camera.default is (2.0 2.0 -2.0).\n");
    fprintf (stderr, "     ex) -l 2.0 2.0 0.0\n");
    fprintf (stderr, "     Coordinates of model are normalization.\n");
    fprintf (stderr, "\n");
    fprintf (stderr, "   (0,1,0)------------(1,1,0)  \n");
    fprintf (stderr, "        /|               /|    \n");
    fprintf (stderr, "       / |              / |    \n");
    fprintf (stderr, "      /  |             /  |    \n");
    fprintf (stderr, "   (0,1,-1)---------(1,1,-1)   \n");
    fprintf (stderr, "      |  |             |  |    \n");
    fprintf (stderr, "      |  |             |  |    \n");
    fprintf (stderr, "      | (0,0,0)-------(1.0.0)  \n");
    fprintf (stderr, "      | /              | /     \n");
    fprintf (stderr, "      |/               |/      \n");
    fprintf (stderr, "      -----------------        \n");
    fprintf (stderr, "   (0,0,-1)         (1,0,-1)   \n");
    fprintf (stderr, "     y                         \n");
    fprintf (stderr, "     |                         \n") ;
    fprintf (stderr, "     -->x                      \n");
    return -1;
  }

  backRGB[0] = 1.0;
  backRGB[1] = 1.0;
  backRGB[2] = 1.0;

  angle = 60.0;
  location[0] = 2.0; location[1] = 2.0;  location[2] = -2.0;

  for(i = 3; i < argc;i++){
    if(!strcmp("-b",argv[i])){
       if(argc -1 < i+3){
         fprintf(stderr,"#ERR The option is not enough\n");  
         return -1;
       }
       backRGB[0] = atof(argv[i+1]);
       backRGB[1] = atof(argv[i+2]);
       backRGB[2] = atof(argv[i+3]);
       i+=3;
    }
    if(!strcmp("-z",argv[i])){
       if(argc -1 < i+1){
         fprintf(stderr,"#ERR The option is not enough\n");  
         return -1;
       }
       angle = atof(argv[i+1]);
       i+=1;
    }
    if(!strcmp("-l",argv[i])){
       if(argc -1 < i+3){
         fprintf(stderr,"#ERR The option is not enough\n");  
         return -1;
       }
       location[0] = atof(argv[i+1]);
       location[1] = atof(argv[i+2]);
       location[2] = atof(argv[i+3]);
       i+=3;
    }

  }


  double minw,maxw; /* work data for normalize process */

  infile  = argv[1];
  outfile = argv[2];

  FILE* fin = fopen(infile,"r");
  if(fin == NULL){
    printf("#ERR file not found (%s)\n",infile);
    return -1;
  }

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL){
    printf("#ERR file not open  (%s)\n",outfile);
    return -1;
  }


  /***************************/
  /*  read pch  & write pov  */
  /***************************/
  fscanf (fin, "%d \n", &nPos);
  pos=  (double (*)[3])calloc(nPos,sizeof(double[3]));

  /*  read first */
  fscanf (fin,  "%lf %lf %lf \n", &(pos[0][0]),&(pos[0][1]),&(pos[0][2]));
  

  min = min3(pos[0][0],pos[0][1],pos[0][2]);
  max = max3(pos[0][0],pos[0][1],pos[0][2]);
  
  /*  read to end  */
  for(i = 1; i < nPos;i++){
    fscanf (fin,  "%lf %lf %lf \n", &(pos[i][0]),&(pos[i][1]),&(pos[i][2]));
    minw = min3(pos[i][0],pos[i][1],pos[i][2]);
    maxw = max3(pos[i][0],pos[i][1],pos[i][2]);
    if(min > minw) min = minw;
    if(max < maxw) max = maxw;
  }

 
  /* normalize position */
  for(i = 0; i < nPos;i++){
    normalizePosition(pos[i],min,max);
    /* z-axis is minus for povray is left-handed system.*/
    pos[i][2] = pos[i][2] * -1;
  }

  /* query minimum and maximum */
  minimum[0] = pos[0][0]; minimum[1] = pos[0][1]; minimum[2] = pos[0][2];
  maximum[0] = pos[0][0]; maximum[1] = pos[0][1]; maximum[2] = pos[0][2];
  for(i = 1; i < nPos;i++){
    if(minimum[0] > pos[i][0]) minimum[0] = pos[i][0];
    if(maximum[0] < pos[i][0]) maximum[0] = pos[i][0];
    if(minimum[1] > pos[i][1]) minimum[1] = pos[i][1];
    if(maximum[1] < pos[i][1]) maximum[1] = pos[i][1];
    if(minimum[2] > pos[i][2]) minimum[2] = pos[i][2];
    if(maximum[2] < pos[i][2]) maximum[2] = pos[i][2];
  }





  /**********************/
  /*  write  pov header */
  /**********************/

  fprintf(fout, "// POV-Ray file generated from trans3d\n");
  fprintf(fout, "camera {\n");
  fprintf(fout, "  location <%f,%f,%f>\n",location[0],location[1],location[2]);
  fprintf(fout, "  angle %f\n",angle);
  fprintf(fout, "  look_at <%f,%f,%f>\n",(maximum[0] - minimum[0]) * 0.5 + minimum[0],
                                         (maximum[1] - minimum[1]) * 0.5 + minimum[1],
                                         (maximum[2] - minimum[2]) * 0.5 + minimum[2]);
  fprintf(fout, "}\n");
  fprintf(fout, "\n");

  fprintf(fout, "background { color rgb <%f,%f,%f> }\n",backRGB[0],backRGB[1],backRGB[2]);
  fprintf(fout, "global_settings { ambient_light color rgb <0, 0, 0> }\n");
  fprintf(fout, "\n");

  fprintf(fout, "// default light\n");
  fprintf(fout, "light_source { <8.13806, 6.19708, -9.54344> color rgb <1,1,1> }\n");
  fprintf(fout, "\n");

  fprintf(fout, "// Object1\n");
  fprintf(fout, "#declare Object1Material = material {\n");
  fprintf(fout, "texture {\n");
  fprintf(fout, "pigment { color rgbf <1.0, 1.0, 0.4, 0> }\n");
  fprintf(fout, " finish { ambient 0.2 diffuse 0.5 }\n");
  fprintf(fout, "  }\n");
  fprintf(fout, "}\n");
  fprintf(fout, "\n");
   
  /* write mesh2 header */
  fprintf(fout, "#declare Object1 =mesh2 {\n");
  fprintf(fout, "  vertex_vectors {\n");

  /* write position */

  fprintf(fout, "    %d\n",nPos);
  for(i = 0; i < nPos;i++){
    fprintf(fout, "    <%f,%f,%f>",pos[i][0],pos[i][1],pos[i][2]);
    if(i != (nPos - 1)){
      fprintf(fout, ",\n");
    }else{
      fprintf(fout, "\n");
    }
  }
  fprintf(fout, "  }\n");

  /* face */
  fscanf (fin, "%d",  &nTri);

  fprintf(fout, "  face_indices {\n");
  fprintf(fout, "    %d\n",nTri);

  for(i = 0; i < nTri ;i++){
    fscanf (fin,  "%d %d %d", &v0,&v1,&v2);
    fprintf(fout, "    <%d,%d,%d>",v0,v1,v2);
    if(i != (nTri - 1)){
      fprintf(fout, ",\n");
    }else{
      fprintf(fout, "\n");
    }
  }
  fprintf(fout, "  }\n");
  fprintf(fout, "}\n");


  fprintf(fout, "object { Object1 material { Object1Material }}\n");


  fclose(fin);
  fclose(fout);

  return 0;

}









