// -*- c++ -*- 
/*****************************************************************************
 * class: Canvas
 *****************************************************************************/
#ifndef CANVAS_H
#define CANVAS_H

#include <gtk/gtk.h>

#include "TshObj.h"
#include "RowData.h"

class CList;
class CLMgr;
class Text;
class Image;
class Form;
class FMgr;

class Canvas : public TshWgt
{
private:
  CLMgr* Cm; // new
  Text*  T;  // new
  Image* I;  // new
  FMgr*  F;  // new

public:
  Canvas();
  ~Canvas(){};
  void hideAll();
  void listRenew(GList*);
  void listShow(int); //test
  void listClear();
  void listAppend(GtkCTreeNode*, int);
  void listAppend(char*);
  void listAutoResize();
  void listHide();
  GtkWidget* getPpCm(int);

  void textShow();
  void textHide();
  void textInsert(char*);
  void textClear();
  GtkWidget* getPpT();

  void imageShow();
  void imageHide();
  void imageLoad(char*, int);
  GtkWidget* getPpI();
  void imageCanvas();
  void imageFullScreen();

  void formShow();
  void formHide();
  GtkWidget* getPpF();
  void setForm(Form*, bool);
};
#endif
