#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/dir.h>

#include "TreeSh.h"
#include "Icon.h"
#include "Util.h"

/*
 * Icon: Constructor/Destructor
 */
Icon::Icon(char* _N, GtkWidget* _W, char* _D)
{
  init();

  char f[64];
  N = strdup(_N);

  sprintf(f, "%s/%s.xpm", _D, _N);

  if(!(X = gdk_pixmap_create_from_xpm(_W->window, &B, &_W->style->bg[GTK_STATE_NORMAL], f)))
    Util::die("Failure to create Icon", _N);
       
}
Icon::~Icon()
{
  if(N) delete [] N;
  init();
}
void Icon::init() { N = NULL, X = NULL, B = NULL; }

/*
 * Icon: Public Members
 */
bool Icon::match(char* _N)
{
  if(!strcmp(_N, N)) return true;
  return false;
}
GdkPixmap* Icon::getXpm() { return X; }
GdkBitmap* Icon::getBmp() { return B; }

/*
 * IcnMgr: Constructor/Destructor
 */
IcnMgr::IcnMgr() : TshObj(Tsh)
{
  init();

  char p[256];
  sprintf(p, "%s/Pixmaps", Tsh->getD());

  addAll(p);

  if(!(D = getIcon("Default"))) Util::die("Cannot get Default Icon", "");
}

IcnMgr::~IcnMgr()
{
  if(I){
    for(int i=0; i<g_list_length(I); i++)
      delete ((Icon*)g_list_nth_data(I, i));
    g_list_free(I);
  }
  init();
}
void IcnMgr::init() { I = NULL, D = NULL; }

/*
 * IcnMgr: Public Members
 */
void IcnMgr::add(char* _N, char* _D)
{
  I = g_list_append(I, new Icon(_N, Tsh->getW(), _D));
}
void IcnMgr::addAll(char* _D)
{
  DIR* d;
  struct direct* dt;
  char* s;

  if(!(d = opendir(_D))) Util::die("Cannot Open Pixmap Directory", _D);

  while((dt = readdir(d)) != NULL) {
    if(dt->d_ino == 0 || strcmp(strchr(dt->d_name, '.'), ".xpm"))
      continue;
    s = dt->d_name;
    s = strtok(s, ".");
    add(s, _D);
  }
    
  closedir(d);
}

Icon* IcnMgr::getIcon(char* _N)
{
  Icon* icn;

  for(int i=0; i<g_list_length(I); i++){
    icn = (Icon*)g_list_nth_data(I, i);
    if(icn->match(_N))
      return icn;
  }
    
  return D;
}

Icon* IcnMgr::getDefault() { return D; }
