#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TreeSh.h"
#include "Image.h"

/*
 * Image: Constructr/Destructor
 */
Image::Image() : TshWgt()
{
  setMode(false);
  W[0] = NULL, W[1] = NULL, I = NULL, P = NULL, B = NULL;
  W[0] = gtk_window_new(GTK_WINDOW_POPUP);
  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gdk_imlib_init();
}
Image::~Image() { clear(); }
void Image::setXY() { X = I->rgb_width, Y = I->rgb_height; }

/*
 * Public Members
 */
void Image::load(char* _F, int _B)
{
  switch(_B){
  case 0:
    clear();
    if(!(I = gdk_imlib_load_image(_F))) return;
    setXY();
    break;
  case 2:
    if(!I) return;
    clearWPB();
    adjust();
    break;
  case 3:
    if(!I) return;
    clearWPB();
    rotate();
    break;
  }

  if(M) adjustScreen();
  gdk_imlib_render(I, X, Y);
  B = gdk_imlib_copy_mask(I);
  P = gdk_imlib_move_image(I);
  W[1] = gtk_pixmap_new(P, B);
  if(M) {
    gtk_container_add(GTK_CONTAINER(W[0]), W[1]);
    gtk_widget_show_all(W[0]);
  }else{
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getPP()), W[1]);
  }
}

void Image::clear()
{
  clearWPB();
  if(I) gdk_imlib_destroy_image(I);
  I = NULL;
}

void Image::clearWPB()
{
  if(W[1]) gtk_widget_destroy(W[1]);
  if(P) gdk_imlib_free_pixmap(P);
  if(B) gdk_imlib_free_bitmap(B);
  W[1] = NULL, P = NULL, B = NULL;
}

void Image::adjust()
{
  if(I->rgb_width > 400){
    X = I->rgb_height*400/I->rgb_width;
    Y = 400;
  }
  if(I->rgb_height > 500){
    Y = I->rgb_width*500/I->rgb_height;
    X = 500;
  }
  resize();
}

void Image::adjustScreen()
{
  X = gdk_screen_width();
  Y = gdk_screen_height();
  resize();
}

void Image::rotate()
{
  gdk_imlib_rotate_image(I, -1);
  setXY();
  resize();
}

void Image::resize()
{
  GdkImlibImage* i = gdk_imlib_clone_scaled_image(I, X, Y);
  gdk_imlib_destroy_image(I);
  I = NULL;
  I = i;
}

void Image::setMode(bool _M) { M = _M; }
void Image::hideRoot() { gtk_widget_hide_all(W[0]); }
