#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/dir.h>

#include "TreeSh.h"
#include "Type.h"
#include "Pop.h"
#include "Tree.h"
#include "RowData.h"

PopItem::PopItem(GtkWidget* _P, char* _S) : TshObj(Tsh)
{
  init();
  char* s = strtok(_S, ":");
  I = gtk_menu_item_new_with_label (s);
  gtk_menu_append (GTK_MENU (_P), I);
  S = strdup(strtok(NULL, ":"));

  gtk_signal_connect(GTK_OBJECT(I), "activate", GTK_SIGNAL_FUNC (popItemFunc),
		     (gpointer)S);
}

PopItem::~PopItem()
{
  if(S) delete [] S;
  init();
}

void PopItem::init() { I = NULL, S = NULL; }

void PopItem::popItemFunc(GtkWidget* _W, char* _S)
{
  char buf[256];
  sprintf(buf, "%s", _S);

  if(!strcmp(_S, "exe")) Tsh->T->exe();
  else if(GtkCTreeNode* n = Tsh->T->insert(buf))
    if(RowData* rd = (RowData*)gtk_ctree_node_get_row_data(Tsh->getCt(), n))
      rd->setStatus(false);
}

/*
 * Pop: Constructor/Destructor
 */
Pop::Pop(FILE* _F, Type* _T) : TshObj(Tsh)
{
  init();

  char l[BUFSIZ],* s[3];
  P = gtk_menu_new ();
  T = _T;

  while(fgets(l, BUFSIZ, _F) != NULL)
    if(l[0] != '#' && l[0] != '\n') {
      l[strlen(l)-1] = '\0';
      appendItem(l);
    }

  gtk_widget_show_all (P);
}
Pop::~Pop()
{
  if(L) {
    for(int i=0; i<g_list_length(L); i++)
      delete (PopItem*)g_list_nth_data(L, i);
    g_list_free(L);
  }
  init();
}

void Pop::init() { P = NULL, L = NULL, T = NULL; }

/*
 * Pop: Public Members
 */
void Pop::appendItem(char* _S){ L = g_list_append(L, new PopItem(P, _S)); }
void Pop::popUp(GdkEventButton* _E)
{
  if(!P) return;
  gtk_menu_popup (GTK_MENU (P), NULL, NULL, NULL, NULL, _E->button, _E->time);
}
