#include <stdio.h>
#include <string.h>

#include "RowData.h"
#include "TreeSh.h"
#include "Type.h"
#include "Form.h"

/*
 * RowData: Private Funcs & Constructor/Destructor
 */
void RowData::init()            { A = NULL, T  = NULL, R = NULL, S = true; }
void RowData::clearA()
{
  char* c;

  for(int i=0; i<g_list_length(A); i++) {
    c = (char*) g_list_nth_data(A, i);
    delete [] c;
    c = NULL;
  }
}

RowData::RowData(Type* _T, GtkCTreeNode* _R, GList* _A) : TshObj(Tsh)
{
  init();
  T = _T, R = _R, A = _A;
}

RowData::~RowData()
{
  if(A) clearA();
  init();
}

/*
 * RowData: Public Members
 */
char* RowData::getLabel()
{
  if(!R) return NULL;
  return (GTK_CELL_TEXT (GTK_CTREE_ROW (R)->row.cell[0])->text);
}

void RowData::setA(GList* _A)
{
  if(A) clearA();
  A = _A;
}

char* RowData::getSA(int _N)
{
  if(!A) return NULL;
  if(_N >= g_list_length(A)) return NULL;
  if(char* r = (char*)g_list_nth_data(A, _N)) return r;
  return NULL;
}

bool RowData::check()
{
  if(!T) return false;
  if(!T->getS(TS_CMD)) return false;
  return true;
}

Icon* RowData::getIcon()
{
  if(!T) return NULL;
  return (T->getIcon());
}

GList* RowData::getA()           { return A; }
void   RowData::append(char* _S) { A = g_list_append(A, strdup(_S)); }
char*  RowData::getS(int _i)     { if(T) return(T->getS(_i)); }
Type*  RowData::getType()        { if(T) return T; }
void   RowData::popUp(GdkEventButton* _E) { if(T) T->popUp(_E); }
GtkCTreeNode* RowData::getR()    { return R; }

void RowData::edit()
{
  setStatus(true); // test
  if(g_list_length(A) < 0) return;
  if(!T) return;
  bool b = true;
  if(T->isForm()) b = false;
  if(Form* f = T->getForm()) {
    f->clearEntrys();
    f->setText(0, getLabel());
    f->setRd(A);
    f->setR(R);
    Tsh->setForm(f, b);
  }
}

bool RowData::getStatus() { return S; }
void RowData::setStatus(bool _S) { S = _S; }

// test
void RowData::print()
{
  if(!T) return;
  T->print();
  for(int i=0; i<g_list_length(A); i++)
    printf(" [%d] => %s\n", i, g_list_nth_data(A, i));
}
