#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
//#include <gdk/gdkkeysyms.h>

#include "Tree.h"
#include "TreeSh.h"
#include "Type.h"
#include "RowData.h"
#include "Util.h"
#include "Canvas.h"
#include "Icon.h"
#include "Type.h"

bool          Tree::A;
GtkWidget*    Tree::C;
GtkCTreeNode* Tree::R;

/*
 * Tree: Callback
 */
void Tree::select(GtkCTree* _Ct, GtkCTreeNode* _R, gint _C)
{
  if(!_Ct || !_R) return;
  R = _R;
  list();
  if(char* s = Util::pathFull("/", R)){
    Tsh->setCmdStr(s);
    delete [] s;
  }
}

void Tree::list()
{
  RowData* rd;
  if(!(rd = (RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(C), R))) return;
  if(!rd->check()) return;
  if(!rd->getStatus()) {
    rd->edit();
    return;
  }
  if(GtkCTreeNode* s = GTK_CTREE_ROW(R)->children){
    Tsh->C->listShow(atoi(rd->getS(TS_TYPE)));
    while(s){
      Tsh->C->listAppend(s, 1);
      s = GTK_CTREE_ROW(s)->sibling;
    }
    return;
  }

  if(char* c = rd->getS(TS_TYPE)) {
    switch(*c){
    case 'F':
      Util::exe(rd, R);
      return;
    case 'T':
      Util::catTxt(rd, R);
      return;
    case 'I':
      Util::catImage(rd, R, 0);
      return;
    }
  }

  Util::treeList(rd, R, atoi(rd->getS(TS_TYPE)));
  expand();
}

void Tree::press(GtkWidget* _W, GdkEventButton* _E, Tree* _T)
{
  if(!R) return;
  RowData* rd;
  if(!(rd = (RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(C), R))) return;

  switch(_E->button){
  case 2:
    rd->popUp(_E);
    break;
  case 3:
    //rd->print(); //debug
    rd->edit();
    break;
  }
}

void Tree::key(GtkWidget* _W, GdkEventKey* _E, Tree* _T)
{
  switch(_E->keyval){
  case 65364: //Down:
    if(!A) next(); break;
  case 65362: //Up:
    if(!A) prev(); break;
  case 65366: //PageDown:
    fetch(TR_NEXT); break;
  case 65365: //Page_Up
    fetch(TR_PREV); break;
  case 65470: //F1
    Tsh->C->imageFullScreen();
    current();
    break;
  case 65307: //Esc
    A = false;
    Tsh->C->imageCanvas();
    current();
    break;
  }
}

void Tree::remove(GtkCTreeNode* _R)
{
  if(RowData* rd = (RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(C), _R)){
    delete rd;
    rd = NULL;
  }
  gtk_ctree_remove_node(GTK_CTREE(C), _R);
}

void Tree::clean(GtkCTreeNode* _R)
{
  while(GTK_CTREE_ROW(_R)->children){
    if(GTK_CTREE_ROW(GTK_CTREE_ROW(_R)->children)->children)
      clean(GTK_CTREE_ROW(_R)->children);
    remove(GTK_CTREE_ROW(_R)->children);
  }
}

void Tree::refresh()
{
  if(!R) return;
  clean(R);
  list();
}

void Tree::expand() { gtk_ctree_expand(GTK_CTREE(C), R); }
void Tree::next()   { gtk_ctree_select(GTK_CTREE(C), GTK_CTREE_NODE_NEXT(R)); }
void Tree::prev()   { gtk_ctree_select(GTK_CTREE(C), GTK_CTREE_NODE_PREV(R)); }
void Tree::current(){ gtk_ctree_select(GTK_CTREE(C), R); }

void Tree::fetch(int _B)
{
  A = true;
  void (*func)(int);

  switch(_B){
  case TR_NEXT:
    func = autoNext; break;
  case TR_PREV:
    func = autoPrev; break;
  }

  signal(SIGALRM, func);
  alarm(1);
}

void Tree::autoNext(int _S)
{
  next();
  if(A) alarm(1);
}

void Tree::autoPrev(int _S)
{
  prev();
  if(A) alarm(1);
}

void Tree::exe()
{
  if(RowData* rd = (RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(C), R))
    Util::canvasList(rd, R);
}

void Tree::find(char* _S)
{
  GtkCTreeNode* n;
  if(R) n = GTK_CTREE_ROW(R)->children; 
  else  n = gtk_ctree_node_nth(GTK_CTREE(C), 0);

  while(n){
    if(!strcmp(GTK_CELL_TEXT (GTK_CTREE_ROW (n)->row.cell[0])->text, _S)){
      gtk_ctree_select(GTK_CTREE(C), n);
      gtk_ctree_expand(GTK_CTREE(C), n);
      return;
    }
    n = GTK_CTREE_ROW(n)->sibling;
  }
}

void Tree::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(C), "tree_select_row",
		      GTK_SIGNAL_FUNC(select), NULL);
  gtk_signal_connect (GTK_OBJECT(C), "button_press_event",
		      GTK_SIGNAL_FUNC(press), (gpointer)this);
  gtk_signal_connect (GTK_OBJECT(C), "key_press_event",
		      GTK_SIGNAL_FUNC(key), (gpointer)this);
}

Tree::Tree() : TshWgt()
{
  C = NULL, R = NULL, A = false;
  C = gtk_ctree_new (1, 0);

  setPP(gtk_scrolled_window_new ((GtkAdjustment*)NULL, (GtkAdjustment*)NULL));
  gtk_widget_set_usize (getPP(), 300, 600);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(getPP()), C);

  show();
  setEvents();
  init();
}

/*
 * Tree: Public Funcs
 */
void Tree::init()
{
  if(FILE* fp = Util::getfp(Tsh->getD(), "Init", "Cannot open file")){
    char l[BUFSIZ];
    R = NULL;

    while(fgets(l, BUFSIZ, fp) != NULL){
      if(l[0] == '#') continue;
      l[strlen(l)-1] = '\0';
      if(l[0] == '+') insert(strtok(l, "+"));
      else {
	R = NULL;
	R = insert(l);
      }
    }
    fclose(fp);
    R = NULL;
  }
}

GtkCTreeNode* Tree::insert(char* _S)
{
  char* n, buf[BUFSIZ];
  Type* t;
  GdkPixmap* p = NULL;
  GdkBitmap* b = NULL;
  Icon *i = NULL;
  GList* a = NULL;

  sprintf(buf, "%s", _S);
  if(!(n = strtok(_S, " "))) return NULL;
  if(!(t = Tsh->getType(n))) return NULL;
  if(!(i = t->getIcon())) i = Tsh->I->getDefault();
  p = i->getXpm();
  b = i->getBmp();

  n = strtok(buf, " ");
  a = g_list_append(a, strdup(n));
  if(!(n = strtok(NULL, " "))) n = "New";
  a = g_list_append(a, strdup(n));
  GtkCTreeNode* res = gtk_ctree_insert_node(GTK_CTREE(C), R, NULL, &n,
					    3, p, b, p, b, FALSE, TRUE);

  while(n = strtok(NULL, " ")) a = g_list_append(a, strdup(n));
    
  RowData* rd = new RowData(t, res, a);
  gtk_ctree_node_set_row_data(GTK_CTREE(C), res, rd);

  return res;
}

void Tree::list(FILE* _F, int _i)
{
  char line[BUFSIZ];

  switch(_i){
  case 0:
    {
      GList* l = NULL;
      char s[64][2];
      while(fgets(line, BUFSIZ, _F)) {
	line[strlen(line)-1] = '\0';
	sscanf(line, "%s %s", s[0], s[1]);
	insert(line);
	l = g_list_append(l, strdup(s[1]));
      }
      Tsh->C->listRenew(l);
      for(int i=0; i<g_list_length(l); i++)
	delete [] (char*)g_list_nth_data(l, i);
      g_list_free(l);
    }
    break;
  default:
    while(fgets(line, BUFSIZ, _F)) {
      line[strlen(line)-1] = '\0';
      if(GtkCTreeNode* n = insert(line)) Tsh->C->listAppend(n, _i);
    }
    break;
  }
}

GtkCTree* Tree::getCt() { return(GTK_CTREE(C)); }
void Tree::parent()
{
  if(R)
    if(GtkCTreeNode* p =  GTK_CTREE_ROW(R)->parent) {
      gtk_ctree_collapse(GTK_CTREE(C), R);
      gtk_ctree_select(GTK_CTREE(C), p);
    } else unselect();
}
void Tree::unselect()
{
  if(R){
    gtk_ctree_unselect(GTK_CTREE(C), R);
    R = NULL;
  }
}
void Tree::complete(char* _S)
{
  //printf("Tree::complete(%s) %d\n", _S, strlen(_S)); //debug
  GtkCTreeNode* n,* s;
  int i = 0;
  if(R) n = GTK_CTREE_ROW(R)->children; 
  else  n = gtk_ctree_node_nth(GTK_CTREE(C), 0);

  while(n){
    if(!strncmp(GTK_CELL_TEXT (GTK_CTREE_ROW (n)->row.cell[0])->text, _S, strlen(_S))) {
      i++;
      s = n;
    }
    n = GTK_CTREE_ROW(n)->sibling;
  }

  if(i == 1) {
    gtk_ctree_select(GTK_CTREE(C), s); 
    gtk_ctree_expand(GTK_CTREE(C), s);
  }
}
