#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/dir.h>

#include "TreeSh.h"
#include "TshObj.h"
#include "Window.h"
#include "CmdLine.h"
#include "Tree.h"
#include "Canvas.h"
#include "Menu.h"
#include "Util.h"
#include "Icon.h"
#include "Type.h"
#include "RowData.h"

char* Ds[] = { ".", getenv("HOME") };

/*
 * TreeSh: Constructr/Destructor
 */
TreeSh::TreeSh()
{
  init();

  char** d = Ds;
  do { if(setD(*d)) break; } while(*++d);

  To = new TshObj(this);
  W  = new Window(800, 600);
  I  = new IcnMgr();
  char path[256];
  sprintf(path, "%s/Type", getD());
  Tm = new TypeMgr(path);
  M  = new Menu();
  Cm = new CmdLine();
  T  = new Tree();
  C  = new Canvas();
  U  = new Util();

  W->packH(M->getPP(),    TRUE, 0);
  W->packH(Cm->getPP(),   TRUE, 1);
  W->packV(T->getPP(),    TRUE, 1);
  W->packVtoH(2, 1,       FALSE);
  W->packH(C->getPpCm(0), TRUE, 2);
  W->packH(C->getPpCm(1), TRUE, 2);
  W->packH(C->getPpCm(2), TRUE, 2);
  W->packH(C->getPpT(),   TRUE, 2);
  W->packH(C->getPpI(),   TRUE, 2);

  gtk_main();
}
TreeSh::~TreeSh()
{
  if(To) delete To;
  if(D)  delete D;
  if(W)  delete W;
  if(I)  delete I;
  if(Tm) delete Tm;
  if(M)  delete M;
  if(Cm) delete Cm;
  if(T)  delete T;
  if(C)  delete C;

  init();
}
void TreeSh::init()
{
  To = NULL;
  L  = NULL;
  D  = NULL;
  W  = NULL;
  I  = NULL;
  Tm = NULL;
  M  = NULL;
  Cm = NULL;
  T  = NULL;
  C  = NULL;
}

/*
 * TreeSh: Public Members
 */
bool  TreeSh::setD(char* _D)
{
  char path[256];
  sprintf(path, "%s/.Trsh", _D);

  struct stat sb;
  if(stat(path, &sb) < 0) return false;
  if((sb.st_mode & S_IFMT) != S_IFDIR) return false;
  D = strdup(path);
  return true;
}
char* TreeSh::getD()               { return D; }
void  TreeSh::packH(GtkWidget* _W) { W->packH(_W, TRUE, 2); }
Icon* TreeSh::getIcon(char* _N)    { return(I->getIcon(_N)); }
Type* TreeSh::getType(char* _N)    { return(Tm->getType(_N)); }
GtkWidget* TreeSh::getW()          { return(W->getW()); }
void TreeSh::setCmdStr(char* _S)   { Cm->setStr(_S); }
GtkCTree* TreeSh::getCt()          { T->getCt(); }
RowData*  TreeSh::getRd(GtkCTreeNode* _R)
{
  return ((RowData*)gtk_ctree_node_get_row_data(GTK_CTREE(T->getCt()), _R));
}

void TreeSh::setForm(Form* _F, bool _B)
{
  if(!_F) return;
  C->setForm(_F, _B);
}
