#include "Window.h"
#include "TshObj.h"

/*
 * Constructr / Destructor
 */
Window::Window(int _W, int _H) : TshObj(Tsh)
{
  create();
  setSize(_W, _H);
  show();
  setEvents();
}
Window::~Window() {}

void Window::setEvents()
{
  gtk_signal_connect (GTK_OBJECT(W), "delete_event",
		      GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
}

/*
 * Public Members
 */
GtkWidget* Window::getW() { return W; }
void Window::create()
{
  W = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  for(int i=0; i<2; i++) V[i] = gtk_vbox_new(FALSE, 0);
  for(int i=0; i<3; i++) H[i] = gtk_hbox_new(FALSE, 0);

  gtk_container_set_border_width (GTK_CONTAINER(W), 5);

  gtk_box_pack_start (GTK_BOX(V[0]), H[0], FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(V[0]), H[1], FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(V[0]), H[2], TRUE, TRUE, 0);

  gtk_container_add(GTK_CONTAINER(W), V[0]);
}
void Window::setSize(int _W, int _H) { gtk_widget_set_usize(W, _W, _H); }
void Window::show()
{
  gtk_widget_show (W);
  gtk_widget_show_all (V[1]);
  gtk_widget_show_all (V[0]);
}

/*
 * Menu
 */
void Window::packH(GtkWidget* _W, gboolean _B, int _H)
{
  gtk_box_pack_start (GTK_BOX(H[_H]), _W, _B, TRUE, 0);
}
void Window::packV(GtkWidget* _W, gboolean _B, int _V)
{
  gtk_box_pack_start (GTK_BOX(V[_V]), _W, _B, TRUE, 0);
}
void Window::packVtoH(int _H, int _V, gboolean _B)
{
  gtk_box_pack_start (GTK_BOX(H[_H]), V[_V], _B, TRUE, 0);
}
