// -*- c++ -*- 
/*****************************************************************************
 * class: Image
 *****************************************************************************/
#ifndef IMAGE_H
#define IMAGE_H

#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "TshObj.h"

class Pop;

class Image : public TshWgt
{
private:
  bool       M;     // Mode: true.root window false.canvas
  GtkWidget* W[2];  // 0.FullScreen 1.Image
  GdkImlibImage* I; // Imlib Image
  GdkPixmap* P;     // Pixmap
  GdkBitmap* B;     // Mask
  Pop*       Pm;    // Pop Menu
  int X,Y;          // X.Width, Y.Height
  void setXY();
  void init();

public:
  Image();
  ~Image();
  void load(char*, int);
  void clear();
  void clearWPB();
  void adjust();
  void adjustScreen();
  void rotate();
  void resize();
  void setMode(bool);
  void hideRoot();
  static void press(GtkWidget*, GdkEventButton*, Image*);
  void popUp(GdkEventButton*);
  void newPop();
};
#endif
