#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TreeSh.h"
#include "Text.h"

/*
 * Text: Constructr/Destructor
 */
Text::Text() : TshWgt()
{
  char path[256];
  sprintf(path, "%s/Font", Tsh->getD());
  bool flg = false;

  if(FILE* fp = fopen(path, "r")){
    char l[BUFSIZ];
    while(fgets(l, BUFSIZ, fp) != NULL){
      if(l[0] == '#' || l[0] == '\n') continue;
      F = gdk_fontset_load(l);
      flg = true;
      break;
    }
  }

  if(!flg) F = gdk_fontset_load("6x9");

  T[0] = gtk_text_new (NULL, NULL);

  gtk_text_set_editable (GTK_TEXT (T[0]), TRUE);
  T[1] = gtk_table_new (1, 2, FALSE);
  setPP(T[1]);

  gtk_text_set_editable (GTK_TEXT (T[0]), TRUE);
  gtk_table_attach (GTK_TABLE (T[1]), T[0], 0, 1, 0, 1,
		    (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL),
		    (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL),
		    0, 0);

  T[2] = gtk_vscrollbar_new (GTK_TEXT (T[0])->vadj);
  gtk_table_attach (GTK_TABLE (T[1]), T[2], 1, 2, 0, 1,
		    GTK_FILL,
		    (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL),
		    0, 0);
  gtk_signal_connect (GTK_OBJECT(getPP()), "button_press_event",
		      GTK_SIGNAL_FUNC(press), (gpointer)NULL);
}

/*
 * Public Members
 */
void Text::insert(char* _S)
{
  gtk_text_insert((GtkText*)T[0], F, NULL, NULL, _S, strlen(_S));
}

void Text::clear()
{
  int l = gtk_text_get_length((GtkText*)T[0]);
  if(l > 0) gtk_editable_delete_text((GtkEditable*)T[0], 0, l); 
}

void Text::press(GtkWidget* _W, GdkEventButton* _E)
{
  //printf("Text::press()\n"); //debug
}
