package jp.snowgoose.treno;

import java.util.Collection;

import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.Scanner;
import jp.snowgoose.treno.component.Scanner.Scanned;
import jp.snowgoose.treno.component.Scanner.Scanned.Conditions;
import jp.snowgoose.treno.config.Config;
import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.context.ParameterConverters;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.context.RequestValueMappers;
import jp.snowgoose.treno.exception.ActionNotRegisterdException;
import jp.snowgoose.treno.exception.ExceptionTreat;
import jp.snowgoose.treno.exception.RenoException;
import jp.snowgoose.treno.exception.ResultNotRegisterdException;
import jp.snowgoose.treno.exception.SimpleExceptionTreat;
import jp.snowgoose.treno.metadata.ActionDescriptorFactory;
import jp.snowgoose.treno.metadata.ActionDescriptors;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.DirectionTypes;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.ClassUtils;

/**
 * @author snowgoose
 */
public class Application<C extends Config> {

    private C config;
    private ActionDescriptors actionDescriptors;
    private DirectionTypes resultTypeRegistry;
    private InstanceProvider actionInstanceProvider;
    private ExceptionTreat exceptionTreat;
    private ParameterConverters parameterProxies;
    private RequestValueMappers valueMappers;

    public Application(C renoConfig) {

        config = renoConfig;

        InstanceProvider componentsInstanceResolver = (InstanceProvider) getInstanceResolver(config
                .getComponentInstanceProviderClassName());
        Scanner componentsScanner = new Scanner(ClassCollector.COLLECTORS,
                componentsInstanceResolver);

        Scanned components = componentsScanner.scan(config.getComponentPackageNames());

        actionInstanceProvider = getInstanceResolver(config.getActionInstanceProviderClassName());

        Scanner actionsScanner = new Scanner(ClassCollector.COLLECTORS);

        Collection<Class<?>> scannedActionClasses = actionsScanner.scan(
                config.getActionPackageNames()).getClasses(
                Conditions.annotateWith(InvokeActions.class));

        ActionDescriptorFactory foundActionDescFactory = components.getInstance(Conditions
                .implementsInterface(ActionDescriptorFactory.class), config
                .getActionDescriptorFactoryId());

        actionDescriptors = new ActionDescriptors(config.getActionPackageNames(),
                foundActionDescFactory, scannedActionClasses);

        Collection<DirectionType> collectedDirectionTypes = components.getInstances(Conditions
                .implementsInterface(DirectionType.class));
        resultTypeRegistry = new DirectionTypes(collectedDirectionTypes);

        Collection<ParameterConverter> collectedParameterProxies = components
                .getInstances(Conditions.implementsInterface(ParameterConverter.class));
        parameterProxies = new ParameterConverters(collectedParameterProxies);

        exceptionTreat = new SimpleExceptionTreat();

        Collection<RequestValueMapper> collectiodValueMappers = components.getInstances(Conditions
                .implementsInterface(RequestValueMapper.class));
        valueMappers = new RequestValueMappers(collectiodValueMappers);

        validate();

    }

    protected InstanceProvider getInstanceResolver(String className) {
        return ClassUtils.newInstanceSilentry(className, null);
    }

    private void validate() throws RenoException {
        if (actionDescriptors.size() == 0) {
            throw new ActionNotRegisterdException();
        }
        if (resultTypeRegistry.size() == 0) {
            throw new ResultNotRegisterdException();
        }
    }

    public Config getConfig() {
        return config;
    }

    public ActionDescriptors getActionDescriptors() {
        return actionDescriptors;
    }

    public DirectionTypes getDirectionTypes() {
        return resultTypeRegistry;
    }

    public void shutdown() {
        // TODO : implements.
    }

    public InstanceProvider getActionInstanceProvider() {
        return actionInstanceProvider;
    }

    public ExceptionTreat getExceptionTreat() {
        return exceptionTreat;
    }

    public ParameterConverters getParameterConverters() {
        return parameterProxies;
    }

    public RequestValueMappers getRequestValueMappers() {
        return valueMappers;
    }

}
