package jp.snowgoose.treno;

import javax.servlet.ServletContext;

import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.ServletContextInstanceProvider;
import jp.snowgoose.treno.config.WebConfig;
import jp.snowgoose.treno.util.ClassUtils;

/**
 * @author snowgoose
 */
public class WebApplication extends Application<WebConfig> {

    public WebApplication(WebConfig renoConfig) {
        super(renoConfig);
    }

    protected InstanceProvider getInstanceResolver(String className, WebConfig config) {
        InstanceProvider resolver = ClassUtils.newInstanceSilentry(className, null);
        if (resolver instanceof ServletContextInstanceProvider) {
            ServletContextInstanceProvider aware = (ServletContextInstanceProvider) resolver;
            ServletContext servletContext = config.getFilterConfig().getServletContext();
            aware.setServletContext(servletContext);
        }
        return resolver;
    }

}
