package jp.snowgoose.treno.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.context.ParameterConverter.AutoParameterConverter;
import jp.snowgoose.treno.metadata.Scope;

/**
 * @author snowgoose
 */
@Retention(RetentionPolicy.RUNTIME)
@Target( { ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE, ElementType.FIELD })
public @interface BindValue {

    String value() default "";

    Scope scope() default Scope.REQUEST;

    String format() default "";

    Class<? extends ParameterConverter> converter() default AutoParameterConverter.class;

}
