package jp.snowgoose.treno.component;

import java.util.ArrayList;
import java.util.List;

import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.metadata.ActionDescriptor;

/**
 * @author snowgoose
 */
public class DefaultActionInstance implements ActionInstance {

    private final ActionDescriptor actionDescriptor;
    private final Object instance;
    private List<Object> preparedArgs = new ArrayList<Object>();

    public DefaultActionInstance(ActionDescriptor actionDescriptor,
            InstanceProvider instanceProvider) {
        this.actionDescriptor = actionDescriptor;
        this.instance = instanceProvider.resolveInstance(actionDescriptor.getActionMethod()
                .getActionClass());
    }

    public ActionDescriptor getActionDescriptor() {
        return actionDescriptor;
    }

    public Object getInstance() {
        return instance;
    }

    public void prepereInvoke(RequestValueMapper requestValueMapper) {
        requestValueMapper.map(this);
    }

    public List<Object> getPreparedArgs() {
        return preparedArgs;
    }

    public void setPreparedArgs(List<Object> args) {
        preparedArgs = args;
    }

}
