package jp.snowgoose.treno.context;

import java.util.Collection;
import java.util.Map;

import jp.snowgoose.treno.util.Maps;

/**
 * @author snowgoose
 */
public class ParameterConverters {

    private Map<Class<? extends ParameterConverter>, ParameterConverter> convertersMap = Maps
            .newLinkedHashMap();

    public ParameterConverters(Collection<ParameterConverter> converters) {
        for (ParameterConverter converter : converters) {
            if (converter != null) { // FIXME
                convertersMap.put(converter.getClass(), converter);
            }
        }
    }

    public ParameterConverter getParameterConverter(
            Class<? extends ParameterConverter> converterType) {
        return convertersMap.get(converterType);
    }

}
