package jp.snowgoose.treno.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * @author snowgoose
 */
public class RequestValueMappers {

    public List<RequestValueMapper> reqsetValueMappers = new LinkedList<RequestValueMapper>();

    public RequestValueMappers(Collection<RequestValueMapper> mappers) {
        reqsetValueMappers.addAll(mappers);
    }

    public void put(RequestValueMapper mapper) {
        reqsetValueMappers.add(mapper);
    }

    public RequestValueMapper select(RequestContext request, ParameterConverters converters) {
        for (RequestValueMapper mapper : reqsetValueMappers) {
            if (mapper.requestSupported(request.getRequest())) {
                mapper.setParameterConverters(converters);
                return mapper;
            }
        }
        return getDefault(request, converters);
    }

    protected RequestValueMapper getDefault(RequestContext request, ParameterConverters converters) {
        return new SimpleValueMapper(request, converters);
    }

}
