package jp.snowgoose.treno.exception;

import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.util.SerializationUtils;

/**
 * @author snowgoose
 */
public class ActionInvocationException extends RenoException {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    private static final String messageKey = "action %s:%s invocation failed.";
    private String[] args;

    public ActionInvocationException(Throwable cause, ActionDescriptor actionDesc) {
        super(cause);
        prepareActionDesc(actionDesc);
    }

    public ActionInvocationException(ActionDescriptor actionDesc) {
        prepareActionDesc(actionDesc);
    }

    private void prepareActionDesc(ActionDescriptor actionDesc) {
        args = new String[] { actionDesc.getActionMethod().getActionClass().getName(),
                actionDesc.getActionMethod().getMethodName() };
    }

    @Override
    public Object[] getMessageArgs() {
        return SerializationUtils.clone(args);
    }

    @Override
    public String getMessageKey() {
        return messageKey;
    }

}
