package jp.snowgoose.treno.exception;

import jp.snowgoose.treno.util.SerializationUtils;

/**
 * @author snowgoose
 */
public class AssertionFailedException extends RenoException {

    /** TODO: default. */
    private static final long serialVersionUID = 1L;
    private String messageKey = "%s is required.";
    private final String[] messageArgs;

    public AssertionFailedException(String name) {
        messageArgs = new String[] { name };
    }

    @Override
    public String getMessageKey() {
        return messageKey;
    }

    @Override
    public Object[] getMessageArgs() {
        return SerializationUtils.clone(messageArgs);
    }

}
