package jp.snowgoose.treno.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.snowgoose.treno.WebApplication;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.component.DefaultActionInstance;
import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.Invoker;
import jp.snowgoose.treno.config.Config;
import jp.snowgoose.treno.config.WebConfig;
import jp.snowgoose.treno.context.DefaultRequestContext;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.metadata.ActionDescriptors;
import jp.snowgoose.treno.metadata.RequestMappedPath;
import jp.snowgoose.treno.result.InvocationResult;
import jp.snowgoose.treno.result.InvocationResultEvaluator;
import jp.snowgoose.treno.result.type.DirectionTypes;

/**
 * @author snowgoose
 */
public class RenoFilter implements Filter {

    private WebApplication application;

    public void destroy() {
        application.shutdown();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;

        try {
            Config config = application.getConfig();

            RequestContext context = newRequestContext(request, response);

            RequestMappedPath requestPath = newRequestMappedPath(request);

            if (requestPath.pathThrowgh(config.getSuffix())) {
                chain.doFilter(request, response);
                return;
            }

            ActionDescriptors registry = application.getActionDescriptors();

            ActionDescriptor actionDesc = registry.getActionDescriptor(requestPath);

            InstanceProvider instanceProvider = application.getActionInstanceProvider();

            RequestValueMapper valueMapper = application.getRequestValueMappers().select(context,
                    getApplication().getParameterConverters());

            ActionInstance actionInstance = new DefaultActionInstance(actionDesc, instanceProvider);
            Invoker invoker = new Invoker(actionInstance, valueMapper);
            InvocationResult result = invoker.invoke();

            DirectionTypes directionTypes = application.getDirectionTypes();
            InvocationResultEvaluator resultEvaluator = new InvocationResultEvaluator(result,
                    directionTypes, context, valueMapper);
            resultEvaluator.evaluate();
        } catch (Throwable t) {
            application.getExceptionTreat().acceptThrowable(t);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        application = new WebApplication(new WebConfig(filterConfig));
    }

    protected WebApplication getApplication() {
        return application;
    }

    protected RequestContext newRequestContext(HttpServletRequest request,
            HttpServletResponse response) {
        return new DefaultRequestContext(request, response);
    }

    protected RequestMappedPath newRequestMappedPath(HttpServletRequest request) {
        return new RequestMappedPath(request);
    }

}
