package jp.snowgoose.treno.metadata;

import java.io.Serializable;

import jp.snowgoose.treno.util.SerializationUtils;

/**
 * @author snowgoose
 */
public class ActionDescriptor implements Serializable {

    /** TODO :default uid */
    private static final long serialVersionUID = 1L;
    protected MappedPath mappedPath;
    protected ActionMethod actionMethod;
    protected BindDescriptors bindDescriptors;
    protected ResultDescriptors resultDescriptors;

    public MappedPath getMappedPath() {
        return mappedPath;
    }

    public ActionMethod getActionMethod() {
        return actionMethod;
    }

    public BindDescriptors getBindDescriptors() {
        return bindDescriptors;
    }

    public ResultDescriptors getResultDescriptors() {
        return resultDescriptors;
    }

    public static class ActionMethod implements Serializable {

        /** TODO : default uid. */
        private static final long serialVersionUID = 1L;
        protected String methodName;
        protected Class<?> actionClass;
        protected Class<?>[] argumentTypes;

        public String getMethodName() {
            return methodName;
        }

        public Class<?> getActionClass() {
            return actionClass;
        }

        public Class<?>[] getArgumentTypes() {
            return SerializationUtils.clone(argumentTypes);
        }
    }

}
