package jp.snowgoose.treno.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import jp.snowgoose.treno.metadata.BindDescriptor.BindElementType.BindType;
import jp.snowgoose.treno.util.Maps;

/**
 * @author snowgoose
 */
public class BindDescriptors implements Serializable {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    private final Map<String, BindDescriptor> bindMap = Maps.newLinkedHashMap();

    public void put(BindDescriptor bindDescriptor) {
        // TODO : bindDescriptor#nameが重複したときの処理を考える。
        if (bindDescriptor != null) {
            bindMap.put(bindDescriptor.getName(), bindDescriptor);
        }
    }

    public void putAll(Collection<BindDescriptor> bindDescriptors) {
        for (BindDescriptor bindDescriptor : bindDescriptors) {
            put(bindDescriptor);
        }
    }

    public BindDescriptor getBindDescriptor(String name) {
        return bindMap.get(name);
    }

    public Collection<BindDescriptor> getAll() {
        return bindMap.values();
    }

    public Collection<BindDescriptor> getParameterBindDescriptors() {
        return getBindDescriptors0(BindType.PARAMETER);
    }

    public Collection<BindDescriptor> getMethodBindDescriptors() {
        return getBindDescriptors0(BindType.METHOD);
    }

    public Collection<BindDescriptor> getFieldBindDescriptors() {
        return getBindDescriptors0(BindType.FIELD);
    }

    protected Collection<BindDescriptor> getBindDescriptors0(BindType elementType) {
        List<BindDescriptor> bindDescriptors = new ArrayList<BindDescriptor>();
        for (BindDescriptor bindDesc : getAll()) {
            if (elementType.equals(bindDesc.getBindElementType().getType())) {
                bindDescriptors.add(bindDesc);
            }
        }
        return bindDescriptors;
    }

}
