package jp.snowgoose.treno.metadata;

import javax.servlet.http.HttpServletRequest;

/**
 * @author snowgoose
 */
public class RequestMappedPath extends MappedPath {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    private Suffix suffix;

    public RequestMappedPath(HttpServletRequest request) {
        super(getFormattedPath(request));
        // FIXME
        this.suffix = getSuffix(request);
    }

    private Suffix getSuffix(HttpServletRequest request) {
        String uri = removeJsessionId(request.getRequestURI());
        if (uri.lastIndexOf('.') != -1) {
            return new Suffix(uri.substring(uri.lastIndexOf('.')));
        } else {
            return Suffix.NONE;
        }
    }

    private static String getFormattedPath(HttpServletRequest request) {
        String uri = removeJsessionId(request.getRequestURI());
        return removeSuffix(uri.replaceFirst(request.getContextPath(), ""));
    }

    private static String removeJsessionId(String uri) {
        int indexOfSessionIdSeparator = uri.indexOf(";");
        if (indexOfSessionIdSeparator == -1) {
            return uri;
        } else {
            return uri.substring(0, indexOfSessionIdSeparator);
        }
    }

    private static String removeSuffix(String uri) {
        if (uri.lastIndexOf('.') > 0) {
            return uri.substring(0, uri.lastIndexOf('.'));
        }
        return uri;
    }

    public boolean pathThrowgh(Suffix suffix) {
        return this.suffix.getSuffix().equals(suffix.getSuffix()) == false;
    }

}
