package jp.snowgoose.treno.metadata;

import java.io.Serializable;

import jp.snowgoose.treno.exception.InvalidActionSuffixException;
import jp.snowgoose.treno.util.StringUtils;

/**
 * @author snowgoose
 */
public class Suffix implements Serializable {

    /** TODO : default uid */
    private static final long serialVersionUID = 1L;
    public static final Suffix NONE = new Suffix("");
    public static final Suffix DEFAULT = new Suffix(".rn");
    private String suffix;
    private boolean suffixNone;

    public Suffix(String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            this.suffixNone = true;
        }
        if (notStartWithComma(suffix) && this.suffixNone == false) {
            throw new InvalidActionSuffixException();
        }
        this.suffix = suffix;
    }

    private boolean notStartWithComma(String suffix) {
        return (suffix.indexOf('.') != 0);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean match(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        int index = path.lastIndexOf('/');
        String tmp = path.substring(index);
        if (isRootPath(path, index)) {
            return false;
        }
        if (suffixNone) {
            return (tmp.indexOf('.') == -1);
        } else {
            return tmp.endsWith(getSuffix());
        }
    }

    private boolean isRootPath(String path, int index) {
        return (index == 0 && path.length() == 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Suffix) {
            Suffix other = Suffix.class.cast(obj);
            return (other.suffixNone == suffixNone && other.suffix.equals(suffix));
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return suffix.hashCode();
    }

    @Override
    public String toString() {
        return suffix;
    }

}
