package jp.snowgoose.treno.result;

import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.DirectionTypes;

/**
 * @author snowgoose
 */
public class InvocationResultEvaluator {

    private final InvocationResult result;
    private final DirectionTypes resultTypeRegistry;
    private final RequestContext context;
    private final RequestValueMapper valueMapper;

    public InvocationResultEvaluator(InvocationResult result, DirectionTypes resultTypeRegistry,
            RequestContext context, RequestValueMapper valueMapper) {
        this.result = result;
        this.resultTypeRegistry = resultTypeRegistry;
        this.context = context;
        this.valueMapper = valueMapper;
    }

    public void evaluate() {
        ResultDescriptor resultDesc = result.getInvokedInstance().getActionDescriptor()
                .getResultDescriptors().getResultDescriptor(result.getResultStatus());
        DirectionType type = resultTypeRegistry.getResultType(resultDesc.getResultType());
        valueMapper.unmap(result.getInvokedInstance());
        type.render(context, valueMapper, result.getInvokedInstance(), resultDesc);
    }

}
