package jp.snowgoose.treno.util;

/**
 * @author snowgoose
 */
public class StringUtils {

    public static final String EMPTY = "";

    private StringUtils() {
        // not-constract
    }

    public static boolean isNotEmpty(String str) {
        return (str != null && str.trim().length() != 0);
    }

    public static boolean isEmpty(String str) {
        return isNotEmpty(str) == false;
    }

    public static String decapitalize(String str) {
        if (str == null) {
            return null;
        } else if (isEmpty(str)) {
            return EMPTY;
        } else {
            StringBuilder result = new StringBuilder();
            char c = str.charAt(0);
            result.append(Character.toLowerCase(c));
            result.append(str.substring(1));
            return result.toString();
        }
    }

}
