/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.io.Serializable;
import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.metadata.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<?> parameterType;
    protected BindElementType bindElementType;
    protected Scope scope;
    protected String format;
    protected Class<? extends ParameterConverter> converterType;

    public String getName() {
        return this.name;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public BindElementType getBindElementType() {
        return this.bindElementType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getFormat() {
        return this.format;
    }

    public Class<? extends ParameterConverter> getConverterType() {
        return this.converterType;
    }

    public boolean bindTypeIs(BindElementType.BindType elementType) {
        return this.getBindElementType().getType().equals((Object)elementType);
    }

    public static interface BindElementType
    extends Serializable {
        public BindType getType();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum BindType {
            PARAMETER,
            METHOD,
            TYPE,
            FIELD;

        }

        public static class FieldBindElement
        implements BindElementType {
            private static final long serialVersionUID = 1L;
            private final int modefiers;
            private String fieldName;

            public final BindType getType() {
                return BindType.FIELD;
            }

            public FieldBindElement(int modefiers, String fieldName) {
                this.modefiers = modefiers;
                this.fieldName = fieldName;
            }

            public int getModefier() {
                return this.modefiers;
            }

            public String getFieldName() {
                return this.fieldName;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TypeBindElement
        implements BindElementType {
            private static final long serialVersionUID = 1L;
            private final Class<?> type;

            @Override
            public final BindType getType() {
                return BindType.TYPE;
            }

            public TypeBindElement(Class<?> type) {
                this.type = type;
            }

            public Class<?> getTypeClass() {
                return this.type;
            }
        }

        public static class ParameterBindElement
        implements BindElementType {
            private static final long serialVersionUID = 1L;
            private final int index;

            public final BindType getType() {
                return BindType.PARAMETER;
            }

            public ParameterBindElement(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }
        }

        public static class MethodBindElement
        implements BindElementType {
            private static final long serialVersionUID = 1L;
            private final String methodName;

            public MethodBindElement(String methodName) {
                this.methodName = methodName;
            }

            public String getMethodName() {
                return this.methodName;
            }

            public final BindType getType() {
                return BindType.METHOD;
            }
        }
    }
}

