/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENNA_DELIMITED_SYM = 686,
     SENNA_NGRAM_SYM = 687,
     SENNA_NORMALIZE_SYM = 688,
     SENNA_SECTIONALIZE_SYM = 689,
     SENNA_SYM = 690,
     SENSITIVE_SYM = 691,
     SEPARATOR_SYM = 692,
     SERIALIZABLE_SYM = 693,
     SERIAL_SYM = 694,
     SESSION_SYM = 695,
     SET = 696,
     SET_VAR = 697,
     SHARE_SYM = 698,
     SHIFT_LEFT = 699,
     SHIFT_RIGHT = 700,
     SHOW = 701,
     SHUTDOWN = 702,
     SIGNED_SYM = 703,
     SIMPLE_SYM = 704,
     SLAVE = 705,
     SMALLINT = 706,
     SNAPSHOT_SYM = 707,
     SOUNDS_SYM = 708,
     SOURCE_SYM = 709,
     SPATIAL_SYM = 710,
     SPECIFIC_SYM = 711,
     SQLEXCEPTION_SYM = 712,
     SQLSTATE_SYM = 713,
     SQLWARNING_SYM = 714,
     SQL_BIG_RESULT = 715,
     SQL_BUFFER_RESULT = 716,
     SQL_CACHE_SYM = 717,
     SQL_CALC_FOUND_ROWS = 718,
     SQL_NO_CACHE_SYM = 719,
     SQL_SMALL_RESULT = 720,
     SQL_SYM = 721,
     SQL_THREAD = 722,
     SSL_SYM = 723,
     STARTING = 724,
     START_SYM = 725,
     STATUS_SYM = 726,
     STD_SYM = 727,
     STDDEV_SAMP_SYM = 728,
     STOP_SYM = 729,
     STORAGE_SYM = 730,
     STRAIGHT_JOIN = 731,
     STRING_SYM = 732,
     SUBDATE_SYM = 733,
     SUBJECT_SYM = 734,
     SUBSTRING = 735,
     SUBSTRING_INDEX = 736,
     SUM_SYM = 737,
     SUPER_SYM = 738,
     SUSPEND_SYM = 739,
     SWAPS_SYM = 740,
     SWITCHES_SYM = 741,
     SYSDATE = 742,
     TABLES = 743,
     TABLESPACE = 744,
     TABLE_SYM = 745,
     TEMPORARY = 746,
     TEMPTABLE_SYM = 747,
     TERMINATED = 748,
     TEXT_STRING = 749,
     TEXT_SYM = 750,
     TIMESTAMP = 751,
     TIMESTAMP_ADD = 752,
     TIMESTAMP_DIFF = 753,
     TIME_SYM = 754,
     TINYBLOB = 755,
     TINYINT = 756,
     TINYTEXT = 757,
     TO_SYM = 758,
     TRAILING = 759,
     TRANSACTION_SYM = 760,
     TRIGGER_SYM = 761,
     TRIGGERS_SYM = 762,
     TRIM = 763,
     TRUE_SYM = 764,
     TRUNCATE_SYM = 765,
     TYPES_SYM = 766,
     TYPE_SYM = 767,
     UDF_RETURNS_SYM = 768,
     UDF_SONAME_SYM = 769,
     ULONGLONG_NUM = 770,
     UNCOMMITTED_SYM = 771,
     UNDEFINED_SYM = 772,
     UNDERSCORE_CHARSET = 773,
     UNDO_SYM = 774,
     UNICODE_SYM = 775,
     UNION_SYM = 776,
     UNIQUE_SYM = 777,
     UNIQUE_USERS = 778,
     UNIX_TIMESTAMP = 779,
     UNKNOWN_SYM = 780,
     UNLOCK_SYM = 781,
     UNSIGNED = 782,
     UNTIL_SYM = 783,
     UPDATE_SYM = 784,
     UPGRADE_SYM = 785,
     USAGE = 786,
     USER = 787,
     USE_FRM = 788,
     USE_SYM = 789,
     USING = 790,
     UTC_DATE_SYM = 791,
     UTC_TIMESTAMP_SYM = 792,
     UTC_TIME_SYM = 793,
     VAR_SAMP_SYM = 794,
     VALUES = 795,
     VALUE_SYM = 796,
     VARBINARY = 797,
     VARCHAR = 798,
     VARIABLES = 799,
     VARIANCE_SYM = 800,
     VARYING = 801,
     VIEW_SYM = 802,
     WARNINGS = 803,
     WEEK_SYM = 804,
     WHEN_SYM = 805,
     WHERE = 806,
     WHILE_SYM = 807,
     WITH = 808,
     WORK_SYM = 809,
     WRITE_SYM = 810,
     X509_SYM = 811,
     XA_SYM = 812,
     XOR = 813,
     YEARWEEK = 814,
     YEAR_MONTH_SYM = 815,
     YEAR_SYM = 816,
     ZEROFILL = 817,
     TABLE_REF_PRIORITY = 818,
     ELSE = 819,
     THEN_SYM = 820,
     CASE_SYM = 821,
     BETWEEN_SYM = 822,
     NEG = 823
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENNA_DELIMITED_SYM 686
#define SENNA_NGRAM_SYM 687
#define SENNA_NORMALIZE_SYM 688
#define SENNA_SECTIONALIZE_SYM 689
#define SENNA_SYM 690
#define SENSITIVE_SYM 691
#define SEPARATOR_SYM 692
#define SERIALIZABLE_SYM 693
#define SERIAL_SYM 694
#define SESSION_SYM 695
#define SET 696
#define SET_VAR 697
#define SHARE_SYM 698
#define SHIFT_LEFT 699
#define SHIFT_RIGHT 700
#define SHOW 701
#define SHUTDOWN 702
#define SIGNED_SYM 703
#define SIMPLE_SYM 704
#define SLAVE 705
#define SMALLINT 706
#define SNAPSHOT_SYM 707
#define SOUNDS_SYM 708
#define SOURCE_SYM 709
#define SPATIAL_SYM 710
#define SPECIFIC_SYM 711
#define SQLEXCEPTION_SYM 712
#define SQLSTATE_SYM 713
#define SQLWARNING_SYM 714
#define SQL_BIG_RESULT 715
#define SQL_BUFFER_RESULT 716
#define SQL_CACHE_SYM 717
#define SQL_CALC_FOUND_ROWS 718
#define SQL_NO_CACHE_SYM 719
#define SQL_SMALL_RESULT 720
#define SQL_SYM 721
#define SQL_THREAD 722
#define SSL_SYM 723
#define STARTING 724
#define START_SYM 725
#define STATUS_SYM 726
#define STD_SYM 727
#define STDDEV_SAMP_SYM 728
#define STOP_SYM 729
#define STORAGE_SYM 730
#define STRAIGHT_JOIN 731
#define STRING_SYM 732
#define SUBDATE_SYM 733
#define SUBJECT_SYM 734
#define SUBSTRING 735
#define SUBSTRING_INDEX 736
#define SUM_SYM 737
#define SUPER_SYM 738
#define SUSPEND_SYM 739
#define SWAPS_SYM 740
#define SWITCHES_SYM 741
#define SYSDATE 742
#define TABLES 743
#define TABLESPACE 744
#define TABLE_SYM 745
#define TEMPORARY 746
#define TEMPTABLE_SYM 747
#define TERMINATED 748
#define TEXT_STRING 749
#define TEXT_SYM 750
#define TIMESTAMP 751
#define TIMESTAMP_ADD 752
#define TIMESTAMP_DIFF 753
#define TIME_SYM 754
#define TINYBLOB 755
#define TINYINT 756
#define TINYTEXT 757
#define TO_SYM 758
#define TRAILING 759
#define TRANSACTION_SYM 760
#define TRIGGER_SYM 761
#define TRIGGERS_SYM 762
#define TRIM 763
#define TRUE_SYM 764
#define TRUNCATE_SYM 765
#define TYPES_SYM 766
#define TYPE_SYM 767
#define UDF_RETURNS_SYM 768
#define UDF_SONAME_SYM 769
#define ULONGLONG_NUM 770
#define UNCOMMITTED_SYM 771
#define UNDEFINED_SYM 772
#define UNDERSCORE_CHARSET 773
#define UNDO_SYM 774
#define UNICODE_SYM 775
#define UNION_SYM 776
#define UNIQUE_SYM 777
#define UNIQUE_USERS 778
#define UNIX_TIMESTAMP 779
#define UNKNOWN_SYM 780
#define UNLOCK_SYM 781
#define UNSIGNED 782
#define UNTIL_SYM 783
#define UPDATE_SYM 784
#define UPGRADE_SYM 785
#define USAGE 786
#define USER 787
#define USE_FRM 788
#define USE_SYM 789
#define USING 790
#define UTC_DATE_SYM 791
#define UTC_TIMESTAMP_SYM 792
#define UTC_TIME_SYM 793
#define VAR_SAMP_SYM 794
#define VALUES 795
#define VALUE_SYM 796
#define VARBINARY 797
#define VARCHAR 798
#define VARIABLES 799
#define VARIANCE_SYM 800
#define VARYING 801
#define VIEW_SYM 802
#define WARNINGS 803
#define WEEK_SYM 804
#define WHEN_SYM 805
#define WHERE 806
#define WHILE_SYM 807
#define WITH 808
#define WORK_SYM 809
#define WRITE_SYM 810
#define X509_SYM 811
#define XA_SYM 812
#define XOR 813
#define YEARWEEK 814
#define YEAR_MONTH_SYM 815
#define YEAR_SYM 816
#define ZEROFILL 817
#define TABLE_REF_PRIORITY 818
#define ELSE 819
#define THEN_SYM 820
#define CASE_SYM 821
#define BETWEEN_SYM 822
#define NEG 823




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1659 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 214 of yacc.c.  */
#line 1674 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  476
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   44725

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  588
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  680
/* YYNRULES -- Number of rules. */
#define YYNRULES  2072
/* YYNRULES -- Number of states. */
#define YYNSTATES  3730

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   823

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   581,     2,     2,     2,   574,   569,     2,
     578,   579,   572,   571,   580,   570,   585,   573,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   587,   586,
       2,     2,     2,     2,   584,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   575,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   582,   568,   583,   576,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   577
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1428,
    1430,  1434,  1436,  1439,  1441,  1444,  1446,  1448,  1450,  1452,
    1457,  1460,  1462,  1467,  1468,  1470,  1471,  1474,  1476,  1480,
    1481,  1488,  1489,  1495,  1496,  1502,  1503,  1509,  1510,  1522,
    1523,  1525,  1526,  1529,  1532,  1534,  1538,  1541,  1545,  1548,
    1553,  1554,  1561,  1562,  1563,  1572,  1577,  1582,  1586,  1590,
    1593,  1596,  1603,  1609,  1613,  1619,  1621,  1623,  1625,  1626,
    1628,  1629,  1631,  1632,  1634,  1636,  1637,  1640,  1642,  1643,
    1645,  1647,  1649,  1650,  1656,  1660,  1661,  1667,  1671,  1675,
    1676,  1680,  1681,  1684,  1686,  1690,  1691,  1693,  1695,  1696,
    1699,  1701,  1705,  1706,  1713,  1714,  1721,  1722,  1728,  1729,
    1731,  1733,  1734,  1741,  1742,  1744,  1746,  1749,  1751,  1753,
    1755,  1756,  1763,  1764,  1770,  1771,  1773,  1775,  1778,  1780,
    1782,  1784,  1786,  1788,  1791,  1792,  1799,  1800,  1802,  1804,
    1805,  1810,  1815,  1819,  1825,  1827,  1831,  1835,  1841,  1843,
    1847,  1850,  1852,  1854,  1855,  1862,  1864,  1868,  1872,  1873,
    1876,  1877,  1882,  1883,  1886,  1888,  1891,  1896,  1899,  1903,
    1904,  1908,  1909,  1910,  1917,  1920,  1922,  1924,  1927,  1930,
    1939,  1944,  1945,  1947,  1950,  1952,  1954,  1956,  1958,  1960,
    1962,  1964,  1966,  1968,  1970,  1972,  1973,  1976,  1981,  1985,
    1987,  1989,  1994,  1995,  1996,  1998,  2000,  2001,  2004,  2007,
    2009,  2011,  2012,  2015,  2016,  2020,  2021,  2025,  2029,  2030,
    2034,  2035,  2039,  2042,  2044,  2048,  2053,  2057,  2062,  2066,
    2071,  2073,  2077,  2082,  2086,  2090,  2097,  2099,  2105,  2112,
    2118,  2126,  2133,  2142,  2148,  2155,  2160,  2165,  2171,  2175,
    2180,  2182,  2186,  2188,  2192,  2194,  2198,  2202,  2204,  2208,
    2212,  2217,  2222,  2224,  2228,  2232,  2236,  2240,  2244,  2246,
    2250,  2252,  2254,  2256,  2258,  2260,  2262,  2264,  2266,  2268,
    2270,  2272,  2274,  2276,  2278,  2280,  2282,  2284,  2287,  2289,
    2293,  2295,  2297,  2299,  2301,  2305,  2308,  2311,  2314,  2317,
    2321,  2325,  2331,  2338,  2343,  2348,  2356,  2361,  2364,  2371,
    2377,  2384,  2391,  2396,  2401,  2405,  2410,  2417,  2426,  2433,
    2442,  2449,  2454,  2461,  2466,  2473,  2478,  2483,  2488,  2493,
    2500,  2509,  2512,  2515,  2520,  2523,  2531,  2539,  2543,  2548,
    2553,  2560,  2567,  2572,  2579,  2586,  2593,  2598,  2605,  2610,
    2617,  2626,  2637,  2650,  2657,  2662,  2669,  2676,  2678,  2685,
    2690,  2699,  2710,  2715,  2717,  2721,  2726,  2733,  2740,  2749,
    2756,  2763,  2768,  2775,  2782,  2791,  2796,  2801,  2808,  2813,
    2816,  2821,  2826,  2831,  2838,  2843,  2848,  2852,  2861,  2868,
    2873,  2880,  2884,  2891,  2900,  2905,  2914,  2921,  2930,  2937,
    2946,  2949,  2954,  2959,  2964,  2971,  2980,  2989,  2994,  3002,
    3010,  3018,  3025,  3032,  3039,  3046,  3053,  3060,  3061,  3067,
    3078,  3082,  3087,  3091,  3094,  3097,  3100,  3105,  3112,  3117,
    3122,  3129,  3136,  3143,  3150,  3155,  3162,  3167,  3174,  3179,
    3184,  3189,  3194,  3201,  3206,  3213,  3218,  3225,  3230,  3235,
    3242,  3247,  3254,  3259,  3266,  3271,  3276,  3283,  3288,  3295,
    3296,  3300,  3304,  3305,  3307,  3308,  3311,  3313,  3317,  3322,
    3327,  3333,  3338,  3343,  3348,  3354,  3359,  3360,  3361,  3369,
    3380,  3385,  3391,  3396,  3402,  3407,  3412,  3417,  3422,  3427,
    3433,  3434,  3443,  3444,  3448,  3452,  3454,  3459,  3460,  3462,
    3463,  3466,  3467,  3469,  3470,  3474,  3477,  3481,  3484,  3486,
    3489,  3491,  3494,  3496,  3498,  3500,  3503,  3504,  3506,  3507,
    3510,  3512,  3516,  3518,  3522,  3523,  3526,  3528,  3532,  3533,
    3535,  3536,  3539,  3544,  3550,  3552,  3554,  3556,  3558,  3562,
    3566,  3570,  3571,  3578,  3579,  3586,  3587,  3596,  3601,  3602,
    3611,  3612,  3623,  3630,  3631,  3640,  3641,  3652,  3659,  3661,
    3664,  3667,  3668,  3673,  3674,  3686,  3690,  3697,  3698,  3702,
    3703,  3704,  3710,  3711,  3713,  3714,  3716,  3717,  3720,  3721,
    3724,  3727,  3730,  3731,  3738,  3739,  3741,  3745,  3747,  3749,
    3751,  3755,  3757,  3759,  3761,  3763,  3765,  3767,  3769,  3771,
    3773,  3775,  3777,  3779,  3781,  3783,  3785,  3787,  3789,  3791,
    3793,  3795,  3797,  3799,  3801,  3803,  3805,  3807,  3808,  3810,
    3812,  3813,  3816,  3817,  3819,  3820,  3821,  3825,  3826,  3827,
    3831,  3834,  3835,  3836,  3841,  3846,  3849,  3850,  3853,  3856,
    3860,  3864,  3866,  3869,  3870,  3872,  3873,  3878,  3883,  3886,
    3887,  3889,  3891,  3892,  3894,  3895,  3897,  3900,  3902,  3906,
    3910,  3912,  3914,  3916,  3918,  3919,  3922,  3924,  3926,  3928,
    3930,  3932,  3934,  3936,  3938,  3940,  3942,  3944,  3945,  3946,
    3953,  3954,  3956,  3960,  3962,  3965,  3966,  3969,  3973,  3975,
    3978,  3980,  3981,  3985,  3986,  3992,  3995,  3997,  3998,  4002,
    4009,  4010,  4017,  4022,  4027,  4032,  4037,  4043,  4048,  4050,
    4054,  4056,  4057,  4060,  4061,  4063,  4064,  4065,  4074,  4075,
    4076,  4083,  4084,  4086,  4088,  4090,  4092,  4094,  4097,  4099,
    4101,  4103,  4107,  4112,  4113,  4117,  4121,  4123,  4126,  4129,
    4130,  4134,  4135,  4141,  4145,  4147,  4151,  4153,  4157,  4159,
    4161,  4162,  4164,  4165,  4170,  4171,  4173,  4177,  4179,  4181,
    4183,  4184,  4185,  4192,  4193,  4194,  4206,  4210,  4212,  4216,
    4220,  4222,  4226,  4227,  4229,  4230,  4235,  4236,  4243,  4244,
    4250,  4251,  4258,  4260,  4264,  4268,  4274,  4275,  4278,  4279,
    4282,  4284,  4286,  4288,  4292,  4293,  4295,  4296,  4298,  4300,
    4304,  4306,  4308,  4311,  4314,  4317,  4319,  4321,  4323,  4325,
    4326,  4330,  4331,  4335,  4338,  4343,  4348,  4353,  4358,  4359,
    4364,  4371,  4388,  4391,  4394,  4395,  4402,  4408,  4411,  4414,
    4417,  4419,  4425,  4431,  4434,  4437,  4439,  4444,  4448,  4451,
    4454,  4457,  4461,  4464,  4467,  4470,  4472,  4474,  4478,  4483,
    4487,  4491,  4494,  4497,  4501,  4505,  4509,  4513,  4517,  4521,
    4526,  4528,  4530,  4532,  4534,  4535,  4537,  4538,  4541,  4542,
    4544,  4546,  4548,  4549,  4552,  4553,  4556,  4557,  4560,  4563,
    4564,  4569,  4570,  4575,  4577,  4579,  4580,  4582,  4583,  4585,
    4587,  4588,  4593,  4597,  4599,  4600,  4604,  4609,  4612,  4614,
    4616,  4618,  4620,  4622,  4624,  4626,  4628,  4629,  4631,  4632,
    4636,  4640,  4642,  4644,  4646,  4649,  4650,  4654,  4658,  4661,
    4664,  4665,  4670,  4671,  4673,  4675,  4678,  4679,  4684,  4690,
    4691,  4692,  4693,  4694,  4713,  4716,  4717,  4719,  4720,  4722,
    4724,  4725,  4727,  4729,  4730,  4733,  4736,  4738,  4742,  4747,
    4751,  4755,  4756,  4759,  4762,  4764,  4768,  4772,  4773,  4777,
    4778,  4782,  4785,  4789,  4791,  4793,  4796,  4797,  4800,  4802,
    4804,  4807,  4810,  4812,  4814,  4816,  4818,  4820,  4823,  4826,
    4828,  4830,  4832,  4834,  4836,  4838,  4840,  4843,  4846,  4849,
    4852,  4855,  4857,  4859,  4861,  4863,  4865,  4867,  4869,  4873,
    4879,  4881,  4883,  4885,  4887,  4889,  4893,  4898,  4904,  4906,
    4912,  4916,  4919,  4921,  4925,  4928,  4930,  4932,  4934,  4936,
    4938,  4940,  4942,  4944,  4946,  4948,  4950,  4952,  4954,  4956,
    4960,  4963,  4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,
    4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,
    5001,  5003,  5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,
    5021,  5023,  5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,
    5041,  5043,  5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,
    5061,  5063,  5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,
    5081,  5083,  5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,
    5101,  5103,  5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,
    5121,  5123,  5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,
    5141,  5143,  5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,
    5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,
    5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,
    5201,  5203,  5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,
    5221,  5223,  5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,
    5241,  5243,  5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,
    5261,  5263,  5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,
    5281,  5283,  5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,
    5301,  5303,  5305,  5307,  5309,  5311,  5313,  5315,  5317,  5319,
    5321,  5323,  5325,  5327,  5329,  5331,  5333,  5335,  5337,  5339,
    5341,  5343,  5345,  5347,  5349,  5351,  5353,  5355,  5357,  5359,
    5361,  5363,  5365,  5367,  5369,  5371,  5373,  5375,  5377,  5379,
    5381,  5383,  5385,  5387,  5389,  5391,  5393,  5395,  5397,  5399,
    5401,  5403,  5405,  5407,  5409,  5411,  5413,  5415,  5417,  5419,
    5421,  5423,  5425,  5427,  5429,  5431,  5433,  5435,  5437,  5439,
    5441,  5443,  5445,  5447,  5449,  5451,  5453,  5455,  5457,  5459,
    5461,  5463,  5465,  5467,  5469,  5471,  5473,  5475,  5477,  5479,
    5481,  5483,  5485,  5487,  5489,  5491,  5493,  5495,  5497,  5498,
    5503,  5504,  5506,  5508,  5512,  5513,  5516,  5518,  5520,  5522,
    5524,  5525,  5527,  5528,  5530,  5532,  5534,  5535,  5538,  5541,
    5544,  5546,  5549,  5554,  5560,  5565,  5572,  5575,  5579,  5583,
    5587,  5593,  5595,  5599,  5603,  5606,  5609,  5612,  5614,  5616,
    5621,  5626,  5628,  5630,  5632,  5634,  5636,  5637,  5642,  5644,
    5646,  5648,  5652,  5656,  5658,  5660,  5663,  5666,  5667,  5671,
    5676,  5680,  5681,  5689,  5691,  5694,  5696,  5698,  5700,  5702,
    5704,  5706,  5707,  5713,  5715,  5717,  5719,  5721,  5723,  5727,
    5734,  5741,  5748,  5756,  5760,  5769,  5778,  5787,  5788,  5790,
    5792,  5795,  5796,  5798,  5800,  5804,  5805,  5809,  5810,  5814,
    5815,  5819,  5820,  5824,  5826,  5828,  5830,  5832,  5834,  5836,
    5838,  5840,  5842,  5844,  5846,  5849,  5852,  5854,  5858,  5861,
    5864,  5867,  5870,  5873,  5876,  5879,  5882,  5883,  5885,  5889,
    5891,  5894,  5897,  5900,  5902,  5906,  5910,  5912,  5914,  5918,
    5920,  5924,  5929,  5935,  5937,  5938,  5942,  5946,  5948,  5950,
    5951,  5954,  5957,  5960,  5963,  5964,  5967,  5970,  5972,  5975,
    5978,  5981,  5984,  5987,  5988,  5992,  5993,  5995,  5996,  6000,
    6003,  6004,  6006,  6009,  6010,  6012,  6017,  6022,  6028,  6031,
    6035,  6036,  6038,  6039,  6044,  6045,  6047,  6049,  6050,  6053,
    6056,  6058,  6059,  6061,  6063,  6068,  6069,  6077,  6079,  6080,
    6081,  6084,  6088,  6090,  6092,  6094,  6095,  6099,  6101,  6104,
    6106,  6109,  6113,  6117,  6121,  6122,  6124,  6125,  6129,  6133,
    6134,  6143,  6144,  6148,  6150,  6154,  6155,  6158,  6162,  6168,
    6169,  6173,  6178,  6183,  6184,  6199,  6200,  6207,  6208,  6209,
    6210,  6211,  6224,  6229,  6234,  6238,  6243,  6247,  6250,  6252,
    6256,  6262,  6264,  6266,  6267,  6269,  6271,  6272,  6275,  6276,
    6277,  6281,  6282
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     589,     0,    -1,     3,    -1,   590,     3,    -1,   591,    -1,
    1213,    -1,   791,    -1,   832,    -1,   822,    -1,   626,    -1,
     603,    -1,   834,    -1,   824,    -1,  1219,    -1,   608,    -1,
     592,    -1,  1053,    -1,  1084,    -1,  1009,    -1,  1011,    -1,
     596,    -1,  1090,    -1,  1188,    -1,  1179,    -1,   601,    -1,
    1017,    -1,  1104,    -1,  1108,    -1,  1171,    -1,   839,    -1,
     847,    -1,   851,    -1,   594,    -1,  1100,    -1,  1222,    -1,
     842,    -1,   827,    -1,  1020,    -1,  1096,    -1,   820,    -1,
    1186,    -1,  1220,    -1,  1221,    -1,   859,    -1,  1154,    -1,
    1070,    -1,   809,    -1,   812,    -1,  1064,    -1,  1177,    -1,
    1045,    -1,  1107,    -1,  1260,    -1,   593,   370,  1148,    -1,
     106,    -1,   129,    -1,   370,  1148,   175,   595,    -1,  1145,
      -1,   584,  1150,    -1,    -1,   151,  1148,   597,   598,    -1,
      -1,   535,   599,    -1,   599,   580,   600,    -1,   600,    -1,
     584,  1150,    -1,    -1,   202,   602,  1150,    -1,    -1,    53,
     287,   503,   604,   605,    -1,   606,    -1,   605,   580,   606,
      -1,   274,   145,  1145,    -1,   288,   145,  1145,    -1,   277,
     145,  1145,    -1,   278,   145,   994,    -1,   273,   145,   994,
      -1,   286,   145,   994,    -1,   282,   145,  1145,    -1,   281,
     145,  1145,    -1,   283,   145,  1145,    -1,   284,   145,  1145,
      -1,   285,   145,  1145,    -1,   607,    -1,   275,   145,  1145,
      -1,   276,   145,   995,    -1,   396,   145,  1145,    -1,   397,
     145,   994,    -1,    -1,    87,   706,   490,   709,  1142,   609,
     693,    -1,    -1,    87,   781,   217,  1148,   782,   344,  1142,
     610,   578,   786,   579,    -1,    -1,    87,    94,   709,  1148,
     611,   703,    -1,    -1,    87,   612,  1236,    -1,    87,   532,
     613,  1204,    -1,    -1,  1148,   585,  1148,    -1,  1148,    -1,
     413,   722,   514,  1145,    -1,    -1,    -1,    -1,    -1,    -1,
     578,   616,   631,   579,   617,   413,   618,   733,   619,   622,
     620,   655,    -1,    -1,   621,   623,    -1,    -1,   622,   624,
      -1,    68,  1145,    -1,   241,   466,    -1,   335,   466,    -1,
      80,   466,    -1,   389,   466,    96,    -1,   311,   466,    96,
      -1,   625,    -1,   623,    -1,   121,    -1,   898,   121,    -1,
     466,   429,   112,    -1,   466,   429,   228,    -1,    -1,    48,
     614,   627,   628,    -1,    -1,   578,   629,   579,    -1,    -1,
     630,    -1,   630,   580,   880,    -1,   880,    -1,    -1,   632,
      -1,   632,   580,   634,    -1,   634,    -1,    -1,  1148,   633,
     733,    -1,    -1,   636,    -1,   636,   580,   637,    -1,   637,
      -1,   638,   633,  1148,   733,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   639,   655,   586,    -1,   655,   586,
      -1,   640,   655,   586,    -1,    -1,   641,   642,   586,    -1,
      -1,   109,   653,   643,   733,   654,    -1,   109,  1148,    76,
     172,   650,    -1,    -1,   109,   647,   199,   172,   644,   648,
     655,    -1,   109,  1148,    92,   172,   645,    -1,    -1,   646,
     591,    -1,   153,    -1,    82,    -1,   649,    -1,   648,   580,
     649,    -1,   652,    -1,   994,    -1,   458,   651,  1146,    -1,
      -1,   541,    -1,   650,    -1,  1148,    -1,   459,    -1,   898,
     173,    -1,   457,    -1,  1148,    -1,   653,   580,  1148,    -1,
      -1,   111,   880,    -1,    -1,   656,   591,    -1,    -1,   414,
     657,   880,    -1,    -1,   213,   658,   663,   141,   213,    -1,
     668,    -1,   683,    -1,    -1,   659,   686,    -1,   248,  1149,
      -1,   235,  1149,    -1,   347,  1148,    -1,    -1,   161,   661,
    1148,   226,   660,   662,    -1,    61,  1148,    -1,    -1,   330,
     175,    -1,   175,    -1,  1148,    -1,   662,   580,  1148,    -1,
      -1,    -1,    -1,   664,   880,   565,   665,   640,   666,   667,
      -1,    -1,   135,   663,    -1,   564,   640,    -1,   669,    -1,
     672,    -1,    -1,    -1,   566,   670,   880,   671,   674,   682,
     141,   566,    -1,    -1,   566,   673,   675,   682,   141,   566,
      -1,   676,    -1,   674,   676,    -1,   679,    -1,   675,   679,
      -1,    -1,    -1,   550,   677,   880,   678,   565,   640,    -1,
      -1,    -1,   550,   680,   880,   681,   565,   640,    -1,    -1,
     564,   640,    -1,    -1,  1149,   587,   684,   686,   685,    -1,
      -1,  1149,    -1,    -1,    28,   687,   641,   639,   141,    -1,
     269,   640,   141,   269,    -1,    -1,    -1,   552,   688,   880,
     128,   689,   640,   141,   552,    -1,    -1,   404,   640,   528,
     690,   880,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   529,    -1,   115,    -1,   578,   694,    -1,   710,   696,
      -1,   252,  1142,    -1,   578,   252,  1142,   579,    -1,   723,
     579,   710,   696,    -1,    -1,   699,   579,   695,  1226,    -1,
      -1,    -1,  1117,   702,   699,   697,  1223,    -1,    -1,  1117,
     702,   578,   699,   579,   698,  1226,    -1,    -1,    -1,   430,
     700,   869,   873,   701,   720,    -1,    -1,    18,    -1,    -1,
     704,    -1,   705,    -1,   704,   705,    -1,   715,    -1,   714,
      -1,    -1,   707,    -1,   708,    -1,   708,   707,    -1,   491,
      -1,    -1,   213,   898,   152,    -1,    -1,   712,    -1,   713,
      -1,   713,   711,    -1,   713,    -1,   713,   712,    -1,   713,
     580,   712,    -1,   143,  1037,   716,    -1,   512,  1037,   716,
      -1,   292,  1037,   995,    -1,   307,  1037,   995,    -1,    24,
    1037,   994,    -1,   361,  1037,  1145,    -1,    68,  1037,  1145,
      -1,    23,  1037,   995,    -1,   358,  1037,   994,    -1,   358,
    1037,   111,    -1,    57,  1037,   994,    -1,   114,  1037,   994,
      -1,   423,  1037,   717,    -1,   387,  1037,   718,    -1,   384,
    1037,   994,    -1,   385,  1037,   994,    -1,   521,  1037,   578,
    1013,   579,    -1,   714,    -1,   715,    -1,   224,  1037,   719,
      -1,    96,   122,  1037,  1145,    -1,   217,   122,  1037,  1145,
      -1,    77,  1037,  1145,    -1,   763,   754,  1037,   756,    -1,
     763,    64,  1037,   762,    -1,  1150,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   994,    -1,   335,    -1,   164,    -1,   243,
      -1,   989,    -1,   868,   872,    -1,    -1,    10,    -1,   477,
      -1,   391,    -1,   108,    -1,   227,    -1,   724,    -1,   723,
     580,   724,    -1,   725,    -1,   726,    -1,   731,   727,    -1,
     731,   768,    -1,   776,   788,   782,   578,   786,   579,    -1,
     729,   777,   788,   782,   578,   786,   579,    -1,   729,   170,
     238,   788,   578,   786,   579,   768,    -1,   730,   727,    -1,
     729,   728,    -1,    -1,   728,    -1,    58,   880,    -1,    -1,
     730,    -1,    79,   788,    -1,    -1,  1141,   732,   733,   750,
      -1,   741,   748,   745,    -1,   742,   749,   745,    -1,   167,
     743,   745,    -1,    37,    -1,    37,   578,   338,   579,    -1,
      42,    -1,    41,    -1,   737,   578,   338,   579,   764,    -1,
     737,   764,    -1,   738,   578,   338,   579,   765,    -1,   738,
     765,    -1,    32,   578,   338,   579,    -1,    32,    -1,   739,
     578,   338,   579,   764,    -1,   740,   578,   338,   579,   765,
      -1,   542,   578,   338,   579,    -1,   561,   748,   745,    -1,
     100,    -1,   499,    -1,   496,   748,    -1,    97,    -1,   500,
      -1,    39,   748,    -1,   736,    -1,   296,    -1,   265,    -1,
     268,   542,    -1,   268,   739,   764,    -1,   502,   764,    -1,
     495,   748,   764,    -1,   298,   764,    -1,   266,   764,    -1,
     108,   743,   745,    -1,   339,   743,   745,    -1,   165,   743,
     745,    -1,    -1,   144,   734,   578,   790,   579,   764,    -1,
      -1,   441,   735,   578,   790,   579,   764,    -1,   268,   764,
      -1,   439,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   737,   546,    -1,   543,
      -1,   323,   543,    -1,   340,    -1,   326,   543,    -1,   323,
      56,   546,    -1,   326,   546,    -1,   227,    -1,   501,    -1,
     451,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   578,   338,   579,    -1,   744,    -1,
     578,   338,   580,   338,   579,    -1,    -1,   746,    -1,   746,
     747,    -1,   747,    -1,   448,    -1,   527,    -1,   562,    -1,
      -1,   578,   338,   579,    -1,    -1,   744,    -1,    -1,   751,
      -1,   751,   752,    -1,   752,    -1,   337,    -1,   898,   337,
      -1,   111,   753,    -1,   344,   529,   334,   879,    -1,    23,
      -1,   439,   111,   541,    -1,   767,   238,    -1,   522,    -1,
     522,   238,    -1,    68,  1145,    -1,    64,   760,    -1,   334,
     879,    -1,  1132,    -1,    56,   441,    -1,    55,    -1,  1150,
      -1,    32,    -1,   755,    -1,   111,    -1,    -1,   754,   756,
      -1,  1150,    -1,    32,    -1,   758,    -1,   111,    -1,  1150,
      -1,    -1,    64,   762,    -1,   760,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   765,    -1,    46,    -1,   520,   765,
      -1,   754,   755,   765,    -1,    32,   766,    -1,    -1,    32,
      -1,    -1,    20,    -1,   520,    -1,   754,   755,    -1,    -1,
     372,    -1,    -1,   394,  1142,   769,   770,    -1,   772,    -1,
     578,   771,   579,   772,    -1,   771,   580,  1148,    -1,  1148,
      -1,    -1,   773,    -1,   773,   774,    -1,   774,    -1,   344,
     115,   775,    -1,   344,   529,   775,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   449,    -1,   411,    -1,    49,    -1,
     441,   337,    -1,   335,     5,    -1,   441,   111,    -1,   778,
      -1,   178,   779,    -1,   455,   779,    -1,   372,   238,    -1,
     522,   779,    -1,   238,    -1,   217,    -1,    -1,   778,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   522,    -1,   178,
      -1,   455,    -1,    -1,   535,   783,    -1,   512,   783,    -1,
      44,    -1,   425,    -1,   200,    -1,   784,    -1,   785,    -1,
     785,   580,   784,    -1,   435,    -1,   335,   435,    -1,   433,
      -1,   335,   433,    -1,   431,    -1,   432,    -1,   434,    -1,
     994,    -1,   786,   580,   787,   987,    -1,   787,   987,    -1,
    1148,    -1,  1148,   578,   338,   579,    -1,    -1,  1141,    -1,
      -1,   585,  1148,    -1,  1130,    -1,   790,   580,  1130,    -1,
      -1,    13,   805,   490,  1142,   792,   798,    -1,    -1,    13,
      94,   797,   793,   703,    -1,    -1,    13,   374,   614,   794,
     621,    -1,    -1,    13,   179,   614,   795,   621,    -1,    -1,
      13,  1242,  1238,  1243,   547,  1142,   796,  1246,    18,  1248,
    1251,    -1,    -1,  1148,    -1,    -1,   124,   489,    -1,   215,
     489,    -1,   800,    -1,   798,   580,   800,    -1,     6,   804,
      -1,   799,   725,   807,    -1,     6,   726,    -1,   799,   578,
     723,   579,    -1,    -1,    53,   804,  1141,   801,   731,   807,
      -1,    -1,    -1,   312,   804,  1141,   802,   733,   750,   803,
     807,    -1,   129,   804,  1141,   806,    -1,   129,   170,   238,
     788,    -1,   129,   372,   238,    -1,   129,   778,  1141,    -1,
     123,   237,    -1,   137,   237,    -1,    13,   804,  1141,   441,
     111,  1132,    -1,    13,   804,  1141,   129,   111,    -1,   401,
     808,  1142,    -1,    83,   503,   754,   756,   761,    -1,   711,
      -1,   169,    -1,   980,    -1,    -1,    67,    -1,    -1,   214,
      -1,    -1,   411,    -1,    49,    -1,    -1,     8,  1148,    -1,
     164,    -1,    -1,   503,    -1,   145,    -1,    18,    -1,    -1,
     470,   450,   814,   810,   818,    -1,   474,   450,   814,    -1,
      -1,   450,   470,   814,   811,   818,    -1,   450,   474,   814,
      -1,   470,   505,   813,    -1,    -1,   553,    78,   452,    -1,
      -1,   815,   816,    -1,   817,    -1,   816,   580,   817,    -1,
      -1,   467,    -1,   398,    -1,    -1,   528,   819,    -1,   607,
      -1,   819,   580,   607,    -1,    -1,   410,  1173,   821,  1013,
     175,  1145,    -1,    -1,    26,  1173,   823,  1013,   503,  1145,
      -1,    -1,    57,  1173,   825,  1013,   826,    -1,    -1,   382,
      -1,   156,    -1,    -1,   402,   841,  1173,   828,  1013,   829,
      -1,    -1,   830,    -1,   831,    -1,   831,   830,    -1,   382,
      -1,   156,    -1,   533,    -1,    -1,    14,   841,  1173,   833,
    1013,   836,    -1,    -1,    58,  1173,   835,  1013,   836,    -1,
      -1,   837,    -1,   838,    -1,   838,   837,    -1,   382,    -1,
     159,    -1,   299,    -1,   156,    -1,    54,    -1,   172,   530,
      -1,    -1,   348,   841,  1173,   840,  1013,   836,    -1,    -1,
     336,    -1,   258,    -1,    -1,   401,  1173,   843,   845,    -1,
     401,   532,   613,   844,    -1,  1151,   503,  1151,    -1,   844,
     580,  1151,   503,  1151,    -1,   846,    -1,   845,   580,   846,
      -1,  1142,   503,  1142,    -1,    47,   217,   848,   229,   850,
      -1,   849,    -1,   848,   580,   849,    -1,  1142,   855,    -1,
    1148,    -1,   111,    -1,    -1,   257,   217,   226,    47,   852,
     853,    -1,   854,    -1,   853,   580,   854,    -1,  1142,   855,
     858,    -1,    -1,   856,   857,    -1,    -1,   779,   578,   964,
     579,    -1,    -1,   214,   247,    -1,   860,    -1,   430,   862,
      -1,   578,   861,   579,  1226,    -1,   430,   864,    -1,   578,
     861,   579,    -1,    -1,   864,   863,  1223,    -1,    -1,    -1,
     865,   869,   873,   866,   867,   872,    -1,   983,   989,    -1,
    1005,    -1,   868,    -1,  1005,   868,    -1,   868,  1005,    -1,
     175,   937,   972,   977,   974,   983,   989,   996,    -1,   175,
     130,   972,   989,    -1,    -1,   870,    -1,   870,   871,    -1,
     871,    -1,   476,    -1,   204,    -1,   125,    -1,   465,    -1,
     460,    -1,   461,    -1,   463,    -1,   464,    -1,   462,    -1,
      12,    -1,    -1,   172,   529,    -1,   262,   229,   443,   310,
      -1,   873,   580,   874,    -1,   874,    -1,   572,    -1,   875,
     877,   876,   878,    -1,    -1,    -1,  1136,    -1,   880,    -1,
      -1,    18,  1148,    -1,    18,  1145,    -1,  1148,    -1,  1145,
      -1,    -1,   578,   579,    -1,    -1,   883,   881,   882,    -1,
      -1,   882,   896,   883,    -1,   883,   558,   883,    -1,    -1,
     886,   884,   885,    -1,    -1,   885,   897,   886,    -1,   333,
     886,    -1,   887,    -1,   888,   232,   509,    -1,   888,   232,
     898,   509,    -1,   888,   232,   158,    -1,   888,   232,   898,
     158,    -1,   888,   232,   525,    -1,   888,   232,   898,   525,
      -1,   888,    -1,   888,   232,   337,    -1,   888,   232,   898,
     337,    -1,   888,   146,   889,    -1,   888,   900,   889,    -1,
     888,   900,   901,   578,  1231,   579,    -1,   889,    -1,   890,
     229,   578,  1231,   579,    -1,   890,   898,   229,   578,  1231,
     579,    -1,   890,   229,   578,   880,   579,    -1,   890,   229,
     578,   880,   580,   926,   579,    -1,   890,   898,   229,   578,
     880,   579,    -1,   890,   898,   229,   578,   880,   580,   926,
     579,    -1,   890,   567,   890,    16,   889,    -1,   890,   898,
     567,   890,    16,   889,    -1,   890,   453,   252,   890,    -1,
     890,   252,   903,   976,    -1,   890,   898,   252,   903,   976,
      -1,   890,   395,   890,    -1,   890,   898,   395,   890,    -1,
     890,    -1,   890,   568,   891,    -1,   891,    -1,   891,   569,
     892,    -1,   892,    -1,   892,   444,   893,    -1,   892,   445,
     893,    -1,   893,    -1,   893,   571,   894,    -1,   893,   570,
     894,    -1,   893,   571,   902,   966,    -1,   893,   570,   902,
     966,    -1,   894,    -1,   894,   572,   895,    -1,   894,   573,
     895,    -1,   894,   574,   895,    -1,   894,   126,   895,    -1,
     894,   313,   895,    -1,   895,    -1,   895,   575,   903,    -1,
     903,    -1,   354,    -1,   351,    -1,    16,    -1,    15,    -1,
     333,    -1,   332,    -1,   581,    -1,   332,    -1,   145,    -1,
     184,    -1,   198,    -1,   244,    -1,   271,    -1,   328,    -1,
      12,    -1,    17,    -1,   225,   880,    -1,  1138,    -1,   903,
      64,  1150,    -1,  1133,    -1,  1131,    -1,   916,    -1,   912,
      -1,   903,   353,   903,    -1,   571,   903,    -1,   570,   903,
      -1,   576,   903,    -1,   899,   903,    -1,   578,  1231,   579,
      -1,   578,   880,   579,    -1,   578,   880,   580,   926,   579,
      -1,   424,   578,   880,   580,   926,   579,    -1,   152,   578,
    1231,   579,    -1,   582,  1148,   880,   583,    -1,   289,   929,
       9,   578,   890,   906,   579,    -1,    20,   578,   880,   579,
      -1,    32,   903,    -1,    51,   578,   880,    18,   924,   579,
      -1,   566,   933,   935,   934,   141,    -1,    83,   578,   880,
     580,   924,   579,    -1,    83,   578,   880,   535,   755,   579,
      -1,   111,   578,  1138,   579,    -1,   540,   578,  1139,   579,
      -1,   180,   578,   579,    -1,   181,   578,   880,   579,    -1,
     182,   578,   880,   580,   880,   579,    -1,   183,   578,   880,
     580,   880,   580,   880,   579,    -1,     7,   578,   880,   580,
     880,   579,    -1,     7,   578,   880,   580,   225,   880,   966,
     579,    -1,   404,   578,   880,   580,   880,   579,    -1,    22,
     578,   880,   579,    -1,    22,   578,   880,   580,   880,   579,
      -1,    56,   578,   926,   579,    -1,    56,   578,   926,   535,
     755,   579,    -1,    55,   578,   880,   579,    -1,    62,   578,
     926,   579,    -1,    65,   578,   880,   579,    -1,    73,   578,
     926,   579,    -1,    74,   578,   880,   580,   926,   579,    -1,
      84,   578,   880,   580,   880,   580,   880,   579,    -1,    90,
     879,    -1,    93,   879,    -1,    93,   578,   880,   579,    -1,
      91,   879,    -1,    98,   578,   880,   580,   902,   966,   579,
      -1,    99,   578,   880,   580,   902,   966,   579,    -1,    94,
     578,   579,    -1,   100,   578,   880,   579,    -1,   105,   578,
     880,   579,    -1,   136,   578,   880,   580,   926,   579,    -1,
     272,   578,   880,   580,   926,   579,    -1,   140,   578,   880,
     579,    -1,   140,   578,   880,   580,   880,   579,    -1,   110,
     578,   880,   580,  1146,   579,    -1,   139,   578,   880,   580,
    1146,   579,    -1,   118,   578,   880,   579,    -1,   118,   578,
     880,   580,   880,   579,    -1,   119,   578,   880,   579,    -1,
     119,   578,   880,   580,   880,   579,    -1,   155,   578,   880,
     580,   880,   580,   880,   579,    -1,   155,   578,   880,   580,
     880,   580,   880,   580,   880,   579,    -1,   155,   578,   880,
     580,   880,   580,   880,   580,   880,   580,   880,   579,    -1,
     171,   578,   880,   580,   338,   579,    -1,   176,   578,   880,
     579,    -1,   176,   578,   880,   580,   880,   579,    -1,   162,
     578,   880,   580,   926,   579,    -1,   905,    -1,   190,   578,
     968,   580,   880,   579,    -1,   209,   578,   880,   579,    -1,
     213,   578,   880,   580,   880,   580,   880,   579,    -1,   223,
     578,   880,   580,   880,   580,   880,   580,   880,   579,    -1,
     902,   966,   571,   880,    -1,   902,    -1,   242,   578,   579,
      -1,   242,   578,   880,   579,    -1,   249,   578,   880,   580,
     880,   579,    -1,   259,   578,   880,   580,   880,   579,    -1,
     259,   578,   880,   580,   880,   580,   880,   579,    -1,   194,
     578,   880,   580,   926,   579,    -1,   246,   578,   880,   580,
     926,   579,    -1,   264,   578,   880,   579,    -1,   264,   578,
     880,   580,   880,   579,    -1,   279,   578,   880,   580,   880,
     579,    -1,   279,   578,   880,   580,   880,   580,   880,   579,
      -1,   302,   578,   880,   579,    -1,   306,   578,   880,   579,
      -1,   313,   578,   880,   580,   880,   579,    -1,   314,   578,
     880,   579,    -1,   334,   879,    -1,   334,   578,   880,   579,
      -1,   361,   578,   880,   579,    -1,   343,   578,   880,   579,
      -1,   368,   578,   890,   229,   880,   579,    -1,   380,   578,
     880,   579,    -1,   388,   578,   880,   579,    -1,   388,   578,
     579,    -1,   405,   578,   880,   580,   880,   580,   880,   579,
      -1,   416,   578,   880,   580,   880,   579,    -1,   419,   578,
     880,   579,    -1,   419,   578,   880,   580,   880,   579,    -1,
     422,   578,   579,    -1,   478,   578,   880,   580,   880,   579,
      -1,   478,   578,   880,   580,   225,   880,   966,   579,    -1,
     428,   578,   880,   579,    -1,   480,   578,   880,   580,   880,
     580,   880,   579,    -1,   480,   578,   880,   580,   880,   579,
      -1,   480,   578,   880,   175,   880,   172,   880,   579,    -1,
     480,   578,   880,   175,   880,   579,    -1,   481,   578,   880,
     580,   880,   580,   880,   579,    -1,   487,   879,    -1,   487,
     578,   880,   579,    -1,   499,   578,   880,   579,    -1,   496,
     578,   880,   579,    -1,   496,   578,   880,   580,   880,   579,
      -1,   497,   578,   967,   580,   880,   580,   880,   579,    -1,
     498,   578,   967,   580,   880,   580,   880,   579,    -1,   508,
     578,   880,   579,    -1,   508,   578,   245,   880,   175,   880,
     579,    -1,   508,   578,   504,   880,   175,   880,   579,    -1,
     508,   578,    43,   880,   175,   880,   579,    -1,   508,   578,
     245,   175,   880,   579,    -1,   508,   578,   504,   175,   880,
     579,    -1,   508,   578,    43,   175,   880,   579,    -1,   508,
     578,   880,   175,   880,   579,    -1,   510,   578,   880,   580,
     880,   579,    -1,  1148,   585,  1148,   578,   925,   579,    -1,
      -1,  1144,   578,   904,   907,   579,    -1,   523,   578,  1129,
     580,   338,   580,   338,   580,   926,   579,    -1,   524,   578,
     579,    -1,   524,   578,   880,   579,    -1,   532,   578,   579,
      -1,   536,   879,    -1,   538,   879,    -1,   537,   879,    -1,
     549,   578,   880,   579,    -1,   549,   578,   880,   580,   880,
     579,    -1,   561,   578,   880,   579,    -1,   559,   578,   880,
     579,    -1,   559,   578,   880,   580,   880,   579,    -1,    29,
     578,   994,   580,   880,   579,    -1,   157,   578,   966,   175,
     880,   579,    -1,    80,   578,   880,   580,   880,   579,    -1,
     188,   578,   880,   579,    -1,   188,   578,   880,   580,   880,
     579,    -1,   189,   578,   880,   579,    -1,   189,   578,   880,
     580,   880,   579,    -1,   186,   578,   926,   579,    -1,   256,
     578,   926,   579,    -1,   317,   578,   926,   579,    -1,   309,
     578,   880,   579,    -1,   309,   578,   880,   580,   880,   579,
      -1,   315,   578,   880,   579,    -1,   315,   578,   880,   580,
     880,   579,    -1,   316,   578,   880,   579,    -1,   316,   578,
     880,   580,   880,   579,    -1,   318,   578,   926,   579,    -1,
     319,   578,   926,   579,    -1,   365,   578,   880,   580,   880,
     579,    -1,   364,   578,   880,   579,    -1,   364,   578,   880,
     580,   880,   579,    -1,   366,   578,   880,   579,    -1,   366,
     578,   880,   580,   880,   579,    -1,   367,   578,   926,   579,
      -1,   185,   578,   880,   579,    -1,   185,   578,   880,   580,
     880,   579,    -1,   254,   578,   880,   579,    -1,   254,   578,
     880,   580,   880,   579,    -1,    -1,   553,   381,   154,    -1,
     229,    41,   310,    -1,    -1,   908,    -1,    -1,   909,   910,
      -1,   911,    -1,   910,   580,   911,    -1,   875,   880,   876,
     878,    -1,    25,   578,   922,   579,    -1,    25,   578,   125,
     922,   579,    -1,    35,   578,   922,   579,    -1,    36,   578,
     922,   579,    -1,    38,   578,   922,   579,    -1,    85,   578,
     971,   572,   579,    -1,    85,   578,   922,   579,    -1,    -1,
      -1,    85,   578,   125,   913,   926,   914,   579,    -1,   197,
     578,  1129,   580,   338,   580,   338,   580,   922,   579,    -1,
     308,   578,   922,   579,    -1,   308,   578,   125,   922,   579,
      -1,   293,   578,   922,   579,    -1,   293,   578,   125,   922,
     579,    -1,   472,   578,   922,   579,    -1,   545,   578,   922,
     579,    -1,   473,   578,   922,   579,    -1,   539,   578,   922,
     579,    -1,   482,   578,   922,   579,    -1,   482,   578,   125,
     922,   579,    -1,    -1,   196,   578,   919,   915,   926,   921,
     920,   579,    -1,    -1,   584,   917,   918,    -1,  1150,   442,
     880,    -1,  1150,    -1,   584,  1163,  1150,   789,    -1,    -1,
     125,    -1,    -1,   437,  1130,    -1,    -1,   984,    -1,    -1,
     971,   923,   880,    -1,    32,   748,    -1,    56,   748,   764,
      -1,   326,   748,    -1,   448,    -1,   448,   227,    -1,   527,
      -1,   527,   227,    -1,   100,    -1,   499,    -1,    97,    -1,
     108,   743,    -1,    -1,   926,    -1,    -1,   927,   928,    -1,
     880,    -1,   928,   580,   880,    -1,   930,    -1,   578,   930,
     579,    -1,    -1,   931,   932,    -1,  1138,    -1,   932,   580,
    1138,    -1,    -1,   880,    -1,    -1,   564,   880,    -1,   550,
     880,   565,   880,    -1,   935,   550,   880,   565,   880,    -1,
     948,    -1,   939,    -1,   938,    -1,   936,    -1,   938,   580,
     936,    -1,   936,   947,   936,    -1,   936,   476,   948,    -1,
      -1,   936,   947,   936,   344,   940,   880,    -1,    -1,   936,
     476,   948,   344,   941,   880,    -1,    -1,   936,   947,   936,
     535,   942,   578,   965,   579,    -1,   936,   324,   236,   948,
      -1,    -1,   936,   249,   958,   236,   936,   344,   943,   880,
      -1,    -1,   936,   249,   958,   236,   948,   944,   535,   578,
     965,   579,    -1,   936,   324,   249,   958,   236,   948,    -1,
      -1,   936,   416,   958,   236,   936,   344,   945,   880,    -1,
      -1,   936,   416,   958,   236,   948,   946,   535,   578,   965,
     579,    -1,   936,   324,   416,   958,   236,   948,    -1,   236,
      -1,   219,   236,    -1,    88,   236,    -1,    -1,   949,  1142,
     970,   960,    -1,    -1,   582,  1148,   936,   249,   355,   236,
     936,   344,   950,   880,   583,    -1,   957,   956,   953,    -1,
     578,   956,   951,  1226,   579,   970,    -1,    -1,   956,   952,
     938,    -1,    -1,    -1,   954,   869,   873,   955,   720,    -1,
      -1,   430,    -1,    -1,   355,    -1,    -1,   172,   236,    -1,
      -1,   534,   961,    -1,   169,   961,    -1,   214,   961,    -1,
      -1,   778,   959,   962,   578,   963,   579,    -1,    -1,   964,
      -1,   964,   580,  1148,    -1,  1148,    -1,   372,    -1,  1148,
      -1,   965,   580,  1148,    -1,   967,    -1,   101,    -1,   102,
      -1,   103,    -1,   104,    -1,   206,    -1,   207,    -1,   208,
      -1,   302,    -1,   304,    -1,   305,    -1,   427,    -1,   560,
      -1,   105,    -1,   549,    -1,   209,    -1,   174,    -1,   306,
      -1,   314,    -1,   380,    -1,   428,    -1,   561,    -1,   100,
      -1,   499,    -1,    97,    -1,   496,    -1,    -1,    18,    -1,
     145,    -1,    -1,   969,  1148,    -1,    -1,    12,    -1,    -1,
      -1,   551,   973,   880,    -1,    -1,    -1,   201,   975,   880,
      -1,   149,   903,    -1,    -1,    -1,   195,    45,   978,   979,
      -1,   978,   580,  1137,   987,    -1,  1137,   987,    -1,    -1,
     553,    89,    -1,   553,   418,    -1,   352,    45,   981,    -1,
     981,   580,   982,    -1,   982,    -1,  1139,   987,    -1,    -1,
     984,    -1,    -1,   352,    45,   985,   986,    -1,   986,   580,
    1137,   987,    -1,  1137,   987,    -1,    -1,    19,    -1,   116,
      -1,    -1,   990,    -1,    -1,   990,    -1,   253,   991,    -1,
     992,    -1,   992,   580,   992,    -1,   992,   341,   992,    -1,
    1131,    -1,   515,    -1,   267,    -1,   338,    -1,    -1,   253,
     992,    -1,   338,    -1,   203,    -1,   267,    -1,   515,    -1,
     107,    -1,   166,    -1,   338,    -1,   515,    -1,   267,    -1,
     107,    -1,   166,    -1,    -1,    -1,   374,  1148,   997,   578,
     998,   579,    -1,    -1,   999,    -1,   999,   580,  1000,    -1,
    1000,    -1,   875,   880,    -1,    -1,  1002,  1003,    -1,  1003,
     580,  1004,    -1,  1004,    -1,   584,  1150,    -1,  1150,    -1,
      -1,   226,  1006,  1007,    -1,    -1,   356,  1147,  1008,  1118,
    1121,    -1,   131,  1147,    -1,  1001,    -1,    -1,   128,  1010,
     926,    -1,   129,  1016,  1173,  1015,  1013,   806,    -1,    -1,
     129,   217,  1148,   344,  1142,  1012,    -1,   129,    94,  1015,
    1148,    -1,   129,   179,  1015,   614,    -1,   129,   374,  1015,
     614,    -1,   129,   532,   613,  1203,    -1,   129,   547,  1015,
    1013,   806,    -1,   129,   506,  1015,   614,    -1,  1014,    -1,
    1013,   580,  1014,    -1,  1142,    -1,    -1,   213,   152,    -1,
      -1,   491,    -1,    -1,    -1,   223,  1018,  1023,   805,  1025,
    1019,  1027,  1043,    -1,    -1,    -1,   405,  1021,  1024,  1025,
    1022,  1027,    -1,    -1,   270,    -1,   113,    -1,   204,    -1,
    1052,    -1,   113,    -1,   226,  1026,    -1,  1026,    -1,  1014,
      -1,  1030,    -1,   578,   579,  1030,    -1,   578,  1029,   579,
    1030,    -1,    -1,   441,  1028,  1034,    -1,  1029,   580,  1135,
      -1,  1135,    -1,   540,  1033,    -1,   541,  1033,    -1,    -1,
     699,  1031,  1223,    -1,    -1,   578,   699,   579,  1032,  1226,
      -1,  1033,   580,  1038,    -1,  1038,    -1,  1034,   580,  1035,
      -1,  1035,    -1,  1139,  1036,  1042,    -1,   145,    -1,   442,
      -1,    -1,  1036,    -1,    -1,   578,  1039,  1040,   579,    -1,
      -1,  1041,    -1,  1041,   580,  1042,    -1,  1042,    -1,   880,
      -1,   111,    -1,    -1,    -1,   344,   132,  1044,   238,   529,
    1050,    -1,    -1,    -1,   529,  1046,  1052,   805,   937,   441,
    1048,  1047,   972,   983,   993,    -1,  1048,   580,  1049,    -1,
    1049,    -1,  1139,  1036,  1042,    -1,  1050,   580,  1051,    -1,
    1051,    -1,  1139,  1036,  1042,    -1,    -1,   270,    -1,    -1,
     115,  1054,  1062,  1055,    -1,    -1,   175,  1142,  1056,   972,
     983,   993,    -1,    -1,  1059,  1057,   175,   937,   972,    -1,
      -1,   175,  1059,  1058,   535,   937,   972,    -1,  1060,    -1,
    1059,   580,  1060,    -1,  1148,  1061,   970,    -1,  1148,   585,
    1148,  1061,   970,    -1,    -1,   585,   572,    -1,    -1,  1063,
    1062,    -1,   382,    -1,   270,    -1,   214,    -1,   510,  1065,
    1014,    -1,    -1,   490,    -1,    -1,  1067,    -1,  1068,    -1,
    1067,   580,  1068,    -1,    86,    -1,   300,    -1,    40,   230,
      -1,    81,   486,    -1,   359,   160,    -1,   231,    -1,   485,
      -1,   454,    -1,    12,    -1,    -1,   172,   381,   338,    -1,
      -1,   446,  1071,  1072,    -1,    95,  1083,    -1,  1079,   488,
    1078,  1083,    -1,  1079,   507,  1078,  1083,    -1,   490,   471,
    1078,  1083,    -1,   347,   488,  1078,  1083,    -1,    -1,   143,
     716,  1073,  1075,    -1,  1079,    66,  1080,  1142,  1078,  1083,
      -1,   329,   287,   172,   450,   553,   275,   145,  1145,    16,
     276,   145,   995,    16,   280,   145,   994,    -1,  1076,   263,
      -1,   450,   205,    -1,    -1,    33,   150,  1081,  1082,  1074,
     988,    -1,   780,  1080,  1142,  1078,   972,    -1,    67,   511,
      -1,   490,   511,    -1,  1077,   142,    -1,   373,    -1,    85,
     578,   572,   579,   548,    -1,    85,   578,   572,   579,   147,
      -1,   548,   988,    -1,   147,   988,    -1,   378,    -1,   377,
    1066,  1069,   988,    -1,  1162,   471,  1083,    -1,   220,   471,
      -1,   320,   471,    -1,  1079,   376,    -1,  1162,   544,  1083,
      -1,   754,  1083,    -1,    65,  1083,    -1,    30,   263,    -1,
     263,    -1,   193,    -1,   193,   172,  1151,    -1,    87,    94,
     709,  1148,    -1,    87,   490,  1142,    -1,    87,   547,  1142,
      -1,   287,   471,    -1,   450,   471,    -1,    87,   374,   614,
      -1,    87,   179,   614,    -1,   374,   471,  1083,    -1,   179,
     471,  1083,    -1,   374,    63,   614,    -1,   179,    63,   614,
      -1,   435,   471,  1078,  1083,    -1,   471,    -1,   263,    -1,
     287,    -1,    32,    -1,    -1,   475,    -1,    -1,  1080,  1148,
      -1,    -1,   177,    -1,   175,    -1,   229,    -1,    -1,   229,
    1145,    -1,    -1,   175,   995,    -1,    -1,   252,  1145,    -1,
     551,   880,    -1,    -1,  1087,  1142,  1085,  1089,    -1,    -1,
    1087,  1088,  1086,   859,    -1,   116,    -1,   117,    -1,    -1,
     156,    -1,    -1,  1130,    -1,  1148,    -1,    -1,   168,   841,
    1091,  1092,    -1,  1092,   580,  1093,    -1,  1093,    -1,    -1,
    1173,  1094,  1095,    -1,   488,   553,   390,   262,    -1,   381,
      47,    -1,   205,    -1,   373,    -1,   263,    -1,   471,    -1,
     450,    -1,   287,    -1,   120,    -1,   409,    -1,    -1,  1013,
      -1,    -1,   408,  1097,  1098,    -1,  1098,   580,  1099,    -1,
    1099,    -1,   450,    -1,   287,    -1,   381,    47,    -1,    -1,
     379,  1101,  1102,    -1,  1076,   263,  1103,    -1,   503,  1145,
      -1,    27,   880,    -1,    -1,   239,  1105,  1106,   880,    -1,
      -1,    77,    -1,   381,    -1,   534,  1148,    -1,    -1,   257,
      96,  1109,  1110,    -1,   257,   490,  1142,   175,   287,    -1,
      -1,    -1,    -1,    -1,  1116,  1115,   218,  1147,  1111,  1117,
     226,  1112,   490,  1142,  1113,   757,  1114,  1118,  1121,  1124,
    1125,  1128,    -1,   175,   287,    -1,    -1,   258,    -1,    -1,
      75,    -1,   270,    -1,    -1,   405,    -1,   214,    -1,    -1,
      66,  1119,    -1,  1119,  1120,    -1,  1120,    -1,   493,    45,
    1130,    -1,   350,   138,    45,  1130,    -1,   138,    45,  1130,
      -1,   148,    45,  1130,    -1,    -1,   255,  1122,    -1,  1122,
    1123,    -1,  1123,    -1,   493,    45,  1130,    -1,   469,    45,
    1130,    -1,    -1,   214,   338,   255,    -1,    -1,   578,  1126,
     579,    -1,   578,   579,    -1,  1126,   580,  1127,    -1,  1127,
      -1,  1139,    -1,   584,  1150,    -1,    -1,   441,  1050,    -1,
    1146,    -1,   325,    -1,   518,   494,    -1,  1129,  1146,    -1,
    1146,    -1,   203,    -1,    34,    -1,   362,    -1,  1133,    -1,
     571,  1134,    -1,   570,  1134,    -1,  1129,    -1,  1134,    -1,
     337,    -1,   158,    -1,   509,    -1,   203,    -1,    34,    -1,
     518,   203,    -1,   518,    34,    -1,   100,  1129,    -1,   499,
    1129,    -1,   496,  1129,    -1,   338,    -1,   267,    -1,   515,
      -1,   107,    -1,   166,    -1,  1139,    -1,  1136,    -1,  1148,
     585,   572,    -1,  1148,   585,  1148,   585,   572,    -1,   880,
      -1,  1148,    -1,  1140,    -1,  1148,    -1,  1140,    -1,  1148,
     585,  1148,    -1,   585,  1148,   585,  1148,    -1,  1148,   585,
    1148,   585,  1148,    -1,  1148,    -1,  1148,   585,  1148,   585,
    1148,    -1,  1148,   585,  1148,    -1,   585,  1148,    -1,  1148,
      -1,  1148,   585,  1148,    -1,   585,  1148,    -1,  1148,    -1,
     210,    -1,   212,    -1,   494,    -1,   494,    -1,   494,    -1,
    1144,    -1,  1152,    -1,  1144,    -1,  1153,    -1,  1148,    -1,
    1145,    -1,   251,    -1,  1150,    -1,  1150,   584,  1150,    -1,
      91,   879,    -1,  1153,    -1,    20,    -1,    26,    -1,    28,
      -1,    46,    -1,    47,    -1,    55,    -1,    57,    -1,    61,
      -1,    68,    -1,    70,    -1,    80,    -1,   106,    -1,   128,
      -1,   141,    -1,   151,    -1,   168,    -1,   199,    -1,   202,
      -1,   241,    -1,   335,    -1,   347,    -1,   370,    -1,   402,
      -1,   408,    -1,   410,    -1,   417,    -1,   426,    -1,   429,
      -1,   448,    -1,   450,    -1,   470,    -1,   474,    -1,   510,
      -1,   520,    -1,   557,    -1,   530,    -1,     5,    -1,     7,
      -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,    17,
      -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,    33,
      -1,    37,    -1,    40,    -1,    42,    -1,    41,    -1,    44,
      -1,    50,    -1,    52,    -1,    54,    -1,    59,    -1,    60,
      -1,    63,    -1,    65,    -1,    66,    -1,    69,    -1,    71,
      -1,    72,    -1,    75,    -1,    77,    -1,    78,    -1,    81,
      -1,    86,    -1,    89,    -1,    96,    -1,    97,    -1,   100,
      -1,   105,    -1,   112,    -1,   114,    -1,   120,    -1,   122,
      -1,   124,    -1,   131,    -1,   132,    -1,   133,    -1,   144,
      -1,   143,    -1,   142,    -1,   147,    -1,   149,    -1,   150,
      -1,   154,    -1,   156,    -1,   159,    -1,   160,    -1,   173,
      -1,   123,    -1,   137,    -1,   177,    -1,   163,    -1,   164,
      -1,   165,    -1,   174,    -1,   187,    -1,   186,    -1,   190,
      -1,   193,    -1,   191,    -1,   200,    -1,   205,    -1,   209,
      -1,   211,    -1,   228,    -1,   215,    -1,   216,    -1,   233,
      -1,   234,    -1,   220,    -1,   224,    -1,   230,    -1,   231,
      -1,   398,    -1,   243,    -1,   247,    -1,   250,    -1,   256,
      -1,   258,    -1,   261,    -1,   263,    -1,   292,    -1,   287,
      -1,   274,    -1,   278,    -1,   275,    -1,   276,    -1,   288,
      -1,   277,    -1,   280,    -1,   273,    -1,   286,    -1,   282,
      -1,   281,    -1,   283,    -1,   284,    -1,   285,    -1,   290,
      -1,   291,    -1,   294,    -1,   295,    -1,   299,    -1,   300,
      -1,   301,    -1,   302,    -1,   303,    -1,   306,    -1,   307,
      -1,   312,    -1,   310,    -1,   314,    -1,   317,    -1,   318,
      -1,   319,    -1,   320,    -1,   322,    -1,   321,    -1,   323,
      -1,   326,    -1,   327,    -1,   330,    -1,   329,    -1,   331,
      -1,   340,    -1,   341,    -1,   343,    -1,   345,    -1,   346,
      -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,   371,    -1,   373,    -1,   375,
      -1,   376,    -1,   377,    -1,   378,    -1,   380,    -1,   381,
      -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,   386,
      -1,   387,    -1,   392,    -1,   393,    -1,   396,    -1,   397,
      -1,   400,    -1,   403,    -1,   406,    -1,   409,    -1,   412,
      -1,   413,    -1,   418,    -1,   420,    -1,   421,    -1,   423,
      -1,   424,    -1,   425,    -1,   428,    -1,   431,    -1,   432,
      -1,   433,    -1,   435,    -1,   439,    -1,   438,    -1,   440,
      -1,   449,    -1,   443,    -1,   447,    -1,   452,    -1,   453,
      -1,   454,    -1,   462,    -1,   461,    -1,   464,    -1,   467,
      -1,   471,    -1,   475,    -1,   477,    -1,   478,    -1,   479,
      -1,   483,    -1,   484,    -1,   485,    -1,   486,    -1,   488,
      -1,   489,    -1,   491,    -1,   492,    -1,   495,    -1,   505,
      -1,   507,    -1,   496,    -1,   497,    -1,   498,    -1,   499,
      -1,   511,    -1,   512,    -1,   513,    -1,   179,    -1,   516,
      -1,   517,    -1,   525,    -1,   528,    -1,   532,    -1,   533,
      -1,   544,    -1,   547,    -1,   541,    -1,   548,    -1,   549,
      -1,   554,    -1,   556,    -1,   561,    -1,    -1,   441,  1156,
    1155,  1157,    -1,    -1,   349,    -1,  1158,    -1,  1157,   580,
    1158,    -1,    -1,  1159,  1164,    -1,  1161,    -1,   191,    -1,
     258,    -1,   440,    -1,    -1,   345,    -1,    -1,   191,    -1,
     258,    -1,   440,    -1,    -1,   191,   585,    -1,   258,   585,
      -1,   440,   585,    -1,  1165,    -1,  1161,  1166,    -1,  1160,
    1167,  1036,  1170,    -1,  1160,   505,   233,   250,  1168,    -1,
     584,  1150,  1036,   880,    -1,   584,   584,  1163,  1167,  1036,
    1170,    -1,   754,   759,    -1,   321,  1036,   880,    -1,   321,
     756,   761,    -1,   361,  1036,  1169,    -1,   361,   172,  1151,
    1036,  1169,    -1,  1148,    -1,  1148,   585,  1148,    -1,   111,
     585,  1148,    -1,   390,   516,    -1,   390,    69,    -1,   403,
     390,    -1,   438,    -1,   494,    -1,   361,   578,   494,   579,
      -1,   343,   578,   494,   579,    -1,   880,    -1,   111,    -1,
     344,    -1,    12,    -1,    32,    -1,    -1,   262,  1173,  1172,
    1174,    -1,   490,    -1,   488,    -1,  1175,    -1,  1174,   580,
    1175,    -1,  1142,   970,  1176,    -1,   390,    -1,   555,    -1,
     270,   555,    -1,   390,   258,    -1,    -1,   526,  1178,  1173,
      -1,   199,  1142,   347,   970,    -1,   199,  1143,    61,    -1,
      -1,   199,  1143,   390,  1180,  1181,   972,   989,    -1,  1182,
      -1,  1148,  1183,    -1,   164,    -1,   330,    -1,   164,    -1,
     330,    -1,   371,    -1,   243,    -1,    -1,  1185,  1184,   578,
    1041,   579,    -1,   145,    -1,   184,    -1,   244,    -1,   198,
      -1,   271,    -1,   415,   613,  1187,    -1,  1191,   344,  1190,
    1202,   175,  1204,    -1,  1191,   344,   179,  1202,   175,  1204,
      -1,  1191,   344,   374,  1202,   175,  1204,    -1,    12,  1192,
     580,   192,   349,   175,  1204,    -1,   192,   613,  1189,    -1,
    1191,   344,  1190,  1202,   503,  1204,  1209,  1210,    -1,  1191,
     344,   179,  1202,   503,  1204,  1209,  1210,    -1,  1191,   344,
     374,  1202,   503,  1204,  1209,  1210,    -1,    -1,   490,    -1,
    1193,    -1,    12,  1192,    -1,    -1,   373,    -1,  1194,    -1,
    1193,   580,  1194,    -1,    -1,   430,  1195,  1206,    -1,    -1,
     223,  1196,  1206,    -1,    -1,   529,  1197,  1206,    -1,    -1,
     394,  1198,  1206,    -1,   115,    -1,   531,    -1,   217,    -1,
      13,    -1,    87,    -1,   129,    -1,   151,    -1,   400,    -1,
     447,    -1,   375,    -1,   163,    -1,   192,   349,    -1,   446,
      95,    -1,   483,    -1,    87,   491,   488,    -1,   262,   488,
      -1,   406,   450,    -1,   406,    60,    -1,    87,   547,    -1,
     446,   547,    -1,    87,   420,    -1,    13,   420,    -1,    87,
     532,    -1,    -1,    16,    -1,  1201,  1199,  1200,    -1,  1201,
      -1,   479,   494,    -1,   234,   494,    -1,    59,   494,    -1,
     572,    -1,  1148,   585,   572,    -1,   572,   585,   572,    -1,
    1142,    -1,  1151,    -1,  1203,   580,  1151,    -1,  1205,    -1,
    1204,   580,  1205,    -1,  1151,   211,    45,   494,    -1,  1151,
     211,    45,   361,   494,    -1,  1151,    -1,    -1,   578,  1207,
     579,    -1,  1207,   580,  1208,    -1,  1208,    -1,  1148,    -1,
      -1,   407,  1200,    -1,   407,   468,    -1,   407,   556,    -1,
     407,   331,    -1,    -1,   553,  1211,    -1,  1211,  1212,    -1,
    1212,    -1,   192,   349,    -1,   291,   994,    -1,   294,   994,
      -1,   290,   994,    -1,   295,   994,    -1,    -1,    28,  1214,
    1215,    -1,    -1,   554,    -1,    -1,    16,   335,    52,    -1,
      16,    52,    -1,    -1,   399,    -1,   335,   399,    -1,    -1,
     426,    -1,    70,  1215,  1216,  1217,    -1,   417,  1215,  1216,
    1217,    -1,   417,  1215,   503,  1218,  1148,    -1,   426,  1148,
      -1,   399,   426,  1148,    -1,    -1,  1224,    -1,    -1,   521,
    1230,  1225,   860,    -1,    -1,  1224,    -1,  1227,    -1,    -1,
    1228,  1229,    -1,   984,   988,    -1,   990,    -1,    -1,   125,
      -1,    12,    -1,   430,  1234,  1233,  1235,    -1,    -1,   578,
    1234,  1231,   579,  1232,  1223,  1235,    -1,   862,    -1,    -1,
      -1,  1238,  1237,    -1,  1239,  1238,  1244,    -1,  1244,    -1,
    1252,    -1,  1254,    -1,    -1,   112,   145,  1151,    -1,  1240,
      -1,  1240,  1241,    -1,  1241,    -1,   354,   405,    -1,    11,
     145,   517,    -1,    11,   145,   301,    -1,    11,   145,   492,
      -1,    -1,  1241,    -1,    -1,   466,   429,   112,    -1,   466,
     429,   228,    -1,    -1,  1243,   547,  1142,  1245,  1246,    18,
    1248,  1251,    -1,    -1,   578,  1247,   579,    -1,  1148,    -1,
    1247,   580,  1148,    -1,    -1,  1249,  1250,    -1,   430,   875,
     862,    -1,   578,   875,   861,   579,  1226,    -1,    -1,   553,
      58,   349,    -1,   553,    50,    58,   349,    -1,   553,   258,
      58,   349,    -1,    -1,   506,   875,   614,   691,   692,   344,
     875,  1142,   172,   875,   134,   424,  1253,   655,    -1,    -1,
     721,   875,   179,   614,  1255,   615,    -1,    -1,    -1,    -1,
      -1,   374,   875,   614,  1256,   578,  1257,   635,   579,  1258,
     622,  1259,   655,    -1,   557,  1262,  1261,  1263,    -1,   557,
     141,  1261,  1265,    -1,   557,   370,  1261,    -1,   557,    70,
    1261,  1264,    -1,   557,   417,  1261,    -1,   557,   392,    -1,
    1130,    -1,  1130,   580,  1130,    -1,  1130,   580,  1130,   580,
     994,    -1,    28,    -1,   470,    -1,    -1,   236,    -1,   412,
      -1,    -1,   346,   363,    -1,    -1,    -1,   484,  1266,  1267,
      -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1221,  1221,  1235,  1238,  1239,  1244,  1245,  1246,  1247,
    1248,  1249,  1250,  1251,  1252,  1253,  1254,  1255,  1256,  1257,
    1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  1267,
    1268,  1269,  1270,  1271,  1272,  1273,  1274,  1275,  1276,  1277,
    1278,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1286,  1287,
    1288,  1289,  1290,  1294,  1303,  1304,  1309,  1318,  1325,  1335,
    1334,  1345,  1347,  1351,  1352,  1355,  1368,  1367,  1386,  1385,
    1396,  1397,  1400,  1405,  1410,  1415,  1420,  1424,  1429,  1433,
    1437,  1441,  1445,  1450,  1454,  1458,  1474,  1478,  1490,  1489,
    1512,  1511,  1538,  1537,  1550,  1549,  1557,  1565,  1579,  1594,
    1612,  1632,  1671,  1679,  1687,  1699,  1631,  1730,  1731,  1735,
    1736,  1741,  1743,  1745,  1747,  1749,  1751,  1753,  1759,  1760,
    1761,  1765,  1769,  1777,  1776,  1789,  1791,  1794,  1796,  1800,
    1804,  1811,  1813,  1817,  1818,  1823,  1842,  1868,  1870,  1874,
    1875,  1879,  1905,  1906,  1907,  1908,  1912,  1913,  1917,  1918,
    1923,  1926,  1953,  1952,  2008,  2023,  2022,  2066,  2090,  2090,
    2121,  2122,  2127,  2129,  2134,  2157,  2163,  2178,  2179,  2183,
    2187,  2196,  2201,  2206,  2214,  2229,  2247,  2248,  2252,  2252,
    2302,  2301,  2325,  2324,  2328,  2329,  2331,  2331,  2342,  2371,
    2399,  2415,  2414,  2431,  2448,  2450,  2451,  2455,  2476,  2499,
    2501,  2515,  2499,  2533,  2535,  2536,  2540,  2541,  2546,  2552,
    2545,  2571,  2570,  2586,  2587,  2591,  2592,  2597,  2601,  2596,
    2618,  2622,  2617,  2637,  2645,  2650,  2649,  2687,  2688,  2693,
    2692,  2719,  2730,  2732,  2729,  2756,  2755,  2773,  2775,  2780,
    2782,  2784,  2789,  2790,  2791,  2797,  2806,  2807,  2807,  2811,
    2813,  2812,  2815,  2814,  2820,  2836,  2819,  2850,  2851,  2854,
    2855,  2858,  2859,  2862,  2863,  2866,  2867,  2870,  2871,  2874,
    2877,  2878,  2880,  2882,  2885,  2886,  2889,  2890,  2891,  2894,
    2895,  2896,  2897,  2898,  2899,  2900,  2901,  2902,  2917,  2923,
    2924,  2925,  2926,  2931,  2936,  2941,  2956,  2957,  2958,  2959,
    2960,  2961,  2965,  2982,  2998,  3008,  3009,  3010,  3011,  3012,
    3013,  3016,  3017,  3018,  3021,  3022,  3023,  3026,  3027,  3030,
    3031,  3034,  3035,  3036,  3037,  3040,  3041,  3045,  3046,  3050,
    3051,  3061,  3075,  3090,  3110,  3117,  3126,  3128,  3132,  3136,
    3137,  3141,  3146,  3145,  3167,  3168,  3169,  3170,  3172,  3174,
    3176,  3178,  3180,  3182,  3185,  3188,  3191,  3194,  3196,  3199,
    3202,  3203,  3204,  3205,  3218,  3219,  3221,  3223,  3235,  3237,
    3239,  3241,  3242,  3243,  3244,  3245,  3246,  3248,  3250,  3252,
    3252,  3254,  3254,  3256,  3257,  3266,  3267,  3268,  3271,  3272,
    3273,  3274,  3275,  3279,  3283,  3284,  3288,  3289,  3293,  3294,
    3295,  3296,  3297,  3301,  3302,  3303,  3304,  3305,  3308,  3310,
    3311,  3315,  3316,  3317,  3320,  3327,  3328,  3331,  3332,  3335,
    3336,  3337,  3340,  3341,  3344,  3345,  3348,  3349,  3352,  3353,
    3356,  3357,  3358,  3359,  3361,  3362,  3368,  3374,  3380,  3386,
    3387,  3403,  3404,  3408,  3409,  3413,  3421,  3425,  3426,  3429,
    3430,  3434,  3443,  3447,  3448,  3451,  3461,  3462,  3466,  3467,
    3470,  3471,  3474,  3475,  3476,  3477,  3486,  3487,  3490,  3491,
    3494,  3495,  3496,  3505,  3507,  3509,  3514,  3513,  3525,  3526,
    3529,  3530,  3534,  3535,  3538,  3539,  3542,  3543,  3544,  3545,
    3546,  3549,  3550,  3551,  3552,  3553,  3556,  3557,  3558,  3570,
    3571,  3574,  3575,  3578,  3579,  3583,  3584,  3585,  3588,  3589,
    3590,  3591,  3604,  3605,  3606,  3609,  3610,  3614,  3615,  3618,
    3619,  3622,  3627,  3632,  3637,  3642,  3647,  3652,  3657,  3668,
    3669,  3672,  3673,  3684,  3685,  3688,  3689,  3692,  3693,  3701,
    3700,  3727,  3726,  3741,  3740,  3759,  3758,  3778,  3776,  3791,
    3792,  3794,  3795,  3796,  3797,  3798,  3801,  3809,  3810,  3814,
    3819,  3818,  3826,  3835,  3825,  3847,  3854,  3858,  3865,  3872,
    3878,  3884,  3890,  3897,  3916,  3937,  3942,  3946,  3953,  3954,
    3957,  3958,  3962,  3963,  3964,  3968,  3969,  3970,  3973,  3974,
    3975,  3976,  3984,  3983,  3994,  4002,  4001,  4011,  4021,  4030,
    4031,  4038,  4038,  4044,  4045,  4049,  4050,  4051,  4055,  4056,
    4073,  4074,  4079,  4078,  4089,  4088,  4099,  4098,  4108,  4109,
    4110,  4115,  4114,  4126,  4127,  4130,  4131,  4134,  4135,  4136,
    4140,  4139,  4152,  4151,  4168,  4169,  4172,  4173,  4176,  4177,
    4178,  4179,  4180,  4181,  4185,  4184,  4196,  4197,  4198,  4203,
    4202,  4208,  4215,  4220,  4228,  4229,  4232,  4244,  4253,  4254,
    4257,  4270,  4271,  4276,  4275,  4285,  4286,  4289,  4302,  4302,
    4312,  4313,  4322,  4323,  4332,  4341,  4343,  4346,  4368,  4372,
    4371,  4391,  4399,  4391,  4405,  4406,  4407,  4408,  4409,  4412,
    4419,  4426,  4428,  4439,  4440,  4443,  4444,  4450,  4451,  4452,
    4453,  4459,  4465,  4471,  4481,  4484,  4486,  4492,  4502,  4503,
    4504,  4517,  4537,  4544,  4551,  4552,  4555,  4556,  4557,  4558,
    4559,  4563,  4564,  4568,  4568,  4585,  4587,  4592,  4593,  4593,
    4610,  4612,  4617,  4618,  4621,  4623,  4625,  4627,  4629,  4630,
    4631,  4635,  4636,  4637,  4638,  4640,  4642,  4645,  4649,  4655,
    4659,  4665,  4669,  4677,  4679,  4685,  4688,  4690,  4692,  4693,
    4695,  4698,  4699,  4702,  4703,  4706,  4708,  4710,  4713,  4714,
    4715,  4717,  4719,  4722,  4723,  4724,  4725,  4726,  4727,  4730,
    4731,  4733,  4733,  4734,  4734,  4735,  4735,  4736,  4736,  4738,
    4739,  4740,  4741,  4742,  4743,  4746,  4747,  4751,  4755,  4756,
    4763,  4764,  4765,  4766,  4767,  4769,  4770,  4771,  4772,  4773,
    4777,  4778,  4783,  4788,  4792,  4793,  4797,  4798,  4802,  4809,
    4811,  4817,  4819,  4830,  4832,  4843,  4854,  4865,  4876,  4878,
    4880,  4882,  4884,  4886,  4888,  4890,  4892,  4894,  4896,  4898,
    4900,  4906,  4908,  4910,  4915,  4920,  4922,  4924,  4929,  4931,
    4933,  4935,  4937,  4942,  4943,  4945,  4947,  4949,  4951,  4953,
    4955,  4957,  4959,  4961,  4963,  4965,  4969,  4971,  4981,  4983,
    4985,  4987,  4989,  4992,  5001,  5006,  5011,  5013,  5015,  5017,
    5019,  5021,  5023,  5025,  5030,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5053,  5055,  5057,  5059,  5061,  5063,  5065,  5067,
    5069,  5070,  5075,  5077,  5079,  5081,  5083,  5085,  5087,  5089,
    5091,  5098,  5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,
    5121,  5123,  5125,  5127,  5129,  5131,  5133,  5147,  5146,  5263,
    5267,  5272,  5274,  5276,  5278,  5280,  5282,  5287,  5289,  5291,
    5293,  5295,  5300,  5304,  5306,  5308,  5310,  5312,  5314,  5318,
    5321,  5324,  5326,  5328,  5330,  5332,  5334,  5336,  5339,  5342,
    5344,  5346,  5348,  5350,  5352,  5355,  5357,  5359,  5361,  5366,
    5367,  5368,  5372,  5373,  5377,  5377,  5383,  5387,  5394,  5425,
    5427,  5429,  5431,  5433,  5435,  5437,  5440,  5442,  5439,  5445,
    5447,  5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,  5470,
    5473,  5472,  5487,  5486,  5501,  5507,  5513,  5526,  5527,  5530,
    5531,  5536,  5539,  5551,  5550,  5566,  5567,  5568,  5569,  5570,
    5571,  5572,  5573,  5574,  5575,  5576,  5580,  5581,  5585,  5585,
    5590,  5591,  5594,  5595,  5598,  5598,  5603,  5604,  5607,  5608,
    5611,  5612,  5615,  5621,  5631,  5632,  5641,  5646,  5647,  5667,
    5669,  5673,  5671,  5688,  5686,  5704,  5702,  5709,  5718,  5716,
    5734,  5733,  5743,  5754,  5752,  5771,  5770,  5781,  5791,  5792,
    5793,  5798,  5798,  5817,  5815,  5834,  5856,  5904,  5903,  5926,
    5944,  5926,  5951,  5955,  5981,  5982,  5984,  5986,  5989,  5990,
    5996,  6003,  6012,  6011,  6018,  6019,  6023,  6027,  6031,  6037,
    6045,  6054,  6055,  6056,  6057,  6058,  6059,  6060,  6061,  6062,
    6063,  6064,  6065,  6066,  6069,  6070,  6071,  6072,  6073,  6074,
    6075,  6076,  6077,  6081,  6082,  6083,  6084,  6087,  6089,  6090,
    6093,  6094,  6097,  6099,  6103,  6105,  6104,  6118,  6121,  6120,
    6135,  6141,  6154,  6156,  6159,  6161,  6165,  6166,  6179,  6197,
    6201,  6202,  6206,  6219,  6221,  6225,  6224,  6256,  6258,  6262,
    6263,  6264,  6269,  6275,  6279,  6280,  6284,  6288,  6295,  6302,
    6311,  6315,  6316,  6317,  6322,  6326,  6334,  6335,  6336,  6337,
    6338,  6339,  6343,  6344,  6345,  6346,  6347,  6350,  6353,  6352,
    6381,  6382,  6385,  6386,  6389,  6404,  6404,  6414,  6415,  6419,
    6431,  6464,  6463,  6476,  6475,  6484,  6496,  6507,  6506,  6523,
    6530,  6530,  6542,  6549,  6561,  6573,  6577,  6583,  6593,  6594,
    6597,  6605,  6606,  6610,  6611,  6619,  6628,  6618,  6638,  6645,
    6637,  6655,  6667,  6668,  6669,  6673,  6674,  6677,  6678,  6681,
    6690,  6691,  6692,  6694,  6693,  6703,  6704,  6707,  6708,  6709,
    6709,  6710,  6710,  6714,  6715,  6718,  6720,  6723,  6731,  6732,
    6736,  6737,  6742,  6741,  6754,  6755,  6758,  6763,  6771,  6772,
    6775,  6777,  6777,  6785,  6794,  6784,  6816,  6817,  6820,  6827,
    6828,  6831,  6840,  6841,  6847,  6846,  6860,  6859,  6868,  6867,
    6875,  6874,  6884,  6885,  6888,  6895,  6908,  6909,  6913,  6914,
    6917,  6918,  6919,  6922,  6932,  6934,  6936,  6938,  6941,  6942,
    6945,  6949,  6953,  6957,  6961,  6965,  6969,  6973,  6977,  6985,
    6988,  6997,  6996,  7010,  7018,  7027,  7036,  7045,  7055,  7054,
    7057,  7067,  7077,  7081,  7086,  7085,  7090,  7100,  7105,  7111,
    7116,  7121,  7123,  7125,  7127,  7129,  7131,  7139,  7148,  7150,
    7152,  7154,  7163,  7171,  7179,  7181,  7183,  7193,  7200,  7206,
    7214,  7222,  7226,  7230,  7237,  7244,  7254,  7264,  7274,  7285,
    7294,  7308,  7321,  7322,  7324,  7326,  7329,  7330,  7333,  7334,
    7337,  7338,  7341,  7342,  7345,  7346,  7348,  7350,  7353,  7365,
    7364,  7379,  7378,  7388,  7389,  7392,  7393,  7397,  7398,  7399,
    7407,  7406,  7418,  7419,  7422,  7422,  7423,  7424,  7425,  7426,
    7427,  7428,  7429,  7430,  7431,  7432,  7435,  7436,  7440,  7439,
    7448,  7449,  7452,  7453,  7454,  7458,  7457,  7467,  7471,  7475,
    7487,  7487,  7495,  7496,  7497,  7502,  7512,  7511,  7527,  7545,
    7556,  7563,  7573,  7544,  7578,  7587,  7588,  7591,  7592,  7604,
    7608,  7609,  7610,  7612,  7614,  7617,  7618,  7621,  7626,  7633,
    7638,  7644,  7646,  7649,  7650,  7653,  7658,  7664,  7666,  7673,
    7674,  7675,  7678,  7680,  7685,  7686,  7691,  7692,  7698,  7703,
    7705,  7707,  7712,  7714,  7725,  7738,  7759,  7760,  7761,  7770,
    7771,  7772,  7777,  7778,  7779,  7780,  7781,  7795,  7809,  7810,
    7811,  7814,  7815,  7816,  7817,  7825,  7840,  7841,  7844,  7850,
    7861,  7864,  7900,  7904,  7912,  7916,  7984,  7999,  8023,  8024,
    8040,  8050,  8053,  8054,  8055,  8059,  8063,  8064,  8089,  8101,
    8114,  8126,  8127,  8136,  8137,  8146,  8147,  8148,  8151,  8164,
    8177,  8191,  8192,  8193,  8194,  8195,  8196,  8197,  8198,  8199,
    8200,  8201,  8202,  8203,  8204,  8205,  8206,  8207,  8208,  8209,
    8210,  8211,  8212,  8213,  8214,  8215,  8216,  8217,  8218,  8219,
    8220,  8221,  8222,  8223,  8224,  8225,  8226,  8227,  8237,  8238,
    8239,  8240,  8241,  8242,  8243,  8244,  8245,  8246,  8247,  8248,
    8249,  8250,  8251,  8252,  8253,  8254,  8255,  8256,  8257,  8258,
    8259,  8260,  8261,  8262,  8263,  8264,  8265,  8266,  8267,  8268,
    8269,  8270,  8271,  8272,  8273,  8274,  8275,  8276,  8277,  8278,
    8279,  8280,  8281,  8282,  8283,  8284,  8285,  8286,  8287,  8288,
    8289,  8290,  8291,  8292,  8293,  8294,  8295,  8296,  8297,  8298,
    8299,  8300,  8301,  8302,  8303,  8304,  8305,  8306,  8307,  8308,
    8309,  8310,  8311,  8312,  8313,  8314,  8315,  8316,  8317,  8318,
    8319,  8320,  8321,  8322,  8323,  8324,  8325,  8326,  8327,  8328,
    8329,  8330,  8331,  8332,  8333,  8334,  8335,  8336,  8337,  8338,
    8339,  8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,
    8349,  8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,
    8359,  8360,  8361,  8362,  8363,  8364,  8365,  8366,  8367,  8368,
    8369,  8370,  8371,  8372,  8373,  8374,  8375,  8376,  8377,  8378,
    8379,  8380,  8381,  8382,  8383,  8384,  8385,  8386,  8387,  8388,
    8389,  8390,  8391,  8392,  8393,  8394,  8395,  8396,  8397,  8398,
    8399,  8400,  8401,  8402,  8403,  8404,  8405,  8406,  8407,  8408,
    8409,  8410,  8411,  8412,  8413,  8414,  8415,  8416,  8417,  8418,
    8419,  8420,  8421,  8422,  8423,  8424,  8425,  8426,  8427,  8428,
    8429,  8430,  8431,  8432,  8433,  8434,  8435,  8436,  8437,  8438,
    8439,  8440,  8441,  8442,  8443,  8444,  8445,  8446,  8447,  8448,
    8449,  8450,  8451,  8452,  8453,  8454,  8455,  8456,  8457,  8458,
    8459,  8460,  8461,  8462,  8463,  8464,  8465,  8466,  8473,  8472,
    8486,  8487,  8490,  8491,  8494,  8494,  8571,  8572,  8573,  8574,
    8578,  8579,  8583,  8584,  8585,  8586,  8590,  8591,  8592,  8593,
    8597,  8598,  8601,  8681,  8694,  8698,  8703,  8710,  8725,  8738,
    8759,  8766,  8804,  8847,  8861,  8862,  8863,  8864,  8868,  8869,
    8876,  8885,  8886,  8887,  8888,  8889,  8897,  8896,  8912,  8913,
    8916,  8917,  8920,  8928,  8929,  8930,  8931,  8936,  8935,  8956,
    8968,  8981,  8980,  8999,  9000,  9004,  9005,  9009,  9010,  9011,
    9012,  9014,  9013,  9024,  9025,  9026,  9027,  9028,  9034,  9039,
    9046,  9059,  9071,  9078,  9083,  9091,  9104,  9118,  9120,  9123,
    9124,  9131,  9133,  9137,  9138,  9141,  9141,  9142,  9142,  9143,
    9143,  9144,  9144,  9145,  9146,  9147,  9148,  9149,  9150,  9151,
    9152,  9153,  9154,  9155,  9156,  9157,  9158,  9159,  9160,  9161,
    9162,  9163,  9164,  9165,  9166,  9167,  9172,  9173,  9177,  9178,
    9182,  9192,  9202,  9215,  9230,  9243,  9256,  9269,  9270,  9279,
    9280,  9289,  9314,  9316,  9323,  9327,  9330,  9331,  9334,  9355,
    9356,  9360,  9364,  9368,  9375,  9376,  9379,  9380,  9384,  9385,
    9391,  9397,  9403,  9413,  9412,  9422,  9423,  9427,  9428,  9429,
    9433,  9434,  9435,  9439,  9440,  9444,  9454,  9461,  9471,  9480,
    9494,  9495,  9500,  9499,  9534,  9535,  9536,  9540,  9540,  9564,
    9565,  9569,  9570,  9571,  9575,  9580,  9579,  9599,  9605,  9626,
    9648,  9650,  9655,  9657,  9659,  9671,  9681,  9694,  9696,  9698,
    9703,  9708,  9710,  9712,  9718,  9719,  9725,  9726,  9728,  9734,
    9733,  9748,  9749,  9753,  9758,  9766,  9766,  9784,  9793,  9806,
    9807,  9809,  9811,  9824,  9822,  9899,  9898,  9908,  9937,  9946,
    9955,  9907,  9979,  9983,  9987,  9991,  9995,  9999, 10005, 10012,
   10019, 10028, 10029, 10033, 10034, 10035, 10039, 10040, 10044, 10045,
   10045, 10050, 10051
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENNA_DELIMITED_SYM", "SENNA_NGRAM_SYM",
  "SENNA_NORMALIZE_SYM", "SENNA_SECTIONALIZE_SYM", "SENNA_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "opt_senna_list", "opt_senna_item", "key_list",
  "key_part", "opt_ident", "opt_component", "string_list", "alter", "@46",
  "@47", "@48", "@49", "@50", "ident_or_empty", "alter_list", "add_column",
  "alter_list_item", "@51", "@52", "@53", "opt_column", "opt_ignore",
  "opt_restrict", "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   124,    38,
      45,    43,    42,    47,    37,    94,   126,   823,    40,    41,
      44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   588,   589,   589,   590,   590,   591,   591,   591,   591,
     591,   591,   591,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   592,   593,   593,   594,   595,   595,   597,
     596,   598,   598,   599,   599,   600,   602,   601,   604,   603,
     605,   605,   606,   606,   606,   606,   606,   606,   606,   606,
     606,   606,   606,   606,   607,   607,   607,   607,   609,   608,
     610,   608,   611,   608,   612,   608,   608,   613,   614,   614,
     615,   616,   617,   618,   619,   620,   615,   621,   621,   622,
     622,   623,   623,   623,   623,   623,   623,   623,   624,   624,
     624,   625,   625,   627,   626,   628,   628,   629,   629,   630,
     630,   631,   631,   632,   632,   633,   634,   635,   635,   636,
     636,   637,   638,   638,   638,   638,   639,   639,   640,   640,
     641,   641,   643,   642,   642,   644,   642,   642,   646,   645,
     647,   647,   648,   648,   649,   650,   650,   651,   651,   652,
     652,   652,   652,   652,   653,   653,   654,   654,   656,   655,
     657,   655,   658,   655,   655,   655,   659,   655,   655,   655,
     655,   660,   655,   655,   661,   661,   661,   662,   662,   664,
     665,   666,   663,   667,   667,   667,   668,   668,   670,   671,
     669,   673,   672,   674,   674,   675,   675,   677,   678,   676,
     680,   681,   679,   682,   682,   684,   683,   685,   685,   687,
     686,   686,   688,   689,   686,   690,   686,   691,   691,   692,
     692,   692,   693,   693,   693,   693,   694,   695,   694,   696,
     697,   696,   698,   696,   700,   701,   699,   702,   702,   703,
     703,   704,   704,   705,   705,   706,   706,   707,   707,   708,
     709,   709,   710,   710,   711,   711,   712,   712,   712,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   714,   715,   716,   717,   717,   717,   717,   717,
     717,   718,   718,   718,   719,   719,   719,   720,   720,   721,
     721,   722,   722,   722,   722,   723,   723,   724,   724,   725,
     725,   726,   726,   726,   726,   726,   727,   727,   728,   729,
     729,   730,   732,   731,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   734,
     733,   735,   733,   733,   733,   736,   736,   736,   736,   736,
     736,   736,   736,   737,   738,   738,   739,   739,   740,   740,
     740,   740,   740,   741,   741,   741,   741,   741,   742,   742,
     742,   743,   743,   743,   744,   745,   745,   746,   746,   747,
     747,   747,   748,   748,   749,   749,   750,   750,   751,   751,
     752,   752,   752,   752,   752,   752,   752,   752,   752,   752,
     752,   753,   753,   754,   754,   755,   755,   756,   756,   757,
     757,   758,   758,   759,   759,   760,   761,   761,   762,   762,
     763,   763,   764,   764,   764,   764,   764,   764,   765,   765,
     766,   766,   766,   766,   767,   767,   769,   768,   770,   770,
     771,   771,   772,   772,   773,   773,   774,   774,   774,   774,
     774,   775,   775,   775,   775,   775,   776,   776,   776,   777,
     777,   778,   778,   779,   779,   780,   780,   780,   781,   781,
     781,   781,   782,   782,   782,   783,   783,   783,   783,   784,
     784,   785,   785,   785,   785,   785,   785,   785,   785,   786,
     786,   787,   787,   788,   788,   789,   789,   790,   790,   792,
     791,   793,   791,   794,   791,   795,   791,   796,   791,   797,
     797,   798,   798,   798,   798,   798,   799,   800,   800,   800,
     801,   800,   802,   803,   800,   800,   800,   800,   800,   800,
     800,   800,   800,   800,   800,   800,   800,   800,   804,   804,
     805,   805,   806,   806,   806,   807,   807,   807,   808,   808,
     808,   808,   810,   809,   809,   811,   809,   809,   812,   813,
     813,   815,   814,   816,   816,   817,   817,   817,   818,   818,
     819,   819,   821,   820,   823,   822,   825,   824,   826,   826,
     826,   828,   827,   829,   829,   830,   830,   831,   831,   831,
     833,   832,   835,   834,   836,   836,   837,   837,   838,   838,
     838,   838,   838,   838,   840,   839,   841,   841,   841,   843,
     842,   842,   844,   844,   845,   845,   846,   847,   848,   848,
     849,   850,   850,   852,   851,   853,   853,   854,   856,   855,
     857,   857,   858,   858,   859,   860,   860,   861,   861,   863,
     862,   865,   866,   864,   867,   867,   867,   867,   867,   868,
     868,   869,   869,   870,   870,   871,   871,   871,   871,   871,
     871,   871,   871,   871,   871,   872,   872,   872,   873,   873,
     873,   874,   875,   876,   877,   877,   878,   878,   878,   878,
     878,   879,   879,   881,   880,   882,   882,   883,   884,   883,
     885,   885,   886,   886,   887,   887,   887,   887,   887,   887,
     887,   888,   888,   888,   888,   888,   888,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   890,   890,   891,   891,   892,   892,   892,   893,   893,
     893,   893,   893,   894,   894,   894,   894,   894,   894,   895,
     895,   896,   896,   897,   897,   898,   898,   899,   899,   900,
     900,   900,   900,   900,   900,   901,   901,   902,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   904,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   906,
     906,   906,   907,   907,   909,   908,   910,   910,   911,   912,
     912,   912,   912,   912,   912,   912,   913,   914,   912,   912,
     912,   912,   912,   912,   912,   912,   912,   912,   912,   912,
     915,   912,   917,   916,   918,   918,   918,   919,   919,   920,
     920,   921,   921,   923,   922,   924,   924,   924,   924,   924,
     924,   924,   924,   924,   924,   924,   925,   925,   927,   926,
     928,   928,   929,   929,   931,   930,   932,   932,   933,   933,
     934,   934,   935,   935,   936,   936,   937,   938,   938,   939,
     939,   940,   939,   941,   939,   942,   939,   939,   943,   939,
     944,   939,   939,   945,   939,   946,   939,   939,   947,   947,
     947,   949,   948,   950,   948,   948,   948,   952,   951,   954,
     955,   953,   956,   957,   958,   958,   959,   959,   960,   960,
     960,   960,   962,   961,   963,   963,   964,   964,   964,   965,
     965,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   968,   968,   968,   968,   969,   969,   969,
     970,   970,   971,   971,   972,   973,   972,   974,   975,   974,
     976,   976,   977,   977,   978,   978,   979,   979,   979,   980,
     981,   981,   982,   983,   983,   985,   984,   986,   986,   987,
     987,   987,   988,   988,   989,   989,   990,   991,   991,   991,
     992,   992,   992,   992,   993,   993,   994,   994,   994,   994,
     994,   994,   995,   995,   995,   995,   995,   996,   997,   996,
     998,   998,   999,   999,  1000,  1002,  1001,  1003,  1003,  1004,
    1004,  1006,  1005,  1008,  1007,  1007,  1007,  1010,  1009,  1011,
    1012,  1011,  1011,  1011,  1011,  1011,  1011,  1011,  1013,  1013,
    1014,  1015,  1015,  1016,  1016,  1018,  1019,  1017,  1021,  1022,
    1020,  1023,  1023,  1023,  1023,  1024,  1024,  1025,  1025,  1026,
    1027,  1027,  1027,  1028,  1027,  1029,  1029,  1030,  1030,  1031,
    1030,  1032,  1030,  1033,  1033,  1034,  1034,  1035,  1036,  1036,
    1037,  1037,  1039,  1038,  1040,  1040,  1041,  1041,  1042,  1042,
    1043,  1044,  1043,  1046,  1047,  1045,  1048,  1048,  1049,  1050,
    1050,  1051,  1052,  1052,  1054,  1053,  1056,  1055,  1057,  1055,
    1058,  1055,  1059,  1059,  1060,  1060,  1061,  1061,  1062,  1062,
    1063,  1063,  1063,  1064,  1065,  1065,  1066,  1066,  1067,  1067,
    1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1069,
    1069,  1071,  1070,  1072,  1072,  1072,  1072,  1072,  1073,  1072,
    1072,  1072,  1072,  1072,  1074,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1075,  1075,  1076,  1076,  1077,  1077,  1078,  1078,  1079,  1079,
    1080,  1080,  1081,  1081,  1082,  1082,  1083,  1083,  1083,  1085,
    1084,  1086,  1084,  1087,  1087,  1088,  1088,  1089,  1089,  1089,
    1091,  1090,  1092,  1092,  1094,  1093,  1093,  1093,  1093,  1093,
    1093,  1093,  1093,  1093,  1093,  1093,  1095,  1095,  1097,  1096,
    1098,  1098,  1099,  1099,  1099,  1101,  1100,  1102,  1103,  1103,
    1105,  1104,  1106,  1106,  1106,  1107,  1109,  1108,  1108,  1111,
    1112,  1113,  1114,  1110,  1110,  1115,  1115,  1116,  1116,  1116,
    1117,  1117,  1117,  1118,  1118,  1119,  1119,  1120,  1120,  1120,
    1120,  1121,  1121,  1122,  1122,  1123,  1123,  1124,  1124,  1125,
    1125,  1125,  1126,  1126,  1127,  1127,  1128,  1128,  1129,  1129,
    1129,  1129,  1130,  1130,  1130,  1131,  1132,  1132,  1132,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,
    1133,  1134,  1134,  1134,  1134,  1134,  1135,  1135,  1136,  1136,
    1137,  1138,  1138,  1139,  1139,  1140,  1140,  1140,  1141,  1141,
    1141,  1141,  1142,  1142,  1142,  1143,  1144,  1144,  1145,  1146,
    1147,  1148,  1148,  1149,  1149,  1150,  1150,  1150,  1151,  1151,
    1151,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,
    1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,
    1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,
    1152,  1152,  1152,  1152,  1152,  1152,  1152,  1152,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1155,  1154,
    1156,  1156,  1157,  1157,  1159,  1158,  1160,  1160,  1160,  1160,
    1161,  1161,  1162,  1162,  1162,  1162,  1163,  1163,  1163,  1163,
    1164,  1164,  1165,  1165,  1166,  1166,  1166,  1166,  1166,  1166,
    1166,  1167,  1167,  1167,  1168,  1168,  1168,  1168,  1169,  1169,
    1169,  1170,  1170,  1170,  1170,  1170,  1172,  1171,  1173,  1173,
    1174,  1174,  1175,  1176,  1176,  1176,  1176,  1178,  1177,  1179,
    1179,  1180,  1179,  1181,  1181,  1182,  1182,  1183,  1183,  1183,
    1183,  1184,  1183,  1185,  1185,  1185,  1185,  1185,  1186,  1187,
    1187,  1187,  1187,  1188,  1189,  1189,  1189,  1190,  1190,  1191,
    1191,  1192,  1192,  1193,  1193,  1195,  1194,  1196,  1194,  1197,
    1194,  1198,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1194,  1194,  1194,  1194,  1194,  1199,  1199,  1200,  1200,
    1201,  1201,  1201,  1202,  1202,  1202,  1202,  1203,  1203,  1204,
    1204,  1205,  1205,  1205,  1206,  1206,  1207,  1207,  1208,  1209,
    1209,  1209,  1209,  1209,  1210,  1210,  1211,  1211,  1212,  1212,
    1212,  1212,  1212,  1214,  1213,  1215,  1215,  1216,  1216,  1216,
    1217,  1217,  1217,  1218,  1218,  1219,  1220,  1220,  1221,  1222,
    1223,  1223,  1225,  1224,  1226,  1226,  1226,  1228,  1227,  1229,
    1229,  1230,  1230,  1230,  1231,  1232,  1231,  1233,  1234,  1235,
    1236,  1236,  1237,  1237,  1237,  1238,  1238,  1239,  1239,  1239,
    1240,  1241,  1241,  1241,  1242,  1242,  1243,  1243,  1243,  1245,
    1244,  1246,  1246,  1247,  1247,  1249,  1248,  1250,  1250,  1251,
    1251,  1251,  1251,  1253,  1252,  1255,  1254,  1256,  1257,  1258,
    1259,  1254,  1260,  1260,  1260,  1260,  1260,  1260,  1261,  1261,
    1261,  1262,  1262,  1263,  1263,  1263,  1264,  1264,  1265,  1266,
    1265,  1267,  1267
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     1,     1,
       3,     1,     2,     1,     2,     1,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     0,     2,     1,     3,     0,
       6,     0,     5,     0,     5,     0,     5,     0,    11,     0,
       1,     0,     2,     2,     1,     3,     2,     3,     2,     4,
       0,     6,     0,     0,     8,     4,     4,     3,     3,     2,
       2,     6,     5,     3,     5,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     1,     0,     1,
       1,     1,     0,     5,     3,     0,     5,     3,     3,     0,
       3,     0,     2,     1,     3,     0,     1,     1,     0,     2,
       1,     3,     0,     6,     0,     6,     0,     5,     0,     1,
       1,     0,     6,     0,     1,     1,     2,     1,     1,     1,
       0,     6,     0,     5,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     0,     6,     0,     1,     1,     0,
       4,     4,     3,     5,     1,     3,     3,     5,     1,     3,
       2,     1,     1,     0,     6,     1,     3,     3,     0,     2,
       0,     4,     0,     2,     1,     2,     4,     2,     3,     0,
       3,     0,     0,     6,     2,     1,     1,     2,     2,     8,
       4,     0,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     4,     3,     1,
       1,     4,     0,     0,     1,     1,     0,     2,     2,     1,
       1,     0,     2,     0,     3,     0,     3,     3,     0,     3,
       0,     3,     2,     1,     3,     4,     3,     4,     3,     4,
       1,     3,     4,     3,     3,     6,     1,     5,     6,     5,
       7,     6,     8,     5,     6,     4,     4,     5,     3,     4,
       1,     3,     1,     3,     1,     3,     3,     1,     3,     3,
       4,     4,     1,     3,     3,     3,     3,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     3,
       1,     1,     1,     1,     3,     2,     2,     2,     2,     3,
       3,     5,     6,     4,     4,     7,     4,     2,     6,     5,
       6,     6,     4,     4,     3,     4,     6,     8,     6,     8,
       6,     4,     6,     4,     6,     4,     4,     4,     4,     6,
       8,     2,     2,     4,     2,     7,     7,     3,     4,     4,
       6,     6,     4,     6,     6,     6,     4,     6,     4,     6,
       8,    10,    12,     6,     4,     6,     6,     1,     6,     4,
       8,    10,     4,     1,     3,     4,     6,     6,     8,     6,
       6,     4,     6,     6,     8,     4,     4,     6,     4,     2,
       4,     4,     4,     6,     4,     4,     3,     8,     6,     4,
       6,     3,     6,     8,     4,     8,     6,     8,     6,     8,
       2,     4,     4,     4,     6,     8,     8,     4,     7,     7,
       7,     6,     6,     6,     6,     6,     6,     0,     5,    10,
       3,     4,     3,     2,     2,     2,     4,     6,     4,     4,
       6,     6,     6,     6,     4,     6,     4,     6,     4,     4,
       4,     4,     6,     4,     6,     4,     6,     4,     4,     6,
       4,     6,     4,     6,     4,     4,     6,     4,     6,     0,
       3,     3,     0,     1,     0,     2,     1,     3,     4,     4,
       5,     4,     4,     4,     5,     4,     0,     0,     7,    10,
       4,     5,     4,     5,     4,     4,     4,     4,     4,     5,
       0,     8,     0,     3,     3,     1,     4,     0,     1,     0,
       2,     0,     1,     0,     3,     2,     3,     2,     1,     2,
       1,     2,     1,     1,     1,     2,     0,     1,     0,     2,
       1,     3,     1,     3,     0,     2,     1,     3,     0,     1,
       0,     2,     4,     5,     1,     1,     1,     1,     3,     3,
       3,     0,     6,     0,     6,     0,     8,     4,     0,     8,
       0,    10,     6,     0,     8,     0,    10,     6,     1,     2,
       2,     0,     4,     0,    11,     3,     6,     0,     3,     0,
       0,     5,     0,     1,     0,     1,     0,     2,     0,     2,
       2,     2,     0,     6,     0,     1,     3,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       0,     2,     0,     1,     0,     0,     3,     0,     0,     3,
       2,     0,     0,     4,     4,     2,     0,     2,     2,     3,
       3,     1,     2,     0,     1,     0,     4,     4,     2,     0,
       1,     1,     0,     1,     0,     1,     2,     1,     3,     3,
       1,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     0,     6,
       0,     1,     3,     1,     2,     0,     2,     3,     1,     2,
       1,     0,     3,     0,     5,     2,     1,     0,     3,     6,
       0,     6,     4,     4,     4,     4,     5,     4,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     8,     0,     0,
       6,     0,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     3,     4,     0,     3,     3,     1,     2,     2,     0,
       3,     0,     5,     3,     1,     3,     1,     3,     1,     1,
       0,     1,     0,     4,     0,     1,     3,     1,     1,     1,
       0,     0,     6,     0,     0,    11,     3,     1,     3,     3,
       1,     3,     0,     1,     0,     4,     0,     6,     0,     5,
       0,     6,     1,     3,     3,     5,     0,     2,     0,     2,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     4,     4,     0,     4,
       6,    16,     2,     2,     0,     6,     5,     2,     2,     2,
       1,     5,     5,     2,     2,     1,     4,     3,     2,     2,
       2,     3,     2,     2,     2,     1,     1,     3,     4,     3,
       3,     2,     2,     3,     3,     3,     3,     3,     3,     4,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     0,     1,     0,     1,     1,
       0,     4,     3,     1,     0,     3,     4,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     3,
       3,     1,     1,     1,     2,     0,     3,     3,     2,     2,
       0,     4,     0,     1,     1,     2,     0,     4,     5,     0,
       0,     0,     0,    18,     2,     0,     1,     0,     1,     1,
       0,     1,     1,     0,     2,     2,     1,     3,     4,     3,
       3,     0,     2,     2,     1,     3,     3,     0,     3,     0,
       3,     2,     3,     1,     1,     2,     0,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     3,     5,
       1,     1,     1,     1,     1,     3,     4,     5,     1,     5,
       3,     2,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     3,     8,     8,     8,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     0,     1,     3,     1,
       2,     2,     2,     1,     3,     3,     1,     1,     3,     1,
       3,     4,     5,     1,     0,     3,     3,     1,     1,     0,
       2,     2,     2,     2,     0,     2,     2,     1,     2,     2,
       2,     2,     2,     0,     3,     0,     1,     0,     3,     2,
       0,     1,     2,     0,     1,     4,     4,     5,     2,     3,
       0,     1,     0,     4,     0,     1,     1,     0,     2,     2,
       1,     0,     1,     1,     4,     0,     7,     1,     0,     0,
       2,     3,     1,     1,     1,     0,     3,     1,     2,     1,
       2,     3,     3,     3,     0,     1,     0,     3,     3,     0,
       8,     0,     3,     1,     3,     0,     2,     3,     5,     0,
       3,     4,     4,     0,    14,     0,     6,     0,     0,     0,
       0,    12,     4,     4,     3,     4,     3,     2,     1,     3,
       5,     1,     1,     0,     1,     1,     0,     2,     0,     0,
       3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       0,     2,  2024,   646,     0,  1973,     0,     0,     0,     0,
       0,  1975,    94,    54,  1284,  1393,  1394,  1207,  1223,     0,
     646,    97,     0,    66,  1225,  1430,     0,     0,   646,     0,
    1425,     0,     0,   646,  1228,  1418,     0,    97,  1975,     0,
     681,  1810,  1321,     0,     0,     0,  1304,  1867,  1273,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   674,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1395,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   549,     0,   581,
       0,     0,  2025,  2015,   648,   647,     0,  1859,  1858,   614,
    1975,     0,  1578,  1579,  1580,  1581,  1582,  1583,  1584,  1542,
    1585,  1586,  1587,  1543,  1544,  1588,  1589,  1590,  1591,  1593,
    1592,  1594,  1545,  1546,  1595,  1596,  1597,  1547,  1548,  1598,
    1599,  1549,  1600,  1601,  1602,  1550,  1603,  1551,  1604,  1605,
    1606,  1607,  1608,  1552,  1609,  1610,  1611,  1612,  1613,  1614,
    1615,  1553,  1616,  1617,  1618,  1619,  1635,  1620,  1554,  1621,
    1622,  1623,  1636,  1555,  1626,  1625,  1624,  1627,  1628,  1629,
    1556,  1630,  1631,  1632,  1633,  1638,  1639,  1640,  1557,  1634,
    1641,  1637,  1793,  1643,  1642,  1644,  1646,  1645,  1558,  1647,
    1559,  1648,  1649,  1526,  1650,  1527,  1652,  1653,  1656,  1657,
    1651,  1658,  1659,  1654,  1655,  1560,  1661,  1662,  1663,  1664,
    1665,  1666,  1667,  1677,  1670,  1672,  1673,  1675,  1671,  1676,
    1680,  1679,  1681,  1682,  1683,  1678,  1669,  1674,  1684,  1685,
    1668,  1686,  1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,
    1696,  1695,  1697,  1698,  1699,  1700,  1701,  1703,  1702,  1704,
    1705,  1706,  1708,  1707,  1709,  1561,  1710,  1711,  1712,  1713,
    1714,  1562,  1715,  1716,  1717,  1718,  1719,  1720,  1721,  1563,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1660,  1740,
    1564,  1741,  1742,  1565,  1743,  1566,  1744,  1745,  1567,  1746,
    1747,  1748,  1749,  1750,  1751,  1568,  1752,  1569,  1753,  1754,
    1755,  1756,  1758,  1757,  1759,  1761,  1762,  1570,  1760,  1571,
    1763,  1764,  1765,  1767,  1766,  1768,  1769,  1572,  1770,  1573,
    1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,
    1781,  1782,  1783,  1786,  1787,  1788,  1789,  1784,  1785,  1574,
    1790,  1791,  1792,  1794,  1795,  1575,  1796,  1797,  1577,  1798,
    1799,  1802,  1800,  1801,  1803,  1804,  1805,  1806,  1576,  1807,
     123,  1531,    99,  1532,  1541,     0,   616,   632,  1976,  1977,
     270,   510,   511,   269,   509,    97,  2015,     0,   266,   267,
       0,  1298,  1028,  1221,  1221,     0,  1221,  1224,  1221,    97,
    1221,     0,    59,  1400,     0,     0,     0,     0,  1525,     0,
    1231,  1432,  1436,     0,     0,  1856,     0,     0,     0,     0,
      97,   649,     0,  1282,     0,   612,     0,  1977,  1988,   675,
     679,   691,  1811,  1808,  1378,   601,   601,   601,   599,   601,
    1305,     0,     0,  1282,  1435,  2061,     0,     0,     0,  2057,
       0,  2062,     0,   681,     0,     0,     1,     3,     0,  1631,
    1391,  1389,  1522,     0,   541,   550,   545,   543,     0,     0,
    2026,   630,     0,  1974,     0,   658,   668,   125,     0,    68,
       0,     0,     0,  1980,     0,     0,     0,     0,    95,   319,
    2015,  2017,  2019,   270,   268,     0,  1302,  1301,  1300,     0,
    1298,  1208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1221,    61,     0,  1901,  1916,  1917,  1913,  1918,  1919,
    1923,     0,  1915,  1907,     0,  1922,  1911,  1920,     0,  1905,
       0,  1921,  1926,  1909,  1914,  1893,     0,  1899,  1903,  1524,
    1127,  1870,  1871,     0,  1537,  1528,  1536,  1535,    67,  1233,
    1234,  1232,   580,  1433,  1434,     0,  1447,     0,     0,     0,
     644,     0,  1373,  1372,     0,  1426,  1989,     0,     0,   621,
    1236,  1283,     0,  1235,  1423,     0,  1422,  1419,  1421,     0,
    1901,  1888,     0,  1983,  1980,  1990,   704,   697,   696,   699,
     700,   703,   701,   702,   698,   695,   712,   692,   694,  1814,
       0,     0,   444,     0,  1386,     0,     0,     0,  1386,     0,
    1162,  1379,     0,  1823,  1356,   507,   506,     0,   505,  1824,
    1355,  1372,     0,     0,     0,  1340,     0,  1306,  1345,     0,
    1825,     0,  1375,     0,  1162,  1386,     0,  1322,     0,     0,
       0,     0,   595,   605,   597,   592,     0,   598,   594,  1303,
    1220,  1868,   580,  1484,  1483,  1529,  2058,  1482,  2066,  2068,
    2054,  2056,  2063,   677,     0,  1994,    53,     0,  1397,  2022,
    2023,  2021,   460,   107,   107,   539,     0,     0,     0,     0,
       0,  1218,     0,     0,   660,   670,   127,   124,    98,     0,
     618,   634,  1979,     0,     0,  1981,  1985,   786,   785,     0,
      92,   721,  1538,  1953,    96,  1949,  2020,   320,   712,   712,
     712,  2010,     0,  2012,  2013,  2014,  2026,  2018,     0,   512,
       0,  1285,  1288,  1292,  1296,  1299,  1579,  1542,     0,  1587,
       0,     0,  1495,     0,     0,     0,     0,  1547,     0,     0,
    1601,     0,     0,  1552,     0,     0,     0,   721,   721,   721,
       0,     0,     0,  1614,  1615,  1504,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1492,     0,  1505,     0,
       0,     0,     0,     0,     0,     0,  1643,     0,     0,  1644,
       0,     0,     0,  1494,  1649,     0,     0,     0,     0,     0,
       0,     0,  1664,     0,     0,  1502,     0,     0,  1034,     0,
    1691,  1693,     0,     0,     0,  1697,     0,     0,  1698,  1699,
    1700,  1479,   788,     0,   721,  1491,  1501,  1712,  1718,  1485,
       0,  1720,     0,  1721,     0,  1728,     0,     0,     0,     0,
       0,     0,  1750,  1752,     0,     0,  1773,     0,     0,     0,
     721,  1786,  1787,  1788,  1789,     0,  1493,  1574,  1503,     0,
       0,     0,  1798,   721,   721,   721,     0,     0,     0,  1804,
       0,  1807,  1038,     0,     0,     0,     0,   787,     0,  1002,
       0,  1030,   723,   728,   733,   740,   746,   760,   762,   764,
     767,   772,   778,     0,   873,   780,   867,   803,   802,  1029,
    1489,   801,   800,  1490,   798,  1512,  1531,  1478,  1511,  1222,
    1212,  1213,     0,  1214,  1217,  1947,  1215,   582,     0,     0,
      60,  1414,  1408,  1410,  1413,  1409,     0,  1415,  1412,  1411,
    1859,  1401,  1403,  1404,  1902,  1900,  1934,  1933,     0,  1935,
    1931,  1924,  1954,  1928,  1954,  1930,  1929,  1954,  1925,  1932,
    1954,  1897,     0,  1128,  1129,     0,  1869,     0,  1523,     0,
    1431,  1448,     0,  1449,  1437,  1445,   663,     0,  1127,  1857,
    1860,     0,     0,    56,    57,     0,   651,     0,   650,   654,
       0,     0,     0,  1239,  1229,  1238,  1424,     0,     0,  1900,
    1897,  1984,     0,  1986,  2001,   680,  1991,   710,   682,   709,
       0,   693,  1809,  1812,  1820,  1354,  1382,   443,     0,     0,
    1353,  1337,     0,   270,     0,     0,     0,     0,  1323,  1328,
     304,     0,  1344,  1163,     0,  1386,     0,  1348,  1361,  1349,
       0,  1376,     0,  1386,  1318,     0,     0,  1310,  1315,  1311,
       0,  1317,  1316,  1319,  1307,  1308,  1376,  1333,  1362,  1376,
    1338,  1343,  1352,  1380,  1381,     0,  1332,  1339,     0,  1350,
    1376,  1376,  1386,  1386,   608,   607,   606,   602,   603,   608,
       0,  1071,     0,     0,  2055,  2069,  2053,  2064,  2065,  2052,
     678,  1995,   676,  1996,     0,  1392,  1390,  1398,  1399,   461,
     542,   460,   261,   264,   263,     0,   546,   544,   460,  2016,
       0,     0,   634,     0,     0,   662,   657,   661,   659,   502,
     501,   504,     0,   669,     0,   128,   130,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    69,    70,    83,   620,   619,   617,   642,   641,
     639,     0,   640,   638,   633,   635,   636,  1978,  1982,   271,
     460,     0,  1540,     0,     0,     0,     0,     0,     0,     0,
    2011,    88,     0,     0,     0,  1290,  1286,  1296,     0,     0,
       0,  1127,     0,     0,     0,  1132,     0,   817,  1132,  1132,
    1132,     0,     0,  1028,  1028,     0,  1028,     0,     0,     0,
       0,  1132,   841,   844,     0,   842,     0,     0,     0,     0,
       0,  1498,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1028,     0,     0,     0,     0,  1007,     0,     0,     0,
       0,   797,     0,     0,     0,     0,  1028,     0,     0,     0,
       0,  1034,     0,  1032,     0,  1132,     0,     0,  1132,     0,
       0,     0,     0,     0,  1028,  1028,  1028,   732,     0,   889,
       0,     0,     0,     0,     0,  1028,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1132,  1132,     0,     0,
       0,  1132,     0,   910,     0,  1500,     0,     0,     0,  1499,
       0,     0,  1497,  1496,  1480,     0,     0,     0,   933,   935,
     934,  1132,     0,  1132,     0,     0,     0,  1039,     0,   806,
     805,   807,  2008,     0,     0,     0,     0,     0,     0,     0,
     725,   730,   789,     0,   790,   791,     0,   792,   793,   794,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   808,
    1102,  1103,  1104,  1105,  1114,  1117,  1106,  1107,  1108,  1116,
    1109,  1110,  1111,  1118,  1119,  1120,  1112,  1121,  1115,  1113,
    1122,     0,  1101,     0,     0,     0,  1481,   927,     0,  1210,
       0,   584,   583,  1216,   582,     0,    62,    64,  1407,     0,
       0,  1416,  1927,     0,  1908,  1912,  1906,  1910,     0,     0,
    1898,     0,  1904,  1131,  1639,  1707,     0,  1134,  1873,  1226,
    1444,  1446,     0,     0,  1438,     0,     0,   634,    58,     0,
       0,  1427,     0,     0,     0,     0,   623,  1237,     0,  1420,
       0,     0,     0,     0,     0,  1987,  2003,  2002,  1992,   712,
    1153,   713,   715,   714,  1511,  1814,  1817,  1818,  1821,  1819,
       0,  1816,  1815,  1830,     0,  1384,  1387,  1388,     0,     0,
    1364,  1363,  1359,  1360,     0,  1172,  1173,  1171,  1166,  1167,
    1170,  1368,  1366,  1357,     0,  1386,     0,  1367,  1365,  1312,
    1313,  1314,     0,  1162,     0,  1386,  1386,  1376,     0,  1386,
    1386,  1347,  1351,     0,   596,   605,   593,   600,  1083,  1082,
       0,  1047,     0,  1046,  1045,  1044,     0,  1082,  2059,  2067,
    2071,     0,  1162,  2000,  1998,   262,  1260,  1260,     0,     0,
       0,     0,     0,     0,     0,   108,   117,   578,   578,  1260,
    1260,   578,  1260,  1260,  1260,     0,     0,  1260,     0,     0,
     578,     0,  1260,   576,     0,     0,  1260,  1260,  1260,   578,
       0,  1260,  1260,  1260,  1260,  1260,   588,  1260,  1260,  1260,
     575,   274,   296,   297,   540,     0,   554,   577,  2027,  2028,
     547,   631,   615,  1219,     0,   126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   643,   637,    93,   722,  1539,     0,  1950,
    2047,     0,     0,  2029,   272,   515,  1180,  1181,   517,  1177,
    1178,     0,  1176,   516,   525,   526,   523,   527,   521,  1179,
     514,   518,   519,   528,   513,     0,     0,  1134,     0,  1293,
    1071,  1297,  1296,  1294,     0,     0,     0,  1133,  1132,     0,
    1013,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   986,     0,  1013,     0,   847,
       0,     0,     0,     0,     0,     0,  1511,     0,     0,     0,
       0,     0,  2008,     0,     0,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,  1125,  1123,  1126,
    1124,     0,     0,  1008,  1000,     0,     0,     0,     0,   874,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1035,  1036,  1132,     0,     0,     0,  1132,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   896,     0,     0,     0,
       0,     0,   901,     0,     0,     0,     0,     0,     0,     0,
    1132,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   930,     0,   932,     0,     0,  1514,  1513,
       0,     0,     0,     0,     0,  1040,   681,     0,   810,  1028,
     809,     0,  1826,  1003,  1005,     0,   727,   724,   729,   743,
     736,   741,   734,   738,     0,   795,  1584,   744,     0,     0,
    1141,   758,     0,     0,   761,     0,     0,     0,     0,   763,
     765,   766,   769,   873,   768,   873,   776,   777,   773,   774,
     775,   779,     0,   799,   804,  1031,   974,  1515,  1211,  1948,
    1209,    65,     0,     0,  1402,  1417,  1405,  1958,     0,  1957,
    1943,  1946,  1522,     0,     0,     0,  1883,  1877,  1884,  1886,
    1880,  1885,  1887,  1878,  1879,  1874,  1881,  1135,  1164,     0,
       0,   664,   665,   668,     0,  1863,  1864,  1862,  1861,   645,
    1429,  1428,     0,   652,   655,   656,   628,   627,   629,   622,
     624,   625,   254,  1243,     0,     0,     0,  1249,  1230,  1240,
     613,     0,     0,     0,     0,     0,   708,  1071,  1201,   705,
     686,  1164,  1154,   685,   716,     0,  1813,     0,  1784,  1841,
       0,     0,     0,     0,     0,  1831,  1383,     0,  1334,     0,
    1358,  1371,  1370,  1329,     0,     0,     0,  1327,  1377,     0,
    1346,  1309,  1369,  1326,  1134,  1376,  1324,  1325,   610,   609,
     604,  1082,  1071,     0,     0,  1068,  1084,     0,  1084,  1071,
    1071,     0,  1071,  1127,  1079,     0,     0,  2070,  1155,  1999,
    1258,  1259,  1261,     0,     0,   111,   114,   112,     0,   113,
       0,     0,   579,   533,   503,   503,   558,     0,   336,   533,
     496,   556,     0,     0,     0,     0,     0,     0,     0,     0,
    1260,     0,   569,   552,     0,     0,     0,     0,   570,     0,
     553,  1260,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   591,   590,   589,     0,     0,     0,     0,   275,
     460,   339,     0,   585,   336,   342,  1518,  2031,  1098,     0,
    1097,   129,    76,    72,    84,  1185,  1186,  1184,  1182,  1183,
      85,    74,    75,    79,    78,    80,    81,    82,    77,    73,
      86,    87,    71,     0,  1951,     0,   238,   237,     0,  2045,
    2031,     0,   339,    89,  1450,   273,   276,   524,   522,     0,
      90,  1071,  1153,  1296,  1134,     0,  1127,     0,   816,   831,
       0,     0,   979,     0,     0,   981,   982,   983,     0,   835,
       0,   833,   836,   837,   838,  1028,     0,     0,     0,     0,
    1028,   985,     0,   843,     0,     0,   848,   849,     0,   822,
       0,   856,     0,   858,     0,  1028,     0,   852,     0,   813,
       0,     0,  1028,     0,   864,     0,   825,     0,     0,   965,
       0,   948,   944,     0,   946,     0,     0,  1028,  1028,     0,
     869,     0,     0,   875,  1028,     0,   967,     0,   949,     0,
     881,     0,  1028,     0,  1033,     0,     0,     0,   992,   885,
     886,     0,   990,   951,     0,     0,   888,   953,     0,   955,
       0,   950,   957,   958,   890,   892,   891,   960,     0,     0,
     962,     0,   964,     0,   894,   895,     0,     0,     0,   899,
       0,  1028,   904,   994,   996,     0,     0,     0,     0,     0,
     998,   911,   913,     0,     0,     0,   912,     0,     0,     0,
       0,     0,     0,     0,   917,     0,     0,   931,   997,   823,
     995,   936,     0,   939,     0,   938,     0,     0,     0,     0,
    2007,  2009,     0,     0,   814,     0,     0,     0,     0,     0,
    1516,   782,   781,     0,   784,   783,     0,   737,   742,   735,
     739,     0,     0,     0,     0,   756,   755,     0,     0,  1141,
     759,     0,   771,   770,   872,     0,   973,   712,  1028,     0,
      63,  1406,  1955,     0,     0,     0,     0,     0,     0,     0,
       0,  1872,  1165,  1270,  1530,  1439,     0,   672,  1865,  1866,
       0,   626,   691,     0,  1262,  1247,  1254,  1248,     0,     0,
       0,  1246,  1507,  1506,  1513,  1990,     0,     0,     0,     0,
    1993,  1134,  1134,  1195,     0,     0,   683,   688,   684,   687,
       0,   711,   720,   719,  1508,  1515,     0,     0,     0,     0,
     446,   448,   447,   456,     0,   445,     0,     0,  1826,     0,
     452,   454,   453,  1836,   451,  1385,  1162,  1342,  1341,  1169,
    1168,     0,  1320,  1336,  1386,     0,  1997,  1077,     0,  1070,
    1069,  1085,     0,  1071,  1084,  1084,     0,  1050,  1049,  1274,
    1277,     0,  1048,  1088,  1075,   691,  2060,  2072,     0,   459,
     458,   303,   455,   302,   116,   115,   121,   122,   341,   534,
     497,   498,     0,     0,     0,   503,   335,   533,   334,   337,
     512,     0,   286,   283,   560,   289,   285,   301,     0,     0,
     290,   533,   567,   568,   582,   279,     0,   315,   316,   314,
     298,   281,   282,   562,  1149,  1151,  1159,   288,   287,   284,
     293,   294,   312,   311,   292,   313,   573,   310,   308,   305,
     307,   306,   309,   291,   280,     0,   555,     0,   325,   327,
     328,  1521,     0,   587,   557,     0,   329,   330,     0,     0,
       0,     0,   671,     0,  1952,  2048,   241,   239,   240,     0,
       0,     0,   244,     0,   242,     0,     0,  1452,  1451,   243,
     257,   460,   277,   520,     0,  1134,  1174,  1289,  1295,     0,
       0,     0,   980,  1014,     0,   422,   422,  1024,  1022,   411,
     422,  1018,  1023,  1020,     0,     0,     0,     0,     0,     0,
       0,   987,   984,     0,     0,     0,  1515,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1011,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   969,  1037,   993,   991,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   999,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1041,   819,  2004,  2005,   811,  1827,
    1828,  1829,   535,  1004,   726,   731,     0,   749,  1028,   747,
    1140,   753,     0,     0,   757,     0,   928,     0,   975,   976,
       0,  1027,  1517,  1956,  1945,  1944,  1959,  1959,  1959,     0,
    1136,     0,  1227,  1450,   666,     0,   667,   653,   712,  1244,
    1256,     0,  1264,     0,     0,  1241,  1251,     0,     0,     0,
    1250,     0,  1890,  1891,  1889,  1164,  1142,     0,     0,  1206,
       0,  1202,   706,     0,   718,   717,     0,  1843,     0,  1842,
    1854,  1855,  1852,  1853,  1851,  1832,     0,  1838,  1837,     0,
       0,     0,  1848,  1839,     0,     0,  1335,     0,  1330,   611,
       0,  1071,  1084,  1071,  1057,     0,     0,  1071,  1053,  1051,
    1055,     0,  1134,     0,     0,     0,     0,  1072,   712,  1510,
    1156,  1159,   338,   533,   499,   500,   512,     0,     0,     0,
       0,   456,   299,   566,   565,   300,     0,     0,  1160,  1161,
    1152,     0,   559,   339,   586,   476,   407,   356,   347,   422,
     350,   349,   393,   364,   361,   411,   409,   379,   411,   411,
     386,   385,   403,   389,   369,   462,   462,   368,   406,   462,
     390,   388,   392,     0,   394,   411,   399,   387,   391,   408,
     384,   381,   405,   422,   422,   362,   365,   404,   462,     0,
     397,   422,   426,   367,   462,   468,     0,     0,   422,   424,
    1520,  2033,     0,  2035,  1096,   142,   712,     0,   101,  2046,
    2035,     0,   247,   272,   258,     0,   278,     0,  1291,     0,
    1287,   797,   828,   832,   941,     0,  1015,   462,     0,  1025,
     413,  1017,  1019,  1021,   818,   834,   839,   943,   821,   820,
       0,     0,     0,     0,   854,   857,   859,   850,   855,   853,
       0,   942,   866,   863,   865,   826,     0,   966,   945,   947,
     868,   879,  1009,  1012,     0,     0,     0,   880,   876,   968,
     877,     0,   882,   851,   883,     0,     0,     0,     0,   952,
     887,   954,   956,   961,   959,   963,   893,   830,     0,   898,
     900,   812,   797,   902,     0,   908,   906,     0,     0,   914,
       0,     0,   923,     0,   921,     0,   922,     0,   924,   925,
       0,   937,   940,  1042,     0,  1990,     0,  1006,   745,     0,
     751,  1028,   748,   754,   713,   712,   926,     0,  1964,  1964,
    1964,  1269,  1268,     0,  1267,  1271,     0,   673,   255,     0,
       0,     0,  1265,  1253,  1994,  1242,  1245,  1515,  1892,   690,
       0,  1137,  1205,  1203,     0,  1196,  1198,  1200,     0,  1509,
       0,     0,  1847,  1833,   457,     0,     0,     0,     0,  1834,
       0,  1127,  1078,     0,     0,  1044,  1071,  1071,     0,  1044,
       0,     0,     0,  1276,  1153,  1278,  1086,  1090,  1091,  1089,
    1080,     0,  1158,     0,     0,     0,   572,     0,   585,   574,
     426,  1150,   295,   326,   482,     0,     0,   366,   415,   410,
       0,   415,   415,   468,   470,   464,   468,     0,   375,   393,
     370,     0,   462,   383,   374,   395,   398,   400,   402,   415,
       0,   462,   363,   372,     0,   415,   434,     0,     0,     0,
     430,     0,   475,     0,   437,   343,   427,   429,     0,     0,
     396,     0,   352,   469,     0,   354,     0,     0,   415,     0,
     425,   415,     0,  2032,     0,  2039,     0,   145,   143,   144,
       0,   138,   140,   135,     0,   323,   324,   322,   321,     0,
     131,  2039,   245,  1994,  1450,     0,   250,     0,  1159,   531,
    1175,     0,     0,  1016,     0,     0,   988,   845,   846,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     815,     0,     0,     0,     0,     0,     0,     0,   920,   918,
     919,     0,  1043,  2009,   536,   750,     0,   716,   977,     0,
       0,  1963,  1961,     0,  1962,  1960,  1936,     0,  1895,  1896,
    1894,  1882,     0,     0,  1440,  1164,  1255,  1257,  1263,  1252,
       0,  1138,  1153,  1453,  1199,     0,   707,  1845,  1844,  1846,
    1840,     0,     0,     0,     0,  1076,  1071,  1058,     0,  1062,
    1067,  1063,     0,  1054,  1052,     0,  1174,     0,  1092,  1164,
    1159,     0,     0,     0,     0,     0,     0,     0,     0,   571,
    1486,   561,   563,     0,     0,     0,   477,   478,   483,   485,
       0,     0,   419,   420,   421,   376,   416,   418,     0,   378,
     346,   463,   471,   472,     0,   467,   465,   468,   371,   401,
     377,     0,   373,     0,   360,   440,   439,   721,   432,   442,
       0,     0,   438,   428,   436,   431,     0,     0,     0,     0,
     344,     0,   345,  1519,  2034,     0,   548,   712,   712,  2036,
    2049,   142,     0,     0,     0,     0,   132,   134,   135,  2030,
     248,   246,     0,  1990,    91,     0,   530,     0,   829,   423,
     412,     0,   840,   860,     0,   827,  1010,  1001,  1132,   870,
       0,   878,   884,   971,   970,   897,   903,   907,   905,   909,
     915,   916,  1028,  2006,   752,   978,  1942,  1941,  1940,  1937,
       0,     0,     0,     0,     0,     0,  1965,  1967,  1266,     0,
       0,   256,   705,   317,  1146,  1159,     0,  1164,     0,  1461,
    1197,  1850,  1849,  1835,     0,     0,     0,     0,     0,     0,
       0,  1099,  1275,  1087,     0,  1081,  1157,     0,     0,   331,
    1488,  1487,   585,   488,   489,   490,     0,     0,     0,   481,
     484,   355,   348,   417,     0,   537,   473,   466,     0,   359,
     441,   721,   435,   462,   468,   462,   468,     0,     0,     0,
     681,     0,   109,   139,     0,   712,   100,   102,     0,     0,
     252,   251,  1159,     0,     0,     0,     0,     0,     0,  1938,
    1968,  1971,  1969,  1970,  1972,  1966,     0,     0,   318,     0,
       0,  1143,  1145,  1139,  1187,     0,     0,     0,     0,  1454,
    1456,     0,  1204,     0,  1073,  1059,     0,  1064,     0,  1056,
       0,  1094,     0,   332,   564,   492,     0,   491,     0,   486,
     487,   482,     0,   462,     0,   462,   433,   351,   353,   357,
     358,     0,  2040,     0,  2037,     0,  2050,   141,     0,     0,
     133,   136,  1994,   529,   532,   414,   861,     0,   989,   871,
     929,  1272,  1280,     0,  1441,  1147,  1148,  1159,     0,   689,
       0,     0,     0,     0,  1455,     0,     0,  1462,  1464,     0,
       0,     0,     0,  1100,     0,  1095,   333,   494,   495,   493,
     479,   480,   380,   538,   382,  2041,  2042,  1994,   119,   118,
     110,     0,   178,     0,   103,   253,     0,     0,     0,   449,
    1144,  1188,  1459,  1460,     0,  1457,     0,     0,  1463,     0,
       0,  1061,  1066,  1093,  2038,   120,     0,   194,   182,     0,
       0,     0,   180,   208,  2051,     0,     0,   184,   206,   207,
     185,  1533,     0,  1534,  2043,     0,   862,  1279,  1281,     0,
    1442,     0,  1458,  1466,  1465,     0,  1074,   193,   196,     0,
       0,   199,   189,   188,   190,     0,     0,     0,   179,   229,
     178,   178,   232,   187,   225,   178,   104,   450,  1453,   712,
       0,   195,     0,     0,     0,   181,   209,   220,   223,   215,
     150,   178,     0,   178,     0,     0,  2044,   109,  1461,     0,
       0,  1191,  1193,     0,   191,     0,     0,     0,     0,   178,
     216,     0,   146,     0,     0,   148,   235,     0,   227,   105,
    1467,  1194,  1189,   712,  1331,     0,   183,   200,   217,   223,
     213,   221,   178,     0,     0,   178,     0,   231,   149,     0,
     233,   226,   228,   178,     0,  1469,  1192,   192,   197,   178,
       0,   214,     0,     0,   212,   161,   160,     0,   152,   174,
     230,     0,   151,     0,   178,   106,     0,     0,  1476,     0,
     178,   218,     0,   178,     0,     0,     0,     0,     0,   147,
       0,   178,  1468,  1471,     0,     0,  1473,  1474,     0,  1443,
     198,   203,     0,   210,   178,   155,   175,   176,     0,   158,
     236,     0,  1475,  1470,     0,  1477,   199,   178,   202,   178,
       0,     0,   153,   167,   154,   165,   157,     0,   234,  1472,
     204,   178,   178,   173,   171,   178,   162,   169,   164,     0,
     170,   177,   168,     0,   159,     0,   156,   172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   983,    58,   532,
     930,  1396,  1397,    59,   429,    60,   709,  1142,  1143,  1144,
      61,  1614,  2494,  1160,   406,   424,   390,  2799,  3070,  3439,
    3535,  3587,  3633,  1106,  3436,  1535,  3490,  1536,    62,   497,
     707,  1124,  1125,  3245,  3246,  3242,  3247,  3060,  3061,  3062,
    3063,  3625,  3581,  3602,  3626,  3666,  3700,  3706,  3707,  3647,
    3715,  3716,  3717,  3723,  3718,  3648,  3702,  3582,  3525,  3555,
    3551,  3526,  3615,  3550,  3637,  3573,  3574,  3639,  3681,  3698,
    3527,  3528,  3556,  3597,  3529,  3557,  3619,  3578,  3620,  3640,
    3682,  3579,  3598,  3643,  3601,  3530,  3585,  3631,  3563,  3580,
    3584,  3654,  3629,  2068,  2479,  2073,  2484,  3073,  2489,  3253,
    3442,  1897,  2302,  3135,  2805,  1100,  1101,  1102,   407,   408,
     409,   505,  2074,  1570,  2075,  2076,  1572,  1573,  1029,  2453,
    2444,  2430,  3301,   730,  3069,  2457,  2458,  2459,  2460,  2408,
    2409,  1987,  1988,  2034,  2468,  2782,  3000,  3020,  2783,  2784,
    2785,  2786,  2787,  2788,  2789,  2819,  2820,  3195,  3196,  3197,
    2816,  3051,  3035,  3036,  3037,  3218,  3007,  2342,  2343,  3540,
    2352,  2353,  2390,  2677,  2391,  1105,  3008,  3045,  3205,  3038,
    2467,  2994,  3186,  3338,  3187,  3188,  3189,  3419,  1989,  2407,
    1121,  1122,   656,   410,  1174,  1630,  1631,  1632,  3077,  3078,
    2398,  2907,  3344,    63,  1108,   692,   694,   693,  2037,   484,
    1574,  1575,  1576,  2720,  2726,  3332,  1991,   111,  1393,  2464,
    2025,    64,  1079,  1074,    65,   667,   662,   663,  1077,  1078,
    1504,  1949,    66,   599,    67,   492,    68,   500,  1147,    69,
     991,  1889,  1890,  1891,    70,   699,    71,   501,  1154,  1155,
    1156,    72,   981,   116,    73,   588,   986,   988,   989,    74,
     494,   495,  1116,    75,  1423,  1871,  1872,   704,   705,  1123,
    2636,    76,    77,   475,   449,   605,   450,   451,  1450,  1909,
    3302,   616,   617,   618,  2326,  1008,  1009,  1010,  1914,  1451,
    2331,  1162,  2922,  1330,  1797,   892,  1331,  1798,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,  2253,  2256,
    3039,   903,  1340,  1808,   904,   905,  1836,   906,  2868,  2275,
    2276,  2277,  2618,  2619,   907,  2110,  2831,  2148,   908,  1327,
    1793,  1704,  3092,  2852,  1649,  2093,  2514,  2620,   521,   522,
     909,  1252,  1253,  1254,  1721,  1318,  2239,  1785,  1511,  1512,
    1513,  1514,  2971,  2970,  2972,  3316,  3158,  3318,  3162,  1960,
    1515,  1516,  3470,  2366,  2691,  2384,  2385,  3169,  1951,  1517,
    2372,  3168,  2707,  2977,  3324,  3474,  2039,  3320,  1381,  1382,
    1701,   965,   966,  1650,  1868,  2290,  3142,  3306,  2265,  2941,
    3304,  3391,  1577,  2434,  2435,  1911,  1912,  2388,  2710,  2730,
    1032,  3303,  2292,  1478,  1479,  2810,  1633,  2050,  3459,  3541,
    3590,  3591,  3592,  2659,  2660,  2945,  2946,  1913,  2323,  2661,
    3143,    78,   412,    79,  1838,   700,   701,   524,   421,    80,
     430,  1869,    81,   443,  1438,   572,   592,   994,   995,  1898,
    2303,  2310,  1899,  2315,  2934,  2305,  2639,  2640,  1972,  1973,
    2306,  2642,  2931,  2923,  2924,  2632,  3133,    82,   463,  2702,
    2379,  2380,  3451,  3452,   593,    83,   411,   741,  1637,  1179,
    1636,   742,   743,  1181,   519,   520,    84,   461,  1053,  1054,
    1055,  1493,    85,   454,   657,  1474,  2356,  1933,   584,   659,
    1485,   660,  1486,  1465,  1928,  1020,    86,   688,   687,    87,
     480,  1096,    88,   533,   941,   942,  1401,  1846,    89,   444,
     597,   598,    90,   438,   585,  1431,    91,   431,   575,    92,
      93,   576,   974,  2633,  3300,  3499,  3568,  1422,   975,  2490,
    3309,  3399,  3400,  3402,  3467,  3468,  3635,  3658,  3675,  3676,
    3679,   910,   676,   911,  3179,   912,   913,  2311,  2312,  2711,
     914,  3453,   915,  2035,   670,   427,   916,   566,   917,  2295,
     918,  3532,   722,   723,   393,   394,    94,   619,   453,  1012,
    1013,  1014,  1460,  1461,   661,  2248,  1462,  1463,  1925,  1920,
    2953,  2683,  2675,    95,   579,   943,   979,   980,  1877,    96,
     462,    97,   967,  1417,  1418,  1865,  2289,  1866,    98,   601,
      99,   555,  1411,   556,   945,   557,   558,   957,   952,   960,
     954,  3290,  3125,  3126,  1853,   926,   724,   725,  1404,  1848,
    1849,  2918,  3128,  3296,  3297,   100,   120,   399,   503,   716,
    1002,   101,   102,   103,   104,  1005,  1091,  1905,  1092,  1093,
    1094,  1524,  1448,  1325,  2905,  2241,  1787,  2596,   508,   731,
     490,   510,   511,   112,   113,   732,   733,  2070,  2471,  2792,
    3055,  3056,  3239,  3236,   734,  3565,   735,  2480,  2065,  2795,
    3362,  3492,   105,   678,   472,  1089,  1084,  1086,  1520,  1967
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3244
static const int yypact[] =
{
    3683, -3244,   200,    47,  -162, -3244,   146, 43054,   113,  -162,
    -162,   288,   779, -3244, -3244, -3244, -3244, -3244,   599, 43054,
      47, -3244, 21332, -3244, -3244, -3244,   229,  -162,    47, 43054,
   -3244,   442,   749,    47, -3244, -3244,  -162, -3244,   288, 43054,
   -3244,   511, -3244,   602,  -130,   436,   422, -3244, -3244, 43054,
     397,   -91,   951,   920, -3244, -3244,   623, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, 21890, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244,   841, 43054, 43054, -3244,
   43054,   554, -3244,   889, -3244, -3244,  -162, -3244, -3244, -3244,
     288, 21332, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,   486, -3244, -3244,   597, -3244, -3244, -3244,  1066,
     963, -3244, -3244, -3244, -3244, -3244,   716,   640, -3244,   733,
     992,    38, -3244,  1023,  1023, 43054,  1023, -3244,  1023, -3244,
    1023,  -162, -3244, -3244,  1129, 43054,   894,   177,   -71, 38059,
     817,   194, -3244,  1017, 21332, -3244,  -162,  1082,   498, 43054,
   -3244, -3244,  -162,   166,   539, -3244,  1680,   120, -3244, -3244,
   -3244,   136, -3244, -3244,  2772, -3244, -3244, -3244,   692, -3244,
   -3244, 21332,  -162,  1001, -3244, -3244,   141,   141,   141, -3244,
     141, -3244,   141, -3244,   -91,   683, -3244, -3244, 43054,   375,
   -3244, -3244,   688,   -69, -3244, -3244, -3244, -3244, 21332,  1140,
     823, -3244, 21332, -3244,   -39, -3244, -3244,   730, 43054, -3244,
   21332, 21332,   408,    20,   818, 43054, 35839,   874, -3244,   185,
     889,  1283, -3244,   963, -3244, 43054, -3244, -3244, -3244, 39724,
      38, -3244, 13367,  1144, 43054, 43054,   954, 43054, 43054, 35839,
   21332,  1023,   787,  1460,   962,   919,   772, -3244, -3244, -3244,
   -3244,  1006, -3244, -3244,   855, -3244, -3244, -3244,   199, -3244,
      42, -3244, -3244, -3244, -3244, -3244,  1015,   781, -3244, -3244,
      90, -3244, -3244, 43054, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1143, -3244, -3244, 13367,   720,  1321,  1205, 21332,
   -3244,  -192, -3244, -3244,  1127, -3244, -3244, 35839, 21332, -3244,
   -3244, -3244, 19090, -3244, -3244,  1335, -3244,   815, -3244, 21332,
     962, -3244,  1059,   988,    20,   896, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244,   866,   136, -3244, -3244,
    1171,  1290, -3244,  1010,    32,   931,   878,   168,    32, 38059,
    1206, -3244,   203, -3244,  1294, -3244, -3244,   997, -3244, -3244,
   -3244,  1003,  1021,  1190,   998, -3244,   226,   347, -3244,  1031,
   -3244,    87, -3244,   521,  1206,    32,   718, -3244,  1244,  1371,
      83,   354, -3244,  -103, -3244, -3244,  1443, -3244, -3244, -3244,
   -3244, -3244,  1143, -3244, -3244, -3244,   944, -3244,  1182,  1046,
   -3244, -3244,   133, -3244,   955,   -25, -3244,   405, 36394, -3244,
   -3244, -3244,   114, -3244, -3244, -3244, 35839,  1113,  1019, 21332,
     352, -3244, 40279, 21332, -3244,   -18, 13367, -3244, -3244,  1869,
      75,    58, -3244,  1517,  1137, -3244, -3244, -3244, -3244,  1430,
   -3244,  1008,  1004,  1390,  1030, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1057, -3244, -3244, -3244,   823, -3244, 21332,   340,
   21332, -3244,  1033, -3244,  1069, -3244,  1054,  1078,  1081,  1093,
    1100, 16272, -3244,  1103,  1110,  1117,  1166,  1168,  1170,  1173,
    1184,  1188,  1198,  1199,  1201,  1202,  1203,  1008,  1008,  1204,
    1207,  1209,  1211,   448,  1213, -3244,  1215,  1218,  1219,  1221,
    1222,  1224,  1225,  1226,  1227,  1228, -3244,  1229, -3244,  1230,
    1232,  1236,  1237,  1238,  1239,  1241,  1242,  1245,  1246,  1247,
    1248,  1250,  1252, -3244,  1254,  1256,  1258, 13367,  1259,  1260,
    1261,  1262,  1264,  1266,  1267, -3244,  1268,  1271,  1272,  1273,
    1274,  1275,  1276,  1277,  1278,  1279,  1280,  1281,  1282,  1285,
    1287, -3244, -3244, 13367,  1289, -3244, -3244,  1292,  1293, -3244,
    1297,  1298,  1299,  1300,  1302,  1303,  1304,  1305,  1306,  1307,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,  1320,  1322,  1324,
    1327,   487,  1331,  1333,   601,  1334, -3244,  1337, -3244,   151,
    1340,  1341,  1342,  1008,  1008,  1008,  1343,  1344,  1346,  1347,
    1348,  1349, 13367, 16272, 16272, 16272,  8719, -3244, 43054, -3244,
   43054, -3244,  1157, -3244, -3244,  1484, -3244,   970,  1214,   880,
     827,   149,  1041, 16272,  3728,   419, -3244, -3244, -3244,  1145,
    1319, -3244, -3244, -3244, -3244, -3244,  1350, -3244,  1183, -3244,
   -3244, -3244, 21332, -3244, -3244, -3244,  1288,    73, 21332,  1200,
   -3244, -3244, -3244, -3244, -3244, -3244,  1751, -3244, -3244, -3244,
    1269,  1354, -3244, -3244, -3244, -3244, -3244, -3244,  1373, -3244,
   -3244, -3244,  1352, -3244,  1352, -3244, -3244,  1352, -3244, -3244,
    1352,   389,  1814, -3244, -3244, 43054, -3244, 43609, -3244, 19090,
   -3244, -3244,  1612, -3244, -3244,  1655, -3244,  1636,   111,  1356,
   -3244, 21332, 38059, -3244, -3244,   124,  1357,  1435,  1360, -3244,
    1441, 21332, 21332, -3244, -3244, -3244, -3244,   539,   122,  1365,
     628, -3244, 43054, -3244,   312, -3244, -3244, -3244,  1366, -3244,
   13367, -3244,  1369, -3244,   658, -3244,  1723, -3244,  1461, 13367,
   -3244, -3244,  1385,   963, 43054, 43054, 21332, 21332, -3244, -3244,
   -3244,   546, -3244, -3244, 43054,    32, 35839, -3244, -3244, -3244,
    1786,   718, 43054,    32, -3244,  1729,  1474, -3244, -3244, -3244,
    1802, -3244, -3244,  1791,  1384, -3244,   718, -3244, -3244,   718,
   -3244, -3244, -3244, -3244, -3244, 21332, -3244, -3244,   718, -3244,
     718,   718,    32,    32,  1440, -3244, -3244,  1389, -3244,  1440,
    1518,   367,   141,  1608, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244,   558, -3244, -3244, -3244, -3244, -3244,
   -3244,   115, -3244, -3244, -3244,  1147,   165,   165,  1649, -3244,
     176, 21332,    58,  1461, 21332, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1394, -3244,  1395,  1393, -3244,  1830,  1833,  1834,
    1835,  1836,  1839,  1841,  1842,  1844,  1845,  1846,  1848,  1849,
    1851,  1852,  1418, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244,  1481, -3244, -3244, -3244, -3244,  1024, -3244, -3244, -3244,
     114,  1433, -3244, 38059,  1968, 35839, 43054, 43054,  1837, 21332,
   -3244, -3244,   843,   843,  1670,  1033, -3244,    79, 43054,  1840,
   25791,    74, 13367, 13367, 13367,   326,   834,  1953,  2007,  2007,
    2007, 13367, 13367, -3244, -3244, 13367, -3244, 13367, 13367, 13367,
   13367,   786, -3244, -3244,  9300, -3244,  1442, 13367, 13367,  1528,
   13367,  1319, 13367, 13367, 22448, 13367, 13367, 13367, 13367, 13367,
     416, 13367,  3728, 13367, 13367, 13367,  1447, 13367, 13367, 13367,
   13367, -3244, 13367, 13367,   217, 13367,  1902,   579, 13367, 13367,
   13367, -3244,  9881, 13367, 13367, 13367, -3244, 13367, 13367, 13367,
   13367, -3244,  2019, -3244, 22448,   851, 13367, 13367,   913, 13367,
   13367, 13367, 13367, 13367, -3244, -3244, -3244, -3244,  9300, -3244,
   13367, 13367, 13367, 13367, 13367, -3244, 16272, 13367, 10462, 13367,
   13367, 13367, 13367,  1450, 13367, 13367,  2007,  2007, 13367, 13367,
   13367,  1038,  9300, -3244, 13367,  1319,   665,   665, 13367,  1319,
    7557, 13367, -3244, -3244, -3244,   579, 11043,  1453, -3244, -3244,
   -3244,  2007, 22448,  2007, 13367, 13367, 13367, -3244,  1485,  1953,
    1953,  1953, -3244,  8719,   768,  1463, 13367, 23564,  1454, 13367,
   -3244, -3244, -3244, 16272, -3244, -3244,    52, -3244, -3244, -3244,
   13948,  1462, 16272, 16272,  1792, 16272, 16272,   522, 16272, 16272,
   16272, 16272, 16272, 16272, 16272, 16272, 16272, 16272, 16272,  1953,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244,  1472, -3244, 38059, 16272, 13367, -3244, -3244, 43054, -3244,
   35839, -3244, -3244, -3244,    73, 38059,  1465, -3244, -3244,  1656,
    1460, 21332, -3244, 43054, -3244, -3244, -3244, -3244, 19648, 19648,
   -3244, 19648, -3244, -3244,    82,    93,  1399,  1496, -3244, -3244,
   -3244, -3244,  1831, 21332, -3244,     8, 21332,    58, -3244, 13367,
    1461, -3244, 35839, 35839, 21332, 21332,    81, -3244,   776, -3244,
    1461,  1856, 19648, 19648, 19648, -3244, -3244, -3244, -3244, -3244,
     625, -3244, -3244, -3244,  1466, -3244, -3244, -3244, -3244, -3244,
   40834,    91, -3244, -3244,  1461,  1877, -3244, -3244,  1477, 43054,
   -3244, -3244, -3244, -3244,    -6, -3244, -3244, -3244, -3244,   -55,
   -3244, -3244, -3244, -3244,  1603,    32, 43054, -3244, -3244, -3244,
   -3244, -3244,  1676,  1206,   347,    32,    32,   718, 21332,    32,
      32, -3244, -3244,   990, -3244,  -103, -3244, -3244, -3244, -3244,
   43054,   877,  1617,  1479, -3244, -3244, 21332, -3244,  1480, -3244,
    1889,  2017,  1206, -3244, -3244, -3244,   266,   266,  1461,  1597,
    1601,  1602,  1604,  1605,  1640, -3244, -3244,   232,  2006,   266,
     266,  2006,   266,   266,   266,  1572,  1956,   266,  1850,  1590,
     702,  1853,   266, -3244,  1599,  1967,   266,   266,   266,  2006,
    2046,   266,   266,   266,   266,   266,   102,   266,   266,   266,
   -3244,  3084, -3244, -3244,  1512, 20206, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, 41389, -3244, 13367,   834,  1461,  1461,
     630,  1461,   834,  1461,  1461,  1461,  1461,  1461,   834,  1461,
    1461,   834,  1869, -3244, -3244, -3244, -3244, -3244,   -93, -3244,
   -3244,  1107, 43054, -3244,  2641, -3244, -3244, -3244, -3244, -3244,
   -3244,   -92, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1514, -3244, -3244, 21332,  1560,  1496, 25791, -3244,
     367, -3244,  1511, -3244,  1519,  1522,   820, -3244,  2007,  1523,
   -3244,  1524,  1527,  1530,  1532,  2079,  1535,  -185,  1539,  1540,
    1541,  1542,  1543,   620,  1545, -3244,  1554,  1526,  1555, -3244,
    1556,  1558,  1562,  1570,  1578,  1581,  1536,   850,   852,  1582,
    1584,   875, -3244,  1587,  1588,  1928,  1589,  1592,   901, -3244,
    1596,  1598,  1600,   909,  1606,   915,   917, -3244, -3244, -3244,
   -3244,  1607,  1610, -3244, -3244,  -187,  1609,  1611,  1614, -3244,
    1616,  1618,  1619,   921,  1621,  1622,   926,  1624,  1625,  1627,
    1529,  1630, -3244,  2007,  1628,  1634,  1638,  2007,  1639,   940,
    1642,  1644,   947,   953,  1645,  1646,  1647,  1652,  1653,  1654,
     991,  1648,   994,  1657,   -35,  1658, -3244,  1659,  1660,  1662,
    1663,  1005, -3244,  1665,  1669,  1671,  1672,  1673,   125,  1674,
    2007,  1678,  1679,  1011,  1675,  1682,  1685, 11624, 12205, 12786,
       7,  1687,  -171, -3244,  1689, -3244,  1691,  1692, -3244,  1536,
    1695,  1013,  1020,  1696, 13367,   544, -3244,   416, -3244, -3244,
   -3244,  1552,   624, -3244,  1725, 43054, -3244,   936,  1534, -3244,
   -3244, -3244, -3244, -3244,   607, -3244,  1623, -3244,  1705,  8719,
     154,  1613, 16272,    78,  1214,  1707, 16272, 16272, 16272,   880,
     827,   827,   149,  3728,   149,  3728,  1041,  1041,  1041,  1041,
    1041,  1953, 13367, -3244,  1953, -3244,  1708,   676, -3244, -3244,
   -3244, -3244,  1200,  1914, -3244,  1706, -3244, -3244,  1040, -3244,
    1594, -3244,  1664,  1683,  1694,  1731, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,  1206,   776,
    1688,  1710, -3244, -3244,  1697,  1919, -3244, -3244, -3244, -3244,
   -3244, -3244,  1785, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244,    33, -3244, -3244,  1713,  1713, 17969, -3244, -3244, -3244,
   -3244,  1943,  2008,  2119,  2120,   405, -3244,   121, -3244,   616,
    2072,  1206, -3244,  2124, 38614, 26348, -3244,  1715,  2068,  1717,
     266, 34174,   296, 24119, 34729, -3244, -3244,   630, -3244,    45,
   -3244, -3244, -3244, -3244,   546,   546,  1750, -3244, -3244,  1966,
   -3244, -3244, -3244, -3244,  1496,   718, -3244, -3244, -3244,  1726,
   -3244, -3244,   367,  2069,  2071, -3244,  1954,    57,  1954,   367,
     367, 22448,   367,  1353, -3244,   834,  2005, -3244, -3244, -3244,
   -3244, -3244, -3244, 36949, 35284, -3244, -3244, -3244,  2217, -3244,
    2219,   198, -3244, 23006,   905,   905, -3244,   164,   190, 23006,
   -3244, -3244, 23006,   630,   834, 23006,   834,  1461,  1461,  1566,
     266,   834, -3244, -3244,  2078,  2080, 23006, 23006, -3244, 38059,
   -3244,   266,   679,   630,   630, 23006, 22448,   202,  1461,   834,
     834,   945, -3244, -3244, -3244, 21332,   794, 38059,  1739, -3244,
    3226, 17411, 43054,   275,   155, -3244,  1734,  1742, -3244,  1044,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244,  1827, -3244,  1744, -3244, -3244,    50, -3244,
    1742, 21332, 16853, -3244,   108, -3244,  2060, -3244, -3244,  1083,
   -3244,   367,  1972,    92,  1496,  1753,    74, 14529, -3244, -3244,
   13367,  1747, -3244, 13367, 13367, -3244, -3244, -3244,   221, -3244,
   37504, -3244, -3244, -3244, -3244, -3244, 13367, 37504,   221, 13367,
   -3244, -3244,  1748, -3244,  2103,  2103, -3244, -3244,  1319, -3244,
   43054, -3244, 13367, -3244, 13367, -3244,  1319, -3244, 13367, -3244,
   13367, 13367, -3244,  1992, -3244, 13367, -3244, 13367, 13367, -3244,
   13367, -3244, -3244, 13367, -3244, 13367, 13367, -3244, -3244,  1994,
   -3244, 13367, 13367, -3244, -3244, 13367, -3244, 13367, -3244, 13367,
   -3244, 13367, -3244, 13367, -3244, 16272, 22448,  1755, -3244, -3244,
   -3244,  1756, -3244, -3244, 13367, 13367, -3244, -3244, 13367, -3244,
   13367, -3244, -3244, -3244, -3244, -3244, -3244, -3244, 13367, 13367,
   -3244, 13367, -3244, 13367, -3244, -3244, 13367, 13367, 13367, -3244,
   13367, -3244, -3244, -3244, -3244, 15110, 13367, 13367, 13367,  1757,
   -3244, -3244, -3244, 13367, 13367, 13367, -3244, 13367,  2163, 13367,
    2166, 13367,  2167, 13367, -3244, 13367,  2009, -3244, -3244, -3244,
   -3244, -3244, 13367, -3244, 13367, -3244,  1781, 13367, 13367,  2207,
   -3244, -3244,  1770,  1771, -3244,  1766,  1768,  1769, 38059, 13367,
   -3244, -3244, -3244, 13367, -3244, -3244, 13367, -3244, -3244, -3244,
   -3244,   416,  1056,  1776, 16272, -3244,  1613, 16272,  8719,   154,
    1613,    99, -3244, -3244, -3244,  1777, -3244, -3244,  1778, 43054,
   -3244, -3244, -3244, 43054,  1787, 26905, 35839, 35839, 35839,  1780,
   13367, -3244, -3244,  2016, -3244, -3244, 21332,  2147, -3244, -3244,
   35839, -3244,   136, 22448, -3244,  1782, -3244,  1782,   645,  1784,
    1058, -3244, -3244, -3244,  1783,   896,  2190, 35839, 35839, 35839,
   -3244,  1496,  1496,   132,  1854,  2137, -3244, -3244, -3244, -3244,
   41944, -3244, -3244, -3244, -3244,   706, 43054,  2121, 43054,  8138,
   -3244, -3244, -3244,  2306, 13367, -3244, 35839,   -28,   624,   266,
   -3244, -3244, -3244, -3244, -3244, -3244,  1206, -3244, -3244, -3244,
   -3244,  2098, -3244, -3244,    32,   990,   349, -3244,   948, -3244,
   -3244, -3244,  2138,   367,  1954,  1954,  2139,  2033,   475,  1798,
   -3244,   266,   877,    36, -3244,   136, -3244, -3244, 13367, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, 13367,  2141,  2142,   905, -3244, 23006, -3244, -3244,
     340,    51, -3244, -3244, -3244, -3244, -3244, -3244, 35284,  1461,
   -3244, 23006, -3244, -3244,   137, -3244,  1461, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244,  1801, -3244,   272, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, 21332, -3244,  1060, -3244, -3244,
   -3244, -3244, 43054, -3244, -3244, 21332, -3244, -3244,  4426, 43054,
   43054,  2364, -3244, 43054, -3244, -3244, -3244, -3244, -3244,  2040,
    -101,  2367, -3244, 21332, -3244,  1807,  1065, -3244, -3244, -3244,
    2369,  2116, -3244, -3244,  1810,  1496,  2136, -3244, -3244, 13367,
    1812,  1813, -3244, -3244,  1816,  1815,  1815, -3244, -3244,  1818,
    1815,  2171, -3244,  2172,  1822,  1824,  1825,  1828,  1838,  1855,
    1829, -3244, -3244,  3728,  3728,  1858,  1857,  1859,  1860,  1861,
    1862,  1864,  1866,  1870,  1871,  1872,  1873,  1874,  1876,  1875,
    1878,  1880,  1881,  1885,  1972,  1888,  1891,  1892,  1886,  1890,
    1894,  1067,  1896,  1899,  1070,   218, -3244, -3244, -3244,  1900,
    1901,  1903,  1905,  1906,  1907,  1908,  1910,  1913,  1915,  1918,
    1920,  1923, 13367,  1926,     5,  1084,  1927, -3244,  1929,  1930,
    1931,  1933, 13367,  1934, 13367,  1935, 13367,  1936,  1937,  1940,
    1938,  1942, 13367,  1868, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1909, -3244,  1157, -3244,  1947, -3244, -3244, -3244,
     419, -3244,  1087,  1948, -3244, 16272, -3244, 13367,  1949, -3244,
    1951, -3244, -3244, -3244, -3244, -3244,  -127,  -127,  -127, 15691,
   -3244,  2278, -3244,    67, -3244,  2168, -3244, -3244,   866,  1952,
   -3244,   266, 15691,  1713,  1989, -3244, -3244,   645, 22448, 26348,
   -3244, 35839,  1030,  1030,  1030,  1206,  2229,  1688,  1688, -3244,
   24674, -3244, -3244,  1982, -3244, -3244, 27462, -3244,   792, -3244,
   -3244, 16272,  1218, -3244, -3244, -3244, 36949, -3244, -3244,   266,
    1944,  1950, -3244, -3244, 42499, 13367, -3244,  2284, -3244, -3244,
    1955,   367,  2076,   367, -3244,  2199,  2245,   367, -3244, -3244,
   -3244, 22448,  1496, 15691,   905,   905,   905, -3244,   866, -3244,
    1958,   272, -3244, 23006, -3244, -3244,   340,  1957,  2387,  2398,
   23006,  2306, -3244, -3244, -3244, -3244,  4426, 22448, -3244, -3244,
   -3244,  1095, -3244, 17411, -3244, -3244, -3244,  1962,  1964,  1815,
   -3244, -3244, -3244, -3244, -3244,  1818,  2164, -3244,  1818,  1818,
   -3244, -3244, -3244, -3244, -3244,   209,   214, -3244, -3244,   209,
   -3244, -3244, -3244,    89,   832,  1818, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244,  1815,  1815, -3244, -3244, -3244,   209,  1965,
   -3244,  1815,   923, -3244,   152,    70,  1969,  1970,  1815,  1971,
    1959, -3244,  1105, -3244, -3244,   174, -3244,   672, -3244, -3244,
   -3244,  1973, -3244,  3084, -3244,   434, -3244, 43054, -3244,   546,
   -3244,  3728, -3244, -3244, -3244,  2208, -3244,   209,  2212, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   13367,  1974,  1975,  1978, -3244, -3244, -3244, -3244, -3244, -3244,
   13367, -3244, -3244, -3244, -3244, -3244, 13367, -3244, -3244, -3244,
   -3244, -3244,  2108, -3244,  2213, 13367, 13367, -3244, -3244, -3244,
   -3244, 13367, -3244, -3244, -3244, 13367,  2517,  2178,  1981, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, 13367, -3244,
   -3244, -3244,  3728, -3244, 13367, -3244, -3244, 13367, 13367, -3244,
   13367, 13367, -3244,  1984, -3244,  1985, -3244,  1986, -3244, -3244,
    2223, -3244, -3244, -3244, 13367,   896, 43054, -3244, -3244,  1987,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244,    85,  2014,  2014,
    2014,  1218, -3244,  1111, -3244, -3244,  2342, -3244,  1366, 22448,
   15691,  1990,  1995, -3244,   -25, -3244, -3244,  1991,  1030, -3244,
    2525,  2373, -3244, -3244, 38059,  1998, -3244, -3244,  2269, -3244,
     105,  2192, -3244, -3244, -3244,   -28,  2086,  2089,   266, -3244,
    1461,  2020,  1479,  2348,   989,  2050,   367,   367,  1263,  2051,
   13367, 13367,  2010, -3244,  1972, -3244,  2415, -3244, -3244, -3244,
    1366, 13367, -3244,  2011,  2012, 43054, -3244,  1047,   275, -3244,
     923, -3244, -3244, -3244,   -46,  2253,  2254, -3244,   369, -3244,
    2015,   369,   369,  2563,    86, -3244,  2563, 37504, -3244,  1010,
   -3244,  2052,   209, -3244, -3244,  2056, -3244, -3244, -3244,   369,
    2018,   209, -3244, -3244,  2259,   369, -3244, 38059,  1461,   618,
   -3244,  2074, -3244,  2493,  2370, -3244,   923, -3244,  2371,  2268,
   -3244,  2272, -3244, -3244,  2273, -3244,  2274,  2275,   369,  2277,
   -3244,   369, 43054, -3244, 43054,  2054,   447, -3244, -3244, -3244,
    2037,  2038, -3244, -3244, 21332, -3244, -3244, -3244, -3244,  2105,
   43054,  2054, -3244,   -25,   108,  1989, -3244,  1119,   272,  2039,
   -3244,  2041,  2042, -3244,  1121,  2043, -3244, -3244, -3244,  1124,
    2044,   141,  2045,  2047,  2053,  2049,  2055,  2057,  2315,  2476,
   -3244,  2059,  2064,  2066,  2070,  2073,  2075,  2077, -3244, -3244,
   -3244,  2067, -3244, -3244, -3244, -3244,  2081, 38614, -3244,  2145,
    2154, -3244, -3244,  2156, -3244, -3244,   118,  1153, -3244, -3244,
   -3244, -3244, 15691,  2393, -3244,   701, -3244, -3244, -3244, -3244,
   13367, -3244,  1972,  2567, -3244, 24674, -3244, -3244, -3244, -3244,
   -3244,  2082,  2084,  8138,  2619, -3244,   367, -3244,  2122, -3244,
   -3244, -3244,  2123, -3244, -3244, 43054,  2136,  2419, -3244,   701,
     272, 43054, 43054,  1128,   579,   579,   579,   642,   642, -3244,
   -3244, -3244, -3244,    95,   159, 43054, -3244, -3244,   777, -3244,
    2087,  2088, -3244, -3244, -3244, -3244,   369, -3244,   141, -3244,
   -3244, -3244, -3244, -3244, 37504, -3244, -3244,  2563, -3244, -3244,
   -3244,   141, -3244,  2091, -3244, -3244, -3244,  1008, -3244, -3244,
    2317,  2127, -3244, -3244, -3244, -3244,  2092,  2093,  2094,  2095,
   -3244,  2096, -3244, -3244, -3244,   246, -3244, -3244, -3244, -3244,
   -3244,   778, 43054,  2503,  1461,  2099,  2100, -3244, -3244, -3244,
   -3244, -3244,  2102,   896, -3244, 43054, -3244,  2341, -3244, -3244,
   -3244,  2344, -3244, -3244, 13367, -3244, -3244, -3244,  2007, -3244,
   13367, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
     183,  2334,   834,   834,   834,   834,  1153, -3244, -3244,  2155,
    2195, -3244,   616, -3244,  -222,   272, 13367,  1206,   357,  2431,
   -3244, -3244, -3244, -3244,  2411,  1345, 13367,  2110, 13367,  2111,
    1130, -3244, -3244, -3244,  2112, -3244, -3244,  1132,  1134, -3244,
   -3244, -3244,   275, -3244, -3244, -3244,   412,   412,  1139, -3244,
   -3244, -3244, -3244, -3244,  1141, -3244, -3244, -3244,  1151, -3244,
   -3244,  1008, -3244,   209,  2563,   209,  2563,  2633,  2343,  2635,
   -3244,   -91, -3244, -3244,  4426, -3244, -3244, -3244, 43054,  4426,
   -3244, -3244,   272,  2128,  2129,  1154,  2131,  2132,  2133, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, 22448, 21332, -3244,   293,
   13367, -3244, -3244, -3244,  2321,  2654,  2655,  2564,  2656,   357,
   -3244,   759, -3244,  2558, -3244, -3244, 43054, -3244, 43054, -3244,
   43054, 41389,  2320, -3244, -3244, -3244,  2710, -3244,   671, -3244,
   -3244,   777, 43054,   209,   141,   209, -3244, -3244, -3244, -3244,
   -3244,  2368, -3244,  2372, -3244,  2140,  1220, -3244,  2582,  2309,
   -3244, -3244,   -25, -3244, -3244, -3244, -3244, 13367, -3244, -3244,
   -3244,  2143, -3244,   266, -3244, -3244, -3244,   272, 43054, -3244,
     141,   141,  2679,   141, -3244,  2680,  2682,   759, -3244,   630,
   13367,  1156,  1158, -3244,  2149,  2150, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244,   -25, -3244, -3244,
   -3244,  2608, 32499,  2307, -3244, -3244,  2157, 22448, 15691,  1566,
   -3244, -3244, -3244, -3244,   141, -3244,   141,   141, -3244,  2718,
    2152, -3244, -3244, -3244, -3244, -3244, 43054,   608, -3244, 44164,
   44164, 43054, -3244,  2188, -3244,  3935,   130, -3244, -3244, -3244,
   -3244, -3244,  2153, -3244, -3244,  4426, -3244, -3244, -3244, 35284,
   -3244,  2161, -3244, -3244, -3244,  2461, -3244, -3244, -3244,  2568,
   43054, -3244, -3244, -3244, -3244, 13367, 13367,  2194, -3244, -3244,
   32499, 32499, -3244, -3244, -3244, 32499, -3244, -3244,  2567,  2169,
    2597, -3244,  2519,  2606, 13367, -3244, -3244, -3244,   573, -3244,
   -3244, 29699,  2165, 33059, 13367,   130, -3244, -3244,  2431, 13367,
    2174,  2170, -3244,   834, -3244,  2541,  2191,  2209, 13367, 32499,
   -3244,  2616,  2649,  2491,  2175, -3244,  2176,  2634, 44164,  1220,
    2550, -3244, -3244, -3244, -3244, 43054, -3244, -3244, -3244,   682,
   -3244, -3244, 30259,  2200, 39169, 30819,  2179, -3244, -3244, 13367,
   -3244, -3244, -3244, 32499,  2429,  2193, -3244,  2189, -3244, 32499,
   13367, -3244,  2627,  2205, -3244, -3244, -3244,  2573,  2196,   304,
   -3244,  2187, -3244,  2636, 32499, -3244,  2520, 18527,  2333, 43054,
   28019, -3244,  2214, 32499,  2607, 43054,  4426,  2609,  2610, -3244,
    2374, 31379, -3244, -3244, 38059,  1161, -3244, -3244, 22448, -3244,
   -3244,    18,  2218, -3244, 28579, -3244, -3244,  2676,  1032, -3244,
   -3244,  2237, -3244, -3244, 20769,  2143, -3244, 32499, -3244, 32499,
   33619, 13367, -3244,  2249, -3244, -3244, -3244,  3935, -3244, -3244,
   -3244, 31939, 29139, -3244, -3244, 25229, -3244, -3244, -3244,  2620,
   -3244, -3244, -3244,  1319, -3244, 33619, -3244, -3244, -3244, -3244
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3244, -3244, -3244, -3243, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,   950, -3244, -3244, -3244, -3244, -3244,  1192, -1426,
   -3244, -3244, -3244, -3244, -3244,   305,    -1, -3244, -3244, -3244,
   -3244, -3244, -3244,  2101,  -791, -3099, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244,  -451,  -569, -3244, -3244,  -440,
   -3244, -3244, -2357, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244,  -922,  -882, -3244, -3244, -3244, -3244, -1630, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244,  -889, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,  -810, -3244,
   -3244,  -768, -3244, -3244,  -808, -3244, -3244, -3244,  -772, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,  -260, -3244,
   -3244, -1857, -3244, -3244, -3244,  1661, -3244,  1714, -3244,  2407,
   -3244,  -381,    15,  1249, -1832, -1032,  -566,  -549, -1187, -3244,
   -3244, -3244,  -350, -3244, -3244,   751,    97,  1251,  1296,   790,
     838, -3244, -3244,   123, -3244, -2655, -3244, -3244, -3244,    80,
   -3244,    84, -3244, -3244, -3244, -1356,    46, -1368, -3244,  -362,
   -1366, -3244,  -152, -3244,  -195, -3244,  -448, -2040, -1936, -3244,
   -3244, -3244,  -182,   126,   170, -3244, -2578, -2179, -3244, -3244,
    -570, -3244, -3244, -3244,  -573, -3244,  -339,  -486, -3244, -3244,
   -1485, -1829, -3244, -3244, -2201,  1681,   773, -3244, -2141,  -402,
   -1910, -3244,  -355, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,   825, -3244, -3244, -3244,  -223,  -242, -1338, -2767,
   -3244, -3244, -3244, -3244, -3244, -3244,   853, -3244, -3244,  1355,
    1789, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,   971, -3244, -3244, -3244, -3244, -3244,  -872,  1716,
   -3244, -3244, -3244,  1231, -3244, -3244, -3244, -3244,  1429, -3244,
   -3244,  2173, -3244, -3244, -3244, -3244,   568,   993, -3244, -3244,
   -3244,  2182,   965,  -466, -1752, -3244,  2400, -3244, -3244, -3244,
   -1287, -1484, -3244,  2257,  -425, -2322,  1431,  -719,   -36, -3244,
    -238,  -750,  3944, -3244, -3244, -1256, -3244, -3244,  -793, -3244,
   -3244, -1289, -1193,  1544,  1537,   277,   391,   116, -3244, -3244,
    -500, -3244, -3244, -3244, -1253,  -724, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244,   -33, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -1120, -3244,   783, -3244, -1063, -3244,
   -3244, -3244,  1635, -3244, -3244, -3244, -3244, -3244, -1903, -1486,
     196, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -1887, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -1360, -3244,
   -1691, -3244, -3244,  -956, -3244, -3244,  -519, -2215, -1186,   457,
   -3244, -3244,  -957,  1699, -1582, -3244, -3244, -3244,   627, -3244,
   -3244, -3244, -3244, -3244,   178, -2039, -1057, -3244, -3244, -2620,
    -634, -1814,  -604, -3244, -1848,  -269, -1163, -1874, -3244, -3244,
   -3244, -3244,  -712, -3244, -3244, -3244,  -241,   996, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244,  -472,  -356,   813, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244,  1960,  1911,  1048,
   -3244, -3244, -2104, -3244, -3244,  1014, -3244,   -13, -1875, -1191,
     278, -3244, -3244,   276, -2629, -3244, -3244, -3244, -3244, -3244,
   -3244,   219,  -755,  -572,  2463, -3244, -3244, -3244, -3244, -3244,
   -3244,  2184,  1749, -1473,  2408, -3244, -3244, -3244, -3244, -3244,
    1436, -3244, -3244, -3244, -3244, -3244, -3244, -3244,  2477, -3244,
    -981, -3244,  -398, -3244, -3244,  -593, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244,  1538, -3244, -3244, -3244, -3244,
   -3244,  1945, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,   299,
    -633, -3244,  -460,  -654, -3244,  -527, -3244, -3244, -3244,  -753,
   -3244,  -748,  -675,  -998,   -86, -2158, -1421,   297,  1946, -2727,
   -1150, -1288, -1281, -1819,    41, -3244,    -7,  -540,  -465,  -899,
    2383, -2480,  -413,  -499, -3244,  1235, -3244, -3244, -3244, -3244,
    1489, -3244, -3244, -3244, -3244,   604, -3244, -3244, -3244,   263,
   -3244,    -5,  -200, -3244, -3244,   732, -3244,  1531, -3244, -3244,
   -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244,  1961,  2508,  2355, -3244,  1996, -3244, -3244, -3244,
   -3244, -3244,  -330, -3244,   -32, -3244, -1526,  1799,   409, -3244,
     684,  -863, -1145, -3244,  -328, -3244, -3244,  1050,  2522,  2362,
   -3244, -3244, -3244, -3244, -3244, -2249,  -591, -3244, -2318, -3244,
   -3244, -3244, -3244, -1159, -3244, -3244,  1650,  -140, -3244, -3244,
    -119, -3244, -3244,  -121, -3244,  2484,  2240, -3244,   907, -3244,
     179, -3244, -3244,   -90, -3244, -3244, -3244, -3244, -3244, -3244,
   -3244, -3244, -3244,   862, -3244, -3244, -3244, -3244, -3244, -3244
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2027
static const short yytable[] =
{
     391,   677,   677,   677,   719,   677,   655,   677,   684,  1166,
    1167,  1168,   391,  1097,  1006,   391,   568,  1202,  1203,  1205,
    1061,  1425,   391,  1651,  1777,  1211,  1033,  1187,   710,   711,
     925,  1778,   391,  1480,  2240,  1028,  1685,  1522,  2393,  2309,
    1267,   984,   391,  2496,  1799,  2339,  2344,  2347,  2690,  2368,
    1033,  1807,  1990,  2355,  2291,  2082,  1840,  2378,   927,  2382,
    2515,  1683,  1062,   426,  1675,  2006,  2650,  2518,  1652,  1653,
    1654,  2990,  2377,  1796,  2975,  1495,  1571,  1948,  1496,  2410,
     391,  1666, -1522,  1744,  1269, -1875,  2359,  2360,   987,  1499,
    1500,  2982,   963, -1130,  2267, -1523, -1876,  2328,  1823,  1825,
     391,   391,  3043,   391,  1722,   669,  3202,   486,   963,   487,
    1293,  -249,  1148,  1295,   391,  2615,  1299,  -259,  -260,  2412,
    2022, -1939,  1391,  1308,  1309,  1310,  1103,   998,   481,   963,
    1657,  1658,   738,  1660,  3289,  1724,   502,   958,  1728,  2431,
    2432,   622,   623,  1104,  3119,  3015,   622,   623,   606,  1068,
    1811,  1429,  1813,  3696,  2084,  2400,  2401,  1964,  3559,  1319,
    1320,  1321,   496,  1910,  2399,  2476,  1755,  1756,  1694,  2086,
    2399,  1761,  3003,  2411,  3147,   673,  2414,  2884,  3013,  1359,
    2718,  3014,  2223,  1714,  3004,  1302,  1391,  2423,  2424,  1886,
     702,  1776,  2357,  1780,  2193,   727,  2433,  1109,  3005,  1119,
    3023,  1734,  1735,  1736,  2645,  2704,  3042,   622,   623,  2717,
    1800,   106,  1743,  2402,  1149,  2485,  1030,  1150,  1383,   964,
    1120,  3181,  2402,   677,  1643,  1099,  1099,  1112, -1997,  3003,
    1151,  1145,   689,  1528,  3003,   964,   993,  1886,   561,  3083,
    1581,  3004,  3119,  3183,  2492,  1529,  3004,  2023,  2402, -1130,
    2705,  2321,   516,  2505,  3170,  3005,   964,  1931,  1065,   955,
    3005,   607,  1023,  2657,   622,   623,  1034,  2376,  2063,   622,
    3009,   573,  3333,  2477,  3336,  1353, -1522,  2506,  1874,   590,
    2917,  2487,  3558,  2462,  1018,   512,  1934,   509,  1578,  1042,
    -339,  2728,  1057,  2373,   107,  1075,  3357,  1440,  3184,  1982,
    2206,  3137,   565,  2264,  3358,   114,  2374,   675,   517,  1616,
    2396,  1983,  2797,  2437,  1697,  2680,  2928,  1698,  2507,  3120,
     457,  2508,  2487,   675,  1446,   432,   117, -1997,   118,  2509,
     969,  3389, -1522,  2681,  2403, -1875,  1974,  3489,  1647,   473,
     608,  2077,   446,  2078,   674, -1523, -1876,  1024,  1993,  1994,
    2100,  1996,  1997,  1998,  1303,   714,  2001,  1152,  3390,  1044,
    -340,  2009,  2363,   121,  1076,  2012,  2013,  2014,  1617,  1087,
    2017,  2018,  2019,  2020,  2021,   458,  2026,  2027,  2028,   108,
    3667, -1130,  3455,   115,   717,   718,  2980,  1045,  2729,  1801,
     737,   736,   982,  2149,  2101,  3057,  3668,  1347,  1875,  3560,
     395,  2064,  -339,  3058,  1579,  1619,  1530,  1518,   391,  2226,
    1984,  1970,  1921,  3305,   109,  1887,  3121,  3120,   391,   715,
     518,  2322,   391,   690,  2042,   465,  2397,   391,  1046,  2052,
    1081, -1522,   391,  1047,  3208,  2058,   591,  1447,  2061,  2463,
    1153,  1970,  1482,  3212, -1523,  1386,   433,  2866,   691,  1119,
    1488,  1648,  1922,  1165,   391,  3334,  1394,  1146,  3256,  1069,
     712,  3415,  1354,  1887,  3724,  1932,  2682,   466,  2346,  1620,
    1120,   391,  2488,  2375,  2685,   578,  1531,  2798,  1466,  1501,
    1502,   391,  2721,  1383,  1392,   391,  2694,   474,  2658,  1705,
    1523,   391,  2719,   391,   391,  3395,  1004,  2716,   391,   391,
    1532, -1130,  2497,  3298,  3359,  3396,  2703,  1384,   391,  1427,
    3489,  2723,   391,  2488,   563,  2984,  1944,   391,   391,  1436,
     391,   391,   391,   391,   921,  1935,   923,   924,  2091,   695,
     582,  3059,  3185,  1346,  3561,  1103,  2404,  1483,   467,  1571,
    1622,   703,  1025,  2935,  3335,  1088,  1990,  2510,  1392,  2465,
    3326,  1508,  1104,  3122,  1533,  1879,   391,  1772,  1058,   728,
    -503,  1802,  -340,  1876,  3123,  3414,  1888,   562,  1408,  1428,
    2706,  1070,   391,  1582,   110,   574,  2715,  1803,  1048,  2478,
     391,   391,  3697,  1019,  2885,   391,  2224,  1990,  2399,   959,
    1071,  2367,   391,  2358,  1103,  2495,   609,   610,   611,   612,
     613,   614,  2399,  2167,  -339,  2024,  3203,  2171,  2313, -1130,
    2086,  1104,   615,   993,  1888,  1778,  3139,   677,  1810,  2266,
     978,  3148,   391,   603,  2270,  2271,  2329,  1430,  2242,   990,
   -1522,  1534,  3016, -1875,  1831,   675,   993,  2272,  1114,  2273,
    2209,  3124,  1469, -1523, -1876,  1304,  1346,  1049,  3044,   956,
    2263,   697,   752,  1114, -1130,  1114,  3113,  1527,  1026,  2806,
    1834,  1114,  3123,  3457,  1638, -1522, -1130,  1346, -1875,  2511,
    1498, -1939,  3006,  2381,  1035,  1923, -1130,  2085, -1523, -1876,
    1778,   391,  3562,  2695,  2696,  3392,  2405,  1985,  3337,   391,
    -580,   729,   391,   413,  -249,   391,   391,  1043,  3040,  1509,
    -259,  -260,  1114,  1510, -1939,  2207,  1050,  3397,  1971,  3437,
     506,  3456,  -340,  1699,  3441,  1027,  1700,  1629,  3174,   434,
    2512,  1355,  1356,  1357,   529,   775,  2243,   106,  2436,  3006,
    3041,   391, -2026,   391,  3006,  1778,   119,  2045,  1971,  2655,
    2656,   396,   397,   713,   496,   587,  1386,  3416,  2513,   775,
    1607,  1815,  3443,  -137,  -339,  3250,  3010,  2780,  1583,   435,
    2626,  2627,  2628,  1409,   441,  2257,  2930,   468,   445,  1982,
    1364,  2867,  1384,   831,  1816,  3427,   786,  3429,   414,  1171,
    3065,  1176,  3478,  3548,   788,   583,  1346,  2309,  2324,   469,
    2964,  2652,  2653,  2654,  2968,   971,  2046,  1508,  1647,  1957,
    1907,  1051,  2386,  2983,  2955, -1396,  2965,  1442,   788,  2419,
    2969,  1031,   831,  1475,   470,  2245,   415,  3192,  2638,  2699,
    2426,   803,  2425,  3417,  3201,  1072,   594,  3206,   489,  3180,
    1386,  2413,  1052,  2415,  1386,    40,  1804,  3500,  2420,  1365,
    2454,  2939,   398,  2427,  3173,  3482,  1322,  3484,   491,  1456,
    3398,  1908,  1172,  3418,  2438,  1113,  2440,  2441,  2445,  1940,
     452,  2523,  2524,  1647,  1892,  2447,  2448,   471,   439,  3538,
    1004,  3180,  2004,   400,  1369,  1173,  1907,  3237,  2325,  1410,
    3566,   391,  2246,   391,  1476,   815,   459,  1615,  1969,  1033,
    1881,  1839,  1937,  1063,  2399,   972,  3193,  2047,  1073,  3066,
    1900,  2708,  1942,  1943,   831,  2449,  1946,  1947,   839,   815,
    1521,  1665,   460,  2808,  1794,   391,  1457,  1817,  1033,  1119,
     595,   391,  2428,   477,  1926,  1647,   831,  2450, -1994,  1845,
     569,  3194,  1114,  1882,  1883,  3166,  1480,  1480,  3549,  2689,
    1120,  1616,   675,   831,  2258,  1509,  3026,  1064,  3076,  1510,
    1616,   476,  3217, -1396,  1031,   835,   836,   401,   391,  2451,
     391,  3080,   391,  1389,  2364,  1953,  1209,  3207,  2048,   -55,
    1833,  1373,  2555,   416,   391,   391,  1723,  1521,  2611,  1374,
     836,   675,  1841,    51,   391,   391,   483,  3027,  1975,   596,
     973,  3028,  1059,   478,  1682,   391,  -508,  2604,  1571,  3057,
    1617,   489,  1443,  1458,  3371,  1209,  2383,  3058,  3479,  1617,
    2700,  3687,  3075,  1924,  2429,  2641,  2556,   391,   391,   391,
     391,   570,  1778,  1470,  1471,  3238,  1210,   391,  3347,   391,
    3327,  3328,  1060,  1481,  3029,   391,  1953,  1619,  1727,  3552,
    3553,  1487,  2516,  1618,   488,  1375,  1619,  2521,  2043,  2044,
    1647,  2051,  1616,  2053,  2054,  2055,  2056,  2057,   391,  2059,
    2060,  1477,  2529,  3067,  2247,  1294,  3183,  1472,  1473,  2534,
     507,   498,   455,   675,  2005,  1892,   456,  1953,  1148,  3159,
    3160,   752,   502,  3153,  2543,  2544,  2724,   571,   447,  1818,
     417,  2548,  2269,  1377,  2237,   675,  1954,  1209,  1459,  2553,
     499,  1620,  2606,  3307,   391,   418,  1497,   391,  2238,  2613,
    1620,  1617,   675,  1955,  3175,  2066,  2259,  3176,  1410,  1209,
    2974,  3184,  1119,  3577,  3495,  2938,  1956,   866,  3632,  2498,
     513,   419,  2260,   868,  2067,  3059,   869,  3599,  2571,  1616,
    2817,   534,   535,  1120,  2821,  2049,   420,  3174,  1619,  3068,
     717,   718,  1580,   531,   775,  2107,   391,   868,   391,   391,
     391,  -474,   391,  1760,  3346,  1610,  1611,  1954,   580,  3514,
     493,   391,  1622,   391,   589,  3428,   504,  3430,  1621,  1298,
    1149,  1622,  2950,  1150,  1955,  1894,  1895,  2452,  3177,  3178,
    1616,  3471,   947,  3472,   671,  2951,  1151,  2692,  1617,  1341,
    2108,  1957,   622,   623,  3583,   786,  1892,   391,  1954,   515,
    1613,  1526,  1620,   788,  1378,  2621,   536,  1893,  3252,  2976,
    2976,  2976,  1342,  2644,   403,  1955,  1380,   525,  3465,   527,
    2952,   528,  3618,   530,   402,  1619,   523,   117,  1956,   118,
    1386,   560,  3622,   577,   537,   666,  3599,   391,  1990,  1617,
     803,   423,  3466,  3315,  2278,   717,   718,   581,   538,   436,
    3030,  2279,   685,   948,   442,  1129,  1130,  3031,  1623,  -265,
     403,   591,  1957,   563,  1624,  1625,  1626,  1627,  1628,   726,
     539,   440,  3660,  1622,  2278,   696,  1619,  2251,  1528,   697,
    2252,  2666,   540,  1958,   106,  3032,   919,  3671,   922,  1620,
    1529,   404,   717,   718,   949,   391,  3684,  1386,   706,   664,
     665,   405,   668,  1957,   815,  1992,  1894,  1895,  1995,   950,
     391,   541,   929,  1152,  1349,  1350,  2913,  2007,  2442,   679,
     680,  2443,   681,  3157,   682,   944,  2015,  2832,  2833,   946,
    3711,  3488,  3712,   953,   928,  3291,   542,  1788,  1789,  1629,
    1620,  1953,   543,  1959,  1896,   951, -1130,   109,  1629,   961,
    2313,   962,  3033,  1405,  1958,  1343,  1406,  1778,   976,  1407,
    1622,   963,   831,  2997,  2332,  3017,   391,  1854,  3018,  1855,
     977,   391,   996,   391,   835,   836,  1140,  1141,   391,  2998,
     985,   544,  3001,  3002,   391,   997,   391,  1351,  1352,  2089,
    2090,   391,   391,  1000,   391,  1958,  1153,  3021,  3022,  3019,
    1902,  1903,  1904,  2381,  1001,  3025,   391,  1004,  1621,   391,
    1778,  1622,  3048,  1344,  1959,   391,   391,   391,   391,  2121,
    2122,  2123,  2124,  1953,  1015,   391,   391,   391,  1007,  2436,
    1016, -1130,  1021,  3292,  3293,  3034,  1778,  3294,  3295,  1851,
    1851,  1017,  1851,   391,  2127,  2128,  1022,  2416,  2417,  1031,
    1629,  1530,   391,  2605,  1873,  1959,  1036,   978,  1037,  1826,
    1827,  1828,  1829,  1830,  1038,   990,  1885,  1040,  2439,   391,
    2134,  2135,  1954,  1851,  1851,  1851,  1041,  2853,  2139,  2140,
    3703,   391,  1039,  3394,  2142,  2143,  2144,  2145,   964,  1955,
    2156,  2157,  1056,   391,   545,  2160,  2161,  1066,  2345,   391,
    2349,  2354,  1956,  1067,  1624,  1625,  1626,  1627,  1628,  2173,
    2174,  1080, -1130,   546,  1082, -1130,  2177,  2178,  1083,   547,
    1085,  1531,  2179,  2180,  1090,   548,  1158,  1345,  1346,  1945,
    2610,   675,  1110,  3175,  1856,  2909,  3176,  1629, -1130,  2254,
    2255,  2418,   717,   718, -1130,  1532,   866,  1963,  2617,   549,
    2392,  2345,   868,  1857,  1954,   869,  1111, -1130,   391,  1157,
    2187,  2188, -1130,  2190,  2191,   550,   551,   391,  3498, -1130,
     931,  1955,  1159,  1858,  2199,  2200,  1161,  1957,  1163, -1130,
    2212,  2213,  2231,  2232,  1956,  3509,  1030,  1859,  1629,  2233,
    2234,  1164, -1130,  3567,  1169,   391, -1130,  3161,  3434,  1533,
    1165,  2069,   552,  1178,  1030, -1130,  1358,  3177,  3178,  2282,
    2283,   622,   623,  2472,  2473,  3081,  1820,  1821,   391,  1332,
    1333,   391,  1182,  3199,  3200,  2607,  2608,  2647,  2648,  2732,
    2733,  2641,  1860,  1861,  2803,  2733,  2860,  2861,  1778,  2864,
    2865,  3210,  -551,  2525,  1180,  1537,  1183,  3214,   553,  1184,
     554,  2530,  1538,  2886,  2887,   932,  2910,  2911,  1334,  1957,
    1862,  1185,  1539,  1540,  2992,  1114,  2080, -1130,  1186,  1958,
    3230,  1188,  1335,  3232,  3053,  3054,  1534,  2345,  1189,  3404,
    3131,  3132,   600,   535,  2345,  1190,  3102, -1130,  3254,  3255,
    3260,  3261,  1541,  3263,  3264, -1130,  1542,  3329,  3255,  3409,
    3410,  3412,  3255,  3413,  3255,  1329,  1336,  1543,  3421,  3422,
    3423,  3424,  2686,   933,  1006,  1385,  1544, -1130,  1337,  1863,
    3425,  3424,  1545,  3446,  3447,  3511,  3410,  3512,  3410,  1959,
    3693,  3694,  1822,  1824,  1191,  1546,  1192,   934,  1193,  2978,
    2979,  1194,  1033,  1764,  1765,  1338,  3330,  3331,  2942,  2943,
    1099,  1958,  1195,  1547,  2919,  2920,  1196,   536,  1388, -1130,
    1864,  2688,  1548,  1549,  3129,  3130,  1197,  1198,  1550,  1199,
    1200,  1201,  1204,  1348,  1395,  1206,  1551,  1207,   391,  1208,
    2664,  1212,  1552,  1213, -1130,   537,  1214,  1215,  1398,  1216,
    1217,  2637,  1218,  1219,  1220,  1221,  1222,  1223,  1224,   538,
    1225,  1480,  1339,   675,  1226,  1227,  1228,  1229,  1553,  1230,
    1231,  1959,  1399,  1232,  1233,  1234,  1235,   535,  1236, -1130,
    1237,   539,  1238,   935,  1239,  2602,  1240,  1242,  1243,  1244,
    1245,   936,  1246,   540,  1247,  1248,  1249,  2679,  3116,  1250,
    1251,  1255,  1256,  1257,  1258,  1259,  1260,  1261,  1262,  1263,
    1264,  1402,  3524,  1265,  1554,  1266,  1555,  1268,  1390,   937,
    1270,  1271,   541,  1556, -1130,  1272,  1273,  1274,  1275,  2722,
    1276,  1277,  1278,  1279,  1280,  1281,  2725, -1130, -1130,   391,
    1282,  1283,  1284,  1285,  1286,  1287,  1288,   542,  1289,  1420,
    1290,   536,  1291,   543, -1130,  1292, -1130,   391,   391,  1296,
     938,  1297,  1300,  1421,   391,  1301,   391,   391,  1305,  1306,
    1307,  1311,  1312,  1424,  1313,  1314,  1315,  1316,  1387,   537,
    1403,   939, -1130, -1130,  1400,  3586,  1426,  1432,  1433, -1130,
    1434,  1557,   544,   538,  1435,  1441,  1449,  1187,   940,  1455,
     118,  3604,  1464,  3604,   391,   565,  1558,  1468,  1484,  1489,
    1490,  1559,  1491,  1492,  1494,   539,   391,   391,  1503,  1505,
    1507,  1519,  1584,  1586,  1585,  1587,   391,   540,  1588,  1589,
    1590,  1591,   391,  2731,  1592,   391,  1593,  1594,   391,  1595,
    1596,  1597,  3604,  1598,  1599,  3651,  1600,  1601,  1602,   391,
     391,  1560,   391,  3655,  3155,  2345,   541,  1561,   391,   391,
    1562,  1603,  1606,  1608,  1635,  1640,  1612,  1383,   391,  1647,
     391,  1669,  1304, -1130,   391,   391,  1689,  1703,  1720,  1752,
    3604,   542,  1775,  1563,  1564,  1784,  1565,   543,   963,  1795,
    1809,  3604,  1790,  1832,  1812,  1842,  1843,  1867,  1901,  1870,
    1566,  1915,  1927,  1936,  3604,   545,  1929,  1939,  1961,  1962,
    1965,  1966,  1968,  1976,   391,   391,  2446,  1977,  1978,  1981,
    1979,  1980,  1567,  1982,   546,  1999,   544,  3064,  2000,  2003,
     547,  3604,  3604,  1539,  1540,  3726,   548,  2002,  2010,  2011,
    2008,  2016,  2030,   391,  2079,  2081,  2085,  2098,  2112,  2087,
     391,  2088,  2092,  2131,  2094,  1778,  2095,  2165, -1130,  2096,
     549,  2097,  2482,   391,  2099,  -460,  -460,  1542,  2102,  2103,
    2104,  2120,  2105,  2106,  -460,  2109,   550,   551,  1543,  3381,
    3382,  3383,  3384,  2111,  2113,  2244,  2114,  1544,  2115,  1539,
    1540,  2116,  1127,  1128,  1129,  1130,  1131,  1132,  3376,  2117,
    1133,  1134,  1135,  1136,  1137,  1138,  1546,  1139,  2118,   391,
    2119,  1568,  2125,   552,  2126,   964,  2129,  2249,  2130,  2132,
    1569,  1099,  2133,  1542,  1547,  2136,  2281,  2299,  2137,  2284,
    2138,  1346,  2294,  2317,  1543,  2141,  2286,  2146,  2150,   545,
    2147,  2151, -1130,  1544,  2152,  2153,  2617,  2287,  2154,  2155,
    2158,  -796,  2159,  1552,  2162,  2163,  2164,  2168,   546,   553,
    2166,   554,  1546,  2169,   547, -1130,  1778,  2170,  2172,  3378,
     548, -1130,  2175,  2176,  2181,  2182,  2183,  1099,  2189,  -551,
    1547,  2184,  2185,  2186,  2288,  -551,  2192,  2194,  2195, -1130,
    2196,   391,  2197,  2198,   549,  2201, -1130,  2947,  2202,  2285,
    2203,  2204,  2298,  2205,  2208,  2214, -1130,  2210,  2211,  1552,
     550,   551,  2215,  2392,  2216,  1140,  1141,  2225,  2227, -1130,
    2228,  2229,   391, -1130,  2230,  2235,   391,  1555,   391,   391,
     391,   391, -1130,  2261,  1556,  2268,  1114,  -972,  2300,   391,
    2296,  2304,  2316,   391,  2318,  2319,   391,   552,  1908,  1907,
    2336,  2337,  2338,  2361,  2362,  2369,  2365,  2370,  2387,  2371,
     391,   391,   391,  2394,  1006,  2395,  2421,  2455,  2422,  2469,
    2470,  2474,  2475,   391,  1521,  1641,  2502,  2522,   807,   391,
    2535,   391,  2545,  1555,  2557,  2558,  2577,  1873,  2582,   391,
    1556,  2584,  2586,   553, -1130,   554,  2592,  2589,  2595,  2597,
    2598,  2599,  1557,  2600,  2601,  2609,  2616, -1026,  2629,  2624,
    2631,  2635,  2643,  2646, -1130,  2651,  2663,  1558,  2649,  3677,
    2676,  2668, -1130,  2687,  2693,  2697,  1778,  2698,  2701,  2713,
    2714,  2727,  2793,  2662,  2796,  2800,  2802,  2804,  2807,  2809,
     392,  2812,  2813,  2815, -1130,  2814,  2818,  1778,  2822,  2823,
     391,  2824,   422,  2825,  2826,   428,  3677,  2827,  1557,  2830,
    2925,   391,   437,  1778,   391,  2927,  3266,  2828,  1561,  1892,
    3154,  1562,   448,  1558,  2940,  2948,  1211,  1295,  1299,  2960,
    3614,  2963,   464,  2904,  2829,  2966, -1130,  2834,  2835,  2836,
    2837,  2838,  2279,  2839,  1563,  1564,  2840,  1565,   391,  2841,
    2842,  2843,  2844,  2845,  2847,   391,  2846,  2848,   391,  2849,
    2850, -1130,   391,   391,  2851,  2857,   391,  3350,  2854,  2858,
     482,  2855,  2856,  2859,  1561,  2862,   391,  1562,  2863,  2869,
    2870,  2967,  2871,  1567,  2872,  2873,  2874,  2875,  3216,  2876,
     485,   392,  2877,   392,  2906,  2878, -1130,  2879,  2986,  2880,
    1563,  1564,  2881,  1565,   482,  2883,  2735,  2888,  2889,  2987,
    2890,  2891,  2892,  2894,  2896,  2898,  2899,  2901,  3360,  3361,
    2900,  2902,  2956,  3345,  2801,  3705,  2908,  2912,  2957,  2915,
    2916,  3144,  2929,  2999,  2961,  2985,  3345,  3705,  2981,  1567,
    2995, -1130,  2996,  3024,  3052,  3091,  3082,  3046,  3047,  3049,
    3084,  3093,  3072,  3086,  3087, -1130,  3204,  3088,  3098,  3099,
    3100,  3111,  3705,  3108,  3109,  3110,  3115,  3127,  3134,  3138,
    3140, -1130,  1568, -1130,  3141,  3132,  2666,  2332,  3145,  3146,
    3151,  1569,  3149,  3152,  3156, -1060, -1065,  3167,  3165,  3171,
    3172,  3190,  3191,  3198,  2345,  3043,  3211,  3213,  3040, -1130,
   -1130,  3426,  3209,  3220,  3221,  3225, -1130,  3235,  3222,  3224,
    3226,  3227,  3228,  3229,  2392,  3231,  3240,  3257,  3241,  3244,
    3258,  3259,  3262,  3265,  3267,  3273,   677,  3268,  1568,  3270,
    3274,  3299,  3269,  3308,  3271,  3314,  3272,  1569,  3275,  3286,
    2491,   391,   391,  3276,   391,  3277,  3438,  3282,  3287,  3278,
    3288,  3351,  3279,   391,  3280,  3323,  3281,  3317,  3319,   391,
    3284,  3311,  1006,  3312,  1539,  1540,  3341,  3342,  3352,   391,
    3349,  3353,  3354,  3355,  3356,  3365,  3261,   391,  3367,  3373,
    3368,  3370,  3374,  3380,  3386,  3387,  3401,  3403,  3406,  3408,
    3411,  3431,  3432,  3433,   391,  3458,  -460,  -460,  1542,  3460,
    3461,  3463,  3462,  3469,  3366,  -460,   391,  3444,  3445,  1543,
    3448,  3449,  3450,   391,  2465,  3477,  3493,  3485,  1544,  3487,
     391,  3486,  3494,  3497,  3504,  3506,   391,  3507,  3513,  3515,
    2473,  3534,  2947,   677,  3545,  3546,  3536,  1546,  -211,  3569,
    3564,  3570,  3593,  3571,  3577,  3594,   677,  3595, -1190,  3483,
    3613,  3605,  1099,  3612,  3616,  1547,  3617,  3623,  3624,  3618,
    3627,  3628,  3630, -1797,  3634,  3652,  3644,  3656,  3662,  3659,
    3663,  3657,  3664,  3669,  3678,  3672,  3665,  3670,  3690,  3685,
    3683,  3688,  3689,  3699,  1552,  3502,  3503,  3701,  3505,  3708,
    3722,  2345,  2280,  3727,  2062,  1107,  3609,  3369,   526,  3440,
     391,  3363,   620,  3729,   582,   621,  3704,  3710,   559,  3641,
    3600,  3642,   567,  3608,  3251,  1525,   514,   482,  3074,  3325,
    2029,  1605,   586,  2486,  2466,  2406,  2033,   622,   623,  3542,
    2993,  3543,  3544,  1986,  3343,  3050,  3011,   624,  3182,   625,
    3012,  3223,  3476,  2988,   482,  3215,  2954,  2989,  3480,  3340,
    3589,  3420,  2493,  3372,  1634,  2456,  3348,   626,  1555,   627,
    1950,   686,  2301,  1884,  2634,  1556,  2297,   628,  1506,  1095,
    2320,   482,  1604,   683,  1011,   482,  1118,  3388,  3117,  3285,
    1906,   708,  3118,   482,   482,  1819,  1719,  2962,   720,   567,
    1814,  2519,  3475,  2071,  3589,  3435,  2614,  3322,   739,   391,
    1667,  3636,   744,  1437,  3310,  2991,  2327,   920,   392,  2307,
     392,   392,   567,   482, -1374,   629,  3136,  2293,  2932,   630,
    2973,  2933,   391,  3695,  1175,  3537,   672,  1639,   745,  1419,
    1941,   658,  2926,  1557,  3610,  3588,  3491,   391,  1844,  3464,
    3508,  3709,  1439,  3219,  1916,  2936,   968,  2958,  1558,   631,
    3150,   632,  2684,  3313,   602,   999,  1453,  1878,  1412,   677,
    3379,  1444,   482,   633,  1609,   634,  1003,  2623,  3385,   604,
     567,   482,  1786,  3283,   698,   482,  1170,  2481,   391,  3071,
       0,  3249,   482,     0,     0,     0,     0,     0,   635,   636,
       0,     0,   637,     0,     0,   677,   677,     0,   677,  1561,
     391,     0,  1562,     0,     0,     0,     0,     0,     0,   638,
       0,     0,   567,     0,     0,     0,     0,     0,     0,     0,
     391,     0,     0,     0,     0,  1563,  1564,     0,  1565,     0,
     639,     0,     0,     0,     0,   640,     0,     0,     0,   677,
       0,   677,   677,     0,     0,   391,     0,   391,     0,     0,
       0,  3539,     0,     0,     0,     0,     0,   391,     0,   641,
       0,     0,     0,   391,  1567,     0,     0,     0,     0,     0,
       0,  1098,     0,     0,     0,     0,     0,     0,     0,   567,
       0,     0,   482,     0,     0,  1117,   482,     0,     0,     0,
       0,     0,   642,     0,     0,     0,     0,     0,     0,     0,
       0,   643,     0,     0,     0,  3243,     0,  1539,  1540,  3491,
     391,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,   482,     0,  1177,     0,     0,  2345,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   391,  -460,
    -460,  1542,     0,     0,     0,   645,   646,     0,  -460,   647,
     648,     0,  1543,  1568,     0,     0,     0,     0,   391,     0,
       0,  1544,  1569,     0,   391,   391,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   391,     0,
    1546,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1099,     0,   391,  1547,     0,
    3719,     0,     0,     0,     0,     0,     0,   649,     0,     0,
       0,     0,   650,     0,     0,     0,     0,     0,     0,  2072,
       0,     0,   651,     0,     0,  3719,     0,  1552,     0,     0,
       0,     0,  1537,     0,     0,   391,     0,     0,     0,  1538,
       0,     0,     0, -1822,     0,     0,     0,   652,   391,  1539,
    1540,     0,     0,     0,     0,     0,     0,     0,  3728,     0,
       0,  3692,   653,     0,     0,     0,     0,     0,     0,     0,
       0,  1326,     0,  1328,     0,     0,     0,     0,     0,  1541,
       0,     0,     0,  1542,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1543,     0,     0,     0,     0,     0,
       0,  1555,     0,  1544,     0,   482,     0,     0,  1556,  1545,
       0,   482,     0,     0,     0,     0, -1822,     0,     0,     0,
     654,     0,  1546,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1099,     0,     0,
    1547,     0,     0,     0,     0,     0,     0,     0,  1413,  1548,
    1416,     0,   482,     0,     0,  1550,     0,     0,     0,     0,
       0,   391,     0,  1551,   482,   567,     0,     0,     0,  1552,
       0,     0,     0,     0,   482,   482,  1557,     0,     0,   391,
     391,     0,     0,     0,     0,  1445,     0,     0,     0,     0,
       0,  1558,     0,  1454,     0,  1553,     0,     0,     0,   391,
       0,   391,     0,   391,   391,     0,     0,   392,   392,   482,
     482,     0,     0,     0,     0,   391,     0,   392,     0,   567,
       0,     0,     0,     0,     0,   392,     0,     0,  3454,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1561,  1555,     0,  1562,     0,     0,   482,     0,
    1556,   391,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,  1564,
       0,  1565,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3531,     0,     0,     0,     0,
     391,     0,     0,     0,   482,     0,     0,   482,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1567,     0,   391,
       0,     0,  3531,  3531,   391,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   391,  1558,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,   391,     0,     0,   567,     0,   567,   392,
     392,     0,   482,  3531,  3531,     0,     0,     0,  3531,     0,
       0,   744,     0,  1642,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3531,     0,  3531,     0,  1560,     0,
       0,     0,     0,     0,  1561,     0,     0,  1562,     0,     0,
       0,     0,  3531,     0,     0,     0,  1568,  1676,     0,     0,
       0,  3531,     0,     0,     0,  1569,     0,     0,   391,     0,
    1563,  1564,     0,  1565,     0,  3531,     0,   391,  3531,     0,
       0,     0,     0,     0,     0,     0,  3531,  1566,     0,     0,
       0,     0,  3531,     0,     0,     0,     0,  1676,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3531,     0,  1567,
     391,     0,   391,  3531,     0,     0,  3531,     0,   391,     0,
       0,     0,     0,     0,  3531,     0,     0,   391,     0,     0,
       0,   391,     0,     0,     0,     0,     0,  3531,     0,     0,
       0,     0,     0,     0,     0,     0,     1,   391,     0,     0,
    3531,     0,  3531,   391,     0,  1779,     2,     3,     0,     0,
       0,     0,     0,     0,  3531,  3531,     0,     0,  3531,     4,
     567,     5,     0,     0,     0,     0,     0,     0,   391,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     8,     0,  1568,     0,
       9,    10,     0,     0,     0,     0,     0,  1569,     0,     0,
       0,     0,     0,    11,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   567,     0,     0,     0,
      12,  1837,     0,   567,     0,     0,     0,     0,   567,     0,
       0,     0,     0,     0,   482,     0,  1847,     0,     0,    13,
       0,  1852,  1852,     0,  1852,     0,     0,     0,    14,    15,
      16,     0,     0,     0,     0,     0,   482,     0,     0,   482,
       0,    17,    18,     0,     0,   567,   567,   482,   482,     0,
       0,     0,     0,     0,     0,  1852,  1852,  1852,     0,  1360,
    1361,  1362,  1363,  1364,    19,     0,     0,     0,     0,     0,
       0,     0,     0,  1919,     0,     0,     0,     0,     0,     0,
       0,    20,  1930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1938,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
       0,   482,    22,     0,     0,    23,     0,     0,     0,     0,
       0,     0,     0,  1952,     0,     0,     0,     0,     0,   482,
       0,     0,  1365,     0,     0,     0,    24,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1366,  1367,  1368,  1369,     0,     0,
      26,     0,     0,     0,     0,    27,     0,     0,     2,     3,
       0,     0,     0,     0,     0,     0,     0,     0,  2036,     0,
       0,     4,     0,     0,     0,     0,     0,  2040,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     8,     0,
       0,     0,     9,    10,     0,   392,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    11,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   482,     0,
       0,  2083,    12,     0,     0,     0,     0,     0,     0,     0,
    1370,    28,  1371,  1372,  1373,     0,     0,     0,     0,     0,
       0,    13,  1374,     0,     0,     0,     0,     0,     0,     0,
      14,    15,    16,    29,     0,     0,     0,     0,     0,     0,
       0,     0,    30,    17,    18,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,    32,    33,    19,     0,    34,     0,
       0,    35,     0,    36,     0,     0,     0,     0,    37,     0,
      38,     0,     0,    20,     0,     0,     0,     0,  1375,    39,
       0,     0,     0,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,    21,     0,    42,
       0,     0,     0,    43,    22,     0,     0,    23,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,  1376,  1377,    45,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,     0,     0,     0,  2250,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    26,    46,     0,     0,     0,    27,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    48,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    51,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1378,     0,  2314,
       0,     0,     0,    28,     0,     0,     0,     0,  1379,  1380,
       0,     0,     0,     0,     0,     0,     0,  2333,  2335,     0,
       0,     0,     0,     0,   567,    29,   567,   567,     0,     0,
       0,     0,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,    32,    33,     0,     0,
      34,     0,     0,    35,  1779,    36,     0,     0,     0,     0,
      37,     0,    38,     0,     0,     0,   567,   567,     0,     0,
       0,    39,     0,     0,     0,    40,  2036,     0,     0,     0,
       0,     0,  2036,     0,     0,  2036,    41,     0,  2036,     0,
       0,    42,     0,     0,     0,    43,     0,     0,     0,  2036,
    2036,     0,   567,     0,     0,     0,     0,     0,  2036,  1779,
       0,     0,     0,     0,     0,    44,     0,     0,   482,    45,
     567,     0,     0,     0,  2036,  2461,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,   482,  2036,     0,  2736,  2737,     0,
       0,    47,     0,  2738,    48,  2739,   891,  2740,  2741,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2742,   567,     0,     0,     0,     0,     0,     0,
     567,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2526,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,   970,
       0,     0,     0,  2743,     0,     0,  2744,     0,     0,     0,
       0,     0,     0,     0,  2745,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1676,
       0,     0,     0,  2746,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2747,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2748,     0,  2749,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2750,  2751,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   567,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1126,     0,     0,  2752,     0,     0,     0,     0,     0,     0,
       0,     0,  2622,     0,     0,     0,  1847,     0,   968,   567,
     567,   567,     0,     0,     0,     0,     0,     0,     0,   482,
       0,     0,  2753,   567,     0,     0,  1779,     0,     0,     0,
       0,  2754,  2755,     0,  2756,     0,     0,     0,     0,     0,
     567,   567,   567,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2665,     0,     0,     0,     0,     0,  2667,
       0,  2669,  2757,  2758,  2759,     0,     0,  3533,     0,   567,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2760,  2761,  2762,     0,     0,     0,  2763,
       0,  1241,  2764,     0,  3533,  3533,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2765,  2766,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2036,  2767,     0,  2768,     0,  3533,  3533,     0,     0,     0,
    3533,   567,     0,     0,  2036,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3533,  2769,  3533,     0,
       0,     0,     0,     0,     0,     0,  1317,     0,     0,     0,
    1324,     0,     0,     0,  3533,     0,     0,     0,   482,     0,
       0,     0,     0,  3533,     0,  2734,     0,     0,   482,     0,
       0,     0,  2790,  2791,     0,     0,  2794,  3533,     0,     0,
    3533,     0,     0,     0,     0,  2770,   482,  2771,  3533,     0,
       0,     0,     0,     0,  3533,     0,     0,  2772,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3533,
       0,     0,     0,     0,     0,  3533,     0,     0,  3533,     0,
       0,     0,     0,     0,     0,     0,  3533,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3533,
       0,  2773,  2774,     0,     0,  2775,  2776,  2777,  2778,     0,
       0,     0,  3533,     0,  3533,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3533,  3533,     0,     0,
    3533,     0,     0,     0,  1452,     0,     0,     0,     0,     0,
       0,     0,     0,  1467,     0,     0,     0,     0,  2779,  2780,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2781,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2314,  2937,     0,   567,     0,     0,     0,     0,     0,
       0,     0,     0,   567,     0,     0,     0,     0,     0,  2622,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   567,
       0,     0,     0,     0,     0,     0,     0,  1919,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1779,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2036,     0,     0,     0,
       0,     0,     0,  2036,     0,     0,     0,     0,     0,     0,
    1779,     0,     0,     0,     0,     0,  2036,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1644,  1645,  1646,     0,
       0,     0,     0,     0,     0,  1655,  1656,     0,     0,  1659,
       0,  1661,  1662,  1663,  1664,     0,     0,     0,  1668,     0,
       0,  1670,  1671,     0,  1672,     0,  1673,  1674,     0,  1677,
    1678,  1679,  1680,  1681,     0,  1684,     0,  1686,  1687,  1688,
       0,  1690,  1691,  1692,  1693,     0,  1695,  1696,     0,  1702,
       0,     0,  1706,  1707,  1708,     0,  1710,  1711,  1712,  1713,
    3079,  1715,  1716,  1717,  1718,     0,     0,     0,     0,     0,
    1725,  1726,     0,  1729,  1730,  1731,  1732,  1733,     0,     0,
       0,     0,  1737,     0,  1738,  1739,  1740,  1741,  1742,     0,
       0,  1745,  1747,  1748,  1749,  1750,  1751,     0,  1753,  1754,
       0,     0,  1757,  1758,  1759,     0,  1762,     0,  1763,     0,
       0,     0,  1766,     0,  1770,  1771,     0,     0,     0,     0,
    1774,     0,     0,     0,     0,     0,     0,     0,  1781,  1782,
    1783,     0,     0,     0,     0,     0,     0,  1324,     0,     0,
    1791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3114,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1779,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   567,     0,  1835,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3079,     0,
       0,     0,     0,  1880,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     567,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     567,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3233,     0,  3234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   482,     0,     0,
       0,     0,     0,  3248,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   567,     0,
    2041,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3321,     0,
       0,     0,     0,     0,  3079,  3079,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3339,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   567,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3079,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2218,  2220,  2222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3248,     0,  2262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1779,
     482,     0,     0,     0,     0,     0,  2274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3321,
       0,  3321,     0,  3473,  2040,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3481,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3501,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1779,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3547,
       0,     0,     0,     0,  3554,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   567,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3638,     0,
       0,     0,     0,     0,     0,     0,     0,  3649,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2500,     0,     0,  2501,     0,     0,  2503,  2504,     0,
    1779,     0,  3680,     0,     0,     0,     0,     0,  3686,     0,
    2517,     0,     0,  2520,     0,     0,     0,   567,     0,     0,
       0,  1779,     0,     0,     0,     0,  2527,     0,  2528,     0,
       0,     0,  2531,     0,  2532,  2533,     0,  1779,     0,  2536,
       0,  2537,  2538,  3720,  2539,     0,     0,  2540,     0,  2541,
    2542,     0,     0,     0,     0,  2546,  2547,     0,     0,  2549,
       0,  2550,     0,  2551,     0,  2552,     0,  2554,  3720,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2559,  2560,
       0,     0,  2561,     0,  2562,     0,     0,     0,     0,     0,
       0,     0,  2563,  2564,     0,  2565,     0,  2566,     0,     0,
    2567,  2568,  2569,     0,  2570,     0,     0,     0,     0,  2573,
    2574,  2575,  2576,     0,     0,     0,     0,  2578,  2579,  2580,
       0,  2581,     0,  2583,     0,  2585,     0,  2587,     0,  2588,
       0,     0,     0,     0,     0,     0,  2590,     0,  2591,     0,
       0,  2593,  2594,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2603,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2612,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2674,     0,     0,     0,     0,  2678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2709,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2712,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2882,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2893,     0,  2895,     0,
    2897,     0,     0,     0,     0,     0,  2903,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2914,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2959,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3085,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3089,     0,     0,     0,     0,     0,
    3090,     0,     0,     0,     0,     0,     0,     0,     0,  3094,
    3095,     0,     0,     0,     0,  3096,     0,     0,     0,  3097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3101,     0,     0,     0,     0,     0,  3103,     0,
       0,  3104,  3105,     0,  3106,  3107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3112,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3163,  3164,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2709,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2709,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2674,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3375,     0,
       0,     0,     0,     0,  3377,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3393,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3405,     0,  3407,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2709,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3496,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3510,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3575,
    3576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3596,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3607,     0,
       0,     0,     0,  3611,     0,     0,     0,     0,     0,     0,
       0,     0,  3621,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   122,     0,   746,   124,   125,   126,   127,     0,
       0,     0,     0,  3653,   128,     0,     0,   747,     0,   748,
     130,   131,   749,   133,  3661,   134,   750,   135,     0,   751,
     136,   752,   753,   754,   137,   755,     0,   138,   139,   140,
    1767,   141,     0,   142,   143,     0,     0,   144,   756,   145,
       0,   146,   757,   758,   148,     0,   149,   150,   151,   759,
     152,     0,   760,   154,     0,   155,   156,   157,   158,   159,
     761,   762,   160,     0,   161,   162,     0,   763,   164,     0,
     764,   765,   766,   165,     0,  3721,   166,   767,   768,     0,
     769,   770,     0,   167,   168,   771,   772,   773,     0,     0,
       0,     0,   774,   171,   775,     0,     0,   776,   777,   172,
       0,   173,     0,     0,     0,   778,   779,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   780,   182,     0,   781,   782,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   783,
       0,   191,   784,   192,   785,   786,   193,   194,     0,   787,
     195,   196,   197,   788,     0,   198,     0,     0,   789,     0,
     199,   200,     0,   790,   201,     0,   202,   791,   792,   793,
     794,     0,   795,   796,   204,   797,   798,   799,   206,     0,
     207,   800,     0,   801,   802,     0,   208,   209,     0,   210,
     803,     0,   211,     0,     0,     0,   804,   213,   214,   215,
     805,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     806,   219,   807,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   808,
     226,     0,  1768,   809,   227,     0,   810,   228,     0,     0,
       0,   811,     0,   812,     0,   230,   813,     0,   231,     0,
     232,   814,     0,     0,   815,     0,     0,     0,     0,   816,
     233,   234,   235,   236,   237,   238,   817,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   818,   248,   249,   250,
     819,   251,   252,     0,     0,     0,   253,   254,   255,   820,
     257,     0,     0,   821,   259,   822,   823,   260,     0,   261,
     824,   825,   826,   827,   828,   829,   830,   266,   267,   268,
     269,     0,   831,   270,   271,     0,   272,   273,   274,   832,
     833,   834,   275,     0,   835,   836,     0,   276,   277,     0,
     837,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   838,   839,
     286,   840,   841,   842,   843,   844,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   845,   297,   298,
     299,   300,   301,   302,   303,   846,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   847,   848,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   849,   318,   319,   850,   320,   321,   851,
     322,   852,   324,   325,     0,   853,   327,     0,   328,   329,
     330,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,   854,
     855,   349,   350,     0,   351,   856,   353,   857,   858,   859,
     354,   355,   356,   357,   860,   358,   359,     0,   360,   361,
       0,   675,   362,   861,   862,   863,   864,     0,     0,     0,
       0,  1769,   367,     0,   368,   865,   866,   867,   370,   371,
     372,     0,   868,   373,   374,   869,     0,   375,     0,     0,
     870,   871,   376,     0,     0,   377,     0,   378,     0,   872,
     380,     0,     0,   873,   874,   875,   876,   877,   381,     0,
       0,   382,   878,     0,   383,   384,   879,     0,     0,     0,
       0,   386,     0,   387,   388,     0,   880,     0,   881,     0,
       0,     0,     0,   882,     0,     0,     0,   883,   884,     0,
       0,     0,     0,   885,     0,   886,     0,     0,   887,   888,
       0,   889,   890,   122,     0,   746,   124,   125,   126,   127,
    2670,     0,     0,     0,     0,   128,     0,     0,   747,     0,
     748,   130,   131,   749,   133,     0,   134,   750,   135,     0,
    2671,   136,   752,   753,   754,   137,   755,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   756,
     145,     0,   146,   757,   758,   148,     0,   149,   150,   151,
     759,   152,     0,   760,   154,     0,   155,   156,   157,   158,
     159,   761,   762,   160,     0,   161,   162,     0,   763,   164,
       0,   764,   765,   766,   165,     0,     0,   166,   767,   768,
       0,   769,   770,     0,   167,   168,   771,   772,   773,     0,
       0,     0,     0,   774,   171,   775,     0,     0,   776,  2672,
     172,     0,   173,     0,     0,     0,   778,   779,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   780,   182,     0,   781,   782,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     783,     0,   191,   784,   192,   785,   786,   193,   194,     0,
     787,   195,   196,   197,   788,     0,   198,     0,     0,   789,
       0,   199,   200,     0,   790,   201,     0,   202,   791,   792,
     793,   794,     0,   795,   796,   204,   797,   798,   799,   206,
       0,   207,   800,     0,   801,   802,     0,   208,   209,     0,
     210,   803,     0,   211,     0,     0,     0,   804,   213,   214,
     215,   805,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   806,   219,   807,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     808,   226,     0,     0,   809,   227,     0,   810,   228,     0,
       0,     0,   811,     0,   812,     0,   230,   813,     0,   231,
       0,   232,   814,     0,     0,   815,     0,     0,     0,     0,
     816,   233,   234,   235,   236,   237,   238,   817,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   818,   248,   249,
     250,   819,   251,   252,     0,     0,     0,   253,   254,   255,
     820,   257,     0,     0,   821,   259,   822,   823,   260,     0,
     261,   824,   825,   826,   827,   828,   829,   830,   266,   267,
     268,   269,     0,   831,   270,   271,     0,   272,   273,   274,
     832,   833,   834,   275,     0,   835,   836,     0,   276,   277,
       0,   837,  2673,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   838,
     839,   286,   840,   841,   842,   843,   844,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   845,   297,
     298,   299,   300,   301,   302,   303,   846,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   847,   848,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   849,   318,   319,   850,   320,   321,
     851,   322,   852,   324,   325,     0,   853,   327,     0,   328,
     329,   330,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
     854,   855,   349,   350,     0,   351,   856,   353,   857,   858,
     859,   354,   355,   356,   357,   860,   358,   359,     0,   360,
     361,     0,   675,   362,   861,   862,   863,   864,     0,     0,
       0,     0,     0,   367,     0,   368,   865,   866,   867,   370,
     371,   372,     0,   868,   373,   374,   869,     0,   375,     0,
       0,   870,   871,   376,     0,     0,   377,     0,   378,     0,
     872,   380,     0,     0,   873,   874,   875,   876,   877,   381,
       0,     0,   382,   878,     0,   383,   384,   879,     0,     0,
       0,     0,   386,     0,   387,   388,     0,   880,     0,   881,
       0,     0,     0,     0,   882,     0,     0,     0,   883,   884,
       0,     0,     0,     0,   885,     0,   886,     0,     0,   887,
     888,     0,   889,   890,   122,     0,   746,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   747,
       0,   748,   130,   131,   749,   133,     0,   134,   750,   135,
       0,   751,   136,   752,   753,   754,   137,   755,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     756,   145,     0,   146,   757,   758,   148,     0,   149,   150,
     151,   759,   152,     0,   760,   154,     0,   155,   156,   157,
     158,   159,   761,   762,   160,     0,   161,   162,     0,   763,
     164,     0,   764,   765,   766,   165,     0,     0,   166,   767,
     768,     0,   769,   770,     0,   167,   168,   771,   772,   773,
       0,     0,     0,     0,   774,   171,   775,     0,     0,   776,
     777,   172,     0,   173,     0,     0,     0,   778,   779,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   780,   182,     0,   781,   782,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   783,     0,   191,   784,   192,   785,   786,   193,   194,
       0,   787,   195,   196,   197,   788,     0,   198,     0,     0,
     789,     0,   199,   200,     0,   790,   201,     0,   202,   791,
     792,   793,   794,     0,   795,   796,   204,   797,   798,   799,
     206,     0,   207,   800,     0,   801,   802,     0,   208,   209,
       0,   210,   803,     0,   211,     0,     0,     0,   804,   213,
     214,   215,   805,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   806,   219,   807,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   808,   226,     0,     0,   809,   227,     0,   810,   228,
       0,     0,     0,   811,     0,   812,     0,   230,   813,     0,
     231,     0,   232,   814,     0,     0,   815,     0,     0,     0,
       0,   816,   233,   234,   235,   236,   237,   238,   817,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   818,   248,
     249,   250,   819,   251,   252,     0,     0,     0,   253,   254,
     255,   820,   257,     0,     0,   821,   259,   822,   823,   260,
       0,   261,   824,   825,   826,   827,   828,   829,   830,   266,
     267,   268,   269,     0,   831,   270,   271,     0,   272,   273,
     274,   832,   833,   834,   275,     0,   835,   836,     0,   276,
     277,     0,   837,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     838,   839,   286,   840,   841,   842,   843,   844,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   845,
     297,   298,   299,   300,   301,   302,   303,   846,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   847,   848,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   849,   318,   319,   850,   320,
     321,   851,   322,   852,   324,   325,     0,   853,   327,  1322,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,   854,   855,   349,   350,     0,   351,   856,   353,   857,
     858,   859,   354,   355,   356,   357,   860,   358,   359,     0,
     360,   361,     0,   675,   362,   861,   862,   863,   864,     0,
       0,     0,     0,     0,   367,     0,   368,   865,   866,   867,
     370,   371,   372,     0,   868,   373,   374,   869,     0,   375,
       0,     0,   870,   871,   376,     0,     0,   377,     0,   378,
       0,   872,   380,     0,     0,   873,   874,   875,   876,   877,
     381,     0,     0,   382,   878,     0,   383,   384,   879,     0,
       0,     0,     0,   386,     0,   387,   388,     0,   880,     0,
     881,     0,     0,     0,     0,   882,     0,     0,     0,   883,
     884,     0,     0,     0,     0,   885,     0,  1323,     0,     0,
     887,   888,     0,   889,   890,   122,     0,   746,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     747,     0,   748,   130,   131,   749,   133,     0,   134,   750,
     135,     0,   751,   136,   752,   753,   754,   137,   755,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   756,   145,     0,   146,   757,   758,   148,     0,   149,
     150,   151,   759,   152,     0,   760,   154,     0,   155,   156,
     157,   158,   159,   761,   762,   160,     0,   161,   162,     0,
     763,   164,     0,   764,   765,   766,   165,     0,     0,   166,
     767,   768,     0,   769,   770,     0,   167,   168,   771,   772,
     773,     0,     0,     0,     0,   774,   171,   775,     0,     0,
     776,   777,   172,     0,   173,     0,     0,     0,   778,   779,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   780,   182,     0,   781,
     782,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   783,     0,   191,   784,   192,   785,   786,   193,
     194,     0,   787,   195,   196,   197,   788,     0,   198,     0,
       0,   789,     0,   199,   200,     0,   790,   201,     0,   202,
     791,   792,   793,   794,     0,   795,   796,   204,   797,   798,
     799,   206,     0,   207,   800,     0,   801,   802,     0,   208,
     209,     0,   210,   803,     0,   211,     0,     0,     0,   804,
     213,   214,   215,   805,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   806,   219,   807,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   808,   226,     0,     0,   809,   227,     0,   810,
     228,     0,     0,     0,   811,     0,   812,     0,   230,   813,
       0,   231,     0,   232,   814,     0,     0,   815,     0,     0,
       0,     0,   816,   233,   234,   235,   236,   237,   238,   817,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   818,
     248,   249,   250,   819,   251,   252,     0,     0,     0,   253,
     254,   255,   820,   257,     0,     0,   821,   259,   822,   823,
     260,     0,   261,   824,   825,   826,   827,   828,   829,   830,
     266,   267,   268,   269,     0,   831,   270,   271,     0,   272,
     273,   274,   832,   833,   834,   275,     0,   835,   836,     0,
     276,   277,     0,   837,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   838,   839,   286,   840,   841,   842,   843,   844,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     845,   297,   298,   299,   300,   301,   302,   303,   846,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   847,   848,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   849,   318,   319,   850,
     320,   321,   851,   322,   852,   324,   325,     0,   853,   327,
       0,   328,   329,   330,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   854,   855,   349,   350,     0,   351,   856,   353,
     857,   858,   859,   354,   355,   356,   357,   860,   358,   359,
       0,   360,   361,     0,   675,   362,   861,   862,   863,   864,
       0,     0,     0,     0,     0,   367,     0,   368,   865,   866,
     867,   370,   371,   372,     0,   868,   373,   374,   869,     0,
     375,     0,     0,   870,   871,   376,     0,     0,   377,     0,
     378,     0,   872,   380,     0,     0,   873,   874,   875,   876,
     877,   381,     0,     0,   382,   878,     0,   383,   384,   879,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   880,
       0,   881,     0,     0,     0,     0,   882,     0,     0,     0,
     883,   884,     0,     0,     0,     0,   885,     0,   886,  1606,
       0,   887,   888,     0,   889,   890,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,   777,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   329,   330,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,   854,   855,   349,   350,     0,   351,   856,
     353,   857,   858,   859,   354,   355,   356,   357,   860,   358,
     359,     0,   360,   361,     0,   675,   362,   861,   862,   863,
     864,     0,     0,     0,     0,     0,   367,     0,   368,   865,
     866,   867,   370,   371,   372,     0,   868,   373,   374,   869,
       0,   375,     0,     0,   870,   871,   376,     0,     0,   377,
       0,   378,     0,   872,   380,     0,     0,   873,   874,   875,
     876,   877,   381,     0,     0,   382,   878,     0,   383,   384,
     879,     0,     0,     0,     0,   386,     0,   387,   388,     0,
     880,     0,   881,     0,     0,     0,     0,   882,     0,     0,
       0,   883,   884,     0,     0,     0,     0,   885,     0,   886,
    1709,     0,   887,   888,     0,   889,   890,   122,     0,   746,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   747,     0,   748,   130,   131,   749,   133,     0,
     134,   750,   135,     0,   751,   136,   752,   753,   754,   137,
     755,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   756,   145,     0,   146,   757,   758,   148,
       0,   149,   150,   151,   759,   152,     0,   760,   154,     0,
     155,   156,   157,   158,   159,   761,   762,   160,     0,   161,
     162,     0,   763,   164,     0,   764,   765,   766,   165,     0,
       0,   166,   767,   768,     0,   769,   770,     0,   167,   168,
     771,   772,   773,     0,     0,     0,     0,   774,   171,   775,
       0,     0,   776,   777,   172,     0,   173,     0,     0,     0,
     778,   779,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   780,   182,
       0,   781,   782,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   783,     0,   191,   784,   192,   785,
     786,   193,   194,     0,   787,   195,   196,   197,   788,     0,
     198,     0,     0,   789,     0,   199,   200,     0,   790,   201,
       0,   202,   791,   792,   793,   794,     0,   795,   796,   204,
     797,   798,   799,   206,     0,   207,   800,     0,   801,   802,
       0,   208,   209,     0,   210,   803,     0,   211,     0,     0,
       0,   804,   213,   214,   215,   805,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   806,   219,   807,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   808,   226,     0,     0,   809,   227,
       0,   810,   228,     0,     0,     0,   811,     0,   812,     0,
     230,   813,     0,   231,     0,   232,   814,     0,     0,   815,
       0,     0,     0,     0,   816,   233,   234,   235,   236,   237,
     238,   817,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   818,   248,   249,   250,   819,   251,   252,     0,     0,
       0,   253,   254,   255,   820,   257,     0,     0,   821,   259,
     822,   823,   260,     0,   261,   824,   825,   826,   827,   828,
     829,   830,   266,   267,   268,   269,     0,   831,   270,   271,
       0,   272,   273,   274,   832,   833,   834,   275,     0,   835,
     836,     0,   276,   277,     0,   837,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   838,   839,   286,   840,   841,   842,   843,
     844,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   845,   297,   298,   299,   300,   301,   302,   303,
     846,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   847,   848,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   849,   318,
     319,   850,   320,   321,   851,   322,   852,   324,   325,     0,
     853,   327,     0,   328,   329,   330,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,   854,   855,   349,   350,     0,   351,
     856,   353,   857,   858,   859,   354,   355,   356,   357,   860,
     358,   359,     0,   360,   361,     0,   675,   362,   861,   862,
     863,   864,     0,     0,     0,     0,     0,   367,     0,   368,
     865,   866,   867,   370,   371,   372,     0,   868,   373,   374,
     869,     0,   375,     0,     0,   870,   871,   376,     0,     0,
     377,     0,   378,     0,   872,   380,     0,     0,   873,   874,
     875,   876,   877,   381,     0,     0,   382,   878,     0,   383,
     384,   879,     0,     0,     0,     0,   386,     0,   387,   388,
       0,   880,     0,   881,     0,     0,     0,     0,   882,     0,
       0,     0,   883,   884,     0,     0,     0,     0,   885,     0,
     886,  1746,     0,   887,   888,     0,   889,   890,   122,     0,
     746,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   747,     0,   748,   130,   131,   749,   133,
       0,   134,   750,   135,     0,   751,   136,   752,   753,   754,
     137,   755,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   756,   145,     0,   146,   757,   758,
     148,     0,   149,   150,   151,   759,   152,     0,   760,   154,
       0,   155,   156,   157,   158,   159,   761,   762,   160,     0,
     161,   162,     0,   763,   164,     0,   764,   765,   766,   165,
       0,     0,   166,   767,   768,     0,   769,   770,     0,   167,
     168,   771,   772,   773,     0,     0,     0,     0,   774,   171,
     775,     0,     0,   776,   777,   172,     0,   173,     0,     0,
       0,   778,   779,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   780,
     182,     0,   781,   782,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   783,     0,   191,   784,   192,
     785,   786,   193,   194,     0,   787,   195,   196,   197,   788,
       0,   198,     0,     0,   789,     0,   199,   200,     0,   790,
     201,     0,   202,   791,   792,   793,   794,     0,   795,   796,
     204,   797,   798,   799,   206,     0,   207,   800,     0,   801,
     802,     0,   208,   209,     0,   210,   803,     0,   211,     0,
       0,     0,   804,   213,   214,   215,   805,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   806,   219,   807,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   808,   226,     0,     0,   809,
     227,     0,   810,   228,     0,     0,     0,   811,     0,   812,
       0,   230,   813,     0,   231,     0,   232,   814,     0,     0,
     815,     0,     0,     0,     0,   816,   233,   234,   235,   236,
     237,   238,   817,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   818,   248,   249,   250,   819,   251,   252,     0,
       0,     0,   253,   254,   255,   820,   257,     0,     0,   821,
     259,   822,   823,   260,     0,   261,   824,   825,   826,   827,
     828,   829,   830,   266,   267,   268,   269,     0,   831,   270,
     271,     0,   272,   273,   274,   832,   833,   834,   275,     0,
     835,   836,     0,   276,   277,     0,   837,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   838,   839,   286,   840,   841,   842,
     843,   844,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   845,   297,   298,   299,   300,   301,   302,
     303,   846,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   847,   848,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   849,
     318,   319,   850,   320,   321,   851,   322,   852,   324,   325,
       0,   853,   327,     0,   328,   329,   330,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,     0,   340,   341,   342,     0,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,   347,   348,   854,   855,   349,   350,     0,
     351,   856,   353,   857,   858,   859,   354,   355,   356,   357,
     860,   358,   359,     0,   360,   361,     0,   675,   362,   861,
     862,   863,   864,     0,     0,     0,     0,     0,   367,     0,
     368,   865,   866,   867,   370,   371,   372,     0,   868,   373,
     374,   869,     0,   375,     0,     0,   870,   871,   376,     0,
       0,   377,     0,   378,     0,   872,   380,     0,     0,   873,
     874,   875,   876,   877,   381,     0,     0,   382,   878,     0,
     383,   384,   879,     0,     0,     0,     0,   386,     0,   387,
     388,     0,   880,     0,   881,     0,     0,     0,     0,   882,
       0,     0,     0,   883,   884,     0,     0,     0,     0,   885,
       0,   886,  1773,     0,   887,   888,     0,   889,   890,   122,
       0,   746,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   747,     0,   748,   130,   131,   749,
     133,     0,   134,   750,   135,     0,   751,   136,   752,   753,
     754,   137,   755,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   756,   145,     0,   146,   757,
     758,   148,     0,   149,   150,   151,   759,   152,     0,   760,
     154,     0,   155,   156,   157,   158,   159,   761,   762,   160,
       0,   161,   162,     0,   763,   164,     0,   764,   765,   766,
     165,     0,     0,   166,   767,   768,     0,   769,   770,     0,
     167,   168,   771,   772,   773,     0,     0,     0,     0,   774,
     171,   775,     0,     0,   776,   777,   172,     0,   173,     0,
       0,     0,   778,   779,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     780,   182,     0,   781,   782,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   783,     0,   191,   784,
     192,   785,   786,   193,   194,     0,   787,   195,   196,   197,
     788,     0,   198,     0,     0,   789,     0,   199,   200,  2217,
     790,   201,     0,   202,   791,   792,   793,   794,     0,   795,
     796,   204,   797,   798,   799,   206,     0,   207,   800,     0,
     801,   802,     0,   208,   209,     0,   210,   803,     0,   211,
       0,     0,     0,   804,   213,   214,   215,   805,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   806,   219,   807,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   808,   226,     0,     0,
     809,   227,     0,   810,   228,     0,     0,     0,   811,     0,
     812,     0,   230,   813,     0,   231,     0,   232,   814,     0,
       0,   815,     0,     0,     0,     0,   816,   233,   234,   235,
     236,   237,   238,   817,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   818,   248,   249,   250,   819,   251,   252,
       0,     0,     0,   253,   254,   255,   820,   257,     0,     0,
     821,   259,   822,   823,   260,     0,   261,   824,   825,   826,
     827,   828,   829,   830,   266,   267,   268,   269,     0,   831,
     270,   271,     0,   272,   273,   274,   832,   833,   834,   275,
       0,   835,   836,     0,   276,   277,     0,   837,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   838,   839,   286,   840,   841,
     842,   843,   844,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   845,   297,   298,   299,   300,   301,
     302,   303,   846,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   847,   848,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     849,   318,   319,   850,   320,   321,   851,   322,   852,   324,
     325,     0,   853,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,   854,   855,   349,   350,
       0,   351,   856,   353,   857,   858,   859,   354,   355,   356,
     357,   860,   358,   359,     0,   360,   361,     0,   675,   362,
     861,   862,   863,   864,     0,     0,     0,     0,     0,   367,
       0,   368,   865,   866,   867,   370,   371,   372,     0,   868,
     373,   374,   869,     0,   375,     0,     0,   870,   871,   376,
       0,     0,   377,     0,   378,     0,   872,   380,     0,     0,
     873,   874,   875,   876,   877,   381,     0,     0,   382,   878,
       0,   383,   384,   879,     0,     0,     0,     0,   386,     0,
     387,   388,     0,   880,     0,   881,     0,     0,     0,     0,
     882,     0,     0,     0,   883,   884,     0,     0,     0,     0,
     885,     0,   886,     0,     0,   887,   888,     0,   889,   890,
     122,     0,   746,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   747,     0,   748,   130,   131,
     749,   133,     0,   134,   750,   135,     0,   751,   136,   752,
     753,   754,   137,   755,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   756,   145,     0,   146,
     757,   758,   148,     0,   149,   150,   151,   759,   152,     0,
     760,   154,     0,   155,   156,   157,   158,   159,   761,   762,
     160,     0,   161,   162,     0,   763,   164,     0,   764,   765,
     766,   165,     0,     0,   166,   767,   768,     0,   769,   770,
       0,   167,   168,   771,   772,   773,     0,     0,     0,     0,
     774,   171,   775,     0,     0,   776,   777,   172,     0,   173,
       0,     0,     0,   778,   779,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   780,   182,     0,   781,   782,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   783,     0,   191,
     784,   192,   785,   786,   193,   194,     0,   787,   195,   196,
     197,   788,     0,   198,     0,     0,   789,     0,   199,   200,
    2219,   790,   201,     0,   202,   791,   792,   793,   794,     0,
     795,   796,   204,   797,   798,   799,   206,     0,   207,   800,
       0,   801,   802,     0,   208,   209,     0,   210,   803,     0,
     211,     0,     0,     0,   804,   213,   214,   215,   805,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   806,   219,
     807,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   808,   226,     0,
       0,   809,   227,     0,   810,   228,     0,     0,     0,   811,
       0,   812,     0,   230,   813,     0,   231,     0,   232,   814,
       0,     0,   815,     0,     0,     0,     0,   816,   233,   234,
     235,   236,   237,   238,   817,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   818,   248,   249,   250,   819,   251,
     252,     0,     0,     0,   253,   254,   255,   820,   257,     0,
       0,   821,   259,   822,   823,   260,     0,   261,   824,   825,
     826,   827,   828,   829,   830,   266,   267,   268,   269,     0,
     831,   270,   271,     0,   272,   273,   274,   832,   833,   834,
     275,     0,   835,   836,     0,   276,   277,     0,   837,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   838,   839,   286,   840,
     841,   842,   843,   844,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   845,   297,   298,   299,   300,
     301,   302,   303,   846,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   847,
     848,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   849,   318,   319,   850,   320,   321,   851,   322,   852,
     324,   325,     0,   853,   327,     0,   328,   329,   330,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,   854,   855,   349,
     350,     0,   351,   856,   353,   857,   858,   859,   354,   355,
     356,   357,   860,   358,   359,     0,   360,   361,     0,   675,
     362,   861,   862,   863,   864,     0,     0,     0,     0,     0,
     367,     0,   368,   865,   866,   867,   370,   371,   372,     0,
     868,   373,   374,   869,     0,   375,     0,     0,   870,   871,
     376,     0,     0,   377,     0,   378,     0,   872,   380,     0,
       0,   873,   874,   875,   876,   877,   381,     0,     0,   382,
     878,     0,   383,   384,   879,     0,     0,     0,     0,   386,
       0,   387,   388,     0,   880,     0,   881,     0,     0,     0,
       0,   882,     0,     0,     0,   883,   884,     0,     0,     0,
       0,   885,     0,   886,     0,     0,   887,   888,     0,   889,
     890,   122,     0,   746,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   747,     0,   748,   130,
     131,   749,   133,     0,   134,   750,   135,     0,   751,   136,
     752,   753,   754,   137,   755,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   756,   145,     0,
     146,   757,   758,   148,     0,   149,   150,   151,   759,   152,
       0,   760,   154,     0,   155,   156,   157,   158,   159,   761,
     762,   160,     0,   161,   162,     0,   763,   164,     0,   764,
     765,   766,   165,     0,     0,   166,   767,   768,     0,   769,
     770,     0,   167,   168,   771,   772,   773,     0,     0,     0,
       0,   774,   171,   775,     0,     0,   776,   777,   172,     0,
     173,     0,     0,     0,   778,   779,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   780,   182,     0,   781,   782,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   783,     0,
     191,   784,   192,   785,   786,   193,   194,     0,   787,   195,
     196,   197,   788,     0,   198,     0,     0,   789,     0,   199,
     200,  2221,   790,   201,     0,   202,   791,   792,   793,   794,
       0,   795,   796,   204,   797,   798,   799,   206,     0,   207,
     800,     0,   801,   802,     0,   208,   209,     0,   210,   803,
       0,   211,     0,     0,     0,   804,   213,   214,   215,   805,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   806,
     219,   807,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   808,   226,
       0,     0,   809,   227,     0,   810,   228,     0,     0,     0,
     811,     0,   812,     0,   230,   813,     0,   231,     0,   232,
     814,     0,     0,   815,     0,     0,     0,     0,   816,   233,
     234,   235,   236,   237,   238,   817,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   818,   248,   249,   250,   819,
     251,   252,     0,     0,     0,   253,   254,   255,   820,   257,
       0,     0,   821,   259,   822,   823,   260,     0,   261,   824,
     825,   826,   827,   828,   829,   830,   266,   267,   268,   269,
       0,   831,   270,   271,     0,   272,   273,   274,   832,   833,
     834,   275,     0,   835,   836,     0,   276,   277,     0,   837,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   838,   839,   286,
     840,   841,   842,   843,   844,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   845,   297,   298,   299,
     300,   301,   302,   303,   846,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     847,   848,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   849,   318,   319,   850,   320,   321,   851,   322,
     852,   324,   325,     0,   853,   327,     0,   328,   329,   330,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,   854,   855,
     349,   350,     0,   351,   856,   353,   857,   858,   859,   354,
     355,   356,   357,   860,   358,   359,     0,   360,   361,     0,
     675,   362,   861,   862,   863,   864,     0,     0,     0,     0,
       0,   367,     0,   368,   865,   866,   867,   370,   371,   372,
       0,   868,   373,   374,   869,     0,   375,     0,     0,   870,
     871,   376,     0,     0,   377,     0,   378,     0,   872,   380,
       0,     0,   873,   874,   875,   876,   877,   381,     0,     0,
     382,   878,     0,   383,   384,   879,     0,     0,     0,     0,
     386,     0,   387,   388,     0,   880,     0,   881,     0,     0,
       0,     0,   882,     0,     0,     0,   883,   884,     0,     0,
       0,     0,   885,     0,   886,     0,     0,   887,   888,     0,
     889,   890,   122,     0,   746,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   747,     0,   748,
     130,   131,   749,   133,     0,   134,   750,   135,     0,   751,
     136,   752,   753,   754,   137,   755,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   756,   145,
       0,   146,   757,   758,   148,     0,   149,   150,   151,   759,
     152,     0,   760,   154,     0,   155,   156,   157,   158,   159,
     761,   762,   160,     0,   161,   162,     0,   763,   164,     0,
     764,   765,   766,   165,     0,     0,   166,   767,   768,     0,
     769,   770,     0,   167,   168,   771,   772,   773,     0,     0,
       0,     0,   774,   171,   775,     0,     0,   776,   777,   172,
       0,   173,     0,     0,     0,   778,   779,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   780,   182,     0,   781,   782,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   783,
       0,   191,   784,   192,   785,   786,   193,   194,     0,   787,
     195,   196,   197,   788,     0,   198,     0,     0,   789,     0,
     199,   200,     0,   790,   201,     0,   202,   791,   792,   793,
     794,     0,   795,   796,   204,   797,   798,   799,   206,     0,
     207,   800,     0,   801,   802,     0,   208,   209,     0,   210,
     803,     0,   211,     0,     0,     0,   804,   213,   214,   215,
     805,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     806,   219,   807,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   808,
     226,     0,     0,   809,   227,     0,   810,   228,     0,     0,
       0,   811,     0,   812,     0,   230,   813,     0,   231,     0,
     232,   814,     0,     0,   815,     0,     0,     0,     0,   816,
     233,   234,   235,   236,   237,   238,   817,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   818,   248,   249,   250,
     819,   251,   252,     0,     0,     0,   253,   254,   255,   820,
     257,     0,     0,   821,   259,   822,   823,   260,     0,   261,
     824,   825,   826,   827,   828,   829,   830,   266,   267,   268,
     269,     0,   831,   270,   271,     0,   272,   273,   274,   832,
     833,   834,   275,     0,   835,   836,     0,   276,   277,     0,
     837,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   838,   839,
     286,   840,   841,   842,   843,   844,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   845,   297,   298,
     299,   300,   301,   302,   303,   846,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   847,   848,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   849,   318,   319,   850,   320,   321,   851,
     322,   852,   324,   325,     0,   853,   327,     0,   328,   329,
     330,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,   854,
     855,   349,   350,     0,   351,   856,   353,   857,   858,   859,
     354,   355,   356,   357,   860,   358,   359,     0,   360,   361,
       0,   675,   362,   861,   862,   863,   864,     0,     0,     0,
       0,     0,   367,     0,   368,   865,   866,   867,   370,   371,
     372,     0,   868,   373,   374,   869,     0,   375,     0,     0,
     870,   871,   376,     0,     0,   377,     0,   378,     0,   872,
     380,     0,     0,   873,   874,   875,   876,   877,   381,     0,
       0,   382,   878,     0,   383,   384,   879,     0,     0,     0,
       0,   386,     0,   387,   388,     0,   880,     0,   881,     0,
       0,     0,     0,   882,     0,     0,     0,   883,   884,     0,
       0,     0,     0,   885,     0,   886,     0,     0,   887,   888,
       0,   889,   890,   122,     0,   746,   124,   125,   126,   127,
    1805,     0,     0,     0,     0,  1806,     0,     0,   747,     0,
     748,   130,   131,   749,   133,     0,   134,   750,   135,     0,
     751,   136,   752,   753,   754,   137,   755,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   756,
     145,     0,   146,   757,   758,   148,     0,   149,   150,   151,
     759,   152,     0,   760,   154,     0,   155,   156,   157,   158,
     159,   761,   762,   160,     0,   161,   162,     0,   763,   164,
       0,   764,   765,   766,   165,     0,     0,   166,   767,   768,
       0,   769,   770,     0,   167,   168,   771,   772,   773,     0,
       0,     0,     0,   774,   171,   775,     0,     0,   776,   777,
     172,     0,   173,     0,     0,     0,   778,   779,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   780,   182,     0,   781,   782,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     783,     0,   191,   784,   192,   785,   786,   193,   194,     0,
     787,   195,   196,   197,   788,     0,   198,     0,     0,   789,
       0,   199,   200,     0,   790,   201,     0,   202,   791,   792,
     793,   794,     0,   795,   796,   204,   797,   798,   799,   206,
       0,   207,   800,     0,   801,   802,     0,   208,   209,     0,
     210,   803,     0,   211,     0,     0,     0,   804,   213,   214,
     215,   805,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   806,   219,   807,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     808,   226,     0,     0,   809,   227,     0,   810,   228,     0,
       0,     0,   811,     0,   812,     0,   230,   813,     0,   231,
       0,   232,   814,     0,     0,   815,     0,     0,     0,     0,
     816,   233,   234,   235,   236,   237,   238,   817,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   818,   248,   249,
     250,   819,   251,   252,     0,     0,     0,   253,   254,   255,
     820,   257,     0,     0,   821,   259,   822,   823,   260,     0,
     261,   824,   825,   826,   827,   828,   829,   830,   266,   267,
     268,   269,     0,   831,   270,   271,     0,   272,   273,   274,
     832,     0,   834,   275,     0,   835,   836,     0,   276,   277,
       0,   837,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   838,
     839,   286,   840,   841,   842,   843,   844,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   845,   297,
     298,   299,   300,   301,   302,   303,   846,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   847,   848,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   849,   318,   319,   850,   320,   321,
     851,   322,   852,   324,   325,     0,   853,   327,     0,   328,
     329,   330,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
     854,   855,   349,   350,     0,   351,   856,   353,   857,   858,
     859,   354,   355,   356,   357,   860,   358,   359,     0,   360,
     361,     0,   675,   362,   861,   862,   863,   864,     0,     0,
       0,     0,     0,   367,     0,   368,   865,   866,   867,   370,
     371,   372,     0,   868,   373,   374,   869,     0,   375,     0,
       0,   870,   871,   376,     0,     0,   377,     0,   378,     0,
     872,   380,     0,     0,   873,   874,   875,   876,   877,   381,
       0,     0,   382,   878,     0,   383,   384,   879,     0,     0,
       0,     0,   386,     0,   387,   388,     0,   880,     0,   881,
       0,     0,     0,     0,   882,     0,     0,     0,   883,   884,
       0,     0,     0,     0,   885,     0,   886,     0,     0,   887,
     888,     0,   889,   890,   122,     0,   746,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   747,
       0,   748,   130,   131,   749,   133,     0,   134,   750,   135,
       0,   751,   136,   752,   753,   754,   137,   755,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     756,   145,     0,   146,   757,   758,   148,     0,   149,   150,
     151,   759,   152,     0,   760,   154,     0,   155,   156,   157,
     158,   159,   761,   762,   160,     0,   161,   162,     0,   763,
     164,     0,   764,   765,   766,   165,     0,     0,   166,   767,
     768,     0,   769,   770,     0,   167,   168,   771,   772,   773,
       0,     0,     0,     0,   774,   171,   775,     0,     0,   776,
     777,   172,     0,   173,     0,     0,     0,   778,   779,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   780,   182,     0,   781,   782,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   783,     0,   191,   784,   192,   785,   786,   193,   194,
       0,   787,   195,   196,   197,   788,     0,   198,     0,     0,
     789,     0,   199,   200,     0,   790,   201,     0,   202,   791,
     792,   793,   794,     0,   795,   796,   204,   797,   798,   799,
     206,     0,   207,   800,     0,   801,   802,     0,   208,   209,
       0,   210,   803,     0,   211,     0,     0,     0,   804,   213,
     214,   215,   805,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   806,   219,  2499,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   808,   226,     0,     0,   809,   227,     0,   810,   228,
       0,     0,     0,   811,     0,   812,     0,   230,   813,     0,
     231,     0,   232,   814,     0,     0,   815,     0,     0,     0,
       0,   816,   233,   234,   235,   236,   237,   238,   817,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   818,   248,
     249,   250,   819,   251,   252,     0,     0,     0,   253,   254,
     255,   820,   257,     0,     0,   821,   259,   822,   823,   260,
       0,   261,   824,   825,   826,   827,   828,   829,   830,   266,
     267,   268,   269,     0,   831,   270,   271,     0,   272,   273,
     274,   832,   833,   834,   275,     0,   835,   836,     0,   276,
     277,     0,   837,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     838,   839,   286,   840,   841,   842,   843,   844,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   845,
     297,   298,   299,   300,   301,   302,   303,   846,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   847,   848,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   849,   318,   319,   850,   320,
     321,   851,   322,   852,   324,   325,     0,   853,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,   854,   855,   349,   350,     0,   351,   856,   353,   857,
     858,   859,   354,   355,   356,   357,   860,   358,   359,     0,
     360,   361,     0,   675,   362,   861,   862,   863,   864,     0,
       0,     0,     0,     0,   367,     0,   368,   865,   866,   867,
     370,   371,   372,     0,   868,   373,   374,   869,     0,   375,
       0,     0,   870,   871,   376,     0,     0,   377,     0,   378,
       0,   872,   380,     0,     0,   873,   874,   875,   876,   877,
     381,     0,     0,   382,   878,     0,   383,   384,   879,     0,
       0,     0,     0,   386,     0,   387,   388,     0,   880,     0,
     881,     0,     0,     0,     0,   882,     0,     0,     0,   883,
     884,     0,     0,     0,     0,   885,     0,   886,     0,     0,
     887,   888,     0,   889,   890,   122,     0,   746,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     747,     0,   748,   130,   131,   749,   133,     0,   134,   750,
     135,     0,   751,   136,   752,   753,   754,   137,   755,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   756,   145,     0,   146,   757,   758,   148,     0,   149,
     150,   151,   759,   152,     0,   760,   154,     0,   155,   156,
     157,   158,   159,   761,   762,   160,     0,   161,   162,     0,
     763,   164,     0,   764,   765,   766,   165,     0,     0,   166,
     767,   768,     0,   769,   770,     0,   167,   168,   771,   772,
     773,     0,     0,     0,     0,   774,   171,   775,     0,     0,
     776,   777,   172,     0,   173,     0,     0,     0,   778,   779,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   780,   182,     0,   781,
     782,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   783,     0,   191,   784,   192,   785,   786,   193,
     194,     0,   787,   195,   196,   197,   788,     0,   198,     0,
       0,   789,     0,   199,   200,     0,   790,   201,     0,   202,
     791,   792,   793,   794,     0,   795,   796,   204,   797,   798,
     799,   206,     0,   207,   800,     0,   801,   802,     0,   208,
     209,     0,   210,   803,     0,   211,     0,     0,     0,   804,
     213,   214,   215,   805,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   806,   219,  2572,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   808,   226,     0,     0,   809,   227,     0,   810,
     228,     0,     0,     0,   811,     0,   812,     0,   230,   813,
       0,   231,     0,   232,   814,     0,     0,   815,     0,     0,
       0,     0,   816,   233,   234,   235,   236,   237,   238,   817,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   818,
     248,   249,   250,   819,   251,   252,     0,     0,     0,   253,
     254,   255,   820,   257,     0,     0,   821,   259,   822,   823,
     260,     0,   261,   824,   825,   826,   827,   828,   829,   830,
     266,   267,   268,   269,     0,   831,   270,   271,     0,   272,
     273,   274,   832,   833,   834,   275,     0,   835,   836,     0,
     276,   277,     0,   837,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   838,   839,   286,   840,   841,   842,   843,   844,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     845,   297,   298,   299,   300,   301,   302,   303,   846,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   847,   848,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   849,   318,   319,   850,
     320,   321,   851,   322,   852,   324,   325,     0,   853,   327,
       0,   328,   329,   330,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,   854,   855,   349,   350,     0,   351,   856,   353,
     857,   858,   859,   354,   355,   356,   357,   860,   358,   359,
       0,   360,   361,     0,   675,   362,   861,   862,   863,   864,
       0,     0,     0,     0,     0,   367,     0,   368,   865,   866,
     867,   370,   371,   372,     0,   868,   373,   374,   869,     0,
     375,     0,     0,   870,   871,   376,     0,     0,   377,     0,
     378,     0,   872,   380,     0,     0,   873,   874,   875,   876,
     877,   381,     0,     0,   382,   878,     0,   383,   384,   879,
       0,     0,     0,     0,   386,     0,   387,   388,     0,   880,
       0,   881,     0,     0,     0,     0,   882,     0,     0,     0,
     883,   884,     0,     0,     0,     0,   885,     0,   886,     0,
       0,   887,   888,     0,   889,   890,   122,     0,   746,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   747,     0,   748,   130,   131,   749,   133,     0,   134,
     750,   135,     0,   751,   136,   752,   753,   754,   137,   755,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   756,   145,     0,   146,   757,   758,   148,     0,
     149,   150,   151,   759,   152,     0,   760,   154,     0,   155,
     156,   157,   158,   159,   761,   762,   160,     0,   161,   162,
       0,   763,   164,     0,   764,   765,   766,   165,     0,     0,
     166,   767,   768,     0,   769,   770,     0,   167,   168,   771,
     772,   773,     0,     0,     0,     0,   774,   171,   775,     0,
       0,   776,  2921,   172,     0,   173,     0,     0,     0,   778,
     779,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   780,   182,     0,
     781,   782,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   783,     0,   191,   784,   192,   785,   786,
     193,   194,     0,   787,   195,   196,   197,   788,     0,   198,
       0,     0,   789,     0,   199,   200,     0,   790,   201,     0,
     202,   791,   792,   793,   794,     0,   795,   796,   204,   797,
     798,   799,   206,     0,   207,   800,     0,   801,   802,     0,
     208,   209,     0,   210,   803,     0,   211,     0,     0,     0,
     804,   213,   214,   215,   805,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   806,   219,   807,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   808,   226,     0,     0,   809,   227,     0,
     810,   228,     0,     0,     0,   811,     0,   812,     0,   230,
     813,     0,   231,     0,   232,   814,     0,     0,   815,     0,
       0,     0,     0,   816,   233,   234,   235,   236,   237,   238,
     817,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     818,   248,   249,   250,   819,   251,   252,     0,     0,     0,
     253,   254,   255,   820,   257,     0,     0,   821,   259,   822,
     823,   260,     0,   261,   824,   825,   826,   827,   828,   829,
     830,   266,   267,   268,   269,     0,   831,   270,   271,     0,
     272,   273,   274,   832,   833,   834,   275,     0,   835,   836,
       0,   276,   277,     0,   837,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   838,   839,   286,   840,   841,   842,   843,   844,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   845,   297,   298,   299,   300,   301,   302,   303,   846,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   847,   848,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   849,   318,   319,
     850,   320,   321,   851,   322,   852,   324,   325,     0,   853,
     327,     0,   328,   329,   330,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,   854,   855,   349,   350,     0,   351,   856,
     353,   857,   858,   859,   354,   355,   356,   357,   860,   358,
     359,     0,   360,   361,     0,   675,   362,   861,   862,   863,
     864,     0,     0,     0,     0,     0,   367,     0,   368,   865,
     866,   867,   370,   371,   372,     0,   868,   373,   374,   869,
       0,   375,     0,     0,   870,   871,   376,     0,     0,   377,
       0,   378,     0,   872,   380,     0,     0,   873,   874,   875,
     876,   877,   381,     0,     0,   382,   878,     0,   383,   384,
     879,     0,     0,     0,     0,   386,     0,   387,   388,     0,
     880,     0,   881,     0,     0,     0,     0,   882,     0,     0,
       0,   883,   884,     0,     0,     0,     0,   885,     0,   886,
       0,     0,   887,   888,     0,   889,   890,   122,     0,   746,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   747,     0,   748,   130,   131,   749,   133,     0,
     134,   750,   135,     0,   751,   136,   752,   753,   754,   137,
     755,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   756,   145,     0,   146,   757,   758,   148,
       0,   149,   150,   151,   759,   152,     0,   760,   154,     0,
     155,   156,   157,   158,   159,   761,   762,   160,     0,   161,
     162,     0,   763,   164,     0,   764,   765,   766,   165,     0,
       0,   166,   767,   768,     0,   769,   770,     0,   167,   168,
     771,   772,   773,     0,     0,     0,     0,   774,   171,   775,
       0,     0,   776,   777,   172,     0,   173,     0,     0,     0,
     778,   779,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   780,   182,
       0,   781,   782,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   783,     0,   191,   784,   192,   785,
     786,   193,   194,     0,   787,   195,   196,   197,   788,     0,
     198,     0,     0,   789,     0,   199,   200,     0,   790,   201,
       0,   202,   791,   792,   793,   794,     0,   795,   796,   204,
     797,   798,   799,   206,     0,   207,   800,     0,   801,   802,
       0,   208,   209,     0,   210,   803,     0,   211,     0,     0,
       0,   804,   213,   214,   215,   805,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   806,   219,   807,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   808,   226,     0,     0,   809,   227,
       0,   810,   228,     0,     0,     0,   811,     0,   812,     0,
     230,   813,     0,   231,     0,   232,   814,     0,     0,   815,
       0,     0,     0,     0,   816,   233,   234,   235,   236,   237,
     238,   817,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   818,   248,   249,   250,   819,   251,   252,     0,     0,
       0,   253,   254,   255,   820,   257,     0,     0,   821,   259,
     822,   823,   260,     0,   261,   824,   825,   826,   827,   828,
     829,   830,   266,   267,   268,   269,     0,   831,   270,   271,
       0,   272,   273,   274,   832,     0,   834,   275,     0,   835,
     836,     0,   276,   277,     0,   837,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   838,   839,   286,   840,   841,   842,   843,
     844,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   845,   297,   298,   299,   300,   301,   302,   303,
     846,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   847,   848,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   849,   318,
     319,   850,   320,   321,   851,   322,   852,   324,   325,     0,
     853,   327,     0,   328,   329,   330,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,   854,   855,   349,   350,     0,   351,
     856,   353,   857,   858,   859,   354,   355,   356,   357,   860,
     358,   359,     0,   360,   361,     0,   675,   362,   861,   862,
     863,   864,     0,     0,     0,     0,     0,   367,     0,   368,
     865,   866,   867,   370,   371,   372,     0,   868,   373,   374,
     869,     0,   375,     0,     0,   870,   871,   376,     0,     0,
     377,     0,   378,     0,   872,   380,     0,     0,   873,   874,
     875,   876,   877,   381,     0,     0,   382,   878,     0,   383,
     384,   879,     0,     0,     0,     0,   386,     0,   387,   388,
       0,   880,     0,   881,     0,     0,     0,     0,   882,     0,
       0,     0,   883,   884,     0,     0,     0,     0,   885,     0,
     886,     0,     0,   887,   888,     0,   889,   890,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,  1983,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,  1984,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
    1119,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,  1120,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,  2483,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,  1892,   328,   329,   330,     0,   331,     0,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,     0,   340,   341,   342,  1985,     0,
       0,     0,     0,     0,   343,   344,     0,   345,     0,     0,
     346,     0,     0,   347,   348,     0,     0,   349,   350,     0,
     351,   352,   353,     0,     0,     0,   354,   355,   356,   357,
       0,   358,   359,     0,   360,   361,     0,     0,   362,   363,
     364,   365,   366,     0,     0,     0,     0,     0,   367,     0,
     368,     0,     0,   369,   370,   371,   372,     0,     0,   373,
     374,     0,     0,   375,     0,     0,     0,     0,   376,     0,
       0,   377,     0,   378,     0,   379,   380,     0,     0,     0,
       0,     0,     0,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,     0,     0,   386,     0,   387,
     388,     0,     0,     0,   389,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,  2032,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
    1983,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,  1984,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,  1119,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,  1120,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,   329,   330,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,  1985,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,     0,     0,   349,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,   369,   370,   371,   372,     0,     0,   373,   374,     0,
       0,   375,     0,     0,     0,     0,   376,     0,     0,   377,
       0,   378,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,     0,     0,   386,     0,   387,   388,     0,
       0,     0,   389,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  2032,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,  1892,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,     0,
     389,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  2308,     0,
     130,   131,   132,   133,   890,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,   329,
     330,     0,   331,     0,     0,   332,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,     0,   340,
     341,   342,     0,     0,     0,     0,     0,     0,   343,   344,
       0,   345,     0,     0,   346,     0,     0,   347,   348,     0,
       0,   349,   350,     0,   351,   352,   353,     0,     0,     0,
     354,   355,   356,   357,     0,   358,   359,     0,   360,   361,
       0,     0,   362,   363,   364,   365,   366,     0,     0,     0,
       0,     0,   367,     0,   368,     0,     0,   369,   370,   371,
     372,     0,     0,   373,   374,     0,     0,   375,     0,     0,
       0,     0,   376,     0,     0,   377,     0,   378,     0,   379,
     380,     0,     0,     0,     0,     0,     0,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,     0,     0,     0,
       0,   386,     0,   387,   388,     0,     0,     0,   389,     0,
       0,     0,     0,     0,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,  3673,   128,     0,     0,
     129,  3674,   890,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,   992,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
       0,   389,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   425,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
     329,   330,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
    1850,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   425,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,     0,     0,
     349,   350,     0,   351,   352,   353,     0,     0,     0,   354,
     355,   356,   357,     0,   358,   359,     0,   360,   361,     0,
       0,   362,   363,   364,   365,   366,     0,     0,     0,     0,
       0,   367,     0,   368,     0,     0,   369,   370,   371,   372,
       0,     0,   373,   374,     0,     0,   375,     0,     0,     0,
       0,   376,     0,     0,   377,     0,   378,     0,   379,   380,
       0,     0,     0,     0,     0,     0,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,     0,     0,
     386,     0,   387,   388,     0,     0,     0,   389,     0,     0,
       0,     0,     0,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2031,     0,   128,     0,     0,   129,
       0,  2032,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,     0,
     389,     0,     0,     0,     0,     0,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,  3674,   890,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,     0,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,     0,   389,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,   425,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   479,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,     0,   331,     0,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,     0,   340,   341,   342,     0,     0,     0,     0,     0,
       0,   343,   344,     0,   345,     0,     0,   346,     0,     0,
     347,   348,     0,     0,   349,   350,     0,   351,   352,   353,
       0,     0,     0,   354,   355,   356,   357,     0,   358,   359,
       0,   360,   361,     0,     0,   362,   363,   364,   365,   366,
       0,     0,     0,     0,     0,   367,     0,   368,     0,     0,
     369,   370,   371,   372,     0,     0,   373,   374,     0,     0,
     375,     0,     0,     0,     0,   376,     0,     0,   377,     0,
     378,     0,   379,   380,     0,     0,     0,     0,     0,     0,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,     0,     0,   386,     0,   387,   388,     0,     0,
       0,   389,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   425,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
     329,   330,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   890,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
       0,   331,     0,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,     0,   340,   341,
     342,     0,     0,     0,     0,     0,     0,   343,   344,     0,
     345,     0,     0,   346,     0,     0,   347,   348,     0,     0,
     349,   350,     0,   351,   352,   353,     0,     0,     0,   354,
     355,   356,   357,     0,   358,   359,     0,   360,   361,     0,
       0,   362,   363,   364,   365,   366,     0,     0,     0,     0,
       0,   367,     0,   368,     0,     0,   369,   370,   371,   372,
       0,     0,   373,   374,     0,     0,   375,     0,     0,     0,
       0,   376,     0,     0,   377,     0,   378,     0,   379,   380,
       0,     0,     0,     0,     0,     0,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,     0,     0,
     386,     0,   387,   388,     0,     0,     0,   389,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,  2032,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,  1792,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,  2348,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,  2944,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,     0,  3523,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,  3725,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,   329,   330,     0,   331,     0,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,     0,   340,   341,   342,     0,     0,     0,     0,
       0,     0,   343,   344,     0,   345,     0,     0,   346,     0,
       0,   347,   348,     0,     0,   349,   350,     0,   351,   352,
     353,     0,     0,     0,   354,   355,   356,   357,     0,   358,
     359,     0,   360,   361,     0,     0,   362,   363,   364,   365,
     366,     0,     0,     0,     0,     0,   367,     0,   368,     0,
       0,   369,   370,   371,   372,     0,     0,   373,   374,     0,
       0,   375,     0,     0,     0,     0,   376,     0,     0,   377,
       0,   378,     0,   379,   380,     0,     0,     0,     0,     0,
       0,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,     0,     0,   386,     0,   387,   388,     0,
       0,     0,   389,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  1641,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
     329,   330,     0,   331,     0,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,     0,
     340,   341,   342,     0,     0,     0,     0,     0,     0,   343,
     344,     0,   345,     0,     0,   346,     0,     0,   347,   348,
       0,     0,   349,   350,     0,   351,   352,   353,     0,     0,
       0,   354,   355,   356,   357,     0,   358,   359,     0,   360,
     361,     0,     0,   362,   363,   364,   365,   366,     0,     0,
       0,     0,     0,   367,     0,   368,     0,     0,   369,   370,
     371,   372,     0,     0,   373,   374,     0,     0,   375,     0,
       0,     0,     0,   376,     0,     0,   377,     0,   378,     0,
     379,   380,     0,     0,     0,     0,     0,     0,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
       0,     0,   386,     0,   387,   388,     0,     0,     0,   389,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2334,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,   329,   330,     0,
     331,     0,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,     0,   340,   341,   342,
       0,     0,     0,     0,     0,     0,   343,   344,     0,   345,
       0,     0,   346,     0,     0,   347,   348,     0,     0,   349,
     350,     0,   351,   352,   353,     0,     0,     0,   354,   355,
     356,   357,     0,   358,   359,     0,   360,   361,     0,     0,
     362,   363,   364,   365,   366,     0,     0,     0,     0,     0,
     367,     0,   368,     0,     0,   369,   370,   371,   372,     0,
       0,   373,   374,     0,     0,   375,     0,     0,     0,     0,
     376,     0,     0,   377,     0,   378,     0,   379,   380,     0,
       0,     0,     0,     0,     0,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,     0,     0,   386,
       0,   387,   388,     0,     0,     0,   389,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,  2625,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,     0,   331,     0,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,     0,   340,   341,   342,     0,     0,     0,
       0,     0,     0,   343,   344,     0,   345,     0,     0,   346,
       0,     0,   347,   348,     0,     0,   349,   350,     0,   351,
     352,   353,     0,     0,     0,   354,   355,   356,   357,     0,
     358,   359,     0,   360,   361,     0,     0,   362,   363,   364,
     365,   366,     0,     0,     0,     0,     0,   367,     0,   368,
       0,     0,   369,   370,   371,   372,     0,     0,   373,   374,
       0,     0,   375,     0,     0,     0,     0,   376,     0,     0,
     377,     0,   378,     0,   379,   380,     0,     0,     0,     0,
       0,     0,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,     0,     0,   386,     0,   387,   388,
       0,     0,     0,   389,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2949,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,  -201,     0,   182,     0,     0,     0,
    -201,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,  -201,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -222,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,  -222,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,  -222,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -219,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,  -219,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,  -219,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3603,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -224,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3650,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3691,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -205,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3516,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3517,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3518,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3519,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3520,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3522,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,     0,   338,     0,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,     0,
     348,     0,     0,     0,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,     0,
     370,   371,   372,     0,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,  3606,     0,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,  -186,     0,   386,     0,   387,     0,     0,     0,     0,
     389,     0,     0,     0,   122,  3523,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,  1616,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,  1617,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,  1619,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,  1620,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,   717,   718,     0,   275,     0,     0,  1622,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,  3713,  3703,  3714,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,  1629,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2340,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2341,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,  1970,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,  1971,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2350,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2351,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2340,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2341,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
     721,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,   673,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,   674,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   675,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    2389,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2340,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   564,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,   565,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,  2330,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,  3645,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,  3646,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,   740,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,     0,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    1115,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  1917,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,     0,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,  1918,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,  2038,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,   565,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
    1917,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,   347,   348,     0,     0,   349,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,     0,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,   369,   370,   371,   372,     0,     0,
     373,   374,     0,     0,   375,     0,     0,     0,     0,   376,
       0,     0,   377,     0,   378,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,   388,     0,     0,   122,   389,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,  1414,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,  1415,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,     0,   331,     0,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
       0,   340,   341,   342,     0,     0,     0,     0,     0,     0,
     343,   344,     0,   345,     0,     0,   346,     0,     0,   347,
     348,     0,     0,   349,   350,     0,   351,   352,   353,     0,
       0,     0,   354,   355,   356,   357,     0,   358,   359,     0,
     360,   361,     0,     0,   362,   363,   364,   365,   366,     0,
       0,     0,     0,     0,   367,     0,   368,     0,     0,   369,
     370,   371,   372,     0,     0,   373,   374,     0,     0,   375,
       0,     0,     0,     0,   376,     0,     0,   377,     0,   378,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,     0,     0,   386,     0,   387,   388,     0,     0,   122,
     389,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,     0,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,     0,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,     0,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,     0,     0,
     312,     0,     0,   314,     0,     0,   316,   317,     0,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,   328,   329,   330,     0,   331,
       0,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,     0,   338,     0,     0,   340,   341,   342,     0,
       0,     0,     0,     0,     0,   343,   344,     0,   345,     0,
       0,   346,     0,     0,     0,   348,     0,     0,     0,   350,
       0,   351,   352,   353,     0,     0,     0,   354,   355,   356,
     357,     0,   358,   359,     0,   360,   361,     0,     0,   362,
     363,   364,   365,   366,     0,     0,     0,     0,     0,   367,
       0,   368,     0,     0,     0,   370,   371,   372,     0,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,     0,     0,   386,     0,
     387,     0,     0,     0,     0,   389
};

static const short yycheck[] =
{
       7,   466,   467,   468,   504,   470,   454,   472,   474,   728,
     729,   730,    19,   688,   605,    22,   429,   767,   768,   769,
     654,   978,    29,  1186,  1312,   773,   630,   751,   500,   501,
     529,  1312,    39,  1031,  1786,   628,  1222,  1094,  1974,  1896,
     833,   581,    49,  2082,  1333,  1920,  1921,  1922,  2366,  1952,
     654,  1340,  1537,  1927,  1868,  1637,  1394,  1960,   530,  1962,
    2100,  1220,   655,    22,  1214,  1550,  2315,  2107,  1188,  1189,
    1190,  2726,  1959,  1329,  2703,  1056,  1108,  1503,  1059,  1989,
      87,  1201,     3,  1276,   834,     3,  1934,  1935,   587,  1070,
    1071,  2711,    18,     3,    16,     3,     3,  1911,  1351,  1352,
     107,   108,    32,   110,  1254,   461,    20,   108,    18,   110,
     860,     3,    54,   861,   121,    16,   864,     3,     3,  1993,
      18,     3,    49,   873,   874,   875,   692,   599,    87,    18,
    1193,  1194,   513,  1196,    16,  1255,    16,    95,  1258,  2013,
    2014,    55,    56,   692,    59,    56,    55,    56,    12,    66,
    1343,    27,  1345,   135,  1640,  1984,  1985,  1517,    28,   883,
     884,   885,   121,  1450,  1983,   115,  1286,  1287,  1231,  1642,
    1989,  1291,    20,  1992,    69,    34,  1995,   172,  2756,   903,
     129,  2759,   175,  1246,    32,    34,    49,  2006,  2007,   156,
     229,  1311,   147,  1313,   229,    10,  2015,   696,    46,   217,
    2778,  1264,  1265,  1266,  2308,   169,  2784,    55,    56,  2410,
     158,    11,  1275,    58,   156,  2072,   629,   159,    64,   145,
     238,  2988,    58,   688,  1181,   111,   111,   699,   253,    20,
     172,   156,   301,    68,    20,   145,   592,   156,    61,  2817,
    1112,    32,    59,   289,  2076,    80,    32,   145,    58,   175,
     214,   130,   214,    32,  2981,    46,   145,   263,   656,    60,
      46,   125,    94,   131,    55,    56,    63,  1958,   361,    55,
      56,    77,   177,   223,   115,   126,   347,    56,   270,   113,
     407,   214,  3525,     8,   252,   406,   341,   406,   112,    63,
      58,    19,   205,   236,    94,   398,    50,   175,   344,    67,
     175,  2930,   494,   149,    58,   258,   249,   494,   270,   107,
     112,    79,   413,   111,    97,   343,  2638,   100,    97,   234,
     450,   100,   214,   494,    12,    96,   488,   352,   490,   108,
     572,   553,   253,   361,   170,   253,  1527,  3436,    12,   430,
     204,   433,    37,   435,   203,   253,   253,   179,  1539,  1540,
     535,  1542,  1543,  1544,   203,   335,  1547,   299,   580,    12,
     170,  1552,  1944,   217,   467,  1556,  1557,  1558,   166,   236,
    1561,  1562,  1563,  1564,  1565,   505,  1567,  1568,  1569,   179,
      76,   270,    89,   336,   332,   333,  2708,    40,   116,   337,
     511,   510,   584,   580,   579,   221,    92,   897,   390,   269,
     287,   494,   170,   229,   228,   203,   241,  1082,   415,   580,
     178,   145,   321,  3140,   214,   382,   331,   234,   425,   399,
     382,  1907,   429,   492,  1587,    28,   228,   434,    81,  1592,
     672,   352,   439,    86,  3012,  1598,   270,   125,  1601,   164,
     382,   145,  1035,  3021,   352,   910,   217,   229,   517,   217,
    1043,   125,   361,   580,   461,   360,   928,   382,  3078,   376,
      52,    49,   313,   382,  3707,   471,   494,    70,   172,   267,
     238,   478,   405,   416,  2349,   434,   311,   578,  1018,  1072,
    1073,   488,  2418,    64,   411,   492,  2373,   578,   356,  1237,
    1094,   498,   441,   500,   501,   138,   521,  2407,   505,   506,
     335,   390,  2084,  3132,   258,   148,  2381,   353,   515,   981,
    3609,  2421,   519,   405,   585,  2716,  1497,   524,   525,   991,
     527,   528,   529,   530,   525,   580,   527,   528,  1648,   488,
      32,   357,   578,   568,   404,  1101,   372,  1036,   141,  1571,
     338,   580,   374,  2647,   449,   412,  2031,   326,   411,   394,
    3170,   430,  1101,   468,   389,  1427,   563,  1305,   471,   374,
     578,   509,   372,   555,   479,  3332,   533,   390,   179,   982,
     534,   488,   579,  1113,   374,   381,  2405,   525,   231,   529,
     587,   588,   564,   551,   579,   592,   579,  2072,  2407,   547,
     507,  1951,   599,   548,  1160,  2081,   460,   461,   462,   463,
     464,   465,  2421,  1723,   372,   503,   520,  1727,  1896,   535,
    2083,  1160,   476,   969,   533,  1896,  2934,  1082,  1342,  1812,
     579,   516,   629,   503,  1817,  1818,  1913,   503,  1787,   588,
     551,   466,   543,   551,  1358,   494,   992,  1823,   580,  1825,
    1760,   556,  1023,   551,   551,   494,   568,   300,   578,   450,
    1809,   466,    34,   580,   580,   580,  2905,  1105,   490,  2491,
    1384,   580,   479,  3390,   585,   586,   555,   568,   586,   448,
    1068,   553,   520,  1961,   471,   584,   586,   585,   586,   586,
    1961,   688,   552,  2374,  2375,  3305,   522,   455,   529,   696,
     490,   506,   699,    94,   586,   702,   703,   471,   546,   578,
     586,   586,   580,   582,   586,   580,   359,   350,   442,  3364,
     405,   418,   522,   496,  3369,   547,   499,   515,   100,   490,
     499,   572,   573,   574,   419,   107,  1789,    11,  2016,   520,
     578,   738,   547,   740,   520,  2016,     4,   107,   442,  2321,
    2322,     9,    10,   335,   703,   440,  1211,   335,   527,   107,
    1163,   229,  3372,   579,   522,  3073,   542,   543,  1114,    27,
    2286,  2287,  2288,   374,    32,   158,  2641,   370,    36,    67,
     105,   553,   353,   325,   252,  3353,   158,  3355,   179,   738,
     108,   740,   111,   175,   166,   287,   568,  2644,   172,   392,
    2693,  2317,  2318,  2319,  2697,    75,   166,   430,    12,   324,
     175,   454,  1965,  2713,  2679,   430,  2693,   179,   166,  2000,
    2697,   253,   325,   267,   417,   191,   217,   448,  2302,   344,
    2011,   203,  2009,   411,  3003,   471,   287,  3006,   112,  2987,
    1295,  1994,   485,  1996,  1299,   430,  1336,  3457,  2001,   174,
    2027,  2655,   554,   164,  2985,  3423,   430,  3425,   116,   191,
     493,   226,   512,   441,  2017,   503,  2019,  2020,  2021,  1493,
     349,  2114,  2115,    12,   430,    71,    72,   470,   426,  3498,
     521,  3029,   170,    94,   209,   535,   175,   430,   262,   490,
    3535,   888,   258,   890,   338,   267,   450,    44,  1522,  1493,
    1430,  1390,  1485,   175,  2713,   175,   527,   267,   544,   227,
    1440,  2385,  1495,  1496,   325,   111,  1499,  1500,   362,   267,
     352,   125,   490,  2495,  1327,   922,   258,   395,  1522,   217,
     381,   928,   243,     3,  1464,    12,   325,   133,   579,  1401,
     113,   562,   580,  1432,  1433,  2974,  1934,  1935,   330,  2365,
     238,   107,   494,   325,   337,   578,    23,   229,  2805,   582,
     107,     0,   334,   578,   253,   337,   338,   178,   965,   165,
     967,  2809,   969,   922,  1945,    88,   518,  3007,   338,   370,
    1383,   306,  2165,   374,   981,   982,   125,   352,  2267,   314,
     338,   494,  1395,   578,   991,   992,   145,    64,  1528,   450,
     270,    68,   471,   370,   578,  1002,   217,  2253,  2030,   221,
     166,   112,   374,   345,  3253,   518,  1963,   229,   337,   166,
     535,  3666,   578,  1461,   335,  2303,  2166,  1024,  1025,  1026,
    1027,   204,  2303,  1024,  1025,   578,   578,  1034,  3207,  1036,
    3171,  3172,   511,  1034,   111,  1042,    88,   203,   125,  3519,
    3520,  1042,  2105,   200,   490,   380,   203,  2110,  1588,  1589,
      12,  1591,   107,  1593,  1594,  1595,  1596,  1597,  1065,  1599,
    1600,   515,  2125,   391,   440,   578,   289,  1026,  1027,  2132,
     354,   585,   470,   494,   372,   430,   474,    88,    54,  2966,
    2967,    34,    16,  2958,  2147,  2148,  2424,   270,    38,   567,
     491,  2154,  1816,   428,   550,   494,   219,   518,   440,  2162,
     503,   267,  2261,  3142,  1111,   506,  1065,  1114,   564,  2268,
     267,   166,   494,   236,   496,     8,   509,   499,   490,   518,
    2702,   344,   217,   550,  3442,  2651,   249,   509,  3608,  2086,
     490,   532,   525,   515,    27,   357,   518,   564,  2201,   107,
    2506,    12,    13,   238,  2510,   515,   547,   100,   203,   477,
     332,   333,  1111,   421,   107,   535,  1163,   515,  1165,  1166,
    1167,   238,  1169,   125,  3204,  1166,  1167,   219,   436,  3487,
     120,  1178,   338,  1180,   442,  3354,   213,  3356,   335,   578,
     156,   338,   390,   159,   236,   540,   541,   393,   570,   571,
     107,  3406,   420,  3408,   462,   403,   172,   249,   166,   229,
     580,   324,    55,    56,  3561,   158,   430,  1214,   219,   217,
    1169,    64,   267,   166,   549,  2278,    87,   441,  3075,  2704,
    2705,  2706,   252,   578,   491,   236,   561,   414,   469,   416,
     438,   418,   550,   420,   455,   203,   213,   488,   249,   490,
    1705,   347,  3599,   226,   115,   553,   564,  1254,  2733,   166,
     203,    20,   493,  3156,   578,   332,   333,   175,   129,    28,
     337,   585,   579,   491,    33,   275,   276,   344,   425,   490,
     491,   270,   324,   585,   431,   432,   433,   434,   435,   405,
     151,   532,  3639,   338,   578,   145,   203,   351,    68,   466,
     354,   585,   163,   416,    11,   372,   152,  3654,   344,   267,
      80,   522,   332,   333,   532,  1312,  3663,  1772,   578,   456,
     457,   532,   459,   324,   267,  1538,   540,   541,  1541,   547,
    1327,   192,   535,   299,   444,   445,  2615,  1550,   383,   467,
     468,   386,   470,   344,   472,   373,  1559,  2523,  2524,   420,
    3697,   121,  3699,   488,   531,   192,   217,   579,   580,   515,
     267,    88,   223,   476,   578,   349,     3,   214,   515,   344,
    2648,   580,   439,   954,   416,   395,   957,  2648,    47,   960,
     338,    18,   325,  2739,  1914,   543,  1383,  1409,   546,  1411,
     175,  1388,    47,  1390,   337,   338,   396,   397,  1395,  2745,
     263,   262,  2748,  2749,  1401,   580,  1403,   570,   571,   579,
     580,  1408,  1409,   344,  1411,   416,   382,  2773,  2774,  2765,
    1442,  1443,  1444,  2701,   426,  2781,  1423,   521,   335,  1426,
    2701,   338,  2788,   453,   476,  1432,  1433,  1434,  1435,   579,
     580,   579,   580,    88,   263,  1442,  1443,  1444,   572,  2727,
     150,    88,   511,   290,   291,   522,  2727,   294,   295,  1408,
    1409,   441,  1411,  1460,   579,   580,   578,  1997,  1998,   253,
     515,   241,  1469,  2256,  1423,   476,   172,  1426,   471,  1353,
    1354,  1355,  1356,  1357,   471,  1434,  1435,   287,  2018,  1486,
     579,   580,   219,  1442,  1443,  1444,   488,  2544,   579,   580,
     458,  1498,   471,  3307,   579,   580,   579,   580,   145,   236,
     579,   580,   471,  1510,   375,   579,   580,   263,  1921,  1516,
    1923,  1924,   249,   142,   431,   432,   433,   434,   435,   579,
     580,    78,   169,   394,   580,   172,   579,   580,   346,   400,
     484,   311,   579,   580,   579,   406,   399,   567,   568,  1498,
    2264,   494,   429,   496,   145,  2608,   499,   515,   195,    15,
      16,  1999,   332,   333,   201,   335,   509,  1516,  2277,   430,
    1973,  1974,   515,   164,   219,   518,   547,   214,  1575,    52,
     579,   580,   219,   579,   580,   446,   447,  1584,  3453,   226,
     120,   236,   152,   184,   579,   580,   578,   324,   584,   236,
     579,   580,   579,   580,   249,  3469,  2009,   198,   515,   579,
     580,   211,   249,  3539,   547,  1612,   253,   344,  3360,   389,
     580,  1612,   483,   580,  2027,   262,   575,   570,   571,   579,
     580,    55,    56,   579,   580,  2811,  1349,  1350,  1635,   145,
     146,  1638,   578,  3001,  3002,   579,   580,   579,   580,   579,
     580,  2929,   243,   244,   579,   580,   579,   580,  2929,   579,
     580,  3019,     3,  2118,   585,     6,   578,  3025,   529,   578,
     531,  2126,    13,   579,   580,   205,   579,   580,   184,   324,
     271,   578,    23,    24,   579,   580,  1635,   324,   578,   416,
    3048,   578,   198,  3051,   579,   580,   466,  2100,   578,   344,
     579,   580,    12,    13,  2107,   578,  2882,   344,   579,   580,
     579,   580,    53,   579,   580,   352,    57,   579,   580,   579,
     580,   579,   580,   579,   580,   558,   232,    68,   579,   580,
     579,   580,  2356,   263,  2315,   580,    77,   374,   244,   330,
     579,   580,    83,   579,   580,   579,   580,   579,   580,   476,
     579,   580,  1351,  1352,   578,    96,   578,   287,   578,  2705,
    2706,   578,  2356,  1296,  1297,   271,  3177,  3178,  2657,  2658,
     111,   416,   578,   114,  2627,  2628,   578,    87,   585,   416,
     371,  2364,   123,   124,  2919,  2920,   578,   578,   129,   578,
     578,   578,   578,   569,   584,   578,   137,   578,  1795,   578,
    2330,   578,   143,   578,   441,   115,   578,   578,    47,   578,
     578,  2300,   578,   578,   578,   578,   578,   578,   578,   129,
     578,  2809,   328,   494,   578,   578,   578,   578,   169,   578,
     578,   476,   553,   578,   578,   578,   578,    13,   578,   476,
     578,   151,   578,   373,   578,  2248,   578,   578,   578,   578,
     578,   381,   578,   163,   578,   578,   578,  2346,  2911,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   488,  3492,   578,   215,   578,   217,   578,   580,   409,
     578,   578,   192,   224,   521,   578,   578,   578,   578,  2419,
     578,   578,   578,   578,   578,   578,  2426,   534,   535,  1896,
     578,   578,   578,   578,   578,   578,   578,   217,   578,   287,
     578,    87,   578,   223,   551,   578,   553,  1914,  1915,   578,
     450,   578,   578,   258,  1921,   578,  1923,  1924,   578,   578,
     578,   578,   578,   287,   578,   578,   578,   578,   578,   115,
     578,   471,   579,   580,   580,  3565,   580,   580,   503,   586,
     580,   292,   262,   129,   503,   580,   580,  2671,   488,   580,
     490,  3581,   229,  3583,  1961,   494,   307,   572,   172,   230,
     486,   312,   160,   172,   580,   151,  1973,  1974,   528,   580,
     452,   363,   578,   580,   579,   145,  1983,   163,   145,   145,
     145,   145,  1989,  2455,   145,  1992,   145,   145,  1995,   145,
     145,   145,  3622,   145,   145,  3625,   145,   145,   580,  2006,
    2007,   352,  2009,  3633,  2961,  2418,   192,   358,  2015,  2016,
     361,   530,   579,    45,   344,   175,   179,    64,  2025,    12,
    2027,   579,   494,     3,  2031,  2032,   579,   125,     9,   579,
    3660,   217,   579,   384,   385,   550,   387,   223,    18,   585,
     578,  3671,   579,   571,   252,   580,   390,   551,   192,   218,
     401,   585,   175,   450,  3684,   375,   579,   381,   441,   580,
     580,   172,    45,   466,  2071,  2072,  2025,   466,   466,   429,
     466,   466,   423,    67,   394,   503,   262,  2796,   122,   489,
     400,  3711,  3712,    23,    24,  3715,   406,   237,   489,   122,
     237,    45,   580,  2100,   580,   535,   585,    18,   572,   580,
    2107,   579,   579,   175,   580,  3386,   579,   578,    88,   579,
     430,   579,  2071,  2120,   579,    55,    56,    57,   579,   579,
     579,   585,   580,   580,    64,   580,   446,   447,    68,  3292,
    3293,  3294,  3295,   579,   579,   583,   580,    77,   580,    23,
      24,   579,   273,   274,   275,   276,   277,   278,  3268,   579,
     281,   282,   283,   284,   285,   286,    96,   288,   580,  2166,
     579,   512,   580,   483,   580,   145,   579,   442,   580,   580,
     521,   111,   580,    57,   114,   579,   262,   258,   580,   585,
     580,   568,   494,   175,    68,   579,   503,   580,   579,   375,
     580,   580,   172,    77,   580,   579,  2915,   503,   580,   580,
     579,   578,   580,   143,   580,   580,   579,   579,   394,   529,
     580,   531,    96,   579,   400,   195,  3497,   579,   579,  3282,
     406,   201,   580,   579,   579,   579,   579,   111,   580,   580,
     114,   579,   579,   579,   503,   586,   579,   579,   579,   219,
     580,  2248,   580,   580,   430,   580,   226,  2660,   579,   585,
     579,   579,   555,   580,   580,   580,   236,   579,   579,   143,
     446,   447,   580,  2676,   579,   396,   397,   580,   579,   249,
     579,   579,  2279,   253,   579,   579,  2283,   217,  2285,  2286,
    2287,  2288,   262,   578,   224,   578,   580,   579,   503,  2296,
     580,   578,   349,  2300,   175,   175,  2303,   483,   226,   175,
     585,   233,   585,   553,   338,   236,   580,   236,   303,   355,
    2317,  2318,  2319,    96,  2905,    96,   238,   578,   238,   585,
     578,   494,   578,  2330,   352,   572,   579,   579,   225,  2336,
     338,  2338,   338,   217,   579,   579,   579,  2296,   175,  2346,
     224,   175,   175,   529,   324,   531,   565,   338,   141,   579,
     579,   585,   292,   585,   585,   579,   579,   579,   578,   572,
     344,   214,   580,   579,   344,   175,   229,   307,   585,  3657,
      64,   250,   352,   275,   236,   236,  3657,   344,   580,   238,
     238,   580,    18,   529,   344,    18,   579,    18,   578,   253,
       7,   579,   579,   578,   374,   579,   578,  3678,   227,   227,
    2407,   579,    19,   579,   579,    22,  3694,   579,   292,   580,
     132,  2418,    29,  3694,  2421,   247,  3091,   579,   358,   430,
    2960,   361,    39,   307,   195,   443,  3174,  3175,  3176,   145,
    3593,   355,    49,   565,   579,   236,   416,   579,   579,   579,
     579,   579,   585,   579,   384,   385,   580,   387,  2455,   579,
     579,   579,   579,   579,   579,  2462,   580,   579,  2465,   579,
     579,   441,  2469,  2470,   579,   579,  2473,  3217,   580,   579,
      87,   580,   580,   579,   358,   579,  2483,   361,   579,   579,
     579,   236,   579,   423,   579,   579,   579,   579,  3028,   579,
     107,   108,   579,   110,   585,   580,   476,   579,   111,   579,
     384,   385,   579,   387,   121,   579,  2465,   580,   579,   111,
     580,   580,   579,   579,   579,   579,   579,   579,  3237,  3238,
     580,   579,   578,  3198,  2483,  3688,   579,   579,   578,   580,
     579,  2944,   580,   369,   579,   578,  3211,  3700,   580,   423,
     578,   521,   578,   578,   585,   437,   338,   578,   578,   578,
     338,   338,   579,   579,   579,   535,  3004,   579,    41,   381,
     579,   338,  3725,   579,   579,   579,   579,   553,   226,   579,
      45,   551,   512,   553,   201,   580,   585,  3117,   580,   310,
     494,   521,   390,   494,   236,   535,   535,   172,   578,   578,
     578,   338,   338,   578,  3007,    32,   578,   338,   546,   579,
     580,  3351,   546,   529,   111,   337,   586,   553,   238,   238,
     338,   338,   338,   338,  3027,   338,   579,   578,   580,   514,
     579,   579,   579,   579,   579,   310,  3091,   580,   512,   580,
     154,   238,   579,    66,   579,    16,   579,   521,   579,   494,
     580,  2648,  2649,   579,  2651,   579,  3365,   580,   494,   579,
     494,   334,   579,  2660,   579,   236,   579,   535,   535,  2666,
     579,   579,  3253,   579,    23,    24,   579,   579,   541,  2676,
     579,   579,   579,   579,   579,   172,   580,  2684,   579,   338,
     580,   579,   338,   349,   529,   490,   255,   276,   578,   578,
     578,    58,   349,    58,  2701,   374,    55,    56,    57,    45,
      45,    45,   138,   145,  3244,    64,  2713,   579,   579,    68,
     579,   579,   579,  2720,   394,     5,   134,   349,    77,   579,
    2727,   349,   413,   580,    45,    45,  2733,    45,   579,   121,
     580,   424,  3145,  3198,    16,   583,   579,    96,   550,   578,
     587,   280,   145,   175,   550,   226,  3211,   141,   579,  3424,
     580,   586,   111,   579,   213,   114,   565,   141,   109,   550,
     269,   586,   128,   587,   214,   586,   566,   338,   141,   580,
     565,   578,   199,   586,   441,   255,   580,   141,   404,   172,
     566,   172,   172,   565,   143,  3460,  3461,   111,  3463,   552,
     541,  3204,  1842,   173,  1602,   694,  3587,  3248,   415,  3368,
    2807,  3241,    30,  3725,    32,    33,  3688,  3696,   425,  3619,
    3578,  3619,   429,  3585,  3074,  1101,   409,   434,  2803,  3169,
    1571,  1160,   439,  2072,  2034,  1987,  1575,    55,    56,  3504,
    2733,  3506,  3507,  1537,  3196,  2789,  2756,    65,  2990,    67,
    2756,  3036,  3412,  2720,   461,  3027,  2676,  2721,  3421,  3188,
    3569,  3337,  2079,  3255,  1173,  2030,  3211,    85,   217,    87,
    1505,   478,  1891,  1434,  2296,   224,  1873,    95,  1079,   687,
    1905,   488,  1156,   473,   617,   492,   703,  3302,  2914,  3117,
    1449,   498,  2915,   500,   501,  1348,  1251,  2691,   505,   506,
    1346,  2108,  3411,   252,  3613,  3361,  2269,  3166,   515,  2906,
    1201,  3613,   519,   992,  3145,  2727,  1910,   524,   525,  1895,
     527,   528,   529,   530,   142,   143,  2929,  1869,  2642,   147,
    2701,  2643,  2929,  3678,   740,  3497,   463,  1178,   520,   969,
    1494,   454,  2633,   292,  3588,  3568,  3436,  2944,  1400,  3399,
    3467,  3694,   997,  3029,  1455,  2648,   563,  2684,   307,   177,
    2955,   179,  2348,  3153,   446,   600,  1010,  1426,   962,  3424,
    3290,  1000,   579,   191,  1165,   193,   604,  2283,  3296,   447,
     587,   588,  1322,  3113,   490,   592,   736,  2070,  2985,  2800,
      -1,  3071,   599,    -1,    -1,    -1,    -1,    -1,   216,   217,
      -1,    -1,   220,    -1,    -1,  3460,  3461,    -1,  3463,   358,
    3007,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,   629,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3027,    -1,    -1,    -1,    -1,   384,   385,    -1,   387,    -1,
     258,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,  3504,
      -1,  3506,  3507,    -1,    -1,  3052,    -1,  3054,    -1,    -1,
      -1,  3499,    -1,    -1,    -1,    -1,    -1,  3064,    -1,   287,
      -1,    -1,    -1,  3070,   423,    -1,    -1,    -1,    -1,    -1,
      -1,   688,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   696,
      -1,    -1,   699,    -1,    -1,   702,   703,    -1,    -1,    -1,
      -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   329,    -1,    -1,    -1,  3064,    -1,    23,    24,  3609,
    3117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,
      -1,   738,    -1,   740,    -1,    -1,  3539,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3145,    55,
      56,    57,    -1,    -1,    -1,   373,   374,    -1,    64,   377,
     378,    -1,    68,   512,    -1,    -1,    -1,    -1,  3165,    -1,
      -1,    77,   521,    -1,  3171,  3172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3185,    -1,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   111,    -1,  3204,   114,    -1,
    3700,    -1,    -1,    -1,    -1,    -1,    -1,   435,    -1,    -1,
      -1,    -1,   440,    -1,    -1,    -1,    -1,    -1,    -1,   578,
      -1,    -1,   450,    -1,    -1,  3725,    -1,   143,    -1,    -1,
      -1,    -1,     6,    -1,    -1,  3242,    -1,    -1,    -1,    13,
      -1,    -1,    -1,   471,    -1,    -1,    -1,   475,  3255,    23,
      24,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3723,    -1,
      -1,  3674,   490,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   888,    -1,   890,    -1,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,   217,    -1,    77,    -1,   922,    -1,    -1,   224,    83,
      -1,   928,    -1,    -1,    -1,    -1,   544,    -1,    -1,    -1,
     548,    -1,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   965,   123,
     967,    -1,   969,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,  3368,    -1,   137,   981,   982,    -1,    -1,    -1,   143,
      -1,    -1,    -1,    -1,   991,   992,   292,    -1,    -1,  3386,
    3387,    -1,    -1,    -1,    -1,  1002,    -1,    -1,    -1,    -1,
      -1,   307,    -1,  1010,    -1,   169,    -1,    -1,    -1,  3406,
      -1,  3408,    -1,  3410,  3411,    -1,    -1,  1024,  1025,  1026,
    1027,    -1,    -1,    -1,    -1,  3422,    -1,  1034,    -1,  1036,
      -1,    -1,    -1,    -1,    -1,  1042,    -1,    -1,  3387,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   217,    -1,   361,    -1,    -1,  1065,    -1,
     224,  3458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,
      -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3492,    -1,    -1,    -1,    -1,
    3497,    -1,    -1,    -1,  1111,    -1,    -1,  1114,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,  3516,
      -1,    -1,  3519,  3520,  3521,    -1,    -1,    -1,   292,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3539,   307,    -1,    -1,    -1,    -1,   312,    -1,
      -1,    -1,    -1,  3550,    -1,    -1,  1163,    -1,  1165,  1166,
    1167,    -1,  1169,  3560,  3561,    -1,    -1,    -1,  3565,    -1,
      -1,  1178,    -1,  1180,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3581,    -1,  3583,    -1,   352,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,    -1,  3599,    -1,    -1,    -1,   512,  1214,    -1,    -1,
      -1,  3608,    -1,    -1,    -1,   521,    -1,    -1,  3615,    -1,
     384,   385,    -1,   387,    -1,  3622,    -1,  3624,  3625,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3633,   401,    -1,    -1,
      -1,    -1,  3639,    -1,    -1,    -1,    -1,  1254,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3654,    -1,   423,
    3657,    -1,  3659,  3660,    -1,    -1,  3663,    -1,  3665,    -1,
      -1,    -1,    -1,    -1,  3671,    -1,    -1,  3674,    -1,    -1,
      -1,  3678,    -1,    -1,    -1,    -1,    -1,  3684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,  3694,    -1,    -1,
    3697,    -1,  3699,  3700,    -1,  1312,    13,    14,    -1,    -1,
      -1,    -1,    -1,    -1,  3711,  3712,    -1,    -1,  3715,    26,
    1327,    28,    -1,    -1,    -1,    -1,    -1,    -1,  3725,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    -1,    53,    -1,   512,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,   521,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1383,    -1,    -1,    -1,
      87,  1388,    -1,  1390,    -1,    -1,    -1,    -1,  1395,    -1,
      -1,    -1,    -1,    -1,  1401,    -1,  1403,    -1,    -1,   106,
      -1,  1408,  1409,    -1,  1411,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,    -1,    -1,    -1,  1423,    -1,    -1,  1426,
      -1,   128,   129,    -1,    -1,  1432,  1433,  1434,  1435,    -1,
      -1,    -1,    -1,    -1,    -1,  1442,  1443,  1444,    -1,   101,
     102,   103,   104,   105,   151,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   168,  1469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1486,
      -1,    -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,    -1,
      -1,  1498,   199,    -1,    -1,   202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1510,    -1,    -1,    -1,    -1,    -1,  1516,
      -1,    -1,   174,    -1,    -1,    -1,   223,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   206,   207,   208,   209,    -1,    -1,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,    13,    14,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1575,    -1,
      -1,    26,    -1,    -1,    -1,    -1,    -1,  1584,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    53,    -1,
      -1,    -1,    57,    58,    -1,  1612,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,    -1,
      -1,  1638,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     302,   348,   304,   305,   306,    -1,    -1,    -1,    -1,    -1,
      -1,   106,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     115,   116,   117,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   128,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,   401,   402,   151,    -1,   405,    -1,
      -1,   408,    -1,   410,    -1,    -1,    -1,    -1,   415,    -1,
     417,    -1,    -1,   168,    -1,    -1,    -1,    -1,   380,   426,
      -1,    -1,    -1,   430,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,   192,    -1,   446,
      -1,    -1,    -1,   450,   199,    -1,    -1,   202,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   470,    -1,   427,   428,   474,   223,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,  1795,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   257,   510,    -1,    -1,    -1,   262,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   526,
      -1,    -1,   529,    -1,    -1,    -1,    -1,   534,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,  1896,
      -1,    -1,    -1,   348,    -1,    -1,    -1,    -1,   560,   561,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1914,  1915,    -1,
      -1,    -1,    -1,    -1,  1921,   370,  1923,  1924,    -1,    -1,
      -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   399,    -1,   401,   402,    -1,    -1,
     405,    -1,    -1,   408,  1961,   410,    -1,    -1,    -1,    -1,
     415,    -1,   417,    -1,    -1,    -1,  1973,  1974,    -1,    -1,
      -1,   426,    -1,    -1,    -1,   430,  1983,    -1,    -1,    -1,
      -1,    -1,  1989,    -1,    -1,  1992,   441,    -1,  1995,    -1,
      -1,   446,    -1,    -1,    -1,   450,    -1,    -1,    -1,  2006,
    2007,    -1,  2009,    -1,    -1,    -1,    -1,    -1,  2015,  2016,
      -1,    -1,    -1,    -1,    -1,   470,    -1,    -1,  2025,   474,
    2027,    -1,    -1,    -1,  2031,  2032,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2071,  2072,    -1,    31,    32,    -1,
      -1,   526,    -1,    37,   529,    39,   522,    41,    42,   534,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    56,  2100,    -1,    -1,    -1,    -1,    -1,    -1,
    2107,    -1,   557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   578,    -1,    -1,    -1,    -1,    -1,   575,
      -1,    -1,    -1,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2166,
      -1,    -1,    -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   165,    -1,   167,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     706,    -1,    -1,   227,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2279,    -1,    -1,    -1,  2283,    -1,  2285,  2286,
    2287,  2288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2296,
      -1,    -1,   256,  2300,    -1,    -1,  2303,    -1,    -1,    -1,
      -1,   265,   266,    -1,   268,    -1,    -1,    -1,    -1,    -1,
    2317,  2318,  2319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2330,    -1,    -1,    -1,    -1,    -1,  2336,
      -1,  2338,   296,   297,   298,    -1,    -1,  3492,    -1,  2346,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   317,   318,   319,    -1,    -1,    -1,   323,
      -1,   807,   326,    -1,  3519,  3520,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2407,   365,    -1,   367,    -1,  3560,  3561,    -1,    -1,    -1,
    3565,  2418,    -1,    -1,  2421,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3581,   391,  3583,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   882,    -1,    -1,    -1,
     886,    -1,    -1,    -1,  3599,    -1,    -1,    -1,  2455,    -1,
      -1,    -1,    -1,  3608,    -1,  2462,    -1,    -1,  2465,    -1,
      -1,    -1,  2469,  2470,    -1,    -1,  2473,  3622,    -1,    -1,
    3625,    -1,    -1,    -1,    -1,   439,  2483,   441,  3633,    -1,
      -1,    -1,    -1,    -1,  3639,    -1,    -1,   451,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3654,
      -1,    -1,    -1,    -1,    -1,  3660,    -1,    -1,  3663,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3671,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3684,
      -1,   495,   496,    -1,    -1,   499,   500,   501,   502,    -1,
      -1,    -1,  3697,    -1,  3699,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3711,  3712,    -1,    -1,
    3715,    -1,    -1,    -1,  1010,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1019,    -1,    -1,    -1,    -1,   542,   543,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2648,  2649,    -1,  2651,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2660,    -1,    -1,    -1,    -1,    -1,  2666,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2676,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2701,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2713,    -1,    -1,    -1,
      -1,    -1,    -1,  2720,    -1,    -1,    -1,    -1,    -1,    -1,
    2727,    -1,    -1,    -1,    -1,    -1,  2733,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1182,  1183,  1184,    -1,
      -1,    -1,    -1,    -1,    -1,  1191,  1192,    -1,    -1,  1195,
      -1,  1197,  1198,  1199,  1200,    -1,    -1,    -1,  1204,    -1,
      -1,  1207,  1208,    -1,  1210,    -1,  1212,  1213,    -1,  1215,
    1216,  1217,  1218,  1219,    -1,  1221,    -1,  1223,  1224,  1225,
      -1,  1227,  1228,  1229,  1230,    -1,  1232,  1233,    -1,  1235,
      -1,    -1,  1238,  1239,  1240,    -1,  1242,  1243,  1244,  1245,
    2807,  1247,  1248,  1249,  1250,    -1,    -1,    -1,    -1,    -1,
    1256,  1257,    -1,  1259,  1260,  1261,  1262,  1263,    -1,    -1,
      -1,    -1,  1268,    -1,  1270,  1271,  1272,  1273,  1274,    -1,
      -1,  1277,  1278,  1279,  1280,  1281,  1282,    -1,  1284,  1285,
      -1,    -1,  1288,  1289,  1290,    -1,  1292,    -1,  1294,    -1,
      -1,    -1,  1298,    -1,  1300,  1301,    -1,    -1,    -1,    -1,
    1306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1314,  1315,
    1316,    -1,    -1,    -1,    -1,    -1,    -1,  1323,    -1,    -1,
    1326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2944,    -1,  1385,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2985,    -1,
      -1,    -1,    -1,  1429,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3007,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3027,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3052,    -1,  3054,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3064,    -1,    -1,
      -1,    -1,    -1,  3070,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3145,    -1,
    1586,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3165,    -1,
      -1,    -1,    -1,    -1,  3171,  3172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3185,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3204,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3242,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3255,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1767,  1768,  1769,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1784,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3368,    -1,  1809,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3386,
    3387,    -1,    -1,    -1,    -1,    -1,  1832,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3406,
      -1,  3408,    -1,  3410,  3411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3422,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3516,
      -1,    -1,    -1,    -1,  3521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3539,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3550,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3615,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3624,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2087,    -1,    -1,  2090,    -1,    -1,  2093,  2094,    -1,
    3657,    -1,  3659,    -1,    -1,    -1,    -1,    -1,  3665,    -1,
    2106,    -1,    -1,  2109,    -1,    -1,    -1,  3674,    -1,    -1,
      -1,  3678,    -1,    -1,    -1,    -1,  2122,    -1,  2124,    -1,
      -1,    -1,  2128,    -1,  2130,  2131,    -1,  3694,    -1,  2135,
      -1,  2137,  2138,  3700,  2140,    -1,    -1,  2143,    -1,  2145,
    2146,    -1,    -1,    -1,    -1,  2151,  2152,    -1,    -1,  2155,
      -1,  2157,    -1,  2159,    -1,  2161,    -1,  2163,  3725,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,  2175,
      -1,    -1,  2178,    -1,  2180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2188,  2189,    -1,  2191,    -1,  2193,    -1,    -1,
    2196,  2197,  2198,    -1,  2200,    -1,    -1,    -1,    -1,  2205,
    2206,  2207,  2208,    -1,    -1,    -1,    -1,  2213,  2214,  2215,
      -1,  2217,    -1,  2219,    -1,  2221,    -1,  2223,    -1,  2225,
      -1,    -1,    -1,    -1,    -1,    -1,  2232,    -1,  2234,    -1,
      -1,  2237,  2238,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2249,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2290,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2339,    -1,    -1,    -1,    -1,  2344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2402,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2572,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2582,    -1,  2584,    -1,
    2586,    -1,    -1,    -1,    -1,    -1,  2592,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2617,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2685,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2830,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2840,    -1,    -1,    -1,    -1,    -1,
    2846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2855,
    2856,    -1,    -1,    -1,    -1,  2861,    -1,    -1,    -1,  2865,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2878,    -1,    -1,    -1,    -1,    -1,  2884,    -1,
      -1,  2887,  2888,    -1,  2890,  2891,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2904,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2970,  2971,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2981,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3140,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3153,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3264,    -1,
      -1,    -1,    -1,    -1,  3270,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3316,    -1,  3318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3390,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3447,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3470,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3555,
    3556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3574,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3584,    -1,
      -1,    -1,    -1,  3589,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3598,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,  3629,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,  3640,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,  3701,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,   245,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,
     443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,
     453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,
      -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,   472,
     473,   474,   475,    -1,   477,   478,   479,   480,   481,   482,
     483,   484,   485,   486,   487,   488,   489,    -1,   491,   492,
      -1,   494,   495,   496,   497,   498,   499,    -1,    -1,    -1,
      -1,   504,   505,    -1,   507,   508,   509,   510,   511,   512,
     513,    -1,   515,   516,   517,   518,    -1,   520,    -1,    -1,
     523,   524,   525,    -1,    -1,   528,    -1,   530,    -1,   532,
     533,    -1,    -1,   536,   537,   538,   539,   540,   541,    -1,
      -1,   544,   545,    -1,   547,   548,   549,    -1,    -1,    -1,
      -1,   554,    -1,   556,   557,    -1,   559,    -1,   561,    -1,
      -1,    -1,    -1,   566,    -1,    -1,    -1,   570,   571,    -1,
      -1,    -1,    -1,   576,    -1,   578,    -1,    -1,   581,   582,
      -1,   584,   585,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,   344,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,
      -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,
     452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
     462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,    -1,   477,   478,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,    -1,   491,
     492,    -1,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,    -1,   505,    -1,   507,   508,   509,   510,   511,
     512,   513,    -1,   515,   516,   517,   518,    -1,   520,    -1,
      -1,   523,   524,   525,    -1,    -1,   528,    -1,   530,    -1,
     532,   533,    -1,    -1,   536,   537,   538,   539,   540,   541,
      -1,    -1,   544,   545,    -1,   547,   548,   549,    -1,    -1,
      -1,    -1,   554,    -1,   556,   557,    -1,   559,    -1,   561,
      -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,   570,   571,
      -1,    -1,    -1,    -1,   576,    -1,   578,    -1,    -1,   581,
     582,    -1,   584,   585,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,   430,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,   472,   473,   474,   475,    -1,   477,   478,   479,   480,
     481,   482,   483,   484,   485,   486,   487,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,   508,   509,   510,
     511,   512,   513,    -1,   515,   516,   517,   518,    -1,   520,
      -1,    -1,   523,   524,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,   536,   537,   538,   539,   540,
     541,    -1,    -1,   544,   545,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,   570,
     571,    -1,    -1,    -1,    -1,   576,    -1,   578,    -1,    -1,
     581,   582,    -1,   584,   585,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,   439,
     440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,
     450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,
      -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,    -1,   477,   478,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   488,   489,
      -1,   491,   492,    -1,   494,   495,   496,   497,   498,   499,
      -1,    -1,    -1,    -1,    -1,   505,    -1,   507,   508,   509,
     510,   511,   512,   513,    -1,   515,   516,   517,   518,    -1,
     520,    -1,    -1,   523,   524,   525,    -1,    -1,   528,    -1,
     530,    -1,   532,   533,    -1,    -1,   536,   537,   538,   539,
     540,   541,    -1,    -1,   544,   545,    -1,   547,   548,   549,
      -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
     570,   571,    -1,    -1,    -1,    -1,   576,    -1,   578,   579,
      -1,   581,   582,    -1,   584,   585,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,
     439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,
     449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,
      -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,
      -1,   470,   471,   472,   473,   474,   475,    -1,   477,   478,
     479,   480,   481,   482,   483,   484,   485,   486,   487,   488,
     489,    -1,   491,   492,    -1,   494,   495,   496,   497,   498,
     499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,   508,
     509,   510,   511,   512,   513,    -1,   515,   516,   517,   518,
      -1,   520,    -1,    -1,   523,   524,   525,    -1,    -1,   528,
      -1,   530,    -1,   532,   533,    -1,    -1,   536,   537,   538,
     539,   540,   541,    -1,    -1,   544,   545,    -1,   547,   548,
     549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
      -1,   570,   571,    -1,    -1,    -1,    -1,   576,    -1,   578,
     579,    -1,   581,   582,    -1,   584,   585,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,
     438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,
     448,   449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,
      -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,    -1,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,    -1,   491,   492,    -1,   494,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,
     508,   509,   510,   511,   512,   513,    -1,   515,   516,   517,
     518,    -1,   520,    -1,    -1,   523,   524,   525,    -1,    -1,
     528,    -1,   530,    -1,   532,   533,    -1,    -1,   536,   537,
     538,   539,   540,   541,    -1,    -1,   544,   545,    -1,   547,
     548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,
      -1,   559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,
      -1,    -1,   570,   571,    -1,    -1,    -1,    -1,   576,    -1,
     578,   579,    -1,   581,   582,    -1,   584,   585,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,    -1,   435,    -1,
      -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,
     447,   448,   449,   450,    -1,   452,   453,   454,    -1,    -1,
      -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,
     467,    -1,    -1,   470,   471,   472,   473,   474,   475,    -1,
     477,   478,   479,   480,   481,   482,   483,   484,   485,   486,
     487,   488,   489,    -1,   491,   492,    -1,   494,   495,   496,
     497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,
     507,   508,   509,   510,   511,   512,   513,    -1,   515,   516,
     517,   518,    -1,   520,    -1,    -1,   523,   524,   525,    -1,
      -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,   536,
     537,   538,   539,   540,   541,    -1,    -1,   544,   545,    -1,
     547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,
     557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,   566,
      -1,    -1,    -1,   570,   571,    -1,    -1,    -1,    -1,   576,
      -1,   578,   579,    -1,   581,   582,    -1,   584,   585,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
      -1,   477,   478,   479,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,   508,   509,   510,   511,   512,   513,    -1,   515,
     516,   517,   518,    -1,   520,    -1,    -1,   523,   524,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
     536,   537,   538,   539,   540,   541,    -1,    -1,   544,   545,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,    -1,
     566,    -1,    -1,    -1,   570,   571,    -1,    -1,    -1,    -1,
     576,    -1,   578,    -1,    -1,   581,   582,    -1,   584,   585,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,    -1,
     435,    -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,
      -1,    -1,   447,   448,   449,   450,    -1,   452,   453,   454,
      -1,    -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,
      -1,    -1,   467,    -1,    -1,   470,   471,   472,   473,   474,
     475,    -1,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,    -1,   491,   492,    -1,   494,
     495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,
     505,    -1,   507,   508,   509,   510,   511,   512,   513,    -1,
     515,   516,   517,   518,    -1,   520,    -1,    -1,   523,   524,
     525,    -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,
      -1,   536,   537,   538,   539,   540,   541,    -1,    -1,   544,
     545,    -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,
      -1,   556,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,   570,   571,    -1,    -1,    -1,
      -1,   576,    -1,   578,    -1,    -1,   581,   582,    -1,   584,
     585,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
      -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,   443,
      -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,   453,
     454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,    -1,
     464,    -1,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,    -1,   477,   478,   479,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,    -1,   491,   492,    -1,
     494,   495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,
      -1,   505,    -1,   507,   508,   509,   510,   511,   512,   513,
      -1,   515,   516,   517,   518,    -1,   520,    -1,    -1,   523,
     524,   525,    -1,    -1,   528,    -1,   530,    -1,   532,   533,
      -1,    -1,   536,   537,   538,   539,   540,   541,    -1,    -1,
     544,   545,    -1,   547,   548,   549,    -1,    -1,    -1,    -1,
     554,    -1,   556,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,   570,   571,    -1,    -1,
      -1,    -1,   576,    -1,   578,    -1,    -1,   581,   582,    -1,
     584,   585,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,
     443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,
     453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,
      -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,   472,
     473,   474,   475,    -1,   477,   478,   479,   480,   481,   482,
     483,   484,   485,   486,   487,   488,   489,    -1,   491,   492,
      -1,   494,   495,   496,   497,   498,   499,    -1,    -1,    -1,
      -1,    -1,   505,    -1,   507,   508,   509,   510,   511,   512,
     513,    -1,   515,   516,   517,   518,    -1,   520,    -1,    -1,
     523,   524,   525,    -1,    -1,   528,    -1,   530,    -1,   532,
     533,    -1,    -1,   536,   537,   538,   539,   540,   541,    -1,
      -1,   544,   545,    -1,   547,   548,   549,    -1,    -1,    -1,
      -1,   554,    -1,   556,   557,    -1,   559,    -1,   561,    -1,
      -1,    -1,    -1,   566,    -1,    -1,    -1,   570,   571,    -1,
      -1,    -1,    -1,   576,    -1,   578,    -1,    -1,   581,   582,
      -1,   584,   585,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,
      -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,
     452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
     462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,    -1,   477,   478,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,    -1,   491,
     492,    -1,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,    -1,   505,    -1,   507,   508,   509,   510,   511,
     512,   513,    -1,   515,   516,   517,   518,    -1,   520,    -1,
      -1,   523,   524,   525,    -1,    -1,   528,    -1,   530,    -1,
     532,   533,    -1,    -1,   536,   537,   538,   539,   540,   541,
      -1,    -1,   544,   545,    -1,   547,   548,   549,    -1,    -1,
      -1,    -1,   554,    -1,   556,   557,    -1,   559,    -1,   561,
      -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,   570,   571,
      -1,    -1,    -1,    -1,   576,    -1,   578,    -1,    -1,   581,
     582,    -1,   584,   585,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,   472,   473,   474,   475,    -1,   477,   478,   479,   480,
     481,   482,   483,   484,   485,   486,   487,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,   508,   509,   510,
     511,   512,   513,    -1,   515,   516,   517,   518,    -1,   520,
      -1,    -1,   523,   524,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,   536,   537,   538,   539,   540,
     541,    -1,    -1,   544,   545,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,   559,    -1,
     561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,   570,
     571,    -1,    -1,    -1,    -1,   576,    -1,   578,    -1,    -1,
     581,   582,    -1,   584,   585,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,   439,
     440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,
     450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,
      -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,    -1,   477,   478,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   488,   489,
      -1,   491,   492,    -1,   494,   495,   496,   497,   498,   499,
      -1,    -1,    -1,    -1,    -1,   505,    -1,   507,   508,   509,
     510,   511,   512,   513,    -1,   515,   516,   517,   518,    -1,
     520,    -1,    -1,   523,   524,   525,    -1,    -1,   528,    -1,
     530,    -1,   532,   533,    -1,    -1,   536,   537,   538,   539,
     540,   541,    -1,    -1,   544,   545,    -1,   547,   548,   549,
      -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
     570,   571,    -1,    -1,    -1,    -1,   576,    -1,   578,    -1,
      -1,   581,   582,    -1,   584,   585,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,
     439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,
     449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,
      -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,
      -1,   470,   471,   472,   473,   474,   475,    -1,   477,   478,
     479,   480,   481,   482,   483,   484,   485,   486,   487,   488,
     489,    -1,   491,   492,    -1,   494,   495,   496,   497,   498,
     499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,   508,
     509,   510,   511,   512,   513,    -1,   515,   516,   517,   518,
      -1,   520,    -1,    -1,   523,   524,   525,    -1,    -1,   528,
      -1,   530,    -1,   532,   533,    -1,    -1,   536,   537,   538,
     539,   540,   541,    -1,    -1,   544,   545,    -1,   547,   548,
     549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
      -1,   570,   571,    -1,    -1,    -1,    -1,   576,    -1,   578,
      -1,    -1,   581,   582,    -1,   584,   585,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,
     438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,
     448,   449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,
      -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,    -1,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,    -1,   491,   492,    -1,   494,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,
     508,   509,   510,   511,   512,   513,    -1,   515,   516,   517,
     518,    -1,   520,    -1,    -1,   523,   524,   525,    -1,    -1,
     528,    -1,   530,    -1,   532,   533,    -1,    -1,   536,   537,
     538,   539,   540,   541,    -1,    -1,   544,   545,    -1,   547,
     548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,
      -1,   559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,
      -1,    -1,   570,   571,    -1,    -1,    -1,    -1,   576,    -1,
     578,    -1,    -1,   581,   582,    -1,   584,   585,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    79,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,   178,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
     217,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,   238,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,   252,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,   430,   431,   432,   433,    -1,   435,    -1,
      -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,
     447,   448,   449,   450,    -1,   452,   453,   454,   455,    -1,
      -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,
     467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,    -1,
     477,   478,   479,    -1,    -1,    -1,   483,   484,   485,   486,
      -1,   488,   489,    -1,   491,   492,    -1,    -1,   495,   496,
     497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,
     507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,   516,
     517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,    -1,
      -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,    -1,
     547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,
     557,    -1,    -1,    -1,   561,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   585,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      79,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,   178,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,   217,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,   238,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,
     439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,
     449,   450,    -1,   452,   453,   454,   455,    -1,    -1,    -1,
      -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,
      -1,   470,   471,    -1,    -1,   474,   475,    -1,   477,   478,
     479,    -1,    -1,    -1,   483,   484,   485,   486,    -1,   488,
     489,    -1,   491,   492,    -1,    -1,   495,   496,   497,   498,
     499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,    -1,
      -1,   510,   511,   512,   513,    -1,    -1,   516,   517,    -1,
      -1,   520,    -1,    -1,    -1,    -1,   525,    -1,    -1,   528,
      -1,   530,    -1,   532,   533,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   541,    -1,    -1,   544,    -1,    -1,   547,   548,
     549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,
      -1,    -1,   561,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   585,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,   430,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,    -1,
     561,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   579,    -1,
      23,    24,    25,    26,   585,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,
     443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,
     453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,
      -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,    -1,
      -1,   474,   475,    -1,   477,   478,   479,    -1,    -1,    -1,
     483,   484,   485,   486,    -1,   488,   489,    -1,   491,   492,
      -1,    -1,   495,   496,   497,   498,   499,    -1,    -1,    -1,
      -1,    -1,   505,    -1,   507,    -1,    -1,   510,   511,   512,
     513,    -1,    -1,   516,   517,    -1,    -1,   520,    -1,    -1,
      -1,    -1,   525,    -1,    -1,   528,    -1,   530,    -1,   532,
     533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,
      -1,   544,    -1,    -1,   547,   548,   549,    -1,    -1,    -1,
      -1,   554,    -1,   556,   557,    -1,    -1,    -1,   561,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   579,    17,    -1,    -1,
      20,   584,   585,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,   226,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,   439,
     440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,
     450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,
      -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,   479,
      -1,    -1,    -1,   483,   484,   485,   486,    -1,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,   498,   499,
      -1,    -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,
     510,   511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,
     520,    -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,
     530,    -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,
      -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,
      -1,   561,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   585,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,
      -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,
     452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
     462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,    -1,
      -1,   483,   484,   485,   486,    -1,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,   511,
     512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,    -1,
      -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,    -1,
     532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,
      -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,    -1,
      -1,    -1,   554,    -1,   556,   557,    -1,    -1,    -1,   561,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
     572,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   585,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
      -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,   443,
      -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,   453,
     454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,    -1,
     464,    -1,    -1,   467,    -1,    -1,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,   479,    -1,    -1,    -1,   483,
     484,   485,   486,    -1,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,
      -1,   505,    -1,   507,    -1,    -1,   510,   511,   512,   513,
      -1,    -1,   516,   517,    -1,    -1,   520,    -1,    -1,    -1,
      -1,   525,    -1,    -1,   528,    -1,   530,    -1,   532,   533,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,
     544,    -1,    -1,   547,   548,   549,    -1,    -1,    -1,    -1,
     554,    -1,   556,   557,    -1,    -1,    -1,   561,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   578,    -1,    17,    -1,    -1,    20,
      -1,   585,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,    -1,
     561,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   584,   585,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,
     438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,
     448,   449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,
      -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,
      -1,    -1,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,   479,    -1,    -1,    -1,   483,   484,   485,   486,    -1,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,
      -1,    -1,   510,   511,   512,   513,    -1,    -1,   516,   517,
      -1,    -1,   520,    -1,    -1,    -1,    -1,   525,    -1,    -1,
     528,    -1,   530,    -1,   532,   533,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   541,    -1,    -1,   544,    -1,    -1,   547,
     548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,
      -1,    -1,    -1,   561,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   585,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,   439,
     440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,
     450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,
      -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,   479,
      -1,    -1,    -1,   483,   484,   485,   486,    -1,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,   498,   499,
      -1,    -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,
     510,   511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,
     520,    -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,
     530,    -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,
      -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,
      -1,   561,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   585,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,
      -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,
     452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
     462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,    -1,
      -1,   483,   484,   485,   486,    -1,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,   511,
     512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,    -1,
      -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,    -1,
     532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,
      -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,    -1,
      -1,    -1,   554,    -1,   556,   557,    -1,    -1,    -1,   561,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   585,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
      -1,   435,    -1,    -1,   438,   439,   440,    -1,    -1,   443,
      -1,    -1,    -1,   447,   448,   449,   450,    -1,   452,   453,
     454,    -1,    -1,    -1,    -1,    -1,    -1,   461,   462,    -1,
     464,    -1,    -1,   467,    -1,    -1,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,   479,    -1,    -1,    -1,   483,
     484,   485,   486,    -1,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,
      -1,   505,    -1,   507,    -1,    -1,   510,   511,   512,   513,
      -1,    -1,   516,   517,    -1,    -1,   520,    -1,    -1,    -1,
      -1,   525,    -1,    -1,   528,    -1,   530,    -1,   532,   533,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,
     544,    -1,    -1,   547,   548,   549,    -1,    -1,    -1,    -1,
     554,    -1,   556,   557,    -1,    -1,    -1,   561,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   585,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,   584,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,   584,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,   584,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,    -1,   566,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,   580,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,   438,
     439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,   448,
     449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,    -1,
      -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,    -1,
      -1,   470,   471,    -1,    -1,   474,   475,    -1,   477,   478,
     479,    -1,    -1,    -1,   483,   484,   485,   486,    -1,   488,
     489,    -1,   491,   492,    -1,    -1,   495,   496,   497,   498,
     499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,    -1,
      -1,   510,   511,   512,   513,    -1,    -1,   516,   517,    -1,
      -1,   520,    -1,    -1,    -1,    -1,   525,    -1,    -1,   528,
      -1,   530,    -1,   532,   533,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   541,    -1,    -1,   544,    -1,    -1,   547,   548,
     549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,    -1,
      -1,    -1,   561,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   572,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,    -1,   435,    -1,    -1,   438,   439,   440,    -1,
      -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,    -1,
     452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
     462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,    -1,
      -1,   483,   484,   485,   486,    -1,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,   511,
     512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,    -1,
      -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,    -1,
     532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,
      -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,    -1,
      -1,    -1,   554,    -1,   556,   557,    -1,    -1,    -1,   561,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     572,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,    -1,
     435,    -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,
      -1,    -1,   447,   448,   449,   450,    -1,   452,   453,   454,
      -1,    -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,
      -1,    -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,
     475,    -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,
     485,   486,    -1,   488,   489,    -1,   491,   492,    -1,    -1,
     495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,
     505,    -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,
      -1,   516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,
     525,    -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,
      -1,    -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,
      -1,   556,   557,    -1,    -1,    -1,   561,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,   572,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,    -1,   435,    -1,    -1,
     438,   439,   440,    -1,    -1,   443,    -1,    -1,    -1,   447,
     448,   449,   450,    -1,   452,   453,   454,    -1,    -1,    -1,
      -1,    -1,    -1,   461,   462,    -1,   464,    -1,    -1,   467,
      -1,    -1,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,   479,    -1,    -1,    -1,   483,   484,   485,   486,    -1,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,    -1,   505,    -1,   507,
      -1,    -1,   510,   511,   512,   513,    -1,    -1,   516,   517,
      -1,    -1,   520,    -1,    -1,    -1,    -1,   525,    -1,    -1,
     528,    -1,   530,    -1,   532,   533,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   541,    -1,    -1,   544,    -1,    -1,   547,
     548,   549,    -1,    -1,    -1,    -1,   554,    -1,   556,   557,
      -1,    -1,    -1,   561,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   572,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,   564,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,   550,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,   564,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,   550,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,   564,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,    -1,
     471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,    -1,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,    -1,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,     5,   566,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,   166,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,   267,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,   332,   333,    -1,   335,    -1,    -1,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,   457,   458,   459,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,   515,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,   145,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,   442,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      91,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    18,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    82,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,   153,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,   175,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,   372,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,   448,   449,   450,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,   510,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,   520,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,   530,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,   557,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,    -1,   435,    -1,    -1,   438,   439,   440,
      -1,    -1,   443,    -1,    -1,    -1,   447,   448,   449,   450,
      -1,   452,   453,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     461,   462,    -1,   464,    -1,    -1,   467,    -1,    -1,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,   479,    -1,
      -1,    -1,   483,   484,   485,   486,    -1,   488,   489,    -1,
     491,   492,    -1,    -1,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,    -1,   505,    -1,   507,    -1,    -1,   510,
     511,   512,   513,    -1,    -1,   516,   517,    -1,    -1,   520,
      -1,    -1,    -1,    -1,   525,    -1,    -1,   528,    -1,   530,
      -1,   532,   533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,   544,    -1,    -1,   547,   548,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   557,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    -1,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    -1,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,    -1,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,    -1,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,   431,   432,   433,    -1,   435,
      -1,    -1,   438,   439,   440,    -1,    -1,   443,    -1,    -1,
      -1,   447,    -1,   449,    -1,    -1,   452,   453,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   461,   462,    -1,   464,    -1,
      -1,   467,    -1,    -1,    -1,   471,    -1,    -1,    -1,   475,
      -1,   477,   478,   479,    -1,    -1,    -1,   483,   484,   485,
     486,    -1,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,   505,
      -1,   507,    -1,    -1,    -1,   511,   512,   513,    -1,    -1,
     516,   517,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   525,
      -1,    -1,   528,    -1,    -1,    -1,   532,   533,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   544,    -1,
      -1,   547,   548,   549,    -1,    -1,    -1,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   441,   446,   450,   470,   474,   510,   526,   529,   534,
     557,   578,   589,   590,   591,   592,   593,   594,   596,   601,
     603,   608,   626,   791,   809,   812,   820,   822,   824,   827,
     832,   834,   839,   842,   847,   851,   859,   860,  1009,  1011,
    1017,  1020,  1045,  1053,  1064,  1070,  1084,  1087,  1090,  1096,
    1100,  1104,  1107,  1108,  1154,  1171,  1177,  1179,  1186,  1188,
    1213,  1219,  1220,  1221,  1222,  1260,    11,    94,   179,   214,
     374,   805,  1241,  1242,   258,   336,   841,   488,   490,  1173,
    1214,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   431,   432,
     433,   435,   438,   439,   440,   443,   447,   448,   449,   450,
     452,   453,   454,   461,   462,   464,   467,   470,   471,   474,
     475,   477,   478,   479,   483,   484,   485,   486,   488,   489,
     491,   492,   495,   496,   497,   498,   499,   505,   507,   510,
     511,   512,   513,   516,   517,   520,   525,   528,   530,   532,
     533,   541,   544,   547,   548,   549,   554,   556,   557,   561,
     614,  1144,  1148,  1152,  1153,   287,  1173,  1173,   554,  1215,
      94,   178,   455,   491,   522,   532,   612,   706,   707,   708,
     781,  1054,  1010,    94,   179,   217,   374,   491,   506,   532,
     547,  1016,  1148,   841,   613,   585,  1142,  1143,  1148,   602,
    1018,  1105,    96,   217,   490,  1173,   841,  1148,  1101,   426,
     532,  1173,   841,  1021,  1097,  1173,   613,  1215,  1148,   862,
     864,   865,   349,  1156,  1071,   470,   474,   450,   505,   450,
     490,  1065,  1178,  1046,  1148,    28,    70,   141,   370,   392,
     417,   470,  1262,   430,   578,   861,     0,     3,   370,   156,
    1088,  1142,  1148,   145,   797,  1148,   614,   614,   490,   112,
    1238,  1173,   823,  1215,   848,   849,  1142,   627,   585,   503,
     825,   835,    16,  1216,   213,   709,   613,   354,  1236,  1238,
    1239,  1240,  1241,   490,   707,   217,   214,   270,   382,  1062,
    1063,   926,   927,   213,  1015,  1015,  1148,  1015,  1015,   613,
    1015,  1173,   597,  1091,    12,    13,    87,   115,   129,   151,
     163,   192,   217,   223,   262,   375,   394,   400,   406,   430,
     446,   447,   483,   529,   531,  1189,  1191,  1193,  1194,  1148,
     347,    61,   390,   585,   251,   494,  1145,  1148,  1150,   113,
     204,   270,  1023,    77,   381,  1106,  1109,   226,  1142,  1172,
    1173,   175,    32,   287,  1076,  1102,  1148,   613,   843,  1173,
     113,   270,  1024,  1052,   287,   381,   450,  1098,  1099,   821,
      12,  1187,  1191,   503,  1216,   863,    12,   125,   204,   460,
     461,   462,   463,   464,   465,   476,   869,   870,   871,  1155,
      30,    33,    55,    56,    65,    67,    85,    87,    95,   143,
     147,   177,   179,   191,   193,   216,   217,   220,   237,   258,
     263,   287,   320,   329,   347,   373,   374,   377,   378,   435,
     440,   450,   475,   490,   548,   754,   780,  1072,  1076,  1077,
    1079,  1162,   814,   815,   814,   814,   553,   813,   814,  1014,
    1142,  1173,  1052,    34,   203,   494,  1130,  1146,  1261,  1261,
    1261,  1261,  1261,   864,   861,   579,  1148,  1086,  1085,   301,
     492,   517,   793,   795,   794,  1142,   145,   466,  1243,   833,
    1013,  1014,   229,   580,   855,   856,   578,   628,  1148,   604,
    1013,  1013,    52,   335,   335,   399,  1217,   332,   333,   898,
    1148,    91,  1150,  1151,  1204,  1205,   405,    10,   374,   506,
     721,  1237,  1243,  1244,  1252,  1254,  1238,  1241,   709,  1148,
     175,  1055,  1059,  1060,  1148,  1062,     7,    20,    22,    25,
      29,    32,    34,    35,    36,    38,    51,    55,    56,    62,
      65,    73,    74,    80,    83,    84,    85,    90,    91,    93,
      94,    98,    99,   100,   105,   107,   110,   111,   118,   119,
     136,   139,   140,   152,   155,   157,   158,   162,   166,   171,
     176,   180,   181,   182,   183,   185,   186,   188,   189,   190,
     194,   196,   197,   203,   209,   213,   223,   225,   242,   246,
     249,   254,   256,   259,   264,   267,   272,   279,   289,   293,
     302,   306,   308,   309,   313,   314,   315,   316,   317,   318,
     319,   325,   332,   333,   334,   337,   338,   343,   361,   362,
     364,   365,   366,   367,   368,   380,   388,   404,   405,   416,
     419,   422,   424,   428,   472,   473,   478,   480,   481,   482,
     487,   496,   497,   498,   499,   508,   509,   510,   515,   518,
     523,   524,   532,   536,   537,   538,   539,   540,   545,   549,
     559,   561,   566,   570,   571,   576,   578,   581,   582,   584,
     585,   880,   883,   886,   887,   888,   889,   890,   891,   892,
     893,   894,   895,   899,   902,   903,   905,   912,   916,   928,
    1129,  1131,  1133,  1134,  1138,  1140,  1144,  1146,  1148,   152,
    1148,   614,   344,   614,   614,  1151,  1203,  1013,  1015,   535,
     598,   120,   205,   263,   287,   373,   381,   409,   450,   471,
     488,  1092,  1093,  1173,   373,  1192,   420,   420,   491,   532,
     547,   349,  1196,   488,  1198,    60,   450,  1195,    95,   547,
    1197,   344,   580,    18,   145,   969,   970,  1180,  1148,   805,
     880,    75,   175,   270,  1110,  1116,    47,   175,  1142,  1174,
    1175,   840,   584,   595,  1145,   263,   844,  1151,   845,   846,
    1142,   828,   226,  1014,  1025,  1026,    47,   580,  1013,  1192,
     344,   426,  1218,  1217,   521,  1223,  1224,   572,   873,   874,
     875,   871,  1157,  1158,  1159,   263,   150,   441,   252,   551,
    1083,   511,   578,    94,   179,   374,   490,   547,  1083,   716,
    1150,   253,   988,   990,    63,   471,   172,   471,   471,   471,
     287,   488,    63,   471,    12,    40,    81,    86,   231,   300,
     359,   454,   485,  1066,  1067,  1068,   471,   205,   471,   471,
     511,   988,  1083,   175,   229,  1080,   263,   142,    66,   376,
     488,   507,   471,   544,   811,   398,   467,   816,   817,   810,
      78,   805,   580,   346,  1264,   484,  1265,   236,   412,  1263,
     579,  1224,  1226,  1227,  1228,   859,  1089,  1130,  1148,   111,
     703,   704,   705,   714,   715,   763,   621,   621,   792,  1151,
     429,   547,  1013,   503,   580,   111,   850,  1148,   849,   217,
     238,   778,   779,   857,   629,   630,   880,   273,   274,   275,
     276,   277,   278,   281,   282,   283,   284,   285,   286,   288,
     396,   397,   605,   606,   607,   156,   382,   826,    54,   156,
     159,   172,   299,   382,   836,   837,   838,    52,   399,   152,
     611,   578,   879,   584,   211,   580,   875,   875,   875,   547,
    1244,  1142,   512,   535,   782,  1059,  1142,  1148,   580,  1057,
     585,  1061,   578,   578,   578,   578,   578,   903,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   879,   879,   578,   879,   578,   578,   578,   518,
     578,  1129,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   880,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   929,   930,   931,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   886,   578,   879,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   879,   578,  1129,   578,   578,   578,  1129,
     578,   578,    34,   203,   494,   578,   578,   578,   879,   879,
     879,   578,   578,   578,   578,   578,   578,   880,   933,   903,
     903,   903,   430,   578,   880,  1231,  1148,   917,  1148,   558,
     881,   884,   145,   146,   184,   198,   232,   244,   271,   328,
     900,   229,   252,   395,   453,   567,   568,   898,   569,   444,
     445,   570,   571,   126,   313,   572,   573,   574,   575,   903,
     101,   102,   103,   104,   105,   174,   206,   207,   208,   209,
     302,   304,   305,   306,   314,   380,   427,   428,   549,   560,
     561,   966,   967,    64,   353,   580,  1146,   578,   585,  1142,
     580,    49,   411,   806,  1013,   584,   599,   600,    47,   553,
     580,  1094,   488,   578,  1206,  1206,  1206,  1206,   179,   374,
     490,  1190,  1194,  1148,   164,   330,  1148,  1181,  1182,  1025,
     287,   258,  1115,   852,   287,   970,   580,  1013,  1150,    27,
     503,  1103,   580,   503,   580,   503,  1013,  1026,  1022,  1099,
     175,   580,   179,   374,  1190,  1148,    12,   125,  1230,   580,
     866,   877,   880,  1136,  1148,   580,   191,   258,   345,   440,
    1160,  1161,  1164,  1165,   229,  1081,  1145,   880,   572,   709,
     614,   614,  1142,  1142,  1073,   267,   338,   515,   991,   992,
    1131,   614,  1083,  1151,   172,  1078,  1080,   614,  1083,   230,
     486,   160,   172,  1069,   580,  1078,  1078,  1142,  1080,  1078,
    1078,  1083,  1083,   528,   818,   580,   818,   452,   430,   578,
     582,   936,   937,   938,   939,   948,   949,   957,  1130,   363,
    1266,   352,   984,   990,  1229,   705,    64,   754,    68,    80,
     241,   311,   335,   389,   466,   623,   625,     6,    13,    23,
      24,    53,    57,    68,    77,    83,    96,   114,   123,   124,
     129,   137,   143,   169,   215,   217,   224,   292,   307,   312,
     352,   358,   361,   384,   385,   387,   401,   423,   512,   521,
     711,   713,   714,   715,   798,   799,   800,   980,   112,   228,
    1142,   836,  1145,  1014,   578,   579,   580,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   580,   530,   837,   703,   579,  1150,    45,  1205,
     614,   614,   179,  1142,   609,    44,   107,   166,   200,   203,
     267,   335,   338,   425,   431,   432,   433,   434,   435,   515,
     783,   784,   785,   994,   783,   344,  1058,  1056,   585,  1060,
     175,   572,  1148,   970,   880,   880,   880,    12,   125,   922,
     971,   994,   922,   922,   922,   880,   880,   926,   926,   880,
     926,   880,   880,   880,   880,   125,   922,   971,   880,   579,
     880,   880,   880,   880,   880,  1138,  1148,   880,   880,   880,
     880,   880,   578,  1231,   880,   966,   880,   880,   880,   579,
     880,   880,   880,   880,   926,   880,   880,    97,   100,   496,
     499,   968,   880,   125,   919,  1129,   880,   880,   880,   579,
     880,   880,   880,   880,   926,   880,   880,   880,   880,   930,
       9,   932,  1138,   125,   922,   880,   880,   125,   922,   880,
     880,   880,   880,   880,   926,   926,   926,   880,   880,   880,
     880,   880,   880,   926,   890,   880,   579,   880,   880,   880,
     880,   880,   579,   880,   880,   922,   922,   880,   880,   880,
     125,   922,   880,   880,   967,   967,   880,    43,   245,   504,
     880,   880,  1129,   579,   880,   579,   922,  1139,  1140,  1148,
     922,   880,   880,   880,   550,   935,  1234,  1234,   579,   580,
     579,   880,   584,   918,  1150,   585,   883,   882,   885,   889,
     158,   337,   509,   525,   898,    12,    17,   889,   901,   578,
     903,   890,   252,   890,   891,   229,   252,   395,   567,   892,
     893,   893,   894,   902,   894,   902,   895,   895,   895,   895,
     895,   903,   571,  1150,   903,   880,   904,  1148,  1012,  1151,
     806,  1150,   580,   390,  1093,  1013,  1095,  1148,  1207,  1208,
     572,  1142,  1148,  1202,  1202,  1202,   145,   164,   184,   198,
     243,   244,   271,   330,   371,  1183,  1185,   551,   972,  1019,
     218,   853,   854,  1142,   270,   390,   555,  1176,  1175,   836,
     880,  1145,  1151,  1151,   846,  1142,   156,   382,   533,   829,
     830,   831,   430,   441,   540,   541,   578,   699,  1027,  1030,
    1145,   192,  1202,  1202,  1202,  1225,   874,   175,   226,   867,
     868,   983,   984,  1005,   876,   585,  1158,   111,   505,  1148,
    1167,   321,   361,   584,   754,  1166,  1145,   175,  1082,   579,
    1148,   263,   471,  1075,   341,   580,   450,  1083,  1148,   381,
     988,  1068,  1083,  1083,  1078,  1142,  1083,  1083,   607,   819,
     817,   956,  1148,    88,   219,   236,   249,   324,   416,   476,
     947,   441,   580,  1142,   956,   580,   172,  1267,    45,   988,
     145,   442,  1036,  1037,  1037,  1145,   466,   466,   466,   466,
     466,   429,    67,    79,   178,   455,   726,   729,   730,   776,
     778,   804,   804,  1037,  1037,   804,  1037,  1037,  1037,   503,
     122,  1037,   237,   489,   170,   372,   778,   804,   237,  1037,
     489,   122,  1037,  1037,  1037,   804,    45,  1037,  1037,  1037,
    1037,  1037,    18,   145,   503,   808,  1037,  1037,  1037,   711,
     580,   578,   585,   725,   731,  1141,  1148,   796,   372,   964,
    1148,   880,   994,  1145,  1145,   107,   166,   267,   338,   515,
     995,  1145,   994,  1145,  1145,  1145,  1145,  1145,   994,  1145,
    1145,   994,   606,   361,   494,  1256,     8,    27,   691,   614,
    1245,   252,   578,   693,   710,   712,   713,   433,   435,   580,
    1142,   535,   972,  1148,   937,   585,  1061,   580,   579,   579,
     580,   922,   579,   923,   580,   579,   579,   579,    18,   579,
     535,   579,   579,   579,   579,   580,   580,   535,   580,   580,
     913,   579,   572,   579,   580,   580,   579,   579,   580,   579,
     585,   579,   580,   579,   580,   580,   580,   579,   580,   579,
     580,   175,   580,   580,   579,   580,   579,   580,   580,   579,
     580,   579,   579,   580,   579,   580,   580,   580,   915,   580,
     579,   580,   580,   579,   580,   580,   579,   580,   579,   580,
     579,   580,   580,   580,   579,   578,   580,   922,   579,   579,
     579,   922,   579,   579,   580,   580,   579,   579,   580,   579,
     580,   579,   579,   579,   579,   579,   579,   579,   580,   580,
     579,   580,   579,   229,   579,   579,   580,   580,   580,   579,
     580,   580,   579,   579,   579,   580,   175,   580,   580,   922,
     579,   579,   579,   580,   580,   580,   579,   175,   880,   175,
     880,   175,   880,   175,   579,   580,   580,   579,   579,   579,
     579,   579,   580,   579,   580,   579,   880,   550,   564,   934,
     862,  1233,  1231,   926,   583,   191,   258,   440,  1163,   442,
    1148,   351,   354,   896,    15,    16,   897,   158,   337,   509,
     525,   578,   880,  1231,   149,   976,   890,    16,   578,   903,
     890,   890,   966,   966,   880,   907,   908,   909,   578,   585,
     600,   262,   579,   580,   585,   585,   503,   503,   503,  1184,
     973,   989,   990,  1027,   494,  1147,   580,   855,   555,   258,
     503,   830,   700,  1028,   578,  1033,  1038,  1033,   579,   699,
    1029,  1135,  1136,  1139,  1148,  1031,   349,   175,   175,   175,
     860,   130,   937,  1006,   172,   262,   872,  1005,   989,   868,
      18,   878,  1145,  1148,   572,  1148,   585,   233,   585,  1036,
      32,   111,   755,   756,  1036,  1150,   172,  1036,   584,  1150,
      32,   111,   758,   759,  1150,   995,  1074,   147,   548,   992,
     992,   553,   338,   972,  1078,   580,   951,   956,   936,   236,
     236,   355,   958,   236,   249,   416,   958,   948,   936,  1048,
    1049,  1139,   936,   970,   953,   954,   994,   303,   985,   111,
     760,   762,  1150,   756,    96,    96,   112,   228,   788,  1141,
     779,   779,    58,   170,   372,   522,   728,   777,   727,   728,
     788,  1141,   995,   994,  1141,   994,  1145,  1145,   754,  1037,
     994,   238,   238,  1141,  1141,   716,  1037,   164,   243,   335,
     719,   995,   995,  1141,   981,   982,  1139,   111,   994,  1145,
     994,   994,   383,   386,   718,   994,  1142,    71,    72,   111,
     133,   165,   393,   717,   716,   578,   800,   723,   724,   725,
     726,  1148,     8,   164,   807,   394,   727,   768,   732,   585,
     578,  1246,   579,   580,   494,   578,   115,   223,   529,   692,
    1255,  1246,  1142,   252,   694,   699,   723,   214,   405,   696,
    1117,   580,   712,   784,   610,   937,   983,   972,   970,   225,
     880,   880,   579,   880,   880,    32,    56,    97,   100,   108,
     326,   448,   499,   527,   924,   755,   926,   880,   755,   924,
     880,   926,   579,   902,   902,  1146,  1148,   880,   880,   926,
    1146,   880,   880,   880,   926,   338,   880,   880,   880,   880,
     880,   880,   880,   926,   926,   338,   880,   880,   926,   880,
     880,   880,   880,   926,   880,   890,  1138,   579,   579,   880,
     880,   880,   880,   880,   880,   880,   880,   880,   880,   880,
     880,   926,   225,   880,   880,   880,   880,   579,   880,   880,
     880,   880,   175,   880,   175,   880,   175,   880,   880,   338,
     880,   880,   565,   880,   880,   141,  1235,   579,   579,   585,
     585,   585,  1150,   880,   883,   886,  1231,   579,   580,   579,
     903,   889,   880,  1231,   976,    16,   579,   875,   910,   911,
     925,   926,  1148,  1208,   572,   572,  1204,  1204,  1204,   578,
     880,   344,  1043,  1111,   854,   214,   858,  1151,   869,  1034,
    1035,  1139,  1039,   580,   578,  1030,   579,   579,   580,   585,
    1223,   175,  1204,  1204,  1204,   972,   972,   131,   356,  1001,
    1002,  1007,   529,   229,  1145,  1148,   585,  1148,   250,  1148,
      12,    32,   111,   344,   880,  1170,    64,   761,   880,  1151,
     343,   361,   494,  1169,  1163,  1036,   988,   275,  1083,   607,
    1226,   952,   249,   236,   948,   958,   958,   236,   344,   344,
     535,   580,  1047,  1036,   169,   214,   534,   960,   869,   880,
     986,  1137,   880,   238,   238,   779,   788,   782,   129,   441,
     801,   756,  1145,   788,   806,  1145,   802,   580,    19,   116,
     987,  1013,   579,   580,  1148,  1142,    31,    32,    37,    39,
      41,    42,    56,    97,   100,   108,   127,   144,   165,   167,
     186,   187,   227,   256,   265,   266,   268,   296,   297,   298,
     317,   318,   319,   323,   326,   339,   340,   365,   367,   391,
     439,   441,   451,   495,   496,   499,   500,   501,   502,   542,
     543,   561,   733,   736,   737,   738,   739,   740,   741,   742,
    1148,  1148,  1247,    18,  1148,  1257,   344,   413,   578,   615,
      18,  1142,   579,   579,    18,   702,   712,   578,   972,   253,
     993,   880,   579,   579,   579,   578,   748,   748,   578,   743,
     744,   748,   227,   227,   579,   579,   579,   579,   579,   579,
     580,   914,   966,   966,   579,   579,   579,   579,   579,   579,
     580,   579,   579,   579,   579,   579,   580,   579,   579,   579,
     579,   579,   921,   984,   580,   580,   580,   579,   579,   579,
     579,   580,   579,   579,   579,   580,   229,   553,   906,   579,
     579,   579,   579,   579,   579,   579,   579,   579,   580,   579,
     579,   579,   880,   579,   172,   579,   579,   580,   580,   579,
     580,   580,   579,   880,   579,   880,   579,   880,   579,   579,
     580,   579,   579,   880,   565,  1232,   585,   789,   579,   926,
     579,   580,   579,   889,   880,   580,   579,   407,  1209,  1209,
    1209,   111,   880,  1041,  1042,   132,  1117,   247,   873,   580,
    1036,  1040,  1041,  1038,  1032,  1030,  1135,  1148,  1204,   989,
     195,   977,  1147,  1147,   584,  1003,  1004,  1150,   443,   572,
     390,   403,   438,  1168,   762,  1036,   578,   578,  1167,   880,
     145,   579,   938,   355,   936,   948,   236,   236,   936,   948,
     941,   940,   942,  1049,   972,  1042,   778,   961,   961,   961,
     873,   580,   987,   788,   782,   578,   111,   111,   731,   761,
     733,   982,   579,   724,   769,   578,   578,   748,   743,   369,
     734,   743,   743,    20,    32,    46,   520,   754,   764,    56,
     542,   737,   739,   764,   764,    56,   543,   543,   546,   743,
     735,   748,   748,   764,   578,   748,    23,    64,    68,   111,
     337,   344,   372,   439,   522,   750,   751,   752,   767,   898,
     546,   578,   764,    32,   578,   765,   578,   578,   748,   578,
     744,   749,   585,   579,   580,  1248,  1249,   221,   229,   357,
     635,   636,   637,   638,   875,   108,   227,   391,   477,   722,
     616,  1248,   579,   695,   710,   578,   699,   786,   787,  1148,
     992,   966,   338,   764,   338,   880,   579,   579,   579,   880,
     880,   437,   920,   338,   880,   880,   880,   880,    41,   381,
     579,   880,   966,   880,   880,   880,   880,   880,   579,   579,
     579,   338,   880,  1223,  1148,   579,   926,   876,   911,    59,
     234,   331,   468,   479,   556,  1200,  1201,   553,  1210,  1210,
    1210,   579,   580,  1044,   226,   701,  1035,  1042,   579,  1226,
      45,   201,   974,  1008,  1150,   580,   310,    69,   516,   390,
    1169,   494,   494,  1036,  1145,   970,   236,   344,   944,   948,
     948,   344,   946,   880,   880,   578,   983,   172,   959,   955,
    1137,   578,   578,   786,   100,   496,   499,   570,   571,  1132,
    1133,   807,   750,   289,   344,   578,   770,   772,   773,   774,
     338,   338,   448,   527,   562,   745,   746,   747,   578,   745,
     745,   765,    20,   520,   754,   766,   765,   755,   764,   546,
     745,   578,   764,   338,   745,   760,  1145,   334,   753,  1132,
     529,   111,   238,   752,   238,   337,   338,   338,   338,   338,
     745,   338,   745,  1148,  1148,   553,  1251,   430,   578,  1250,
     579,   580,   633,  1142,   514,   631,   632,   634,  1148,  1251,
    1226,   696,   699,   697,   579,   580,   987,   578,   579,   579,
     579,   580,   579,   579,   580,   579,  1130,   579,   580,   579,
     580,   579,   579,   310,   154,   579,   579,   579,   579,   579,
     579,   579,   580,  1235,   579,   878,   494,   494,   494,    16,
    1199,   192,   290,   291,   294,   295,  1211,  1212,  1042,   238,
    1112,   720,   868,   989,   978,  1137,   975,   983,    66,  1118,
    1004,   579,   579,  1170,    16,   936,   943,   535,   945,   535,
     965,  1148,   993,   236,   962,   720,   987,   786,   786,   579,
    1134,  1134,   803,   177,   360,   449,   115,   529,   771,  1148,
     774,   579,   579,   747,   790,  1130,   755,   765,   790,   579,
     879,   334,   541,   579,   579,   579,   579,    50,    58,   258,
     875,   875,  1258,   637,  1148,   172,  1145,   579,   580,   633,
     579,  1223,   787,   338,   338,   880,   922,   880,   926,  1200,
     349,   994,   994,   994,   994,  1212,   529,   490,   872,   553,
     580,   979,   987,   880,   989,   138,   148,   350,   493,  1119,
    1120,   255,  1121,   276,   344,   880,   578,   880,   578,   579,
     580,   578,   579,   579,   807,    49,   335,   411,   441,   775,
     775,   579,   580,   579,   580,   579,   879,   764,   765,   764,
     765,    58,   349,    58,   862,   861,   622,   733,   875,   617,
     634,   733,   698,   987,   579,   579,   579,   580,   579,   579,
     579,  1050,  1051,  1139,  1142,    89,   418,  1137,   374,   996,
      45,    45,   138,    45,  1120,   469,   493,  1122,  1123,   145,
     950,   965,   965,  1148,   963,   964,   768,     5,   111,   337,
     772,  1148,   764,  1130,   764,   349,   349,   579,   121,   623,
     624,   898,  1259,   134,   413,  1226,   880,   580,  1036,  1113,
     987,  1148,  1130,  1130,    45,  1130,    45,    45,  1123,   995,
     880,   579,   579,   579,  1226,   121,    61,   161,   213,   235,
     248,   347,   414,   566,   655,   656,   659,   668,   669,   672,
     683,  1144,  1149,  1153,   424,   618,   579,  1051,  1042,   754,
     757,   997,  1130,  1130,  1130,    16,   583,  1148,   175,   330,
     661,   658,  1149,  1149,  1148,   657,   670,   673,   591,    28,
     269,   404,   552,   686,   587,  1253,   733,   756,  1114,   578,
     280,   175,  1148,   663,   664,   880,   880,   550,   675,   679,
     687,   640,   655,   640,   688,   684,   655,   619,  1118,   875,
     998,   999,  1000,   145,   226,   141,   880,   671,   680,   564,
     679,   682,   641,   141,   655,   586,   528,   880,   686,   622,
    1121,   880,   579,   580,   994,   660,   213,   565,   550,   674,
     676,   880,   640,   141,   109,   639,   642,   269,   586,   690,
     128,   685,  1149,   620,   214,  1124,  1000,   662,  1148,   665,
     677,   676,   682,   681,   566,    82,   153,   647,   653,  1148,
     141,   655,   586,   880,   689,   655,   338,   578,  1125,   580,
     640,   880,   141,   565,   199,   580,   643,    76,    92,   586,
     141,   640,   255,   579,   584,  1126,  1127,  1139,   441,  1128,
    1148,   666,   678,   566,   640,   172,  1148,   733,   172,   172,
     404,   141,  1150,   579,   580,  1050,   135,   564,   667,   565,
     644,   111,   654,   458,   650,   994,   645,   646,   552,  1127,
     663,   640,   640,   457,   459,   648,   649,   650,   652,   898,
    1148,   880,   541,   651,   591,   580,   655,   173,  1146,   649
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1222 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1235 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1295 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 56:
#line 1310 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= yyvsp[-2].lex_str;
        }
    break;

  case 57:
#line 1319 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1326 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1335 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 60:
#line 1342 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1356 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&yyvsp[0].lex_str, sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1368 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1376 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= yyvsp[0].lex_str.str;
       }
    break;

  case 68:
#line 1386 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1392 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1401 "sql_yacc.yy"
    {
	 Lex->mi.host = yyvsp[0].lex_str.str;
       }
    break;

  case 73:
#line 1406 "sql_yacc.yy"
    {
	 Lex->mi.user = yyvsp[0].lex_str.str;
       }
    break;

  case 74:
#line 1411 "sql_yacc.yy"
    {
	 Lex->mi.password = yyvsp[0].lex_str.str;
       }
    break;

  case 75:
#line 1416 "sql_yacc.yy"
    {
	 Lex->mi.port = yyvsp[0].ulong_num;
       }
    break;

  case 76:
#line 1421 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = yyvsp[0].ulong_num;
       }
    break;

  case 77:
#line 1425 "sql_yacc.yy"
    {
           Lex->mi.ssl= yyvsp[0].ulong_num ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1430 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= yyvsp[0].lex_str.str;
         }
    break;

  case 79:
#line 1434 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= yyvsp[0].lex_str.str;
         }
    break;

  case 80:
#line 1438 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= yyvsp[0].lex_str.str;
         }
    break;

  case 81:
#line 1442 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= yyvsp[0].lex_str.str;
         }
    break;

  case 82:
#line 1446 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= yyvsp[0].lex_str.str;
	 }
    break;

  case 84:
#line 1455 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = yyvsp[0].lex_str.str;
       }
    break;

  case 85:
#line 1459 "sql_yacc.yy"
    {
           Lex->mi.pos = yyvsp[0].ulonglong_number;
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1475 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = yyvsp[0].lex_str.str;
         }
    break;

  case 87:
#line 1479 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = yyvsp[0].ulong_num;
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1490 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, yyvsp[0].table, NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
#ifdef ENABLE_SENNA
	  lex->senna_clear();
#endif
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=yyvsp[-3].num | yyvsp[-1].num;
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1510 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1512 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, yyvsp[0].table, NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1524 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-9].key_type,yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-9].key_type, yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1538 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1543 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=yyvsp[-2].lex_str.str;
            lex->create_info.options=yyvsp[-3].num;
	  }
    break;

  case 94:
#line 1550 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1556 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1558 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1565 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1580 "sql_yacc.yy"
    {
            if (!yyvsp[-2].lex_str.str || check_db_name(yyvsp[-2].lex_str.str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spname= new sp_name(yyvsp[-2].lex_str, yyvsp[0].lex_str, true);
	    yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1595 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    yyval.spname= new sp_name(db, yyvsp[0].lex_str, false);
            if (yyval.spname)
	      yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1613 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) yyvsp[-2].num;
	    lex->udf.dl=yyvsp[0].lex_str.str;
	  }
    break;

  case 101:
#line 1632 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1671 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1679 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1687 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) yyvsp[0].num,
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1699 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1708 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1730 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1731 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1735 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1736 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1742 "sql_yacc.yy"
    { Lex->sp_chistics.comment= yyvsp[0].lex_str; }
    break;

  case 112:
#line 1744 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1746 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1748 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1750 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1752 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1754 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1759 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1760 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1761 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1766 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1770 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1777 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= yyvsp[0].spname;
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, yyvsp[0].spname, TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1785 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1801 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 130:
#line 1805 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 135:
#line 1823 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1843 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-2].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-2].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1880 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-1].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-1].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     (sp_param_mode_t)yyvsp[-3].num);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1905 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 143:
#line 1906 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 144:
#line 1907 "sql_yacc.yy"
    { yyval.num= sp_param_out; }
    break;

  case 145:
#line 1908 "sql_yacc.yy"
    { yyval.num= sp_param_inout; }
    break;

  case 146:
#line 1912 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1917 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1923 "sql_yacc.yy"
    {
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	  }
    break;

  case 151:
#line 1927 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if ((yyvsp[-1].spblock.vars || yyvsp[-1].spblock.conds) && (yyvsp[-2].spblock.curs || yyvsp[-2].spblock.hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (yyvsp[-1].spblock.curs && yyvsp[-2].spblock.hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    yyval.spblock.vars= yyvsp[-2].spblock.vars + yyvsp[-1].spblock.vars;
	    yyval.spblock.conds= yyvsp[-2].spblock.conds + yyvsp[-1].spblock.conds;
	    yyval.spblock.hndlrs= yyvsp[-2].spblock.hndlrs + yyvsp[-1].spblock.hndlrs;
	    yyval.spblock.curs= yyvsp[-2].spblock.curs + yyvsp[-1].spblock.curs;
	  }
    break;

  case 152:
#line 1953 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary(yyvsp[0].num);
          }
    break;

  case 153:
#line 1961 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) yyvsp[-1].num;
            Item *dflt_value_item= yyvsp[0].item;
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-yyvsp[-3].num ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            yyval.spblock.vars= yyvsp[-3].num;
            yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
          }
    break;

  case 154:
#line 2009 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&yyvsp[-3].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), yyvsp[-3].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&yyvsp[-3].lex_str, yyvsp[0].spcondtype);
	    yyval.spblock.vars= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	    yyval.spblock.conds= 1;
	  }
    break;

  case 155:
#line 2023 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, yyvsp[-2].num,
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2038 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if (yyvsp[-5].num == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.curs= 0;
	    yyval.spblock.hndlrs= yyvsp[-1].num;
	    lex->spcont->add_handlers(yyvsp[-1].num);
	  }
    break;

  case 157:
#line 2067 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&yyvsp[-3].lex_str, &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), yyvsp[-3].lex_str.str);
	      delete yyvsp[0].lex;
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, yyvsp[0].lex,
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&yyvsp[-3].lex_str);
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= 0;
	    yyval.spblock.curs= 1;
	  }
    break;

  case 158:
#line 2090 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2099 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    yyval.lex= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2121 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2122 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2128 "sql_yacc.yy"
    { yyval.num= 1; }
    break;

  case 163:
#line 2130 "sql_yacc.yy"
    { yyval.num+= 1; }
    break;

  case 164:
#line 2135 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler(yyvsp[0].spcondtype))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition(yyvsp[0].spcondtype);
	      ctx->push_handler(yyvsp[0].spcondtype);
	    }
	  }
    break;

  case 165:
#line 2158 "sql_yacc.yy"
    {			/* mysql errno */
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::number;
	    yyval.spcondtype->mysqlerr= yyvsp[0].ulong_num;
	  }
    break;

  case 166:
#line 2164 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&yyvsp[0].lex_str))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::state;
	    memcpy(yyval.spcondtype->sqlstate, yyvsp[0].lex_str.str, 5);
	    yyval.spcondtype->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2178 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2179 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2184 "sql_yacc.yy"
    {
	    yyval.spcondtype= yyvsp[0].spcondtype;
	  }
    break;

  case 170:
#line 2188 "sql_yacc.yy"
    {
	    yyval.spcondtype= Lex->spcont->find_cond(&yyvsp[0].lex_str);
	    if (yyval.spcondtype == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2197 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2202 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2207 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2215 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= 1;
	  }
    break;

  case 175:
#line 2230 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= yyvsp[-2].num + 1;
	  }
    break;

  case 176:
#line 2247 "sql_yacc.yy"
    { yyval.item = NULL; }
    break;

  case 177:
#line 2248 "sql_yacc.yy"
    { yyval.item = yyvsp[0].item; }
    break;

  case 178:
#line 2252 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2261 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2302 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2304 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, yyvsp[0].item,
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2325 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2327 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2330 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2331 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2337 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2343 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2372 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2400 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2415 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&yyvsp[-1].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2430 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2432 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2456 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2477 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2499 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2501 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               yyvsp[-1].item, lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2515 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2526 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2546 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2552 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, yyvsp[0].item))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2563 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2571 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2579 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2597 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2601 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2610 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2618 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2622 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2629 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2637 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2650 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[-1].lex_str.str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label(yyvsp[-1].lex_str.str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2668 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (yyvsp[0].lex_str.str)
	    {
	      sp_label_t *lab= lex->spcont->find_label(yyvsp[0].lex_str.str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, yyvsp[0].lex_str.str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2687 "sql_yacc.yy"
    { yyval.lex_str= null_lex_str; }
    break;

  case 228:
#line 2688 "sql_yacc.yy"
    { yyval.lex_str= yyvsp[0].lex_str; }
    break;

  case 229:
#line 2693 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2705 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if (yyvsp[-2].spblock.hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.hndlrs));
	    if (yyvsp[-2].spblock.curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2721 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2730 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2732 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       yyvsp[-1].item, lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2746 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2756 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2758 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               yyvsp[-2].item, lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2774 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2776 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2781 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2783 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2785 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2789 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2790 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2792 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[0].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2798 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[-1].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2806 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2807 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2807 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2811 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2813 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2813 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2815 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2815 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2820 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2836 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2840 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2850 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2851 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2854 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2855 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2858 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2859 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2862 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2863 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2866 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 266:
#line 2867 "sql_yacc.yy"
    { yyval.num= yyvsp[0].num;}
    break;

  case 267:
#line 2870 "sql_yacc.yy"
    { yyval.num=yyvsp[0].num; }
    break;

  case 268:
#line 2871 "sql_yacc.yy"
    { yyval.num= yyvsp[-1].num | yyvsp[0].num; }
    break;

  case 269:
#line 2874 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2877 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 271:
#line 2878 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2894 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2895 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2896 "sql_yacc.yy"
    { Lex->create_info.max_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2897 "sql_yacc.yy"
    { Lex->create_info.min_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2898 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2899 "sql_yacc.yy"
    { Lex->create_info.password=yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2900 "sql_yacc.yy"
    { Lex->create_info.comment=yyvsp[0].lex_str; Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2901 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2903 "sql_yacc.yy"
    {
            switch(yyvsp[0].ulong_num) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2918 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2923 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2924 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2925 "sql_yacc.yy"
    { Lex->create_info.row_type= yyvsp[0].row_type;  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2927 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2932 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2937 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2942 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2958 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2959 "sql_yacc.yy"
    { Lex->create_info.data_file_name= yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2960 "sql_yacc.yy"
    { Lex->create_info.index_file_name= yyvsp[0].lex_str.str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2961 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= yyvsp[0].lex_str.str; Lex->create_info.connect_string.length= yyvsp[0].lex_str.length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2966 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", yyvsp[0].charset->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= yyvsp[0].charset;
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2983 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       yyvsp[0].charset->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= yyvsp[0].charset;
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 2999 "sql_yacc.yy"
    {
	  yyval.db_type = ha_resolve_by_name(yyvsp[0].lex_str.str,yyvsp[0].lex_str.length);
	  if (yyval.db_type == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), yyvsp[0].lex_str.str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 3008 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 3009 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 3010 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3011 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3012 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3013 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3016 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 312:
#line 3017 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 313:
#line 3018 "sql_yacc.yy"
    { yyval.ulong_num=yyvsp[0].ulong_num;}
    break;

  case 314:
#line 3021 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3022 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3023 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3026 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3030 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3031 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3034 "sql_yacc.yy"
    {yyval.num = (int) STRING_RESULT; }
    break;

  case 322:
#line 3035 "sql_yacc.yy"
    {yyval.num = (int) REAL_RESULT; }
    break;

  case 323:
#line 3036 "sql_yacc.yy"
    {yyval.num = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3037 "sql_yacc.yy"
    {yyval.num = (int) INT_RESULT; }
    break;

  case 330:
#line 3052 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3062 "sql_yacc.yy"
    {
            LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-5].key_type,yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-5].key_type, yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
            lex->col_list.empty();              /* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3076 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= yyvsp[-4].simple_string ? yyvsp[-4].simple_string:yyvsp[-6].simple_string;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-5].key_type, key_name, yyvsp[-3].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-5].key_type, key_name, yyvsp[-3].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3091 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= yyvsp[-4].simple_string ? yyvsp[-4].simple_string : yyvsp[-7].simple_string;
            Key *key= new foreign_key(key_name, lex->col_list,
                                      yyvsp[0].table,
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
#ifdef ENABLE_SENNA
            lex->senna_clear();
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3111 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3118 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 339:
#line 3136 "sql_yacc.yy"
    { yyval.simple_string=(char*) 0; }
    break;

  case 340:
#line 3137 "sql_yacc.yy"
    { yyval.simple_string= yyvsp[0].simple_string; }
    break;

  case 341:
#line 3141 "sql_yacc.yy"
    { yyval.simple_string=yyvsp[0].simple_string; }
    break;

  case 342:
#line 3146 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 343:
#line 3154 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, yyvsp[-3].lex_str.str,
				(enum enum_field_types) yyvsp[-1].num,
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 344:
#line 3167 "sql_yacc.yy"
    { yyval.num=yyvsp[-2].num; }
    break;

  case 345:
#line 3168 "sql_yacc.yy"
    { yyval.num=yyvsp[-2].num; }
    break;

  case 346:
#line 3169 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_FLOAT; }
    break;

  case 347:
#line 3170 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  yyval.num=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3172 "sql_yacc.yy"
    { Lex->length= yyvsp[-1].lex_str.str;
					  yyval.num=FIELD_TYPE_BIT; }
    break;

  case 349:
#line 3174 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3176 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_TINY; }
    break;

  case 351:
#line 3178 "sql_yacc.yy"
    { Lex->length=yyvsp[-2].lex_str.str;
					  yyval.num=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3180 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3182 "sql_yacc.yy"
    { Lex->length=yyvsp[-2].lex_str.str;
					  yyval.num=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3185 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 355:
#line 3188 "sql_yacc.yy"
    { Lex->length=yyvsp[-1].lex_str.str;
					  Lex->charset=&my_charset_bin;
					  yyval.num=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3191 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  yyval.num=FIELD_TYPE_STRING; }
    break;

  case 357:
#line 3194 "sql_yacc.yy"
    { Lex->length=yyvsp[-2].lex_str.str;
					  yyval.num= MYSQL_TYPE_VARCHAR; }
    break;

  case 358:
#line 3196 "sql_yacc.yy"
    { Lex->length=yyvsp[-2].lex_str.str;
					  yyval.num= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 359:
#line 3199 "sql_yacc.yy"
    { Lex->length=yyvsp[-1].lex_str.str;
					  Lex->charset=&my_charset_bin;
					  yyval.num= MYSQL_TYPE_VARCHAR; }
    break;

  case 360:
#line 3202 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_YEAR; }
    break;

  case 361:
#line 3203 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_DATE; }
    break;

  case 362:
#line 3204 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_TIME; }
    break;

  case 363:
#line 3206 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      yyval.num=FIELD_TYPE_DATETIME;
	  