<?php
/*
 * Ajax Chat for TRPG ver.1.0.1
 * (c)2007 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 *
 * [注意事項他]
 * 本チャットスクリプトの使用および配布は、BSDライセンスに基づきます。
 * BSDライセンスの詳細につきましては、添付のライセンス.txtを参照してください。
 *
 * BSDライセンス概要＆使用上の注意
 * 1. このスクリプトはフリーソフトです。以下の条件を満たす限りにおいて、使用・改造・再配布（オリジナルおよび改造版の両方とも）は自由です。
 * 再配布する場合、上記著作権表示、本条件書きおよび第2項・第3項の責任限定規定を必ず含めてください。
 * 2. 同梱のアイコンはPetite Prier様(http://snow.if.tv/)の素材です。
      本スクリプトの使用および再配布時にアイコンをそのまま用いる場合は、配布元の規定も遵守してください。
 * 3. 本スクリプトは無保証です。自己責任で使用してください。このスクリプトを使用したいかなる損害に対しても、作者は一切の責任を負いません。
 * 4. 設置および使用方法に関する質問は、配布サイトの掲示板にお願いします。ただし、必ず回答できるとは限りません。
 * メールによる質問は、ご遠慮ください。
 */

// 設定ファイルの読み込み
require_once 'trpgchat-ini.php';
//メンバーチェッカー
require_once 'member_check.php';

// ユーザの情報
$host = gethostbyaddr($_SERVER['REMOTE_ADDR']);

// IPブロック
foreach ($block_ip as $v) {
    if (strstr($host, $v)) { die("書きこみできません。"); }
}

// ファイルロック
$lfp = fopen($lockfile,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 既存ファイル内容の格納
$log = array();
$log[] = file($recent_log);

// 受信データの整形
foreach($_GET as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}

    // PC名がない場合PL名
if (!$data['c']) $data['c'] = $data['n'];

$ua = getenv("HTTP_USER_AGENT");

    // コメント本文の処理：（予定）ダイス、カード、タグ有効[b,span,i,u]、オートリンク、禁止語句処理など
        // ダイス
if ($dice_max) {
    if(preg_match("/(.*)[[]\({0,}([0-9]{1,3})([dD])([0-9]{1,3})([-\+\*\/0-9\s]{0,}[\]])(.*$)/i", $data['m'], $dice)) {
        $dice_result = dice_convert($dice[2], $dice[4], $dice[5], $dice_max, $dice_color);
        $data['m'] = $dice[1].$dice_result.$dice[6];
    }
}

// 既存ログのチェック
if(!is_array($log)){
    $log = array();
} else {
    $stopflag=0;
    foreach ($log[0] as $k => $v){
        $temp[$k] = explode("<>", $v);
    }
}

// 書込み
if($stopflag==0) {

    // 最新ログNO
    if ($temp[0][0]) {
        $last_id = $temp[0][0]+1;
    } else {
        $last_id = 1;
    }

    // 書き込み整形
    $write = "";
        // ログイン
    if ($data['y'] =='in') {
        $pcname = $system;
        $data['m'] = $data['n'].$online_msg;
        $data['l'] = $color_system;
        $data['s'] = 0;
        // ログアウト
    } elseif ($data['y'] == 'out') {
        $pcname = $system;
        $data['m'] = $data['n'].$offline_msg;
        $data['l'] = $color_system;
        $data['s'] = 0;
    } else {
        $pcname = $data['c'];
    }

    if ($data['n'] && $data['p']) {
        $pwd = create_hash($data['n'],$data['p']);
    }

    $write = $last_id."<>".$data['n']."<>".$pcname."<>".$data['l']."<>".$data['m']."<>".time()."<>".$host."<>".$ua."<>".$pwd."<>".$data['w']."<>".$data['h']."<>".$data['s']."<>".$data['t']."<>".$data['a']."\n";

    array_unshift($log[0], $write);

    //最大行数を超えていたら最終行を削除
    if (count($log[0]) >= $max_num) {
        array_pop($log[0]);
    }

    // ログファイル更新
    $fp = @fopen($recent_log, "w+") or die("ログファイルを開けません。");
    //$bom = "\xef\xbb\xbf";
    //fwrite($fp, $bom);

        foreach($log[0] as $k => $v) {
            fwrite($fp, $v);
        }
    fclose($fp);
}

    //直近の過去ログ更新
    write_recent_past($write, $past_log);

    // ロック解除
fflush($lfp);
fclose($lfp);

    //参加者チェッカーに書き込み
member_checker($data['n'], $pwd, $data['y'], $now_member, $getdata_off);

1;


/**** ここから関数 ****/

// 直近の過去ログ
function write_recent_past($write, $pdata) {
    $pfp = @fopen($pdata, "a+") or die("過去ログファイルを開けません。");

    fwrite($pfp, $write);

    return true;
}

function dice_convert($dicenum, $dicenumber, $revision, $dice_max, $color) {

    // ダイス本体
    if($dicenum >= 1 && $dicenum <= $dice_max) {
        if ($dicenumber >= 1 && $dicenumber <= 100) {
            mt_srand((double) microtime() * 1000000);
            $dicesum = 0;
            for ($i=0; $i<$dicenum; $i++) {
                $d_result[$i] = mt_rand(1,$dicenumber);
                $dice_sum += $d_result[$i];
                if ($i != 0) {
                    $dice_list .= ", ".$d_result[$i];
                } else {
                    $dice_list = " (".$d_result[$i];
                }
            }
            $dice_list .= ")";
        } else {
            return $dice.' (d2～d100の範囲で指定してください)';
        }
    } else {
        return $dice.' (ダイスの数は1から'.$dice_max.'の間で指定してください)';
    }

    // 修正値を加えた結果の計算
    if(rtrim($revision, "]")) {
        $dice = preg_replace("/\s/","+",$dice);
        $value = calc_value($dice_sum, $revision);
    } else {
        $value = $dice_sum;
    }

    if (!is_numeric($value)) {
        return '<span style="color:#'.$color.';">'.$dice.' ('.$value.')</span>';
    } else {
        $dice = '<span style="color:#'.$color.'; font-weight: bold;">['.$dicenum.'d'.$dicenumber.$revision.' :'.$dice_list.' = '.$value.'</span>';
        return $dice;
    }
}

/* ダイス修正値の計算
 */
function calc_value($dice_sum, $revision) {
    $multi = preg_match("/\*/", $revision);
    $dev = preg_match("/\//", $revision);
    $add = preg_match("/\+/", $revision);
    $subtract = preg_match("/\-/", $revision);

    // +-*/で分割
    $revision = preg_replace("/\+/","<>+<>",$revision);
    $revision = preg_replace("/\-/","<>-<>",$revision);
    $revision = preg_replace("/\*/","<>*<>",$revision);
    $revision = preg_replace("/\//","<>/<>",$revision);
    $parts = explode("<>",$revision);
    array_splice($parts, 0, 1, $dice_sum);

    // 乗算&除算
    if ($multi || $dev) {
        foreach ($parts as $k => $v) {
            if ($v != '0' && $v == '*') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) return "演算子が連続してます";
                $flg = $k;
                array_splice($parts, $k+1, 1, $parts[$k-1] * $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
            if ($v != '0' && $v == '/') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) return "演算子が連続してます";
                array_splice($parts, $k+1, 1, $parts[$k-1] / $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
        }
    }

    // 加減算
        foreach ($parts as $k => $v){
            if ($v != '0') {
                if ($v == '+') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  return "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] + $parts[$k+1]);
                } elseif ($v == '-') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  return "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] - $parts[$k+1]);
                }
            }
        }

    return round($parts[0], 1);
}

 ?>