<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません');
}

// パスワードの照合
auth();

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

if (!$request['file'][0]) {
    error('ファイルを指定してください。');
}

// 削除確認画面表示
if ($request['mode'] == '削除確認') {

    print html_header(CHAT_TITLE.' 確認', 'admin', false, true);

    print "<h2>削除確認</h2>\n";
    print '<p><font color="#FF0000">以下の過去ログを削除します。よろしいですか？</font></p>'."\n";
    print '<form action="./pastlog_del.php" method="'.METHOD.'">'."\n";
    print "<ul>\n";
foreach ($request['file'] as $k => $v) {
    print '<li><input type="hidden" name="file[]" value="'.$v.'"> <a href="'.$v.'" target="admin_past">'.$v.'</a></li>'."\n";
}
print "</ul>\n";
print '<p><input type="submit" value="削除する"></p>'."\n";
print "</form>\n";
print '<form action="./admin.php" method="'.METHOD.'">'."\n";
print '<p><input type="submit" value="戻る"></p>'."\n";
print "</form>\n";

print html_footer('');
exit;

// ファイル移動
} elseif ($request['mode'] == '移動') {

    if (!$request['type']) {
        error('リクエストが不正です。');
    }

    if ($request['mode'] == '移動' && !$request['dir']) {
        error('ファイルの移動先を指定してください。');
    }

    // 移動
    $msg = '';
    foreach($request['file'] as $v) {
        $filename = strrchr($v, "/");
        if (file_exists($request['type'].$request['dir']."/".$filename)) {
            $msg .= $filename."と同じ名前のファイルが".$request['dir']."にあるため、移動は中止しました。<br>\n";
        } else {
            if ($request['dir'] == PAST_DIR || $request['dir'] == MASTER_PAST_DIR) {
                $path = $request['dir'];
            } else {
                $path = $request['type'].$request['dir'];
            }

            if (!copy($v, $path.$filename)) {
                $msg .= $filename."の移動に失敗しました<br>\n";
            } else {
                @unlink($v);
                $msg .= $filename."を".$request['dir']."に移動しました<br>\n";
            }
        }
    }

// 移動完了表示
display_finish(CHAT_TITLE.' 過去ログ移動完了', $msg);


// ファイル名変更(入力）
} elseif ($request['mode'] == 'ファイル名変更') {

    if(!$request['new_filename']) {
        error('新しいファイル名を指定してください。');
    }

    // ファイル名チェック
    check_name($request['new_filename']);

    if(count($request['file']) > 1) {
        $list = "選択されたファイル<br>\n";
        foreach($request['file'] as $v) {
            $list .= $v."<br>\n";
        }
        error('ファイル名変更では、選択できるファイルは１回に１つだけです。<br><br>'.$list);
    }

    $old_filename = strrchr($request['file'][0], "/");
    $new_filepath = str_replace($old_filename, "/".$request['new_filename'].".html", $request['file'][0]);

    if (file_exists($new_filepath)) {
        error('今あるファイルと同じ名前には変更できません。');
    } else {
        if (!rename($request['file'][0], $new_filepath)) {
            error('ファイル名の変更に失敗しました');
        }
        // 完了表示
        display_finish(CHAT_TITLE.' 過去ログファイル名変更完了', $request['new_filename'].".htmlに変更しました");
    }
} else {
    error('アクションが不正です');
}

?>