<?php
/*
 * Ajax Chat for TRPG ver.2.0
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */
require_once './trpgchat-ini.php';

?>
<script type="text/javascript">
<!--

// ウインドウサイズ変更でフォームサイズ変更
function changeSize() {
    var winWidth = document.body.clientWidth;
    var winHeight = document.body.clientHeight - 130;
    $(".input_comment").css({width: winWidth-205});
    $(".status").css({width: winWidth-313});
    $("#mainframe").css({height: winHeight});
    $("#logoutBt").css({width: winWidth-390});
}

// 発言成形
function comment(Obj) {
    // 発言取得
    var pc_input = Obj.pc_input.value;
    if (pc_input) {
        //入力チェック
        var name = convert($("#name_on").attr("value"));
        var pc_name = Obj.pc_name.value;
        if (!pc_name) {
            alert("PC名を入力してください。");
            return false;
        }
        var pc_color = Obj.pc_color.value;

        //データ成形
        var params =
            '?n='+name//名前
            +'&c='+convert(pc_name)//PC
            +'&l='+pc_color//色
            +'&m='+convert(pc_input);//本文

        // ささやき
        var whisper_to_name = $("#whisper_to").attr("value");
        var whisper_to_hash = $("#whisper_to_hash").attr("value");
        if(whisper_to_name && whisper_to_name != '全員' && whisper_to_hash) {
            params = params
                +'&w='+convert(whisper_to_name)//whisperto
                +'&h='+whisper_to_hash;//whisperto_hash
        }

        //状態表示
        if (Obj.show_status.checked) {
            params = params+'&s='+'1';
        } else {
            params = params+'&s='+'0';
        }

        //状態
        if (Obj.status.value) {
            params = params+'&t='+convert(Obj.status.value);
        }

        //他
//        params = params+'&a='+Obj.status.value;

        if ($("#pwd_on").attr("value")) {
            var pwd = convert($("#pwd_on").attr("value"));
        }
        if(pwd) {
            var params =
            params+'&p='+pwd;//PWD
        }
        var params =
            params+'&y=com'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        Obj.pc_input.value = "";
    }
        Obj.pc_input.focus();

        return false;
}


// 書き込み
function writeComment(params)
{
    $.ajax({
        type: "get",
        url: writescript+params,
        success: function() {
    // 受信完了イベント
            window.mainframe.getLog();
        }
    });
}

// 在室確認
function isMember(name){
    var member = $(window.mainframe.document.getElementById("indi")).text();
    var name_array = member.split('<>');
    for (i=0;i<name_array.length;i++) {
        if (name_array[i] == name) {
            return true;
        }
    }
}


// カーソル位置に指定文字列を挿入
function insert(Obj, text, backlength) {
    Obj.focus();

    var textLength = text.length;
    //FireFoxなど
    if (Obj.selectionStart) {
        var position = Obj.selectionStart;
        Obj.value = Obj.value.substring(0, position)+text+Obj.value.substring(position, Obj.value.length);
        Obj.setSelectionRange(position + textLength, position + textLength - backlength);
    } else {
        // IE
        if (document.selection) {
            var sel = document.selection.createRange();
            sel.text = text;
            sel.move('character', -backlength);
            sel.select();
        // その他
        } else {
            Obj.value = Obj.value+text;
        }
    }
}

// ダイス挿入
function insertDice(Obj, columnId) {
    var dice = $("#dice").attr("value");
    var revision = $("#revision").attr("value");
    if (typeof(revision) != 'string') {
        revision = '0';
    }
    var cfInput = $("#cfinput").attr("checked");
    if (cfInput) {
        var clit = $("#clit").attr("value");
        var famble = $("#famble").attr("value");
    }

    if (revision.match(/[^-0-9+\*\/]/)) {
        alert('ダイス修正値は半角数字と+,-,*,/のみで入力してください。');
        return false;
    }

    if (revision == '0') revision = "";
    if (revision) {
        if (!revision.match(/^[-+\*\/]/)) {
            dice = dice+'+';
        }
        dice = dice+revision;
    }

    if (clit || famble) {
        dice = dice + '@';
        if (clit) {
            dice = dice + 'c' + clit;
        }
        if (famble) {
            dice = dice + 'f' + famble;
        }
    }
    document.getElementById(columnId).focus();

    // ダイス入力
    insert(document.getElementById(columnId), '['+dice+']', 0)
    return false;
}

// 名前文字色を反映
function changeColor(Obj1, Obj2, Ev) {
    if(Ev != "37" && Ev != "39" && Ev != "8" && Ev != "16" && Ev != "17" && Ev != "18"){
        Obj2.pc_color.style.color = Obj1.value;
        Obj2.pc_color.value = Obj1.value;
        Obj2.pc_color_select.style.color = Obj1.value;
        Obj2.pc_name.style.color = Obj1.value;
    }
}

// タグ挿入
function insertTag(tag, columnId) {
    insert(document.getElementById(columnId), '<'+tag+'></'+tag+'>', tag.length+3)
}

// フォントタグ挿入
function insertFontTag(columnId) {
    var size = prompt("フォントサイズを指定してください(1～7または-4～+4)", "");
    var color = prompt("フォント色を指定してください", "");

    if (!size && !color) {
        return false;
    } else {
        var tag = "<font";
        if (size) {
            tag= tag+" size="+size;
        }
        if (color) {
            tag= tag+" color="+color;
        }
        tag = tag+"></font>";
        insert(document.getElementById(columnId), tag, 7)
    }
}

// 直前に選択していた欄のIDとカーソル位置を記録
function selectedColumnId(Obj1, Obj2) {
    columnId = Obj1.id;
    pcColorId = Obj2.pc_color.id;
}

// 入室中にリロード・ページ遷移で自動退室
function UnLoad() {
    var name = $("#name_on").attr("value");
    if (name && isMember(name)==true) {
        $("#logout").click();
    }
}

// クッキーの書き込み
function cookieWrite() {
    if (!navigator.cookieEnabled) {
        alert("クッキーが無効になっています。ブラウザの設定を変更してください。");
        return false;
    }
    // クッキー名
    var CookieName = "<?php print COOKIE;?>";
    // クッキー保存期間
    var Expires = (60 * 60 * 24 * 1000 * <?php print COOKEI_EXPIRE; ?>);
    // どちらかがない場合クッキー使用しない
    if (!CookieName || !Expires) {
        alert('チャット側の設定により、クッキー保管機能は無効です。');
    }

    // 値のセット
    // ログイン名
    var COOKIE = "name_off="+$("#name_off").attr("value");

    // ダイスショートカット
    <?php
    for ($i=1;$i<=10;$i++) {
         print '        if ($("#dice_'.$i.'").attr("value")) {COOKIE += "&dice_'.$i.'="+$("#dice_'.$i.'").attr("value"); }'."\n"; 
    }
         ?>

    // PC設定
    if (document.getElementsByName("pc_color_select_0")[0].value+"") { COOKIE += "&pc_color_select_0="+document.getElementsByName("pc_color_select_0")[0].value+"";}
    if ($("#pc_color_0").attr("value")+"") { COOKIE += "&pc_color_0="+$("#pc_color_0").attr("value")+"";}
    if ($("#pc_status_0").attr("value")) { COOKIE += "&pc_status_0="+$("#pc_status_0").attr("value"); }
<?php
    if (PC_NUM > 1) {
        for ($i=1; $i<=PC_NUM-1; $i++) {
            print '    if ($("#pc_name_'.$i.'").attr("value")) {COOKIE += "&pc_name_'.$i.'="+$("#pc_name_'.$i.'").attr("value"); }'."\n";
            print '    if (document.getElementsByName("pc_color_select_'.$i.'")[0].value+"") { COOKIE += "&pc_color_select_'.$i.'="+document.getElementsByName("pc_color_select_'.$i.'")[0].value+"";}'."\n";
            print '    if ($("#pc_color_'.$i.'").attr("value")+"") { COOKIE += "&pc_color_'.$i.'="+$("#pc_color_'.$i.'").attr("value")+""; }'."\n";
            print '    if ($("#pc_status_'.$i.'").attr("value")) { COOKIE += "&pc_status_'.$i.'="+$("#pc_status_'.$i.'").attr("value"); }'."\n";
        }
    }
?>

    var str = CookieName+"="+encodeURIComponent(COOKIE);
    domain = location.hostname.replace(/^[^\.]*/, "");
    str += "; domain="+domain;
    path = location.pathname;
    str += "; path="+path;
    var nowtime = new Date().getTime();
    expires = new Date(nowtime + Expires);
    expires = expires.toGMTString();
    str += "; expires="+expires;

    document.cookie = str;

    alert("クッキーを記録しました");
    return true;
}

// クッキーの削除
function cookieDelete() {
    if (!navigator.cookieEnabled) {
        alert("クッキーが無効になっています。ブラウザの設定を変更してください。");
        return false;
    }
    // クッキー名
    var CookieName = "<?php print COOKIE;?>";
    // クッキー保存期間
    var Expires = (60 * 60 * 24 * 1000 * <?php print COOKEI_EXPIRE; ?>);
    // どちらかがない場合クッキー使用しない
    if (!CookieName || !Expires) {
        alert('チャット側の設定により、クッキー保管機能は無効です。');
    }

    // 値のセット
    var COOKIE = "";

    var str = CookieName+"="+escape(COOKIE);
    domain = location.hostname.replace(/^[^\.]*/, "");
    str += "; domain="+domain;
    path = location.pathname;
    str += "; path="+path;
    str += "; expires=0";

    document.cookie = str;

    alert("クッキーを削除しました");
    return true;
}
-->
</script>