<?php
/*
 * Free Map ver.β1.1
 * (c)2008 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */


/*****************
 *  PHPライブラリ：共通
 *****************/

/* リクエストを取得 */
function request() {
    if (!strcasecmp(METHOD, 'GET')) {
        $request = $_GET;
    } elseif (!strcasecmp(METHOD, 'POST')) {
        $request = $_POST;
    }
    return $request;
}

/* ログイン情報取得 */
function getAuth() {
    @session_name('FreeMap');
    @session_start();
    if(!$_SESSION['user_hash'] || !$_SESSION['plname']) {
        error('ログインに失敗しました', true);
    }

    return array($_SESSION['user_hash'], $_SESSION['plname']);
}

/* ヘッター */
function html_header($title, $window, $js = true, $no_cache = true) {
    $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n";
    $header .= '<html>'."\n";
    $header .= '<head>'."\n";
    $header .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $header .= '<meta http-equiv="Content-Style-Type" content="text/css" />'."\n";
    if ($js) {
        $header .= '<meta http-equiv="Content-Script-Type" content="text/javascript" />'."\n";
    }
    if ($no_cache) {
        $header .= '<meta http-equiv="Pragma" content="no-cache">'."\n";
        $header .= '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">'."\n";
        $header .= '<meta http-equiv="Expires" content="-1">'."\n";
    }
    $header .= '<link rel="stylesheet" type="text/css" href="./css/freemap.css">'."\n";
    if ($window == 'index') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/index.css">'."\n";
    } elseif ($window == 'map') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/map.css">'."\n";
    } elseif ($window == 'admin') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/admin.css">'."\n";
    }
    // 動的CSS設定
    $header .= '<style type="text/css">'."\n";
    $header .= '<!--'."\n";
    if ($window == 'index') {
        $header .= '#unit_name,'."\n";
        $header .= '#unit_bg_color_select,'."\n";
        $header .= '#unit_bg_color, '."\n";
        $header .= '#unit_st_color_select,'."\n";
        $header .= '#unit_st_color {'."\n";
        $header .= '    color: #'.UNIT_FONT_COLOR.';'."\n";
        $header .= '    background: #'.UNIT_BG_COLOR.';'."\n";
        $header .= '}'."\n";
    }
    if ($window == 'map') {
        $header .= '.unit {'."\n";
            $header .= '    overflow: hidden;'."\n";
        if (!UNIT_NAME_ALL) {
        } else {
            $header .= '    overflow: visible;'."\n";
        }
        $header .= '}'."\n";
    }
    $header .= '-->'."\n";
    $header .= '</style>'."\n";

    $header .= '<title>'.TITLE.$title.'</title>'."\n";
    if ($js) {
        $header .= '<script type="text/javascript" src="./lib/js/jquery-1.2.6.min.js" ></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/ui.core.min.js" ></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/ui.draggable.min.js" ></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/ui.droppable.min.js"></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/freemap.js" ></script>'."\n";
        if ($window == 'index') {
            $header .= '<script type="text/javascript" src="./lib/js/console.js" ></script>'."\n";
        } elseif ($window == 'map') {
            $header .= '<script type="text/javascript" src="./lib/js/map.js" ></script>'."\n";
        }
    }

    return $header;
}


/* フッター */
function html_footer($copyright = true, $adminlogin = false) {
    $footer = '';
    $footer .= '<table style="width:100%; border-style:none; padding:3px;">
'."\n";
    $footer .= '<tr>'."\n";
    if ($adminlogin) {
    $footer .= '<td style="width:150px;">'."\n";
        $footer .= '<form action="./admin_auth.php" method="'.METHOD.'" target="admin">'."\n";
        $footer .= '管理画面：<input type="password" name="admin_pwd" size="8" class="inputpwd" value=""><input name="action" type="hidden" value="admin.php"> <input type="image" class="btn sub" src="'.ADMIN_ICON.'"></form></td>'."\n";
    }
    $footer .= '<td nowrap>'."\n";
    if ($copyright) $footer .= '<p class="copyright" style="text-align:left;">'.COPYRIGHT.'</p>'."\n";
    $footer .= '</td></tr></table>'."\n";
    $footer .= '</body>'."\n";
    $footer .= '</html>'."\n";

    return $footer;
}

/* エラー表示 */
function error($msg, $back = false, $close = false, $reload = false) {
    print html_header('エラー', false, false, false);
    print <<<ERROR
</head>
</head>
<body>
<p class="msg">エラー<br>
<br>
$msg
<br>
</p>
ERROR;

    if ($back || $reload || $close) print  "<center>\n";
    if ($back) print  '<FORM><INPUT TYPE="button" VALUE="戻る" onClick="javascript:history.back()"></FORM>'."\n";
    if ($close) print  '<FORM><INPUT TYPE="button" VALUE="閉じる" onClick="javascript:window.close()"></FORM>'."\n";
    if ($reload) print  '<FORM><INPUT TYPE="button" VALUE="再読み込み" onClick="javascript:window.location.reload()"></FORM>'."\n";
    if ($back || $reload || $close) print  "</center>\n";
    print  html_footer();
    exit;
}

/* トリップ生成 */
function create_hash($name,$pwd) {
    //パスワードがなければ中止
    if (!$pwd) {
        return false;
    }

    $key = substr(md5($name),0,1).substr(ADMIN_HASH_KEY,0,1);
    $key = strtr($key,':;<=>?@[\]^_`','ABCDEFGabcdef');
    $pwd = substr(crypt($pwd, $key), -10);

    return $pwd;
}
/* 書き込みブロック */
function write_block() {
    if (!$GLOBALS['FREEMAP']['W_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['FREEMAP']['W_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("書きこみできません。");
            }
        }
    }
}

/* アクセスブロック */
function access_block() {
    if (!$GLOBALS['FREEMAP']['A_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['FREEMAP']['A_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("接続に失敗しました");
            }
        }
    }
}


?>