<?php
/*
 * Free Map ver.β1.1
 * (c)2008 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：過去ログ用
 *****************/

require_once './lib/admin.php';


/*
 * ユニットデータの読み込みと整形
 */
function read_unitlog($mode='nowUnit', $masterlog=false) {
    $data = array();
    // ログの読み込み
    $log = array();
    if ($mode == 'nowUnit' || $mode == 'editUnit') {
        $log = file(LOGFILE);
    } elseif ($mode == 'textLog') {
        $log = file(TEXT_LOGFILE);
    }
    if (!is_array($log)) {
        return false;
    } else {
        // データの整形と出力
        foreach($log as $k => $v) {
            if (!$v) {
                continue;
            } else {
                if ($mode == 'nowUnit' || $mode == 'editUnit') {
                    $data[] = output_unitlog($v, $mode);
                } elseif ($mode == 'textLog') {
                    $data[] = output_textlog($v, $masterlog);
                }
                print "\n";
            }
        }
    }
    return $data;
}

/*
 * FreeMap汎用ログ整形
 */
function output_log($v, $is_text=false) {
    $arr_data = array();

    if ($v) {
        $unit = explode("<>", $v);

        if (!$unit[0]) {
            return false;
        }
         if ($is_text) {
             $arr_data['mode'] = array_shift($unit);
         }
         $arr_data['unitName'] = array_shift($unit);
         $arr_data['plName'] = array_shift($unit);
         array_shift($unit); // ハッシュは表に出さない
         $arr_data['x'] = array_shift($unit);
         $arr_data['y'] = array_shift($unit);
         $arr_data['w'] = array_shift($unit);
         $arr_data['h'] = array_shift($unit);
         $arr_data['unitColor'] = array_shift($unit);
         $arr_data['textColor'] = array_shift($unit);
         $arr_data['status'] = array_shift($unit);
         $arr_data['show'] = array_shift($unit);
         $timestamp = array_shift($unit);
         $arr_data['datetime'] = date("Y/m/d H:i:s", $timestamp);
         $arr_data['ua'] = array_shift($unit);
         $arr_data['host'] = array_shift($unit);
    }
    return $arr_data;
}

/*
 * 現在のユニットログ整形
 */
function output_unitlog($v, $mode='nowUnit') {
    $arr_data = output_log($v, false);

    // 難読化(現在未対応）

    // 成形
    $output = "";
    if ($arr_data) {
        $output .= '<div class="nowUnitList">';
        if ($mode=='editUnit') {
            $output .= '<input type="checkbox" name="unitname[]" value="'.$arr_data['unitName'].'"> ';
        }
        $output .= $arr_data['unitName'].' ('.$arr_data['plName'].')</div>';
    }
    return $output;
}


/*
 * テキストログ整形
 */
function output_textlog($v, $masterlog=false) {
    $arr_data = output_log($v, true);

    // 難読化(現在未対応）

    // 成形
    $output = "";
    if ($arr_data) {
        $output .= '<div class="unitLog">';
        $output .= $arr_data['datetime'].' : ';
        $output .= $arr_data['plName']."が";
        if ($arr_data['mode']=='out') {
            $output .= 'ログアウトしました';
        } else {
            $output .= $arr_data['unitName'].'を';
            if ($arr_data['mode']=='add') {
                $output .= '追加しました';
            } elseif ($arr_data['mode']=='drop') {
                $output .= 'X座標'.$arr_data['x'].', Y座標'.$arr_data['y'].'へ移動しました';
            } elseif ($arr_data['mode']=='del') {
                $output .= '削除しました';
            } elseif ($arr_data['mode']=='edit') {
                $output .= '編集しました';
            }
        }
        if ($masterlog) $output .= '<span style="color:#999999;"> ('.$arr_data['ua'].', '.$arr_data['host'].')</span>';

        $output .= '</div>';
    }
    return $output;
}


/* 関数 */
// HTMLログ作成
function write_log($filename, $masterlog=false) {

    $header = html_header('HTMLログ '.$filename, 'pastlog', false, false);
    $footer = html_footer();


    $log = read_unitlog('textLog', $masterlog);
    if (!$log[0]) {
        error("テキストログがありません。", true);
    }

    if ($masterlog) {
        $dir = MASTER_PAST_DIR;
    } else {
        $dir = PAST_DIR;
    }
    $fp = fopen($dir.$filename.".html", "w");
    stream_set_write_buffer($fp, 0);
    flock($fp,LOCK_EX);
    fwrite($fp, $header);
    if ($log) {
        foreach ($log as $v) {
            fwrite($fp, $v."\n");
        }
    }
    fwrite($fp, '<hr>');
    fwrite($fp, $footer);
    fflush($fp);
    fclose($fp);

}

/*
 * ディレクトリ開閉タグの出力
 */
function print_toggle_dir($id, $dir_name, $child = false, $default = 'close', $title = 'クリックで開閉', $form = 'false', $past = '') {
    print '<div style="margin:0px;">';
    if ($child) { print "├";}
    if ($form) { print '<input type="radio" name="dir" value="'.$id.'">';};
    print '<span onclick="toggleColumn(\''.$id.'\');toggleColumn(\'icon_'.$id.'_s\');toggleColumn(\'icon_'.$id.'_h\');" title="'.$title.'">';
    print '<image src="'.PASTLOG_DIR_CLOSE_ICON.'" id="icon_'.$id.'_h" style="margin:0px;';
    if ($default == 'open') {
        print ' display:none;';
    }
    print '">'.
        '<image src="'.PASTLOG_DIR_OPEN_ICON.'" id="icon_'.$id.'_s" style="margin:0px;';
    if ($default != 'open') {
        print ' display:none;';
    }
    print '">'.
        $dir_name.
        "</span></div>\n";
    print '<div id="'.$id.$past.'" style="padding:0px;';
    if ($default != 'open') {
        print 'display:none;';
    }
    print '">'."\n";

}

/* 
 * ファイル名チェック
 * スラッシュ・ドット不許可
 */
function check_name($name) {
    if (!$name)  error('ファイル名またはディレクトリ名を入力してください', true);
    if (preg_match("/[^0-9a-zA-Z\-_]/", $name)) {
        error('使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。', true);
    }
}

/*
 * 過去ログファイルリスト表示
 */
function print_pastloglist($files, $dir, $child = false, $form = false, $target = '_blank') {
    foreach($files as $v) {
        if ($child) { print '│'; }
        print '├';
        if ($form) { print '<input type="checkbox" name="file[]" value="'.$dir.$v.'">';}
        print '<a href="'.$dir.$v.'" target="'.$target.'">'.substr($v, 0, strlen($v)-5)."</a><br>\n";
    }
}

/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function get_dir_contents_list($dir, $sort = 'DESC') {
    $file_list = array();
    $dir_list = array();

    $dp = opendir($dir);
    while($str = readdir($dp)) {
        if (is_dir($dir.$str) && $str != '.' && $str != '..') {
            $dir_list[] = $str;
        } elseif (is_file($dir.$str) && $str != 'index.html') {
            $file_list[] = $str;
        }
    }
    closedir($dp);

    // ソート
    if($sort == 'ASC') {
        sort($file_list);
        sort($dir_list);
    } else {
        rsort($file_list);
        rsort($dir_list);
    }

    return array('dirs' => $dir_list, 'files' => $file_list);
}

/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function print_pastlog_contents_list($id, $dir, $root_name, $sort = 'DESC', $form = '', $path = '', $past = '', $open_root = 'open', $open_child = 'close', $root_name = 'ルートディレクトリ', $title = 'クリックで開閉', $target = '_blank') {
    $list = get_dir_contents_list($dir, $sort);
    if ($list['dirs'] || $list['files']) {

        if ($form) {
            print '<form action="'.$path.'" method="'.METHOD.'">'."\n";
            print '<input type="hidden" name="type" value="'.$dir.'">'."\n";
        }

        // ルートディレクトリ
        print_toggle_dir($id, $root_name, false, $open_root, $title, $form);

        // 子ディレクトリ
        if ($list['dirs'][0]) {
            foreach ($list['dirs'] as $k => $v) {
                $child[$k] = get_dir_contents_list($dir.$v."/", $sort);
                print_toggle_dir($id.$k, $v, true, $open_child, $title, $form, $past);
                if ($child[$k]['files']) {
                    print_pastloglist($child[$k]['files'], $dir.$v.'/', true, $form, $target);
                }
                print "</div>\n";
            }
        }

        // ルートファイル一覧表示
        if ($list['files']) {
            print_pastloglist($list['files'], $dir, false, $form, $target);
        }
        print "</div>\n";

        if ($form) {
            print "<p>\n";
            print '<input type="submit" name="mode" value="削除確認">　';
            print '<input type="submit" name="mode" value="移動"></p>';
            print '<p><input type="text" name="new_filename" value="">.html　';
            print '<input type="submit" name="mode" value="ファイル名変更"><br>ファイル名に使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。<br>
</p>';
            print '<input type="reset">';
            print '</form>'."\n";
        }

    } else {
        print '<div align="center">HTMLログはありません</div>';
    }
}


?>