<?php
/*
 * Ajax Chat for TRPG ver.2.4
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// かんたんセットアップ対応
require_once './lib/trpgchat.php';
require_once './trpgchat-ini-2.php';
if (!file_exists('./trpgchat-ini.php')) {
    if (!file_exists('./setup.php')) {
        error('setup.phpがありません。ディレクトリを確認してください。', false, false, true);
    }
    $self_url = get_self_url();
    $url =str_replace('index.php', 'setup.php', $self_url);
    header('Location: '.$url);
    exit;
}
if (file_exists('./setup.php')) {
    error('setup.phpを移動するか、または名前を変えてください。', false, false, true);
}

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/ini/trpgchat-ini-help.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// 携帯は携帯INDEXへ
// 後日実装

// HTML出力
print html_header(CHAT_TITLE, 'index', true, true);

// COOKIE読み込み
$cookies = read_cookie();

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/index-js.php';

?>
</head>
<body onresize="changeSize()" onunload="return UnLoad()">

<!-- ここから：オンライン標準表示欄 -->
<table border="0" cellspacing="3" cellpadding="0" id="online1" class="online" style="display:none;">
<tr>
<td>
<form name="online1" onsubmit="return false;" action="">
<input type="hidden" name="name_on" value="" size="10" id="name_on">
<input type="hidden" name="pwd_on" size="4" id="pwd_on">
<input type="hidden" name="my_hash" value="" id="my_hash">
</td>

<?php

//=======ここから：オンラインTRPG欄
if (DICE_MAX && $GLOBALS['AJAX_CHAT_TRPG']['PRESET_DICE'][0]) {
    print '<td title="右のダイスアイコンで入力するダイスを選んでください">';
    print '<select name="dice" id="dice">'."\n";
    foreach ($GLOBALS['AJAX_CHAT_TRPG']['PRESET_DICE'] as $v) {
         print '<option value="'.$v.'">'.$v.'</option>'."\n";
    }
    print '</select></td>'."\n";
    print '<td> + </td>'."\n";
    print "<td>\n";
    print '<span title="ダイスの修正値を入力してください"><option value="'.$v.'"><input type="text" size="6" value="" name="revision" id="revision"></span>';
    print "</td>\n";
    if (CF_INPUT) {
        print "<td nowrap>\n";
        if (!CF_FIXED) {
            print '<span title="クリティカル値　11:「11で」クリティカル　11-：11「以上」でクリティカル">C:';
        }
        print '<input type="text" size="1" value="';
        print C_DEFAULT;
        print '" name="clit" id="clit"';
        if (CF_FIXED) {
            print ' style="display:none;"';
        }
        print '>';
        if (!CF_FIXED) {
            print '</span>';
        }
        print "</td>\n";
        print '<td nowrap>';
        if (!CF_FIXED) {
            print '<span title="ファンブル　3:「3で」ファンブル　3-：3「以下」でファンブル"> F:';
        }
        print '<input type="text" size="1" value="';
        print F_DEFAULT;
        print '" name="famble" id="famble"';
        if (CF_FIXED) {
            print ' style="display:none;"';
        }
        print '>';
        if (!CF_FIXED) {
            print '</span>';
        }
        print "</td>\n";

        print '<td nowrap>';
        print '<span title="クリティカル・ファンブルで変化するダイスを発言欄に入力します">入力:<input id="cfinput" type="checkbox" onclick=\'toggleColumn("cfchange")\'></span></td>';

        print '<td id="cfchange" style="display:none;" nowrap>';
        print '<span title="クリティカルで自動的に振り足されるダイスを発言欄に入力します">回る:<input id="crolling" type="checkbox"></span>';
        print '<span title="ファンブルで絶対失敗（0点扱い）になるダイスを発言欄に入力します。">絶対失敗:<input id="fzero" type="checkbox"></span>';
        print "</td>\n";
    }
    print "<td>";
    show_icon(DICE_ICON, "", "", "dice", "ダイス入力", "右で指定したダイスを入力します", "insertDice(this.form, columnId);");
    print '<input type="submit" style="display:none;" onclick="insertDice(this.form, columnId);">';

    if (SHORTCUT_DICE) {
        show_icon(DICE_SHORTCUT_SHOW_ICON, DICE_SHORTCUT_HIDE_ICON, "", "dice_shortcut_icon", "↓", "ダイスショートカット欄をON/OFFします", "toggleColumn('dice_shortcut');");
    }
    // 市販ルール欄
    if (USE_CONSUMER_RULES) {
        show_icon(CONSUMER_RULES_OPEN_ICON, CONSUMER_RULES_CLOSE_ICON, "", "consumer_rule_icon", "†", "市販ルールの簡易使用欄をON/OFFします", 'toggleColumn(\'consumer_rule\');');
    }
    print "</td>\n";
        print '<td class="nodisplay"></form></td>'."\n";
}
//=======ここまで：オンラインTRPG欄

// タグボタン
if (ALLOW_TAG) {
    print '<td id="tags1">';
    $tag_num = count($GLOBALS['AJAX_CHAT_TRPG']['TAGS']);
    for($i=0;$i<$tag_num;$i++) {
        if ($GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][1] && $GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][3]) {
            $tag = $GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][0];
            show_icon($GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][2], "", "", "", $tag, $tag."タグ", "insertTag('$tag', columnId);");
        }
    }
    print "</td>\n";
    print '<td id="tags2">';
    show_icon(INSERT_FONT_ICON, "", "", "", "Ｆ", "フォントタグ", "insertFontTag(columnId);");
    print "</td>\n";
}

if (USER_WHISPER) {
    print "<td>\n";
    $onclick_whisper = 'document.getElementById(\'whisper_to\').value=\'全員\', document.getElementById(\'whisper_to_hash\').value=\'\', document.getElementById(\'whisper_mark\').src=\''.WHISPER_ON_ICON.'\'';
    show_icon(WHISPER_ICON, "", "", "whisper", "解除", "クリックで「ささやき」を解除します。", $onclick_whisper);
    show_icon(WHISPER_ON_ICON, "", "", "whisper_mark", "∂","「ささやき」状態を表示しています", $onclick_whisper);
    print "</td>\n";
    print "<td>";
    print '<span title="今話しかけている相手です"><input type="text" name="whisper_to" value="全員" size="8" class="inputname" id="whisper_to" style="display:inline;">';
    print '<input type="hidden" name="whisper_to_hash" value="" id="whisper_to_hash"></span>';
    print "</td>\n";
}
?>
<td>
<?php
show_icon(RELOAD_ICON, "", "", "", "Ｒ", "チャット画面をリフレッシュ！", "window.mainframe.clearLog();");

show_icon(TOOLS_ICON, "", "", "", "TOOL", "過去ログ表示・クッキー保存アイコンなどの表示をON/OFFします", "toggleColumn('tools1');toggleColumn('tools2');toggleColumn('tools3');toggleColumn('tools4');");

print "</td>";
// 過去ログ表示
if (!(DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG)) {
    print '<td id="tools1" style="display:none;"><a href="./pastlog_index.php" target="pastlog">';
    print show_icon(PASTLOG_SHOW_ICON, "", "", "pastlog_show", "ログ", "過去ログを見る", "submit();");
    print '</a></td>';
    print '<td class="nodisplay"><form action="./#" method="METHOD" onsubmit="return false;"></td>';
    print '<td id="tools2" style="display:none;">';
    print show_icon(PASTLOG_DL_ICON, "", "", "pastlog_output", "DL", "過去ログをHTMLでダウンロード", "pastlogHtmlOutput();");
    print "</td>\n";
    print "<td class=\"nodisplay\"></form></td>\n";
}

if (COOKEI_EXPIRE || COOKIE) {
    print '<td id="tools3" style="display:none;">';
    show_icon(COOKIE_WRITE_ICON, "", "", "", "CW", "現在の設定をクッキーに保管します", "cookieWrite()")."\n";
    show_icon(COOKIE_DELETE_ICON, "", "", "", "CD", "現在のクッキーを削除します", "cookieDelete()")."\n";
    print "</td>\n";
}
// 携帯使用
if (USE_MOBILE) {
    print '<td id="tools4" style="display:none;"><a href="./info-mobile.php" target="_blank">';
    print show_icon(MOBILE_ICON, "", "", "mobile", "携帯", "携帯用URLを紹介", '');
    print '</a></td>'."\n";
}
print "<td>";
$onclick_help = 'toggleColumn(\'help_win\');';
show_icon(HELP_ICON, '', '', 'help_win_icon', '？', 'ヘルプをON/OFFします', $onclick_help);
?>
</td>
<td align="right" id="logoutBt"><input type="button" value="退室" name="logout" class="btn logout" id="logout" /></td>
</table>

<?php
// ここから：TRPG市販ルール欄
if (DICE_MAX && USE_CONSUMER_RULES) {
    print '<table border="0" cellspacing="3" cellpadding="0" id="consumer_rule" style="display:none;">'."\n";
    print "<tr>";
    // SW
    if (SW) {
        print '<td><td class="nodisplay"><form onsubmit="return false;"></td>';
        print "<td>";
        show_icon(SW_ICON, "", "", "", "SW", "SWレーティング振り欄をON/OFFします", "toggleColumn('cr_sw');");
        print '</td><td id="cr_sw" ';
        if (!SW_SHOW) {
            print 'style="display:none;" ';
        }
        print 'nowrap>レーティング<input name="rating" id="rating" value="10" size="2">';
        print ' + ';
        print '<span title="修正値を入力してください"><input type="text" size="4" value="" name="sw_revision" id="sw_revision"></span>';
        print '<span title="クリティカル値：「回らない」場合は空欄にして下さい"> C:';
        print '<input type="text" size="1" value="10" name="sw_clit" id="sw_clit">';
        print '</span>';
        show_icon(DICE_ICON, "", "", "", "レーティング", "右で指定したレーティングを入力します。", "insertSWRating(this.form, columnId);");
        print '<input type="submit" style="display:none;" onclick="insertSWRating(this.form, columnId);">';
        print '<td class="nodisplay"></form></td>'."\n";
    }

    // 一定値以上の出目カウント
    if (PICKUP) {
        print '<td>';
        show_icon(PICKUP_ICON, "", "", "", "↑↓", "指定値以上/以下の出目のみを数えます", "toggleColumn('cr_pickup');");
        print '</td><td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td id="cr_pickup" ';
        if (!PICKUP_SHOW) {
            print 'style="display:none;" ';
        }
        print 'nowrap>';
        print '<input id="pickup_num" value="'.PICKUP_DEFAULT_DICE_NUM.'" size="2">d';
        print '<input id="pickup_dice_number" value="'.PICKUP_DEFAULT_DICE_NUMBER.'" size="2"> ';
        print '+';
        print '<span title="修正値を入力してください"><input type="text" size="2" value="" id="pickup_revision"></span>';
        print ' <input type="text" size="1" value="'.PICKUP_DEFAULT_NUMBER.'" id="pickup_number">';
        print '<select id="u_l"><option value="u" selected>以上<option value="l">以下</select>';
        print ' <span title="最大の出目のみを合計します 例：5d6=2,4,3,3,5 = 5">MAXのみ:<input id="pickup_count_max" type="checkbox"></span>';
        print ' <span title="クリティカル値　8:「8で」クリティカル　8-：8「以上」でクリティカル">C:';
        print '<input type="text" size="1" value="'.PICKUP_DEFAULT_CLIT.'" id="pickup_clit">';
        print '</span>';
        print ' <span title="クリティカルで振り足されるダイスを発言欄に入力します">振り足す:<input id="pickup_crolling" type="checkbox"></span>';

        print ' <span title="クリティカルはダイス出目の最大値として扱います 例：d10 クリティカル値8以上で出目9 = 10扱い">C=MAX:<input id="pickup_c_max" type="checkbox"></span>';
        show_icon(DICE_ICON, "", "", "dice", "ダイス入力", "右＆上で指定したダイスを入力します。", "insertPickupDice(columnId);");
    print '<input type="submit" style="display:none;" onclick="insertPickupDice(columnId);">';
        print '<td class="nodisplay"></form></td>'."\n";
    }

    print '</td></tr></table>'."\n";
}
?>
<!-- ここまで、市販ルールツール欄 -->

<!-- ここから、ダイスショートカット欄 -->
<?php
if (DICE_MAX && SHORTCUT_DICE) {
    print '<table border="0" cellspacing="3" cellpadding="0" id="dice_shortcut" style="display:none;">'."\n";
    print '<tr>'."\n";
    for ($i=1;$i<=5;$i++) {
        $dice_key = "dice_".$i;
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td><input type="text" name="dice" id="dice_'.$i.'" value="'.$cookies[$dice_key].'" size="8" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print "<td>\n";
        show_icon(DICE_ICON, "", "", "", "D", "右欄に設定のダイスを入力します", "insert(document.getElementById(columnId), 'dice_$i', $('#dice_$i').attr('value'), 0);");
        print "</td>\n";
        print '<input type="submit" style="display:none;" onclick="insert(document.getElementById(columnId), \'dice_'.$i.'\', $(\'#dice_'.$i.'\').attr(\'value\'), 0);">';
        print '<td class="nodisplay"></form></td>'."\n";
    }
    print "<td>";
    show_icon(DICE_SHORTCUT_SHOW_ICON, $img2, "", "dice_shortcut_icon", "↓", "ダイスショートカット欄2行目をON/OFFします", 'toggleColumn(\'dice_shortcut_2\')');
    print "</td></tr>\n";
    print '<tr id="dice_shortcut_2" style="display:none;">'."\n";
    for ($i=6;$i<=10;$i++) {
        $dice_key = "dice_".$i;
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td><input type="text" name="dice" id="dice_'.$i.'" value="'.$cookies[$dice_key].'" size="8" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td>';
        show_icon(DICE_ICON, "", "", "dice", "D", "右欄に設定のダイスを入力します", "insert(document.getElementById(columnId), 'dice_$i', $('#dice_$i').attr('value'), 0);");
        print "</td>\n";
        print '<input type="submit" style="display:none;" onclick="insert(document.getElementById(columnId), \'dice_'.$i.'\', $(\'#dice_'.$i.'\').attr(\'value\'), 0);">';
        print '<td class="nodisplay"></form></td>'."\n";
    }
    print '<td>&nbsp;</td>'."\n";
    print '</tr></table>'."\n";
}
?>

<!-- ここから、PC/NPC欄 -->
<table border="0" cellspacing="3" cellpadding="0" id="online2" class="online" style="display:none;">
<tr>
<td class="nodisplay"><form onsubmit="return false;"></td>
<td align="left" nowrap><input type="text" name="pc_name" size="6" class="pc_name inputmain" id="pc_name_0" style="font-weight: bold; color:#<?php print $cookies[pc_color_0]; ?>;" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="text" name="pc_input" class="input_comment inputmain" id="pc_input_0" size="75%" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline;" name="submit" onclick="comment(this.form)"></td>
<td>
<?php
show_icon(PC_STATUS_ICON, "", "", $id, "状態", "設定欄をON/OFFします", "toggleColumn('status_0');");
if (PC_NUM > 1) {
   show_icon(PC_SHOW_ICON, PC_HIDE_ICON, "", "PC_btn_0", "PC欄", "PC欄を追加/削除します", "toggleColumn('pc_1');");
}
 ?>
</td></tr>
</table>

<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_0" style="display:none;">
<tr>
<td nowrap>名前色</td>
<td id="select_color_0">
<select onChange='changeColor(this, this.form)' style="font-weight: bold; color:#<?php print $cookies[pc_color_select_0]; ?>" id="pc_color_select" name="pc_color_select_0" class="inputmain">

<?php colorbox("pc_color", $cookies[pc_color_select_0]); ?>
</select>
</td>
<td id="free_color_0" style="display:none;"><input type="text" value="<?php print $cookies[pc_color_0]; ?>" size="10" name="pc_color" id="pc_color_0" style="font-weight: bold; color:#<?php print $cookies[pc_color_0]; ?>" onkeydown='if(navigator.appName == "Netscape"){key=event.which;}else{key=window.event.keyCode;}' onkeyup='changeColor(this, this.form, key);' class="inputmain"></td>
<td><?php show_icon(PC_FONT_ICON, "", "", $id, "Ｆ", "クリックでPC名文字色入力方法を変更できます", "toggleColumn('free_color_0');toggleColumn('select_color_0');"); ?></td>
<td nowrap>ステータス:<input type="text" name="status" class="status inputmain" id="pc_status_0" onblur="selectedColumnId(this, this.form)" value="
<?php
    if ($cookies[$pc_status_0]) { 
        print $cookies[$pc_status_0];
    } else {
        print STATUS;
    }
 ?>
"></td>
<td><input type="checkbox" name="show_status" class="show_status"></td>
<td nowrap> 表示</td>
<td class="nodisplay"></form></td>
</tr>
</table>

<?php
if (PC_NUM >= 2) {
    for ($i=1; $i<=PC_NUM-1; $i++) {
        $pc_name_key = "pc_name_".$i;
        $pc_color_key = "pc_color_".$i;
        $pc_color_select_key = "pc_color_select_".$i;
        $pc_status_key = "pc_status_".$i;
        print '<table border="0" cellspacing="3" cellpadding="0" id="pc_'.$i.'" class="add_pc" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td align="left" nowrap><input type="text" name="pc_name" value="'.$cookies[$pc_name_key].'" size="6" class="pc_name inputmain" id="pc_name_'.$i.'" style="font-weight:bold; color:#'.$cookies[$pc_color_key].'" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input type="text" name="pc_input" class="input_comment inputmain" size="75%" id="pc_input_'.$i.'" onblur="selectedColumnId(this, this.form)">';
        print "</td>\n";
        print '<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>'."\n";
        print '<td>';
        show_icon(PC_STATUS_ICON, "", "", "", "状態", "ステータス欄をON/OFFします", "toggleColumn('status_$i');");
        if ($i != PC_NUM-1) {
            $num = $i+1;
            show_icon(PC_SHOW_ICON, PC_HIDE_ICON, "", "PC_btn_$i", "PC欄", "PC欄を追加/削除します", "toggleColumn('pc_$num');");
        } else {
            print " ";
        }
        print "</td>\n";
        print '</tr>'."\n";
        print '</table>'."\n";
        print '<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_'.$i.'" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td nowrap>名前色</td>'."\n";
        print '<td id="select_color_'.$i.'">';
        print '<select onChange=\'changeColor(this, this.form)\' style="font-weight: bold; color:#'.$cookies[$pc_color_key].';" id="pc_color_select" name="pc_color_select_'.$i.'" class="inputmain">'."\n";
        colorbox("pc_color", $cookies[$pc_color_select_key]);
        print '</select></td>'."\n";
        print '<td id="free_color_'.$i.'" style="display:none;"><input type="text" value="'.$cookies[$pc_color_key].'" size="10" name="pc_color" id="pc_color_'.$i.'" style="font-weight: bold; color:#'.$cookies[$pc_color_key].';" onkeyup="changeColor(this, this.form)" class="inputmain"></td>'."\n";
        print '<td>';
        show_icon(PC_FONT_ICON, "", "", "", "Ｆ", "クリックでPC名文字色入力方法を変更できます", "toggleColumn('free_color_$i');toggleColumn('select_color_$i');");
        print "</td>\n";
        print '<td nowrap>ステータス:<input type="text" name="status" class="status inputmain" value="';
        if ($cookies[$pc_status_key]) { 
            print $cookies[$pc_status_key];
        } else {
            print STATUS;
        }
        print '" id="pc_status_'.$i.'" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input name="show_status" type="checkbox" class="show_status"></td>'."\n";
        print '<td nowrap> 表示</td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
    }
}
 ?>

<!-- ここから：ＰＬログイン画面欄  -->
<table border="0" cellspacing="3" cellpadding="0" id="offline" style="display:inline; height:30px;">
<tr>
<td class="nodisplay"><form id="chat_off" name="chat" onsubmit="return false;" action=""></td>
<td nowrap>お名前<input type="text" name="name_off" value="<?php if ($cookies[name_off]) { print $cookies[name_off]; } else { print NONAME; } ?>" size="8" class="inputname" id="name_off"></td>
<td nowrap>パスワード<input type="password" name="pwd_off" size="6" class="inputpwd" id="pwd_off"></td>
<td width="35"><input type="submit" value="入室" name="login" class="login_btn_area" id="login" /></td>
<td><?php show_icon(RELOAD_ICON, "", "", "reload", "Ｒ", "チャット画面をリフレッシュ！", "window.mainframe.location.reload()"); ?></td>
<td class="nodisplay"></form></td>
<td><?php show_icon(HELP_ICON, '', '', 'help_win_icon', '？', 'ヘルプをON/OFFします', $onclick_help); ?></td>
<td class="nodisplay"><form action="<?php print HOME; ?>" target="<?php print HOME_TARGET; ?>"></td>
<td><input type="image" class="btn" src="<?php print HOME_ICON; ?>" value="submit" alt="ホーム" title="ホーム"></td>
<td class="nodisplay"></form></td>
<?php 
// FreeMap連動
if (FREEMAP_URL) {
    print '<td><a href="'.FREEMAP_URL.'" target="map">';
    print show_icon(FREEMAP_ICON, "", "", "freemap", "MAP", "マップとコマを使う", '');
    print '</a></td>';
}

// 過去ログ表示
if (!(DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG)) { 
    print '<td><a href="./pastlog_index.php" target="pastlog">';
    print show_icon(PASTLOG_SHOW_ICON, "", "", "pastlog_show", "ログ", "過去ログを見る", "submit();");
    print '</a></td>';
    if (!UNPUBLIC_LAST_PASTLOG) {
        print '<td class="nodisplay"><form action="#" method="METHOD" onsubmit="return false;"></td>';
        print '<td>';
        print show_icon(PASTLOG_DL_ICON, "", "", "pastlog_output", "DL", "過去ログをHTMLでダウンロード", "pastlogHtmlOutput();");
        print "</td>\n";
        print "<td class=\"nodisplay\"></form></td>\n";
    }
}

// 携帯使用
if (USE_MOBILE) {
    print '<td><a href="./info-mobile.php" target="_blank">';
    print show_icon(MOBILE_ICON, "", "", "mobile", "携帯", "携帯用URLを紹介", '');
    print '</a></td>';
}

?>

</tr>
</table>
<div>
<?php
// コンソール
// ヘルプ
write_console('55px', '0px', '350px', 'none', 'help_win', 'ヘルプ', nl2br(HELP_MSG).nl2br($GLOBALS['AJAX_CHAT_TRPG']['STATIC_HELP']), '', false);
// 入室前表示
if (OFFWINDOW_MSG || (UNPUBLIC_LAST_PASTLOG && NO_LAST_PASTLOG_MSG)) {
    $off_msg = OFFWINDOW_MSG;
    if (UNPUBLIC_LAST_PASTLOG) $off_msg .= NO_LAST_PASTLOG_MSG;
    write_console('30px', '-330px', '250px', '', 'offline_win', '', nl2br($off_msg), '', false);
}
?>
</div>
<iframe src="./main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:500px;" id="mainframe"></iframe>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です</p>
</noscript>

<?php

// フッター
print html_footer(true, true);

exit;
 ?>