<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：ログのPHP読み込み用
 *****************/

/*
 * ログ基本整形
 */
function format_log($line, $hash='', $d=true, $is_mobile=false)
{
    $unit = explode("<>", $line);
    $num = $unit[0];
    $name = $unit[1];
    $pc = $unit[2];
    $color = $unit[3];
    if (!$color) {
        $color = MAIN_TEXTCOLOR;
    }
    $com = $unit[4];
    if ($d) {
        $date_format = 'm/d H:i';
        if (SHOW_DATETIME_YEAR && !$is_mobile) {
$date_format = 'Y/'.$date_format;
        }
        if (SHOW_DATETIME_SECOND && !$is_mobile) {
$date_format .= ":s";
        }
        $datetime = date($date_format, $unit[5]);
    }
    $host = (MASTERPASS && $hash == MASTERPASS) ? '<!--' : NULL ;
    $host .= (MASTERPASS && $hash == MASTERPASS && $unit[6]) ? $unit[6].'<>' : NULL ;
    $host .= (MASTERPASS && $hash == MASTERPASS) ? $unit[7].' -->' : NULL ;
    $whisper_from_pass = $unit[8];
    $whisper_to_name = $unit[9];
    $whisper_to_pass = $unit[10];

    $w = 'n';
    if ($unit[9] || $unit[10]) {
        $w = 'y';
        if ($hash == MASTERPASS) {
            $w = 'to';
        } elseif ($unit[8] && $hash == $unit[8]) {
            $w = 'to';
        } elseif ($unit[10] && $hash == $unit[10]) {
            $w = 'from';
        }
    }
    $status = "";
    if ($unit[11] == '1' && $unit[12]) {
        $status = $unit[12];
    }
    $isMobile = $unit[13];

    return array($num, $name, $pc, $color, $com, $datetime, $host, $whisper_from_pass, $whisper_to_name, $whisper_to_pass, $w, $status, $isMobile);
}

/*
 * 難読化デコード
 */
function decode_obf_log($pc, $com, $name, $whisper_to_name, $status)
{
    $pc = de_obf_xor($pc);
    $com = de_obf_xor($com);
    $name = de_obf_xor($name);
    if ($whisper_to_name) $whisper_to_name = de_obf_xor($whisper_to_name);
    if ($status) $status = de_obf_xor($status);

    return array($pc, $com, $name, $whisper_to_name, $status);
}


?>